/* i386-opcode.h -- Intel 80386 opcode table
   Copyright 1989, 1991, 1992 Free Software Foundation.

This file is part of GAS, the GNU Assembler, and GDB, the GNU Debugger.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

static const template i386_optab[] = {

/* number of operands in the code */

#define _ None
/* move instructions */
{ "mov", 1, 0xa0, _, DW|NoModrm, Disp32, 0, 0, ReadMem, T_NOBR },
{ "mov", 1, 0x88, _, DW|Modrm, Reg|Mem, 0, 0, WriteMem, T_NOBR },
{ "mov", 1, 0xb0, _, ShortFormW, Imm, 0, 0, NoMemAcc, T_NOBR },
{ "mov", 2, 0xc6, _,  W|Modrm, Reg|Mem, Imm, 0, WriteMem, T_NOBR },
{ "mov", 1, 0x8c, _, D|Modrm, Reg16|Mem16, 0, 0, WriteMem, T_NOBR },
/* move to/from control debug registers */
{ "mov", 1, 0x0f20, _, D|Modrm, Reg32, 0, 0, NoMemAcc, T_NOBR },
{ "mov", 1, 0x0f21, _, D|Modrm, Reg32, 0, 0, NoMemAcc, T_NOBR },
{ "mov", 1, 0x0f24, _, D|Modrm, Reg32, 0, 0, NoMemAcc, T_NOBR },

/* move with sign extend */
/* "movsbl" & "movsbw" must not be unified into "movsb" to avoid
   conflict with the "movs" string move instruction.  Thus, */
{"movsb", 1, 0x0fbe, _, ReverseRegRegmem|Modrm, Reg8|Mem,  0, 0, ReadMem, T_NOBR },
/*   is not kosher; we must seperate the two instructions. */
/* {"movsbl", 2, 0x0fbe, _, ReverseRegRegmem|Modrm, Reg8|Mem,  Reg32, 0, CvOp|ReadMem, T_NOBR },
{"movsbw", 2, 0x660fbe, _, ReverseRegRegmem|Modrm, Reg8|Mem,  Reg16, 0, CvOp|ReadMem, T_NOBR }, */
{"movswl", 1, 0x0fbf, _, ReverseRegRegmem|Modrm, Reg16|Mem, 0, 0, ReadMem, T_NOBR },

/* move with zero extend */
{"movzb", 1, 0x0fb6, _, ReverseRegRegmem|Modrm, Reg8|Mem, 0, 0, ReadMem, T_NOBR },
{"movzwl", 1, 0x0fb7, _, ReverseRegRegmem|Modrm, Reg16|Mem, 0, 0, ReadMem, T_NOBR },

/* push instructions */
{"push", 1, 0x50, _, ShortForm, WordReg, 0, 0, PushOp, T_NOBR },
{"push", 1, 0xff, 0x6,  Modrm, WordReg|WordMem, 0, 0, PushOp, T_NOBR },
{"push", 1, 0x6a, _, NoModrm, Imm8S, 0, 0, PushOp, T_NOBR },
{"push", 1, 0x68, _, NoModrm, Imm32, 0, 0, PushOp, T_NOBR },
{"push", 1, 0x06, _,  Seg2ShortForm, SReg2, 0, 0, PushOp, T_NOBR },
{"push", 1, 0x0fa0, _, Seg3ShortForm, SReg3, 0, 0, PushOp, T_NOBR },
/* push all */
{"pusha", 0, 0x60, _, NoModrm, 0, 0, 0, PushOp, T_NOBR },

/* pop instructions */
{"pop", 1, 0x58, _, ShortForm, WordReg, 0, 0, PopOp, T_NOBR },
{"pop", 1, 0x8f, 0x0,  Modrm, WordReg|WordMem, 0, 0, PopOp, T_NOBR },
#define POP_SEG_SHORT 0x7
{"pop", 1, 0x07, _,  Seg2ShortForm, SReg2, 0, 0, PopOp, T_NOBR },
{"pop", 1, 0x0fa1, _, Seg3ShortForm, SReg3, 0, 0, PopOp, T_NOBR },
/* pop all */
{"popa", 0, 0x61, _, NoModrm, 0, 0, 0, StackOp, T_NOBR },

/* xchg exchange instructions
   xchg commutes:  we allow both operand orders */
{"xchg", 1, 0x90, _, ShortForm, WordReg, 0, 0, NoMemAcc, T_NOBR },
/* {"xchg", 2, 0x90, _, ShortForm, Acc, WordReg, 0, NoMemAcc, T_NOBR }, */
{"xchg", 1, 0x86, _, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
/* {"xchg", 2, 0x86, _, W|Modrm, Reg|Mem, Reg, 0, RAndWMem, T_NOBR }, */

/* in/out from ports */
{"in", 1, 0xe4, _, W|NoModrm, Imm8, 0, 0, NoMemAcc, T_NOBR },
{"in", 1, 0xec, _, W|NoModrm, InOutPortReg, 0, 0, NoMemAcc, T_NOBR },
{"in", 1, 0xe4, _, W|NoModrm, Imm8, 0, 0, NoMemAcc, T_NOBR },
{"in", 1, 0xec, _, W|NoModrm, InOutPortReg, 0, 0, NoMemAcc, T_NOBR },
{"out", 1, 0xe6, _, W|NoModrm, Imm8, 0, 0, NoMemAcc, T_NOBR },
{"out", 1, 0xee, _, W|NoModrm, InOutPortReg, 0, 0, NoMemAcc, T_NOBR },
{"out", 1, 0xe6, _, W|NoModrm, Imm8, 0, 0, NoMemAcc, T_NOBR },
{"out", 1, 0xee, _, W|NoModrm, InOutPortReg, 0, 0, NoMemAcc, T_NOBR },

#if 0
{"inb",  1, 0xe4, _, NoModrm, Imm8, 0, 0, NoMemAcc, T_NOBR },
{"inb",  1, 0xec, _, NoModrm, WordMem, 0, 0, NoMemAcc, T_NOBR },
{"inw",  1, 0x66e5, _, NoModrm, Imm8, 0, 0, NoMemAcc, T_NOBR },
{"inw",  1, 0x66ed, _, NoModrm, WordMem, 0, 0, NoMemAcc, T_NOBR },
{"outb", 1, 0xe6, _, NoModrm, Imm8, 0, 0, NoMemAcc, T_NOBR },
{"outb", 1, 0xee, _, NoModrm, WordMem, 0, 0, NoMemAcc, T_NOBR },
{"outw", 1, 0x66e7, _, NoModrm, Imm8, 0, 0, NoMemAcc, T_NOBR },
{"outw", 1, 0x66ef, _, NoModrm, WordMem, 0, 0, NoMemAcc, T_NOBR },
#endif

/* load effective address */
{"lea", 1, 0x8d, _, Modrm, WordMem, 0, 0, NoMemAcc, T_NOBR },

/* load segment registers from memory */
{"lds", 1, 0xc5, _, Modrm, Mem48, 0, 0, ReadMem, T_NOBR },
{"les", 1, 0xc4, _, Modrm, Mem48, 0, 0, ReadMem, T_NOBR },
{"lfs", 1, 0x0fb4, _, Modrm, Mem48, 0, 0, ReadMem, T_NOBR },
{"lgs", 1, 0x0fb5, _, Modrm, Mem48, 0, 0, ReadMem, T_NOBR },
{"lss", 1, 0x0fb2, _, Modrm, Mem48, 0, 0, ReadMem, T_NOBR },

/* flags register instructions */
{"clc", 0, 0xf8, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cld", 0, 0xfc, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cli", 0, 0xfa, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"clts", 0, 0x0f06, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cmc", 0, 0xf5, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"lahf", 0, 0x9f, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"sahf", 0, 0x9e, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"pushf", 0, 0x9c, _, NoModrm, 0, 0, 0, PushOp, T_NOBR },
{"popf", 0, 0x9d, _, NoModrm, 0, 0, 0, PopOp, T_NOBR },
{"stc", 0, 0xf9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"std", 0, 0xfd, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"sti", 0, 0xfb, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },

{"add", 1, 0x0,  _, DW|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"add", 2, 0x83, 0, Modrm, WordReg|WordMem, Imm8S, 0, RAndWMem, T_NOBR },
{"add", 1, 0x4,  _, W|NoModrm, Imm, 0, 0, NoMemAcc, T_NOBR },
{"add", 2, 0x80, 0, W|Modrm, Reg|Mem, Imm, 0, StOp|RAndWMem, T_NOBR },

{"inc", 1, 0x40, _, ShortForm, WordReg, 0, 0, NoMemAcc, T_NOBR },
{"inc", 1, 0xfe, 0, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },

{"sub", 1, 0x28,  _, DW|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"sub", 2, 0x83, 5,  Modrm, WordReg|WordMem, Imm8S, 0, RAndWMem, T_NOBR },
{"sub", 1, 0x2c,  _, W|NoModrm, Imm, 0, 0, NoMemAcc, T_NOBR },
{"sub", 2, 0x80, 5,  W|Modrm, Reg|Mem, Imm, 0, RAndWMem, T_NOBR },

{"dec", 1, 0x48, _, ShortForm, WordReg, 0, 0, NoMemAcc, T_NOBR },
{"dec", 1, 0xfe, 1, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },

{"sbb", 1, 0x18,  _, DW|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"sbb", 2, 0x83, 3,  Modrm, WordReg|WordMem, Imm8S, 0, RAndWMem, T_NOBR },
{"sbb", 1, 0x1c,  _, W|NoModrm, Imm, 0, 0, NoMemAcc, T_NOBR },
{"sbb", 2, 0x80, 3,  W|Modrm, Reg|Mem, Imm, 0, RAndWMem, T_NOBR },

{"cmp", 1, 0x38,  _, DW|Modrm, Reg|Mem, 0, 0, ReadMem, T_NOBR },
{"cmp", 2, 0x83, 7,  Modrm, WordReg|WordMem, Imm8S, 0, ReadMem, T_NOBR },
{"cmp", 1, 0x3c,  _, W|NoModrm, Imm, 0, 0, NoMemAcc, T_NOBR },
{"cmp", 2, 0x80, 7,  W|Modrm, Reg|Mem, Imm, 0, ReadMem, T_NOBR },

{"test", 1, 0x84, _, W|Modrm, Reg|Mem, 0, 0, ReadMem, T_NOBR },
/* {"test", 2, 0x84, _, W|Modrm, Reg, Reg|Mem, 0, ReadMem, T_NOBR }, */
{"test", 1, 0xa8, _, W|NoModrm, Imm, 0, 0, NoMemAcc, T_NOBR },
{"test", 2, 0xf6, 0, W|Modrm, Reg|Mem, Imm, 0, ReadMem, T_NOBR },

{"and", 1, 0x20, _, DW|Modrm, Reg|Mem, 0, 0, WriteMem, T_NOBR },
{"and", 2, 0x83, 4, Modrm, WordReg|WordMem, Imm8S, 0, WriteMem, T_NOBR },
{"and", 1, 0x24, _, W|NoModrm, Imm, 0, 0, NoMemAcc, T_NOBR },
{"and", 2, 0x80, 4, W|Modrm, Reg|Mem, Imm, 0, WriteMem, T_NOBR },

{"or", 1, 0x08, _, DW|Modrm, Reg|Mem, 0, 0, WriteMem, T_NOBR },
{"or", 2, 0x83, 1, Modrm, WordReg|WordMem, Imm8S, 0, WriteMem, T_NOBR },
{"or", 1, 0x0c, _, W|NoModrm, Imm, 0, 0, NoMemAcc, T_NOBR },
{"or", 2, 0x80, 1, W|Modrm, Reg|Mem, Imm, 0, WriteMem, T_NOBR },

{"xor", 1, 0x30, _, DW|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"xor", 2, 0x83, 6, Modrm, WordReg|WordMem, Imm8S, 0, RAndWMem, T_NOBR },
{"xor", 1, 0x34, _, W|NoModrm, Imm,  0, 0, NoMemAcc, T_NOBR },
{"xor", 2, 0x80, 6, W|Modrm, Reg|Mem, Imm, 0, RAndWMem, T_NOBR },

{"adc", 1, 0x10, _, DW|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"adc", 2, 0x83, 2, Modrm, WordReg|WordMem, Imm8S, 0, RAndWMem, T_NOBR },
{"adc", 1, 0x14, _, W|NoModrm, Imm,  0, 0, NoMemAcc, T_NOBR },
{"adc", 2, 0x80, 2, W|Modrm, Reg|Mem, Imm, 0, RAndWMem, T_NOBR },

{"neg", 1, 0xf6, 3, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"not", 1, 0xf6, 2, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },

{"aaa", 0, 0x37, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"aas", 0, 0x3f, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"daa", 0, 0x27, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"das", 0, 0x2f, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"aad", 0, 0xd50a, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"aam", 0, 0xd40a, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },

/* conversion insns */
/* conversion:  intel naming */
/* {"cbw", 0, 0x6698, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cwd", 0, 0x6699, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR }, */
{"cwde", 0, 0x98, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cdq", 0, 0x99, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
/*  att naming */
/* {"cbtw", 0, 0x6698, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cwtl", 0, 0x98, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cwtd", 0, 0x6699, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cltd", 0, 0x99, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR }, */

/* Warning! the mul/imul (opcode 0xf6) must only have 1 operand!  They are
   expanding 64-bit multiplies, and *cannot* be selected to accomplish
   'imul %ebx, %eax' (opcode 0x0faf must be used in this case)
   These multiplies can only be selected with single operand forms. */
{"mul",  1, 0xf6, 4, W|Modrm, Reg|Mem, 0, 0, ReadMem, T_NOBR },
{"imul", 1, 0xf6, 5, W|Modrm, Reg|Mem, 0, 0, ReadMem, T_NOBR },

/* imulKludge here is needed to reverse the i.rm.reg & i.rm.regmem fields.
   These instructions are exceptions:  'imul $2, %eax, %ecx' would put
   '%eax' in the reg field and '%ecx' in the regmem field if we did not
   switch them. */
{"imul", 1, 0x0faf, _, Modrm|ReverseRegRegmem, WordReg|Mem, 0, 0, ReadMem, T_NOBR },
{"imul", 2, 0x6b, _, Modrm|ReverseRegRegmem, WordReg|Mem, Imm8S, 0, ReadMem, T_NOBR },
{"imul", 2, 0x69, _, Modrm|ReverseRegRegmem, WordReg|Mem, Imm16|Imm32, 0, ReadMem, T_NOBR },
/*
  imul with 2 operands mimicks imul with 3 by puting register both
  in i.rm.reg & i.rm.regmem fields
*/
/* {"imul", 2, 0x6b, _, Modrm|imulKludge, Imm8S, WordReg, 0, ReadMem, T_NOBR },
 {"imul", 2, 0x69, _, Modrm|imulKludge, Imm16|Imm32, WordReg, 0, ReadMem, T_NOBR }, */
{"div", 1, 0xf6, 6, W|Modrm, Reg|Mem, 0, 0, ReadMem, T_NOBR },
/* {"div", 1, 0xf6, 6, W|Modrm, Reg|Mem, 0, 0, ReadMem, T_NOBR }, */
{"idiv", 1, 0xf6, 7, W|Modrm, Reg|Mem, 0, 0, ReadMem, T_NOBR },
/* {"idiv", 1, 0xf6, 7, W|Modrm, Reg|Mem, 0, 0, ReadMem, T_NOBR }, */

{"rol", 1, 0xd0, 0, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"rol", 2, 0xc0, 0, W|Modrm, Reg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"rol", 1, 0xd2, 0, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
/* {"rol", 1, 0xd0, 0, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR }, */

{"ror", 1, 0xd0, 1, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"ror", 2, 0xc0, 1, W|Modrm, Reg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"ror", 1, 0xd2, 1, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
/* {"ror", 1, 0xd0, 1, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR }, */

/* {"rcl", 2, 0xd0, 2, W|Modrm, Imm1, Reg|Mem, 0, RAndWMem, T_NOBR }, */
{"rcl", 2, 0xc0, 2, W|Modrm, Reg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"rcl", 1, 0xd2, 2, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
/* {"rcl", 1, 0xd0, 2, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR }, */

/* {"rcr", 2, 0xd0, 3, W|Modrm, Imm1, Reg|Mem, 0, RAndWMem, T_NOBR }, */
{"rcr", 2, 0xc0, 3, W|Modrm, Reg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"rcr", 1, 0xd2, 3, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"rcr", 1, 0xd0, 3, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },

/* {"sal", 2, 0xd0, 4, W|Modrm, Imm1, Reg|Mem, 0, RAndWMem, T_NOBR }, */
{"sal", 2, 0xc0, 4, W|Modrm, Reg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"sal", 1, 0xd2, 4, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"sal", 1, 0xd0, 4, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },

/* {"shl", 2, 0xd0, 4, W|Modrm, Imm1, Reg|Mem, 0, RAndWMem, T_NOBR }, */
{"shl", 2, 0xc0, 4, W|Modrm, Reg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"shl", 1, 0xd2, 4, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"shl", 1, 0xd0, 4, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },

{"shld", 2, 0x0fa4, _, Modrm, WordReg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"shld", 1, 0x0fa5, _, Modrm, WordReg|Mem, 0, 0, RAndWMem, T_NOBR },
/* {"shld", 2, 0x0fa5, _, Modrm, WordReg, WordReg|Mem, 0, RAndWMem, T_NOBR }, */

/* {"shr", 2, 0xd0, 5, W|Modrm, Imm1, Reg|Mem, 0, RAndWMem, T_NOBR }, */
{"shr", 2, 0xc0, 5, W|Modrm, Reg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"shr", 1, 0xd2, 5, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"shr", 1, 0xd0, 5, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },

{"shrd", 2, 0x0fac, _, Modrm, WordReg|Mem, Imm8, 0, RAndWMem, T_NOBR },
/* {"shrd", 3, 0x0fad, _, Modrm, ShiftCount, WordReg, WordReg|Mem, RAndWMem, T_NOBR }, */
{"shrd", 1, 0x0fad, _, Modrm, WordReg|Mem, 0, 0, RAndWMem, T_NOBR },

/* {"sar", 2, 0xd0, 7, W|Modrm, Imm1, Reg|Mem, 0, RAndWMem, T_NOBR }, */
{"sar", 2, 0xc0, 7, W|Modrm, Reg|Mem, Imm8, 0, RAndWMem, T_NOBR },
{"sar", 1, 0xd2, 7, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"sar", 1, 0xd0, 7, W|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },

/* control transfer instructions */
#define CALL_PC_RELATIVE 0xe8
{"call", 1, 0xe8, _, JumpDword, Disp32, 0, 0, StackOp, T_CALL },
{"call", 1, 0xff, 2, Modrm, Reg|Mem|JumpAbsolute, 0, 0, ReadMem, T_CALL },
#define CALL_FAR_IMMEDIATE 0x9a
{"lcall", 2, 0x9a, _, JumpInterSegment, Imm16, Abs32, 0, NoMemAcc, T_CALL },
{"lcall", 1, 0xff, 3, Modrm, Mem48, 0, 0, ReadMem, T_CALL },

#define JUMP_PC_RELATIVE 0xeb
{"jmp", 1, 0xeb, _, Jump, Disp, 0, 0, NoMemAcc, T_JUMP },
{"jmp", 1, 0xff, 4, Modrm, Reg32|Mem|JumpAbsolute, 0, 0, ReadMem, T_JUMP },
#define JUMP_FAR_IMMEDIATE 0xea
{"ljmp", 2, 0xea, _, JumpInterSegment, Imm16, Imm32, 0, NoMemAcc, T_JUMP },
{"ljmp", 1, 0xff, 5, Modrm, Mem48, 0, 0, ReadMem, T_JUMP },

{"ret", 0, 0xc3, _, NoModrm, 0, 0, 0, StackOp, T_RET },
{"ret", 1, 0xc2, _, NoModrm, Imm16, 0, 0, StackOp, T_RET },
{"lret", 0, 0xcb, _, NoModrm, 0, 0, 0, StackOp, T_RET },
{"lret", 1, 0xca, _, NoModrm, Imm16, 0, 0, StackOp, T_RET },
{"enter", 2, 0xc8, _, NoModrm, Imm16, Imm8, 0, StackOp, T_NOBR },
{"leave", 0, 0xc9, _, NoModrm, 0, 0, 0, StOp|StackOp, T_NOBR },

/* conditional jumps */
{"jo", 1, 0x70, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jno", 1, 0x71, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jb", 1, 0x72, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jc", 1, 0x72, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jnae", 1, 0x72, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jnb", 1, 0x73, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jnc", 1, 0x73, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jae", 1, 0x73, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"je", 1, 0x74, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jz", 1, 0x74, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jne", 1, 0x75, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jnz", 1, 0x75, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jbe", 1, 0x76, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jna", 1, 0x76, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jnbe", 1, 0x77, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"ja", 1, 0x77, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"js", 1, 0x78, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jns", 1, 0x79, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jp", 1, 0x7a, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jpe", 1, 0x7a, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jnp", 1, 0x7b, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jpo", 1, 0x7b, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jl", 1, 0x7c, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jnge", 1, 0x7c, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jnl", 1, 0x7d, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jge", 1, 0x7d, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jle", 1, 0x7e, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jng", 1, 0x7e, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"jnle", 1, 0x7f, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jg", 1, 0x7f, _, Jump, Disp, 0, 0, NoMemAcc, T_CONDBR },

/* these turn into pseudo operations when disp is larger than 8 bits */
#define IS_JUMP_ON_CX_ZERO(o) \
  (o == 0x67e3)
#define IS_JUMP_ON_ECX_ZERO(o) \
  (o == 0xe3)

{"jcxz", 1, 0x67e3, _, JumpByte, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"jecxz", 1, 0xe3, _, JumpByte, Disp, 0, 0, NoMemAcc, T_CONDBR },

#define IS_LOOP_ECX_TIMES(o) \
  (o == 0xe2 || o == 0xe1 || o == 0xe0)

{"loop", 1, 0xe2, _, JumpByte, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"loopz", 1, 0xe1, _, JumpByte, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"loope", 1, 0xe1, _, JumpByte, Disp, 0, 0, NoMemAcc, T_CONDBR },

{"loopnz", 1, 0xe0, _, JumpByte, Disp, 0, 0, NoMemAcc, T_CONDBR },
{"loopne", 1, 0xe0, _, JumpByte, Disp, 0, 0, NoMemAcc, T_CONDBR },

/* set byte on flag instructions */
/* TG: WriteMem or RAndWMem ? BUG */
{"seto", 1, 0x0f90, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setno", 1, 0x0f91, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setb", 1, 0x0f92, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setc", 1, 0x0f92, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setnae", 1, 0x0f92, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setnb", 1, 0x0f93, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setnc", 1, 0x0f93, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setae", 1, 0x0f93, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"sete", 1, 0x0f94, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setz", 1, 0x0f94, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setne", 1, 0x0f95, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setnz", 1, 0x0f95, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setbe", 1, 0x0f96, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setna", 1, 0x0f96, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setnbe", 1, 0x0f97, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"seta", 1, 0x0f97, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"sets", 1, 0x0f98, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setns", 1, 0x0f99, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setp", 1, 0x0f9a, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setpe", 1, 0x0f9a, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setnp", 1, 0x0f9b, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setpo", 1, 0x0f9b, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setl", 1, 0x0f9c, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setnge", 1, 0x0f9c, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setnl", 1, 0x0f9d, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setge", 1, 0x0f9d, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setle", 1, 0x0f9e, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setng", 1, 0x0f9e, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

{"setnle", 1, 0x0f9f, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },
{"setg", 1, 0x0f9f, 0, Modrm, Reg8|Mem, 0, 0, WriteMem, T_NOBR },

#define IS_STRING_INSTRUCTION(o) \
  ((o) == 0xa6 || (o) == 0x6c || (o) == 0x6e || (o) == 0x6e || \
   (o) == 0xac || (o) == 0xa4 || (o) == 0xae || (o) == 0xaa || \
   (o) == 0xd7)

/* string manipulation */
{"cmps", 0, 0xa6, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"scmp", 0, 0xa6, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"ins",  0, 0x6c, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"outs", 0, 0x6e, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"lods", 0, 0xac, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"slod", 0, 0xac, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"movs", 0, 0xa4, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"smov", 0, 0xa4, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"scas", 0, 0xae, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"ssca", 0, 0xae, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"stos", 0, 0xaa, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"ssto", 0, 0xaa, _, W|NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"xlat", 0, 0xd7, _, NoModrm, 0, 0, 0, StrOp, T_NOBR },

/* bit manipulation */
{"bsf", 1, 0x0fbc, _, Modrm|ReverseRegRegmem, WordReg|WordMem, 0, 0, RAndWMem, T_NOBR },
{"bsr", 1, 0x0fbd, _, Modrm|ReverseRegRegmem, WordReg|WordMem, 0, 0, RAndWMem, T_NOBR },
{"bt", 1, 0x0fa3, _, Modrm, WordReg|WordMem, 0, 0, RAndWMem, T_NOBR },
{"bt", 2, 0x0fba, 4, Modrm, WordReg|WordMem, Imm8, 0, RAndWMem, T_NOBR },
{"btc", 1, 0x0fbb, _, Modrm, WordReg|WordMem, 0, 0, RAndWMem, T_NOBR },
{"btc", 2, 0x0fba, 7, Modrm, WordReg|WordMem, Imm8, 0, RAndWMem, T_NOBR },
{"btr", 1, 0x0fb3, _, Modrm, WordReg|WordMem, 0, 0, RAndWMem, T_NOBR },
{"btr", 2, 0x0fba, 6, Modrm, WordReg|WordMem, Imm8, 0, RAndWMem, T_NOBR },
{"bts", 1, 0x0fab, _, Modrm, WordReg|WordMem, 0, 0, RAndWMem, T_NOBR },
{"bts", 2, 0x0fba, 5, Modrm, WordReg|WordMem, Imm8, 0, RAndWMem, T_NOBR },

/* interrupts & op. sys insns */
/* See i386.c for conversion of 'int $3' into the special int 3 insn. */
#define INT_OPCODE 0xcd
#define INT3_OPCODE 0xcc
{"int", 1, 0xcd, _, NoModrm, Imm8, 0, 0, IntOp, T_NOBR },
{"int3", 0, 0xcc, _, NoModrm, 0, 0, 0, IntOp, T_NOBR },
{"into", 0, 0xce, _, NoModrm, 0, 0, 0, IntOp, T_NOBR },
{"iret", 0, 0xcf, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },

/* TG: BUG */
{"boundl", 2, 0x62, _, Modrm, Reg32, Mem, 0, RF64bOp, T_NOBR },
{"boundw", 2, 0x6662, _, Modrm, Reg16, Mem, 0, RF32bOp, T_NOBR },

{"hlt", 0, 0xf4, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"wait", 0, 0x9b, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
/* nop is actually 'xchgl %eax, %eax' */
{"nop", 0, 0x90, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },

/* protection control */
{"arpl", 1, 0x63, _, Modrm, Reg16|Mem, 0, 0, ReadMem, T_NOBR },
{"lar", 1, 0x0f02, _, Modrm|ReverseRegRegmem, WordReg|Mem, 0, 0, ReadMem},
{"lgdt", 1, 0x0f01, 2, Modrm, Mem, 0, 0, RProtOp, T_NOBR },
{"lidt", 1, 0x0f01, 3, Modrm, Mem, 0, 0, RProtOp, T_NOBR },
{"lldt", 1, 0x0f00, 2, Modrm, WordReg|Mem, 0, 0, ReadMem, T_NOBR },
{"lmsw", 1, 0x0f01, 6, Modrm, WordReg|Mem, 0, 0, ReadMem, T_NOBR },
{"lsl", 1, 0x0f03, _, Modrm|ReverseRegRegmem, WordReg|Mem, 0, 0, ReadMem, T_NOBR },
{"ltr", 1, 0x0f00, 3, Modrm, WordReg|Mem, 0, 0, ReadMem, T_NOBR },

{"sgdt", 1, 0x0f01, 0, Modrm, Mem, 0, 0, WProtOp, T_NOBR },
{"sidt", 1, 0x0f01, 1, Modrm, Mem, 0, 0, WProtOp, T_NOBR },
{"sldt", 1, 0x0f00, 0, Modrm, WordReg|Mem, 0, 0, WriteMem, T_NOBR },
{"smsw", 1, 0x0f01, 4, Modrm, WordReg|Mem, 0, 0, WriteMem, T_NOBR },
{"str", 1, 0x0f00, 1, Modrm, Reg16|Mem, 0, 0, WriteMem, T_NOBR },

{"verr", 1, 0x0f00, 4, Modrm, WordReg|Mem, 0, 0, NoMemAcc, T_NOBR },
{"verw", 1, 0x0f00, 5, Modrm, WordReg|Mem, 0, 0, NoMemAcc, T_NOBR },

/* floating point instructions */

/* load */
{"fld", 1, 0xd9c0, _, ShortForm, FloatReg, 0, 0, T_NOBR }, /* register */
{"flds", 1, 0xd9, 0, Modrm, Mem, 0, 0, RF32bOp, T_NOBR }, /* %st0 <-- mem float */
{"fldl", 1, 0xdd, 0, Modrm, Mem, 0, 0, RF64bOp, T_NOBR }, /* %st0 <-- mem double */
{"fldl", 1, 0xd9c0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR }, /* register */
{"fild", 1, 0xdf, 0, Modrm, Mem, 0, 0, RF16bOp, T_NOBR },  /* %st0 <-- mem word (16) */
{"fildl", 1, 0xdb, 0, Modrm, Mem, 0, 0, RF32bOp, T_NOBR }, /* %st0 <-- mem dword (32) */
{"fildq",1, 0xdf, 5, Modrm, Mem, 0, 0, RF64bOp, T_NOBR },  /* %st0 <-- mem qword (64) */
{"fildll",1, 0xdf, 5, Modrm, Mem, 0, 0, RF64bOp, T_NOBR }, /* %st0 <-- mem qword (64) */
{"fldt", 1, 0xdb, 5, Modrm, Mem, 0, 0, RF80bOp, T_NOBR },  /* %st0 <-- mem efloat */
{"fbld", 1, 0xdf, 4, Modrm, Mem, 0, 0, RF80bOp, T_NOBR },  /* %st0 <-- mem bcd */

/* store (no pop) */
{"fst", 1, 0xddd0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR }, /* register */
{"fsts", 1, 0xd9, 2, Modrm, Mem, 0, 0, WF32bOp, T_NOBR }, /* %st0 --> mem float */
{"fstl", 1, 0xdd, 2, Modrm, Mem, 0, 0, WF64bOp, T_NOBR }, /* %st0 --> mem double */
{"fstl", 1, 0xddd0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR }, /* register */
{"fist", 1, 0xdf, 2, Modrm, Mem, 0, 0, WF16bOp, T_NOBR }, /* %st0 --> mem word (16) */
{"fistl", 1, 0xdb, 2, Modrm, Mem, 0, 0, WF32bOp, T_NOBR }, /* %st0 --> mem dword (32) */

/* store (with pop) */
{"fstp", 1, 0xddd8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR }, /* register */
{"fstps", 1, 0xd9, 3, Modrm, Mem, 0, 0, WF32bOp, T_NOBR }, /* %st0 --> mem float */
{"fstpl", 1, 0xdd, 3, Modrm, Mem, 0, 0, WF64bOp, T_NOBR }, /* %st0 --> mem double */
{"fstpl", 1, 0xddd8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR }, /* register */
{"fistp", 1, 0xdf, 3, Modrm, Mem, 0, 0, WF16bOp},  /* %st0 --> mem word (16) */
{"fistpl",1, 0xdb, 3, Modrm, Mem, 0, 0, WF32bOp},  /* %st0 --> mem dword (32) */
{"fistpq",1, 0xdf, 7, Modrm, Mem, 0, 0, WF64bOp},  /* %st0 --> mem qword (64) */
{"fistpll",1,0xdf, 7, Modrm, Mem, 0, 0, WF64bOp},  /* %st0 --> mem qword (64) */
{"fstpt", 1, 0xdb, 7, Modrm, Mem, 0, 0, WF80bOp},  /* %st0 --> mem efloat */
{"fbstp", 1, 0xdf, 6, Modrm, Mem, 0, 0, WF80bOp},  /* %st0 --> mem bcd */

/* exchange %st<n> with %st0 */
{"fxch", 1, 0xd9c8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },

/* comparison (without pop) */
{"fcom", 1, 0xd8d0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fcoms", 1, 0xd8, 2, Modrm, Mem, 0, 0, RF32bOp, T_NOBR }, /* compare %st0, mem float */
{"ficoml", 1, 0xda, 2, Modrm, Mem, 0, 0, RF16bOp, T_NOBR }, /* compare %st0, mem word */ 
{"fcoml", 1, 0xdc, 2, Modrm, Mem, 0, 0, RF64bOp, T_NOBR }, /* compare %st0, mem double */
{"fcoml", 1, 0xd8d0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"ficoms", 1, 0xde, 2, Modrm, Mem, 0, 0, RF32bOp, T_NOBR }, /* compare %st0, mem dword */

/* comparison (with pop) */
{"fcomp", 1, 0xd8d8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fcomps", 1, 0xd8, 3, Modrm, Mem, 0, 0, RF32bOp, T_NOBR }, /* compare %st0, mem float  */
{"ficompl", 1, 0xda, 3, Modrm, Mem, 0, 0, RF16bOp, T_NOBR }, /* compare %st0, mem word  */ 
{"fcompl", 1, 0xdc, 3, Modrm, Mem, 0, 0, RF64bOp, T_NOBR }, /* compare %st0, mem double  */
{"fcompl", 1, 0xd8d8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"ficomps", 1, 0xde, 3, Modrm, Mem, 0, 0, RF32bOp, T_NOBR }, /* compare %st0, mem dword */
{"fcompp", 0, 0xded9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR }, /* compare %st0, %st1 & pop 2 */

/* unordered comparison (with pop) */
{"fucom", 1, 0xdde0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fucomp", 1, 0xdde8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fucompp", 0, 0xdae9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR }, /* ucompare %st0, %st1 & pop twice */

{"ftst", 0, 0xd9e4, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },	/* test %st0 */
{"fxam", 0, 0xd9e5, _, NoModrm, 0, 0, 0, NoMemAcc},	/* examine %st0 */

/* load constants into %st0 */
{"fld1", 0, 0xd9e8, _, NoModrm, 0, 0, 0, NoMemAcc},	/* %st0 <-- 1.0 */
{"fldl2t", 0, 0xd9e9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },	/* %st0 <-- log2(10) */
{"fldl2e", 0, 0xd9ea, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },	/* %st0 <-- log2(e) */
{"fldpi", 0, 0xd9eb, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },	/* %st0 <-- pi */
{"fldlg2", 0, 0xd9ec, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },	/* %st0 <-- log10(2) */
{"fldln2", 0, 0xd9ed, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },	/* %st0 <-- ln(2) */
{"fldz", 0, 0xd9ee, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },	/* %st0 <-- 0.0 */

/* arithmetic */

/* add */
{"fadd", 1, 0xd8c0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fadd", 1, 0xd8c0, _, ShortForm|FloatD, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fadd", 0, 0xdcc1, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR }, /* alias for fadd %st, %st(1) */
{"faddp", 1, 0xdac0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"faddp", 1, 0xdac0, _, ShortForm|FloatD, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"faddp", 0, 0xdec1, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR }, /* alias for faddp %st, %st(1) */
{"fadds", 1, 0xd8, 0, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fiaddl", 1, 0xda, 0, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"faddl", 1, 0xdc, 0, Modrm, Mem, 0, 0, RF64bOp, T_NOBR },
{"fiadds", 1, 0xde, 0, Modrm, Mem, 0, 0, RF16bOp, T_NOBR },

/* sub */
/* Note:  intel has decided that certain of these operations are reversed
   in assembler syntax. */
{"fsub", 1, 0xd8e0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fsub", 1, 0xd8e0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#ifdef NON_BROKEN_OPCODES
{"fsub", 1, 0xdce8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#else
{"fsub", 1, 0xdce0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#endif
{"fsub", 0, 0xdce1, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fsubp", 1, 0xdae0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fsubp", 1, 0xdae0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#ifdef NON_BROKEN_OPCODES
{"fsubp", 1, 0xdee8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#else
{"fsubp", 1, 0xdee0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#endif
{"fsubp", 0, 0xdee1, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fsubs", 1, 0xd8, 4, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fisubl", 1, 0xda, 4, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fsubl", 1, 0xdc, 4, Modrm, Mem, 0, 0, RF64bOp, T_NOBR },
{"fisubs", 1, 0xde, 4, Modrm, Mem, 0, 0, RF16bOp, T_NOBR },

/* sub reverse */
{"fsubr", 1, 0xd8e8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fsubr", 1, 0xd8e8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#ifdef NON_BROKEN_OPCODES
{"fsubr", 1, 0xdce0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#else
{"fsubr", 1, 0xdce8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#endif
{"fsubr", 0, 0xdce9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fsubrp", 1, 0xdae8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fsubrp", 1, 0xdae8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#ifdef NON_BROKEN_OPCODES
{"fsubrp", 1, 0xdee0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#else
{"fsubrp", 1, 0xdee8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#endif
{"fsubrp", 0, 0xdee9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fsubrs", 1, 0xd8, 5, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fisubrl", 1, 0xda, 5, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fsubrl", 1, 0xdc, 5, Modrm, Mem, 0, 0, RF64bOp, T_NOBR },
{"fisubrs", 1, 0xde, 5, Modrm, Mem, 0, 0, RF16bOp, T_NOBR },

/* mul */
{"fmul", 1, 0xd8c8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fmul", 1, 0xd8c8, _, ShortForm|FloatD, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fmul", 0, 0xdcc9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fmulp", 1, 0xdac8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fmulp", 1, 0xdac8, _, ShortForm|FloatD, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fmulp", 0, 0xdec9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fmuls", 1, 0xd8, 1, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fimull", 1, 0xda, 1, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fmull", 1, 0xdc, 1, Modrm, Mem, 0, 0, RF64bOp, T_NOBR },
{"fimuls", 1, 0xde, 1, Modrm, Mem, 0, 0, RF16bOp, T_NOBR },

/* div */
/* Note:  intel has decided that certain of these operations are reversed
   in assembler syntax. */
{"fdiv", 1, 0xd8f0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fdiv", 1, 0xd8f0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#ifdef NON_BROKEN_OPCODES
{"fdiv", 1, 0xdcf8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#else
{"fdiv", 1, 0xdcf0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#endif
{"fdiv", 0, 0xdcf1, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fdivp", 1, 0xdaf0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fdivp", 1, 0xdaf0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#ifdef NON_BROKEN_OPCODES
{"fdivp", 1, 0xdef8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#else
{"fdivp", 1, 0xdef0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#endif
{"fdivp", 0, 0xdef1, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fdivs", 1, 0xd8, 6, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fidivl", 1, 0xda, 6, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fdivl", 1, 0xdc, 6, Modrm, Mem, 0, 0, RF64bOp, T_NOBR },
{"fidivs", 1, 0xde, 6, Modrm, Mem, 0, 0, RF16bOp, T_NOBR },

/* div reverse */
{"fdivr", 1, 0xd8f8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fdivr", 1, 0xd8f8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#ifdef NON_BROKEN_OPCODES
{"fdivr", 1, 0xdcf0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#else
{"fdivr", 1, 0xdcf8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#endif
{"fdivr", 0, 0xdcf9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fdivrp", 1, 0xdaf8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fdivrp", 1, 0xdaf8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#ifdef NON_BROKEN_OPCODES
{"fdivrp", 1, 0xdef0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#else
{"fdivrp", 1, 0xdef8, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
#endif
{"fdivrp", 0, 0xdef9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fdivrs", 1, 0xd8, 7, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fidivrl", 1, 0xda, 7, Modrm, Mem, 0, 0, RF32bOp, T_NOBR },
{"fdivrl", 1, 0xdc, 7, Modrm, Mem, 0, 0, RF64bOp, T_NOBR },
{"fidivrs", 1, 0xde, 7, Modrm, Mem, 0, 0, RF16bOp, T_NOBR },

{"f2xm1", 0,   0xd9f0, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fyl2x", 0,   0xd9f1, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fptan", 0,   0xd9f2, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fpatan", 0,  0xd9f3, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fxtract", 0, 0xd9f4, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fprem1", 0,  0xd9f5, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fdecstp", 0,  0xd9f6, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fincstp", 0,  0xd9f7, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fprem", 0,   0xd9f8, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fyl2xp1", 0, 0xd9f9, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fsqrt", 0,   0xd9fa, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fsincos", 0, 0xd9fb, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"frndint", 0, 0xd9fc, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fscale", 0,  0xd9fd, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fsin", 0,    0xd9fe, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fcos", 0,    0xd9ff, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },

{"fchs", 0, 0xd9e0, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fabs", 0, 0xd9e1, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },

/* processor control */
{"fninit", 0, 0xdbe3, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"finit", 0, 0xdbe3, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fldcw", 1, 0xd9, 5, Modrm, Mem, 0, 0, RF16bOp, T_NOBR },
{"fnstcw", 1, 0xd9, 7, Modrm, Mem, 0, 0, WF16bOp, T_NOBR },
{"fstcw", 0, 0xd9, 7, Modrm, Mem, 0, 0, WF16bOp, T_NOBR },
{"fnstsw", 1, 0xdfe0, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fnstsw", 1, 0xdd, 7, Modrm, Mem, 0, 0, WF16bOp, T_NOBR },
{"fnstsw", 0, 0xdfe0, _, NoModrm, 0, 0, 0, NoMemAcc , T_NOBR },
{"fstsw", 0, 0xdfe0, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fstsw", 1, 0xdd, 7, Modrm, Mem, 0, 0, WF16bOp, T_NOBR },
{"fstsw", 0, 0xdfe0, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fnclex", 0, 0xdbe2, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fclex", 0, 0xdbe2, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
/*
 We ignore the short format (287) versions of fstenv/fldenv & fsave/frstor
 instructions;  i'm not sure how to add them or how they are different.
 My 386/387 book offers no details about this.
*/
/* TG: I don't known how memory is used BUG */
{"fnstenv", 1, 0xd9, 6, Modrm, Mem, 0, 0, WF80bOp, T_NOBR },
{"fstenv", 1, 0xd9, 6, Modrm, Mem, 0, 0, WF80bOp, T_NOBR },
{"fldenv", 1, 0xd9, 4, Modrm, Mem, 0, 0, RF80bOp, T_NOBR },
{"fnsave", 1, 0xdd, 6, Modrm, Mem, 0, 0, WF80bOp, T_NOBR },
{"fsave", 1, 0xdd, 6, Modrm, Mem, 0, 0, WF80bOp, T_NOBR },
{"frstor", 1, 0xdd, 4, Modrm, Mem, 0, 0, WF80bOp, T_NOBR },

{"ffree", 1, 0xddc0, _, ShortForm, FloatReg, 0, 0, NoMemAcc, T_NOBR },
{"fnop", 0, 0xd9d0, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fwait", 0, 0x9b, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },

/*
  opcode prefixes; we allow them as seperate insns too
  (see prefix table below)
*/
{"aword", 0, 0x67, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"addr16", 0, 0x67, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"word", 0, 0x66, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"data16", 0, 0x66, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"lock", 0, 0xf0, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"cs", 0, 0x2e, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"ds", 0, 0x3e, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"es", 0, 0x26, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"fs", 0, 0x64, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"gs", 0, 0x65, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"ss", 0, 0x36, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"rep", 0, 0xf3, _, NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"repe", 0, 0xf3, _, NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"repz", 0, 0xf3, _, NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"repne", 0, 0xf2, _, NoModrm, 0, 0, 0, StrOp, T_NOBR },
{"repnz", 0, 0xf2, _, NoModrm, 0, 0, 0, StrOp, T_NOBR },

/* 486 extensions */

{"bswap", 1, 0x0fc8, _, ShortForm, Reg32,0 ,0, NoMemAcc , T_NOBR },
{"xadd", 1, 0x0fc0, _, DW|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"cmpxchg", 1, 0x0fb0, _, DW|Modrm, Reg|Mem, 0, 0, RAndWMem, T_NOBR },
{"invd", 0, 0x0f08, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"wbinvd", 0, 0x0f09, _, NoModrm, 0, 0, 0, NoMemAcc, T_NOBR },
{"invlpg", 1, 0x0f01, 7, Modrm, Mem, 0, 0, NoMemAcc, T_NOBR },

{"", 0, 0, 0, 0, 0, 0, 0, NoMemAcc, T_NOBR }	/* sentinal */
};
#undef _

#if 0
static const template *const i386_optab_end
  = i386_optab + sizeof (i386_optab)/sizeof(i386_optab[0]);

/* 386 register table */
static const reg_entry i386_regtab[] = {
  /* 8 bit regs */
  {"al", Reg8|Acc, 0}, {"cl", Reg8|ShiftCount, 1}, {"dl", Reg8, 2},
  {"bl", Reg8, 3},
  {"ah", Reg8, 4}, {"ch", Reg8, 5}, {"dh", Reg8, 6}, {"bh", Reg8, 7},
  /* 16 bit regs */
  {"ax", Reg16|Acc, 0}, {"cx", Reg16, 1}, {"dx", Reg16|InOutPortReg, 2}, {"bx", Reg16, 3},
  {"sp", Reg16, 4}, {"bp", Reg16, 5}, {"si", Reg16, 6}, {"di", Reg16, 7},
  /* 32 bit regs */
  {"eax", Reg32|Acc, 0}, {"ecx", Reg32, 1}, {"edx", Reg32, 2}, {"ebx", Reg32, 3},
  {"esp", Reg32, 4}, {"ebp", Reg32, 5}, {"esi", Reg32, 6}, {"edi", Reg32, 7},
  /* segment registers */
  {"es", SReg2, 0}, {"cs", SReg2, 1}, {"ss", SReg2, 2},
  {"ds", SReg2, 3}, {"fs", SReg3, 4}, {"gs", SReg3, 5},
  /* control registers */
  {"cr0", Control, 0},   {"cr2", Control, 2},   {"cr3", Control, 3},
  /* debug registers */
  {"db0", Debug, 0},   {"db1", Debug, 1},   {"db2", Debug, 2},
  {"db3", Debug, 3},   {"db6", Debug, 6},   {"db7", Debug, 7},
  /* test registers */
  {"tr6", Test, 6}, {"tr7", Test, 7},
  /* float registers */
  {"st(0)", FloatReg|FloatAcc, 0},
  {"st", FloatReg|FloatAcc, 0},
  {"st(1)", FloatReg, 1}, {"st(2)", FloatReg, 2}, 
  {"st(3)", FloatReg, 3}, {"st(4)", FloatReg, 4}, {"st(5)", FloatReg, 5}, 
  {"st(6)", FloatReg, 6}, {"st(7)", FloatReg, 7}
};

#define MAX_REG_NAME_SIZE 8	/* for parsing register names from input */

static const reg_entry *const i386_regtab_end
  = i386_regtab + sizeof(i386_regtab)/sizeof(i386_regtab[0]);

/* segment stuff */
static const seg_entry cs = { "cs", 0x2e };
static const seg_entry ds = { "ds", 0x3e };
static const seg_entry ss = { "ss", 0x36 };
static const seg_entry es = { "es", 0x26 };
static const seg_entry fs = { "fs", 0x64 };
static const seg_entry gs = { "gs", 0x65 };
static const seg_entry null = { "", 0x0 };

/*
  This table is used to store the default segment register implied by all
  possible memory addressing modes.
  It is indexed by the mode & modrm entries of the modrm byte as follows:
      index = (mode<<3) | modrm;
*/
static const seg_entry *const one_byte_segment_defaults[] = {
  /* mode 0 */
  &ds, &ds, &ds, &ds, &null, &ds, &ds, &ds,
  /* mode 1 */
  &ds, &ds, &ds, &ds, &null, &ss, &ds, &ds,
  /* mode 2 */
  &ds, &ds, &ds, &ds, &null, &ss, &ds, &ds,
  /* mode 3 --- not a memory reference; never referenced */
};

static const seg_entry *const two_byte_segment_defaults[] = {
  /* mode 0 */
  &ds, &ds, &ds, &ds, &ss, &ds, &ds, &ds,
  /* mode 1 */
  &ds, &ds, &ds, &ds, &ss, &ds, &ds, &ds,
  /* mode 2 */
  &ds, &ds, &ds, &ds, &ss, &ds, &ds, &ds,
  /* mode 3 --- not a memory reference; never referenced */
};
#endif

static const prefix_entry i386_prefixtab[] = {
  { "addr16", 0x67 },		/* address size prefix ==> 16bit addressing
				 * (How is this useful?) */
#define WORD_PREFIX_OPCODE 0x66
  { "data16", 0x66 },		/* operand size prefix */
  { "lock", 0xf0 },		/* bus lock prefix */
  { "wait", 0x9b },		/* wait for coprocessor */
  { "cs", 0x2e }, { "ds", 0x3e }, /* segment overrides ... */
  { "es", 0x26 }, { "fs", 0x64 },
  { "gs", 0x65 }, { "ss", 0x36 },
/* REPE & REPNE used to detect rep/repne with a non-string instruction */
#define REPNE 0xf2
#define REPE  0xf3
  { "rep", 0xf3 }, 		/* repeat string instructions */
  { "repe", 0xf3 },  { "repz", 0xf3 },
  { "repne", 0xf2 }, { "repnz", 0xf2 }
};

static const prefix_entry *const i386_prefixtab_end
  = i386_prefixtab + sizeof(i386_prefixtab)/sizeof(i386_prefixtab[0]);

/* end of i386-opcode.h */
