# This shell script emits a C file. -*- C -*-
# It does some substitutions.
cat >e${EMULATION_NAME}.c <<EOF
/* This file is is generated by a shell script.  DO NOT EDIT! */

/* 32 bit ELF emulation code for ${EMULATION_NAME}
   Copyright (C) 1991, 1993, 1994, 1995 Free Software Foundation, Inc.
   Written by Steve Chamberlain <sac@cygnus.com>
   ELF support by Ian Lance Taylor <ian@cygnus.com>

This file is part of GLD, the Gnu Linker.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define TARGET_IS_${EMULATION_NAME}

#include "bfd.h"
#include "sysdep.h"

#include <ctype.h>

#include "bfdlink.h"

#include "ld.h"
#include "config.h"
#include "ldmain.h"
#include "ldemul.h"
#include "ldfile.h"
#include "ldmisc.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldgram.h"

 
/* FIXME: On some hosts we will need to include a different file.
   This is correct for ELF/SVR4, which is the only place this file will
   typically be compiled.  However, if somebody configures the linker
   for all targets, they will run into trouble here.  */
#include <dirent.h>

static void gld${EMULATION_NAME}_before_parse PARAMS ((void));
static boolean gld${EMULATION_NAME}_open_dynamic_archive
  PARAMS ((const char *, lang_input_statement_type *));
static void gld${EMULATION_NAME}_before_allocation PARAMS ((void));
static void gld${EMULATION_NAME}_find_statement_assignment
  PARAMS ((lang_statement_union_type *));
static void gld${EMULATION_NAME}_find_exp_assignment PARAMS ((etree_type *));
static boolean gld${EMULATION_NAME}_place_orphan
  PARAMS ((lang_input_statement_type *, asection *));
static void gld${EMULATION_NAME}_place_section
  PARAMS ((lang_statement_union_type *));
static char *gld${EMULATION_NAME}_get_script PARAMS ((int *isfile));
static boolean gld${EMULATION_NAME}_find_so PARAMS ((lang_input_statement_type *entry));

extern boolean try_open_bfd PARAMS ((const char *attempt,
		lang_input_statement_type *entry));

static void
gld${EMULATION_NAME}_before_parse()
{
  ldfile_output_architecture = bfd_arch_${ARCH};
  config.dynamic_link = ${DYNAMIC_LINK-true};
}

/* figure out which library is greater */
static int libcmp(p1, p2)
  char *p1, *p2;
{
    while (*p1)
    {
	if (isdigit(*p1) && isdigit(*p2))
	{
	    /* must compare this numerically */
	    int v1, v2;
	    v1 = strtoul(p1, &p1, 10);
	    v2 = strtoul(p2, &p2, 10);
	    if (v1 != v2)
		return v1 - v2;
	}
	else if (*p1 != *p2)
	    return *p1 - *p2;
	else
	    p1++, p2++;
    }

    return *p1 - *p2;
}

/* Search for and open the .so file specified by ENTRY until
   a match .so or .a file is found. H.J. */
static boolean
gld${EMULATION_NAME}_find_so (entry)
     lang_input_statement_type *entry;
{
  search_dirs_type *search;
  char *filename;
  unsigned int len;
  char *found;
  boolean found_static;

  found_static = false;
  found = NULL;
  filename = (char *) entry->filename;
  len = strlen (filename);
  for (search = search_head;
       search != (search_dirs_type *)NULL;
       search = search->next) 
  {
    DIR *dir;
    struct dirent *ent;

    /* We try this directory. */
    dir = opendir (search->name);
    if (dir == NULL)
      continue;

    while ((ent = readdir (dir)) != NULL)
    {
      /* We are looking for libxxxx.*. */
      if (ent->d_name [len + 3] != '.'
	  || strncmp (ent->d_name, "lib", 3) != 0
	  || strncmp (ent->d_name + 3, filename, len) != 0)
	continue;

      if (strncmp (ent->d_name + 3 + len, ".a", 2) == 0)
      {
	found_static = true;
	continue;
      }

      if (strncmp (ent->d_name + 3 + len, ".so", 3) != 0)
	continue;

      /* We've found a lib*.so.x.x.x file. We compare it with the
	 one we have found if there is one. */
      if (found == NULL)
      {
	found = (char *) xmalloc (strlen (ent->d_name) + 1);
	strcpy (found, ent->d_name);
      }
      else
      {
	if (libcmp (&ent->d_name [len + 6], &found [len + 6]) > 0)
	{
	  free (found);
	  found = (char *) xmalloc (strlen (ent->d_name) + 1);
	  strcpy (found, ent->d_name);
	}
      }
    }

    closedir (dir);

    /* We find a shared or static library. */
    if (found != NULL || found_static == true)
      break;
  }

  if (found == NULL)
  {
    /* We did not find a matching .so file.  This isn't an error,
       since there might still be a matching .a file, which will be
       found by the usual search.  */
    return false;
  }

  filename = (char *) xmalloc (strlen (search->name)
	+ strlen (found) + 2);
  sprintf (filename, "%s/%s", search->name, found);

  free (found);

  /* Give it a try */
  if (try_open_bfd (filename, entry)) 
  {
    entry->filename = filename;
    return true;
  }
  else
  {
    free (filename);
    return false;
  }
}

/* Try to open a dynamic archive.  This is where we know that ELF
   dynamic libraries have an extension of .so.  */

static boolean
gld${EMULATION_NAME}_open_dynamic_archive (arch, entry)
     const char *arch;
     lang_input_statement_type *entry;
{
  if (gld${EMULATION_NAME}_find_so (entry) == false)
    return false;

  /* We have found a dynamic object to include in the link.  The ELF
     backend linker will create a DT_NEEDED entry in the .dynamic
     section naming this file.  If this file includes a DT_SONAME
     entry, it will be used.  Otherwise, the ELF linker will just use
     the name of the file.  For an archive found by searching, like
     this one, the DT_NEEDED entry should consist of just the name of
     the file, without the path information used to find it.  Note
     that we only need to do this if we have a dynamic object; an
     archive will never be referenced by a DT_NEEDED entry.

     FIXME: This approach--using bfd_elf_set_dt_needed_name--is not
     very pretty.  I haven't been able to think of anything that is
     pretty, though.  */
  if (bfd_check_format (entry->the_bfd, bfd_object)
      && (entry->the_bfd->flags & DYNAMIC) != 0)
    {
      char *needed_name;
      char *shlib;

      ASSERT (entry->is_archive && entry->search_dirs_flag);

      /* We may have /xxxxx/libxxxx.so.x.x.x. We only want the
       * libxxx.so.x.x.x part. */
      shlib = strrchr (entry->filename, '/');
      needed_name = strdup (shlib ? shlib + 1 : entry->filename);
      bfd_elf_set_dt_needed_name (entry->the_bfd, needed_name);
    }

  return true;
}

/* This is called after the sections have been attached to output
   sections, but before any sizes or addresses have been set.  */

static void
gld${EMULATION_NAME}_before_allocation ()
{
  asection *sinterp;

  /* If we are going to make any variable assignments, we need to let
     the ELF backend know about them in case the variables are
     referred to by dynamic objects.  */
  lang_for_each_statement (gld${EMULATION_NAME}_find_statement_assignment);

  /* Let the ELF backend work out the sizes of any sections required
     by dynamic linking.  */
  if (! bfd_elf32_size_dynamic_sections (output_bfd,
					 command_line.soname,
					 command_line.rpath,
					 command_line.export_dynamic,
					 &link_info,
					 &sinterp))
    einfo ("%P%F: failed to set dynamic section sizes: %E\n");

  /* Let the user override the dynamic linker we are using.  */
  if (command_line.interpreter != NULL
      && sinterp != NULL)
    {
      sinterp->contents = (bfd_byte *) command_line.interpreter;
      sinterp->_raw_size = strlen (command_line.interpreter) + 1;
    }

  /* Look for any sections named .gnu.warning.  As a GNU extensions,
     we treat such sections as containing warning messages.  We print
     out the warning message, and then zero out the section size so
     that it does not get copied into the output file.  */

  {
    LANG_FOR_EACH_INPUT_STATEMENT (is)
      {
	asection *s;
	bfd_size_type sz;
	char *msg;
	boolean ret;

	if (is->just_syms_flag)
	  continue;

	s = bfd_get_section_by_name (is->the_bfd, ".gnu.warning");
	if (s == NULL)
	  continue;

	sz = bfd_section_size (is->the_bfd, s);
	msg = xmalloc ((size_t) sz + 1);
	if (! bfd_get_section_contents (is->the_bfd, s, msg, (file_ptr) 0, sz))
	  einfo ("%F%B: Can't read contents of section .gnu.warning: %E\n",
		 is->the_bfd);
	msg[sz] = '\0';
	ret = link_info.callbacks->warning (&link_info, msg);
	ASSERT (ret);
	free (msg);

	/* Clobber the section size, so that we don't waste copying the
	   warning into the output file.  */
	s->_raw_size = 0;
      }
  }

#if defined (TARGET_IS_elf32bmip) || defined (TARGET_IS_elf32lmip)
  /* For MIPS ELF the .reginfo section requires special handling.
     Each input section is 24 bytes, and the final output section must
     also be 24 bytes.  We handle this by clobbering all but the first
     input section size to 0.  The .reginfo section is handled
     specially by the backend code anyhow.  */
  {
    boolean found = false;
    LANG_FOR_EACH_INPUT_STATEMENT (is)
      {
	asection *s;

	if (is->just_syms_flag)
	  continue;

	s = bfd_get_section_by_name (is->the_bfd, ".reginfo");
	if (s == NULL)
	  continue;

	if (! found)
	  {
	    found = true;
	    continue;
	  }

	s->_raw_size = 0;
	s->_cooked_size = 0;
      }
  }
#endif
}

/* This is called by the before_allocation routine via
   lang_for_each_statement.  It locates any assignment statements, and
   tells the ELF backend about them, in case they are assignments to
   symbols which are referred to by dynamic objects.  */

static void
gld${EMULATION_NAME}_find_statement_assignment (s)
     lang_statement_union_type *s;
{
  if (s->header.type == lang_assignment_statement_enum)
    gld${EMULATION_NAME}_find_exp_assignment (s->assignment_statement.exp);
}

/* Look through an expression for an assignment statement.  */

static void
gld${EMULATION_NAME}_find_exp_assignment (exp)
     etree_type *exp;
{
  switch (exp->type.node_class)
    {
    case etree_assign:
      if (strcmp (exp->assign.dst, ".") != 0)
	{
	  if (! bfd_elf32_record_link_assignment (output_bfd, &link_info,
						  exp->assign.dst))
	    einfo ("%P%F: failed to record assignment to %s: %E\n",
		   exp->assign.dst);
	}
      gld${EMULATION_NAME}_find_exp_assignment (exp->assign.src);
      break;

    case etree_binary:
      gld${EMULATION_NAME}_find_exp_assignment (exp->binary.lhs);
      gld${EMULATION_NAME}_find_exp_assignment (exp->binary.rhs);
      break;

    case etree_trinary:
      gld${EMULATION_NAME}_find_exp_assignment (exp->trinary.lhs);
      gld${EMULATION_NAME}_find_exp_assignment (exp->trinary.lhs);
      gld${EMULATION_NAME}_find_exp_assignment (exp->trinary.rhs);
      break;

    case etree_unary:
      gld${EMULATION_NAME}_find_exp_assignment (exp->unary.child);
      break;

    default:
      break;
    }
}

/* Place an orphan section.  We use this to put random SHF_ALLOC
   sections in the right segment.  */

static asection *hold_section;
static lang_output_section_statement_type *hold_use;
static lang_output_section_statement_type *hold_text;
static lang_output_section_statement_type *hold_data;
static lang_output_section_statement_type *hold_bss;
static lang_output_section_statement_type *hold_rel;

/*ARGSUSED*/
static boolean
gld${EMULATION_NAME}_place_orphan (file, s)
     lang_input_statement_type *file;
     asection *s;
{
  lang_output_section_statement_type *place;
  asection *snew, **pps;
  lang_statement_list_type *old;
  lang_statement_list_type add;
  etree_type *address;
  const char *secname, *ps;
  lang_output_section_statement_type *os;

  if ((s->flags & SEC_ALLOC) == 0)
    return false;

  /* Look through the script to see where to place this section.  */
  hold_section = s;
  hold_use = NULL;
  lang_for_each_statement (gld${EMULATION_NAME}_place_section);

  if (hold_use != NULL)
    {
      /* We have already placed a section with this name.  */
      wild_doit (&hold_use->children, s, hold_use, file);
      return true;
    }

  secname = bfd_get_section_name (s->owner, s);

  /* Decide which segment the section should go in based on the
     section name and section flags.  */
  place = NULL;
  if ((s->flags & SEC_HAS_CONTENTS) == 0
      && hold_bss != NULL)
    place = hold_bss;
  else if ((s->flags & SEC_READONLY) == 0
	   && hold_data != NULL)
    place = hold_data;
  else if (strncmp (secname, ".rel", 4) == 0
	   && hold_rel != NULL)
    place = hold_rel;
  else if ((s->flags & SEC_READONLY) != 0
	   && hold_text != NULL)
    place = hold_text;
  if (place == NULL)
    return false;

  /* Create the section in the output file, and put it in the right
     place.  This shuffling is to make the output file look neater.  */
  snew = bfd_make_section (output_bfd, secname);
  if (snew == NULL)
      einfo ("%P%F: output format %s cannot represent section called %s\n",
	     output_bfd->xvec->name, secname);
  if (place->bfd_section != NULL)
    {
      for (pps = &output_bfd->sections; *pps != snew; pps = &(*pps)->next)
	;
      *pps = snew->next;
      snew->next = place->bfd_section->next;
      place->bfd_section->next = snew;
    }

  /* Start building a list of statements for this section.  */
  old = stat_ptr;
  stat_ptr = &add;
  lang_list_init (stat_ptr);

  /* If the name of the section is representable in C, then create
     symbols to mark the start and the end of the section.  */
  for (ps = secname; *ps != '\0'; ps++)
    if (! isalnum (*ps) && *ps != '_')
      break;
  if (*ps == '\0' && config.build_constructors)
    {
      char *symname;

      symname = (char *) xmalloc (ps - secname + sizeof "__start_");
      sprintf (symname, "__start_%s", secname);
      lang_add_assignment (exp_assop ('=', symname,
				      exp_nameop (NAME, ".")));
    }

  if (! link_info.relocateable)
    address = NULL;
  else
    address = exp_intop ((bfd_vma) 0);

  lang_enter_output_section_statement (secname, address, 0,
				       (bfd_vma) 0,
				       (etree_type *) NULL,
				       (etree_type *) NULL,
				       (etree_type *) NULL);

  os = lang_output_section_statement_lookup (secname);
  wild_doit (&os->children, s, os, file);

  lang_leave_output_section_statement ((bfd_vma) 0, "*default*");
  stat_ptr = &add;

  if (*ps == '\0' && config.build_constructors)
    {
      char *symname;

      symname = (char *) xmalloc (ps - secname + sizeof "__stop_");
      sprintf (symname, "__stop_%s", secname);
      lang_add_assignment (exp_assop ('=', symname,
				      exp_nameop (NAME, ".")));
    }

  /* Now stick the new statement list right after PLACE.  */
  *add.tail = place->header.next;
  place->header.next = add.head;

  stat_ptr = old;

  return true;
}

static void
gld${EMULATION_NAME}_place_section (s)
     lang_statement_union_type *s;
{
  lang_output_section_statement_type *os;

  if (s->header.type != lang_output_section_statement_enum)
    return;

  os = &s->output_section_statement;

  if (strcmp (os->name, hold_section->name) == 0)
    hold_use = os;

  if (strcmp (os->name, ".text") == 0)
    hold_text = os;
  else if (strcmp (os->name, ".data") == 0)
    hold_data = os;
  else if (strcmp (os->name, ".bss") == 0)
    hold_bss = os;
  else if (hold_rel == NULL
	   && strncmp (os->name, ".rel", 4) == 0)
    hold_rel = os;
}

static char *
gld${EMULATION_NAME}_get_script(isfile)
     int *isfile;
EOF

if test -n "$COMPILE_IN"
then
# Scripts compiled in.

# sed commands to quote an ld script as a C string.
sc='s/["\\]/\\&/g
s/$/\\n\\/
1s/^/"/
$s/$/n"/
'

cat >>e${EMULATION_NAME}.c <<EOF
{			     
  *isfile = 0;

  if (link_info.relocateable == true && config.build_constructors == true)
    return `sed "$sc" ldscripts/${EMULATION_NAME}.xu`;
  else if (link_info.relocateable == true)
    return `sed "$sc" ldscripts/${EMULATION_NAME}.xr`;
  else if (!config.text_read_only)
    return `sed "$sc" ldscripts/${EMULATION_NAME}.xbn`;
  else if (!config.magic_demand_paged)
    return `sed "$sc" ldscripts/${EMULATION_NAME}.xn`;
  else if (link_info.shared)
    return `sed "$sc" ldscripts/${EMULATION_NAME}.xs`;
  else
    return `sed "$sc" ldscripts/${EMULATION_NAME}.x`;
}
EOF

else
# Scripts read from the filesystem.

cat >>e${EMULATION_NAME}.c <<EOF
{			     
  *isfile = 1;

  if (link_info.relocateable == true && config.build_constructors == true)
    return "ldscripts/${EMULATION_NAME}.xu";
  else if (link_info.relocateable == true)
    return "ldscripts/${EMULATION_NAME}.xr";
  else if (!config.text_read_only)
    return "ldscripts/${EMULATION_NAME}.xbn";
  else if (!config.magic_demand_paged)
    return "ldscripts/${EMULATION_NAME}.xn";
  else if (link_info.shared)
    return "ldscripts/${EMULATION_NAME}.xs";
  else
    return "ldscripts/${EMULATION_NAME}.x";
}
EOF

fi

cat >>e${EMULATION_NAME}.c <<EOF

struct ld_emulation_xfer_struct ld_${EMULATION_NAME}_emulation = 
{
  gld${EMULATION_NAME}_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  after_open_default,
  after_allocation_default,
  set_output_arch_default,
  ldemul_default_target,
  gld${EMULATION_NAME}_before_allocation,
  gld${EMULATION_NAME}_get_script,
  "${EMULATION_NAME}",
  "${OUTPUT_FORMAT}",
  NULL,
  NULL,
  gld${EMULATION_NAME}_open_dynamic_archive,
  gld${EMULATION_NAME}_place_orphan
};
EOF
