/* layout.c

   Takes a Postscript 2.0 file from standard in (to figure out how
many pages are in it) and writes a data file (to standard out) which
gives the pairs of pages that need to be next to each other on each
side of a physical sheet.

   Written May 20, 1993 by Joel F. Klein

*/

#include <stdio.h>
#include <strings.h>

#define WIDTH 4096

void main() {
   char done=0;
   char line[WIDTH+1];
   char *flag = "%%Pages: ";
   int flagLength = strlen(flag);
   int Length;
   int EF, OF, EB, OB;  /* even front, odd front, even back, odd back */

   while(!(done)){
      fgets(line, WIDTH, stdin);
      done = (!(strncasecmp(flag, line, flagLength))) || (feof(stdin));
   }

   sscanf(line+flagLength, "%d", &Length);

   if((Length%4)!=0) {
      printf("\n\nError!\n");
      printf("Document length (%d pages) is not a multiple of  
four!\n",Length);
      exit(1);
   }

   for(EF=Length, OF=1, EB=2, OB=Length-1;
       EB<=(Length/2);
       EF-=2, OF+=2, EB+=2, OB-=2)
   {
      printf("%d %d\n%d %d\n", EF, OF, EB, OB);
   }
   
}
