/******************************************************************************
*                                                                             *
*      S I S C A D - P                                                        *
*      P r o g r a m m i e r s c h n i t t s t e l l e                        *
*                                                                             *
*-----------------------------------------------------------------------------*
*                                                                             *
*             Diese Include-Datei ist urheberrechtlich geschuetzt             *
*                                                                             *
*                   (c) Copyright STAEDTLER MARS GmbH & Co                    *
*                                                                             *
*     Weder der Autor noch STAEDTLER MARS GmbH & Co haften fuer Schaeden,     *
*     welche durch direkte oder indirekte Verwendung dieser Include-Datei     *
*     oder Informationen aus ihr entstehen sollten.                           *
*                                                                             *
*-----------------------------------------------------------------------------*
*  entwickelt von: Oliver Billmann                                            *
*-----------------------------------------------------------------------------*
*  Email:                                                                     *
*  billmann@sis.staedtler.de  oder  billmann@informatik.fh-augsburg.de        *
*-----------------------------------------------------------------------------*
*                                                                             *
*      m o d u l . h                                                          *
*                                                                             *
******************************************************************************/


#ifndef _modul_h_
#define _modul_h_ 1

#if ( i386 || i486 ) && ( _LINUX || __linux__ )
#  undef SisLINUX
#  define SisLINUX 1
#endif

#if ( i386 || i486 ) && !( _LINUX || __linux__ )
#  undef SisINTERACTIVE
#  define SisINTERACTIVE 1
#endif

#if sparc
#  undef SisSUN
#  define SisSUN 1
#  if __svr4__
#    undef SisSOLARIS
#    define SisSOLARIS
#  endif
#endif

#if sgi
#  undef SisIRIX
#  define SisIRIX 1
#endif

#if ultrix
#  undef SisULTRIX
#  define SisULTRIX 1
#endif

#if _AIX
#  undef SisIBM
#  define SisIBM 1
#endif


#if !defined(_XtIntrinsic_h)
typedef char Boolean;
#endif

typedef struct {
  double X;
  double Y;
} Koord2D;

typedef struct {
  double X;
  double Y;
  double Z;
} Koord3D;

typedef struct {
  long Nummer;
  long DBNummerUndTyp;
} CadObjektId;

#define CadObjektIdentifizierung CadObjektId
#define Koordinaten3D            Koord3D
#define Koordinaten2D            Koord2D

#define LeseGeradeEndlich(a,b)		LeseCadObjekt(a,(void*)b)
#define LeseGeradeUnendlich(a,b)	LeseCadObjekt(a,(void*)b)
#define LeseGeradeEinsUnendlich(a,b)	LeseCadObjekt(a,(void*)b)
#define LeseVektor(a,b)			LeseCadObjekt(a,(void*)b)
#define LeseKreisBogen(a,b)		LeseCadObjekt(a,(void*)b)
#define LeseKreisVoll(a,b)		LeseCadObjekt(a,(void*)b)
#define LesePunkt(a,b)			LeseCadObjekt(a,(void*)b)
#define LeseGruppe(a,b)			LeseCadObjekt(a,(void*)b)
#define LeseGerade(a,b)			LeseCadObjekt(a,(void*)b)
#define LeseKreis(a,b)			LeseCadObjekt(a,(void*)b)
#define LeseText(a,b)			LeseCadObjekt(a,(void*)b)
#define LeseFlaeche(a,b)       		LeseCadObjekt(a,(void*)b)
#define LeseSchraffur(a,b)     		LeseCadObjekt(a,(void*)b)
#define LeseLinienzug(a,b)		LeseCadObjekt(a,(void*)b)
#define LeseFormelement(a,b)		LeseCadObjekt(a,(void*)b)

#define InitGruppe(a)		InitCadObjekt(xxxGruppe,(void*)a)
#define ReInitGruppe(a)		ReInitCadObjekt(xxxGruppe,(void*)a)
#define InitFlaeche(a)		InitCadObjekt(xxxFlaeche,(void*)a)
#define ReInitFlaeche(a)	ReInitCadObjekt(xxxFlaeche,(void*)a)
#define InitCadBeziehung(a)	InitCadObjekt(xxxCadBeziehung,(void*)a)
#define ReInitCadBeziehung(a)	ReInitCadObjekt(xxxCadBeziehung,(void*)a)
#define InitName(a)		InitCadObjekt(xxxName,(void*)a)
#define ReInitName(a)		ReInitCadObjekt(xxxName,(void*)a)
#define InitFunktion(a)		InitCadObjekt(xxxFunktion,(void*)a)
#define ReInitFunktion(a)	ReInitCadObjekt(xxxFunktion,(void*)a)
#define InitVariable(a)		InitCadObjekt(xxxVariable,(void*)a)
#define ReInitVariable(a)	ReInitCadObjekt(xxxVariable,(void*)a)
#define InitLinienzug(a)	InitCadObjekt(xxxLinienzug,(void*)a)
#define ReInitLinienzug(a)	ReInitCadObjekt(xxxLinienzug,(void*)a)
#define InitSilhouette(a)	InitCadObjekt(xxxSilhouette,(void*)a)
#define ReInitSilhouette(a)	ReInitCadObjekt(xxxSilhouette,(void*)a)
#define InitText(a)		InitCadObjekt(xxxText,(void*)a)
#define ReInitText(a)		ReInitCadObjekt(xxxText,(void*)a)
#define InitEndlicheGerade(a)	InitCadObjekt(xxxEndlicheGerade,(void*)a)
#define ReInitEndlicheGerade(a)	ReInitCadObjekt(xxxEndlicheGerade,(void*)a)
#define InitUnendlicheGerade(a)		\
				InitCadObjekt(xxxUnendlicheGerade,(void*)a)
#define ReInitUnendlicheGerade(a)	\
				ReInitCadObjekt(xxxUnendlicheGerade,(void*)a)
#define InitEinsUnendlicheGerade(a)	\
			InitCadObjekt(xxxEinseitigUnendlicheGerade,(void*)a)
#define ReInitEinsUnendlicheGerade(a)	\
			ReInitCadObjekt(xxxEinseitigUnendlicheGerade,(void*)a)
#define InitKreisbogen(a)	InitCadObjekt(xxxKreisbogen,(void*)a)
#define ReInitKreisbogen(a)	ReInitCadObjekt(xxxKreisbogen,(void*)a)
#define InitVollkreis(a)	InitCadObjekt(xxxVollkreislinie,(void*)a)
#define ReInitVollkreis(a)	ReInitCadObjekt(xxxVollkreislinie,(void*)a)
#define InitPunkt(a)		InitCadObjekt(xxxPunktKartesisch,(void*)a)
#define ReInitPunkt(a)		ReInitCadObjekt(xxxPunktKartesisch,(void*)a)
#define InitVektor(a)		InitCadObjekt(xxxVektorKartesisch,(void*)a)
#define ReInitVektor(a)		ReInitCadObjekt(xxxVektorKartesisch,(void*)a)
#define InitSchraffur(a)	InitCadObjekt(xxxSchraffur,(void*)a)
#define ReInitSchraffur(a)	ReInitCadObjekt(xxxSchraffur,(void*)a)
#define InitFormelement(a)	InitCadObjekt(xxxFormelement,(void*)a)
#define ReInitFormelement(a)	ReInitCadObjekt(xxxFormelement,(void*)a)

#define _Na_(a)		ErzeugeTempElement ( typString , (void *) a )
#define _Id_(a)		ErzeugeTempElement ( typIdentifizierung , (void *) a )
#define _Ko_(a)		ErzeugeTempElement ( typKoordinaten3D , (void *) a )
#define _XY_(a,b)	ErzeugeTempXYElement ( (double) a , (double) b , 0.0 )

typedef enum {
  ErstePda             =  0 ,
  PdaKleinerKreis      =  1 ,
  PdaKleinesRechteck   =  2 ,
  PdaKleinesKreuz      =  3 ,
  PdaKleinerStern      =  4 ,
  PdaKleinesDreieckSO  =  5 ,
  PdaKleinesDreieckSU  =  6 ,
  PdaKleinesDreieckSR  =  7 ,
  PdaKleinesDreieckSL  =  8 ,
  PdaGrosserKreis      =  9 ,
  PdaGrossesRechteck   = 10 ,
  PdaGrossesKreuz      = 11 ,
  PdaGrosserStern      = 12 ,
  PdaGrossesDreieckSO  = 13 ,
  PdaGrossesDreieckSU  = 14 ,
  PdaGrossesDreieckSR  = 15 ,
  PdaGrossesDreieckSL  = 16 ,
  PdaKeine             = 17 ,
  PdaPixel             = 18 ,
  PdaIso1013           = 19 ,
  PdaIso1014           = 20 ,
  PdaIso1011           = 21 ,
  PdaIso1047           = 22 ,
  PdaIso1012           = 23 ,
  PdaIso1015           = 24 ,
  PdaIso1022           = 25 ,
  PdaIso1023           = 26 ,
  PdaIso1024           = 27 ,
  BeginnReserviertePda = 28 ,
  PdaPfeilEnde         = 29 ,
  PdaPfeilSpitze       = 30 ,
  LetztePda            = 31
} ArtGrafDarstellungPunkt;

typedef enum {
  ErsteFarbe              =  0 ,
  Schwarz                 =  1 ,
  HellGrau                =  2 ,
  Grau                    =  3 ,
  DunkelGrau              =  4 ,
  HellRot                 =  5 ,
  Rot                     =  6 ,
  DunkelRot               =  7 ,
  HellLila                =  8 ,
  Lila                    =  9 ,
  DunkelLila              = 10 ,
  HellGruen               = 11 ,
  Gruen                   = 12 ,
  DunkelGruen             = 13 ,
  HellBlau                = 14 ,
  Blau                    = 15 ,
  DunkelBlau              = 16 ,
  HellGelb                = 17 ,
  Gelb                    = 18 ,
  DunkelGelb              = 19 ,
  Weiss                   = 20 ,
  BeginnReservierteFarben = 21 ,
  Reserviert1             = 22 ,
  Reserviert2             = 23 ,
  Reserviert3             = 24 ,
  Reserviert4             = 25 ,
  Reserviert5             = 26 ,
  Reserviert6             = 27 ,
  Reserviert7             = 28 ,
  FarbeUndefiniert        = 29 ,
  LetzteFarbe             = 30
} Farbe;

typedef enum {
  ErsteLinienart               = 0 ,
  VollLinie                    = 1 ,
  StrichLinie                  = 2 ,
  StrichPunktLinie             = 3 ,
  StrichZweiPunktLinie         = 4 ,
  BeginnReservierteLinienarten = 5 ,
  LinienartUndefiniert         = 6 ,
  LetzteLinienart              = 7
} Linienart;

typedef enum {
  ErsteLinienbreite              = 0 ,
  Schmal                         = 1 ,
  Mittel                         = 2 ,
  Breit                          = 3 ,
  ExtraBreit                     = 4 ,
  BeginnReservierteLinienbreiten = 5 ,
  LinienbreiteUndefiniert        = 6 ,
  LetzteLinienbreite             = 7
} Linienbreite;

typedef enum {  
  xxxBeginnCadObjektTypen ,
  xxxBeginnGeometrieModell ,
   xxxBeginnBildobjekte ,
    xxxBild ,
    xxxBildEllipse ,
    xxxBildEllipsenbogen ,
    xxxBildEndlicheGerade ,
    xxxBildEinsUnendlicheGerade ,
    xxxBildUnendlicheGerade ,
    xxxBildKreisbogen ,
    xxxBildPunkt ,
    xxxBildVollkreislinie ,
    xxxBildSchraffur ,
    xxxBildText ,
    xxxBildTextZeile ,
    xxxBildPolylinie ,
    xxxPolyrahmen ,
    xxxRahmen ,
    xxxRechteckrahmen ,
    xxxFolie ,  
    xxxMassBegrenzer ,
    xxxPositionsnummer , 
   xxxEndeBildobjekte ,
   xxxBeginnGeometrieobjekte ,
    xxxSilhouette , 
    xxxVektorKartesisch ,
    xxxPunktKartesisch ,
    xxxEndlicheGerade ,
    xxxEinseitigUnendlicheGerade ,
    xxxUnendlicheGerade ,
    xxxEllipsenbogen ,
    xxxKreisbogen ,
    xxxVollkreislinie ,
    xxxEllipse ,
    xxxLinienzug ,
    xxxFlaeche ,
    xxxVariableZahlFormel ,
    xxxVariableKoordinatenFormel ,
    xxxVariableTextFormel ,
    xxxFunktionZahl ,
    xxxFunktionKoordinaten ,
    xxxFunktionText ,
    xxxName ,
    xxxGruppe ,
    xxxVariantentabelle ,
    xxxAnsicht ,
    xxxEinzelheitrahmen ,
    xxxZeichnungsrahmen ,
    xxxObjektbeschreibung ,
    xxxText ,
    xxxStifttabelle ,   
    xxxSymbol ,
   xxxEndeGeometrieobjekte ,
  xxxEndeGeometrieModell ,
  xxxBeginnTechnGestaltModell ,
   xxxRundung ,
   xxxFase ,
   xxxFormelement ,
  xxxEndeTechnGestaltModell ,
  xxxBeginnFunktionsModell ,
  xxxEndeFunktionsModell ,
  xxxBeginnTechnologieModell ,
   xxxBeginnToleranzModell ,
    xxxBeginnMassobjekte ,
     xxxBezugskantenmass ,
     xxxBezugskantenmassElement ,
     xxxDurchmessermass ,
     xxxKettenmass ,
     xxxKettenmassElement ,
     xxxLaengenmass ,
     xxxRadiusmass ,
     xxxSteigendesMass ,
     xxxSteigendesMassElement ,
     xxxWinkelmass ,
    xxxEndeMassobjekte ,
    xxxToleranzzeichen ,
   xxxEndeToleranzModell ,
   xxxBeginnOberflaechenModell ,
    xxxOberflaeche ,
   xxxEndeOberflaechenModell ,
   xxxBeginnMaterialModell ,
    xxxSchraffur ,
   xxxEndeMaterialModell ,
  xxxEndeTechnologieModell ,
  xxxBeginnProduktionsModell ,
   xxxBeginnFertigungsModell ,
    xxxTeilStammdaten ,
    xxxTeilPlazierung ,
   xxxEndeFertigungsModell ,
   xxxBeginnMontageModell ,
   xxxEndeMontageModell ,
   xxxBeginnPruefModell ,
   xxxEndePruefModell ,
  xxxEndeProduktionsModell ,
  xxxBeginnSonstigeObjekte ,
   xxxStruktur ,
   xxxVoreinstellung ,
   xxxParametrik ,
   xxxGozintoObjekt ,
   xxxLink ,
  xxxEndeSonstigeObjekte ,
  xxxCadObjektUndefiniert ,
  xxxBeginnParametrikHilfsobjekte ,
   xxxParametrikPunkt ,
   xxxParametrikLinie ,
   xxxParametrikKreis ,
  xxxEndeParametrikHilfsobjekte ,
  xxxEndeCadObjektTypen ,
  xxxBeginnProschniTypen ,
   xxxFunktion ,
   xxxCadBeziehung ,
   xxxVariable ,
  xxxEndeProschniTypen
} CadObjektTyp;

typedef enum {
  NullBeziehung ,
  bDefiniertObjekte ,
  bKonstruiertObjekte ,
  bDefinierendeObjekteHaben ,
  bDefinierendeFormelobjekteHaben ,
  bDefinierendeBasisobjekteHaben ,
  bKonstruierendeObjekteHaben ,
  bBildSeinVon ,
  bBilderHaben ,
  bEntgegengesetztOrientierteLzEl ,
  bRandorientierungGegenDefinitio ,
  bRahmenHaben ,
  bRahmenSeinVon ,
  bRahmenLiegtInSchraffur ,
  bSchraffurEnthaeltRahmen ,
  bNamenHaben ,
  bNamenSeinVon ,
  bFormatAufPapierrahmen ,
  bPapierrahmenZumFormat ,
  bFormatHatInnenrand ,
  bInnenrandVomFormat ,
  bFormatHatSchriftfeldrahmen ,
  bSchriftfeldrahmenVomFormat ,
  bFormatHatStuecklistenrahmen ,
  bStuecklistenrahmenVomFormat ,
  bFormatHatPlotfensterrahmen ,
  bPlotfensterrahmenVomFormat ,
  bFormatHatFensterrahmen ,
  bFensterrahmenVomFormat ,
  bParametrikObjektSeinVon ,
  bIdentischenPunktHaben ,
  bPosNrHatText ,
  bTextVonPosNrSein ,
  bHinweislinieHaben ,
  bHinweislinieSeinVon ,
  bObjektHatText ,
  bTextVonObjektSein ,
  bObjektHatLinie ,
  bLinieVonObjektSein ,
  bMassZwischenStrukturenSein ,
  bTeilHatBZEVonMassInAnderemTeil ,
  bSMLVonFormelementSein ,
  bSMLHaben ,
  AnfangMassBeziehungen ,
  bMassHatMasstext ,
  bMasstextSeinVon ,
  bMassHatLinie ,
  bMasslinieSeinVon ,
  bBegrenzerHaben ,
  bBegrenzerSeinVon ,
  bMassHatKoerperkante ,
  bMasskoerperkanteSeinVon ,
  bMassHatProjektion ,
  bMassprojektionSeinVon ,
  bTextHatRahmen ,
  bTextrahmenSeinVon ,
  bKennzeichnungHaben ,
  bKennzeichnungSeinVon ,
  bUmrandungHaben ,
  bUmrandungSeinVon ,
  bAlternativesNennmassHatKlammer ,
  bAlternNennmassklammerSeinVon ,
  bMassHatToleranztext ,
  bMasstoleranztextSeinVon ,
  bMassHatAenderungsindex ,
  bMassaenderungsindexSeinVon ,
  EndeMassBeziehungen ,
  LetzteBeziehung
} Beziehungsart;

#define  Linksbuendig      1
#define  Rechtsbuendig     2
#define  Mittig            4
#define  Gebogen           8
#define  XSpiegelung      16
#define  YSpiegelung      32
#define  Vertikal         64
#define  StartpunktUnten 128

#define BRAUCHE_PROTOTYPEN 2

#if !defined(_p_tks_h_)
#define FehlerNotYetImplemented      -100
#define FehlerUnbekannterOperand     -101
#define FehlerUnbekannterOperator    -102
#define FehlerUnbekannteKennung      -103
#define FehlerUnbekannterTyp         -104
#define FehlerUnbekannterKey         -105
#define FehlerUnbekannterName        -106
#define FehlerInternShmZeiger        -107
#define FehlerUnbekannterTypMod      -108
#define FehlerhafterParameterMod     -109
#define FehlerFalscherLeTyp          -110
#define FehlerProschniIstBelegt      -111
#define FehlerUnbekannterLeTyp       -112
#define FehlerPositionGroesserLaenge -113
#endif

#endif

#ifndef _proschni_h_
#define _proschni_h_ 1

#if SisSUN && !SisSOLARIS
#  ifdef atexit
#    undef atexit
#  endif
#  define atexit(a) on_exit ( a , (char *) 0 )
extern int on_exit();
#endif

#if !defined(NetzwerkmanagerSpez)
typedef unsigned short TypDatenbasisNummer;
#endif

#if !defined(BRAUCHE_PROTOTYPEN)
#  define BRAUCHE_PROTOTYPEN 1
#endif

#define LEER -1

/***
  WICHTIG:
  Die Reihenfolge der Kennungen auf keinen Fall veraendern, da diese Werte
  fest in die Library hineincompiliert sind und dann eine Neucompilierung aller
  Module nach sich zieht...
  Neue Kennungen am Ende anfuegen.
***/

typedef enum {
  kenLeer = -1 ,
  kenDummy = 100 ,
  kenAbstand ,
  kenAequidistante ,
  kenAequidistantePARALLEL ,
  kenBereich ,
  kenBereichAP ,
  kenBereichDX ,
  kenBereichDY ,
  kenBereichG ,
  kenBereichK ,
  kenBereichNTEIL ,
  kenBereichPF ,
  kenBereichPOL ,
  kenBereichPP ,
  kenBereichPPP ,
  kenBereichPW ,
  kenBereichSP ,
  kenDXF ,
  kenDurchmass ,
  kenDurchmassDM ,
  kenDurchmassDMZ ,
  kenDurchmesserA ,
  kenDurchmesserE ,
  kenEigenschaft ,
  kenEigenschaftAUS ,
  kenEigenschaftEIN ,
  kenEinzelheit ,
  kenEinzelheitAUS ,
  kenEinzelheitDX ,
  kenEinzelheitDY ,
  kenEinzelheitEIN ,
  kenEinzelheitK ,
  kenEinzelheitLZ ,
  kenEinzelheitPARAMETER ,
  kenEinzelheitPOL ,
  kenEinzelheitPP ,
  kenEinzelheitPPP ,
  kenEinzelheitPW ,
  kenEinzelheitR ,
  kenElementAE ,
  kenElementAP ,
  kenElementZE ,
  kenElementZP ,
  kenFase ,
  kenFaseTRE ,
  kenFaseTRZ ,
  kenFixierung ,
  kenFlaeche ,
  kenFlaecheAP ,
  kenFlaecheAUS ,
  kenFlaecheAUT ,
  kenFlaecheDIF ,
  kenFlaecheDUR ,
  kenFlaecheDX ,
  kenFlaecheDY ,
  kenFlaecheG ,
  kenFlaecheGB ,
  kenFlaecheK ,
  kenFlaecheLB ,
  kenFlaecheNTEIL ,
  kenFlaechePF ,
  kenFlaechePOL ,
  kenFlaechePP ,
  kenFlaechePPP ,
  kenFlaechePW ,
  kenFlaecheR ,
  kenFlaecheSP ,
  kenFlaecheVER ,
  kenFolie ,
  kenFolieAUS ,
  kenFolieEIN ,
  kenFormelement ,
  kenFormelementAP ,
  kenFormelementAUS ,
  kenFormelementDX ,
  kenFormelementDY ,
  kenFormelementEIN ,
  kenFormelementG ,
  kenFormelementK ,
  kenFormelementPARAMETER ,
  kenFormelementPF ,
  kenFormelementPOL ,
  kenFormelementPP ,
  kenFormelementPPP ,
  kenFormelementPW ,
  kenFormelementSML ,
  kenFunktion ,
  kenFunktionK ,
  kenFunktionT ,
  kenFunktionZ ,
  kenGerade ,
  kenGeradeAP ,
  kenGeradeDX ,
  kenGeradeDY ,
  kenGeradeG ,
  kenGeradeK ,
  kenGeradeLOT ,
  kenGeradeNT ,
  kenGeradeNTEIL ,
  kenGeradePA ,
  kenGeradePAA ,
  kenGeradePF ,
  kenGeradePOL ,
  kenGeradePP ,
  kenGeradePPP ,
  kenGeradePW ,
  kenGeradePX ,
  kenGeradePY ,
  kenGeradeSA ,
  kenGeradeSP ,
  kenGeradeTE ,
  kenGeradeTEW ,
  kenGeradeVT ,
  kenGeradeWT ,
  kenGruppe ,
  kenGruppeA ,
  kenGruppeAP ,
  kenGruppeAUS ,
  kenGruppeDX ,
  kenGruppeDY ,
  kenGruppeE ,
  kenGruppeG ,
  kenGruppeK ,
  kenGruppeLZ ,
  kenGruppeNTEIL ,
  kenGruppePF ,
  kenGruppePOL ,
  kenGruppePP ,
  kenGruppePPP ,
  kenGruppePW ,
  kenGruppeSP ,
  kenHistorie ,
  kenHorizontalitaetA ,
  kenHorizontalitaetE ,
  kenKettenbemassung ,
  kenKettenbemassungPR ,
  kenKettenbemassungSE ,
  kenKettenbemassungSR ,
  kenKettenbemassungZO ,
  kenKettenbemassungZP ,
  kenKollinearitaetA ,
  kenKollinearitaetE ,
  kenKonstruktionWAS ,
  kenKonstruktionWIE ,
  kenKonzentrizitaetA ,
  kenKonzentrizitaetE ,
  kenKreis ,
  kenKreisAP ,
  kenKreisDX ,
  kenKreisDY ,
  kenKreisEEE ,
  kenKreisEER ,
  kenKreisG ,
  kenKreisK ,
  kenKreisKMP ,
  kenKreisMD ,
  kenKreisME ,
  kenKreisMR ,
  kenKreisNTEIL ,
  kenKreisPE ,
  kenKreisPF ,
  kenKreisPOL ,
  kenKreisPP ,
  kenKreisPPP ,
  kenKreisPW ,
  kenKreisSP ,
  kenLaengenmass ,
  kenLaengenmassDMSE ,
  kenLaengenmassPR ,
  kenLaengenmassSE ,
  kenLaengenmassSR ,
  kenLaengenmassZO ,
  kenLaengenmassZP ,
  kenLinienzug ,
  kenLinienzugAP ,
  kenLinienzugAUS ,
  kenLinienzugDX ,
  kenLinienzugDY ,
  kenLinienzugG ,
  kenLinienzugK ,
  kenLinienzugNTEIL ,
  kenLinienzugPF ,
  kenLinienzugPOL ,
  kenLinienzugPP ,
  kenLinienzugPPP ,
  kenLinienzugPW ,
  kenLinienzugSP ,
  kenLotA ,
  kenLotE ,
  kenMetafile ,
  kenMittelpunktlageA ,
  kenMittelpunktlageE ,
  kenName ,
  kenNennmass ,
  kenOberflaechenzeichen ,
  kenOberflaechenzeichenBEZ ,
  kenOberflaechenzeichenLEG ,
  kenParallelitaetA ,
  kenParallelitaetE ,
  kenPositionsnummer ,
  kenPunkt ,
  kenPunktAE ,
  kenPunktAP ,
  kenPunktAUS ,
  kenPunktDX ,
  kenPunktDY ,
  kenPunktEIN ,
  kenPunktG ,
  kenPunktK ,
  kenPunktKAR ,
  kenPunktMAE ,
  kenPunktNT ,
  kenPunktNTEIL ,
  kenPunktPF ,
  kenPunktPOL ,
  kenPunktPP ,
  kenPunktPPP ,
  kenPunktPW ,
  kenPunktSP ,
  kenPunktVT ,
  kenPunktZP ,
  kenPunktlageA ,
  kenPunktlageE ,
  kenRID ,
  kenRadiusA ,
  kenRadiusE ,
  kenRadiusmass ,
  kenRadiusmassPM ,
  kenRadiusmassPR ,
  kenRadiusmassSR ,
  kenRadiusmassWH ,
  kenRahmen ,
  kenRegelAUS ,
  kenRegelEIN ,
  kenRundung ,
  kenRundungTRE ,
  kenRundungTRZ ,
  kenSMLvariante ,
  kenSMLvarianteAB ,
  kenSMLvarianteAUF ,
  kenSachmerkmalleiste ,
  kenSchraffur ,
  kenSteigendebemassung ,
  kenSteigendebemassungPR ,
  kenSteigendebemassungSE ,
  kenSteigendebemassungSR ,
  kenSteigendebemassungZO ,
  kenSteigendebemassungZP ,
  kenStueckliste ,
  kenStuecklisteAUS ,
  kenStuecklisteBSTL ,
  kenStuecklisteDX ,
  kenStuecklisteDY ,
  kenStuecklisteEIN ,
  kenStuecklisteMSTL ,
  kenStuecklistePOL ,
  kenStuecklistePP ,
  kenStuecklisteSSTL ,
  kenSymmetrieA ,
  kenSymmetrieE ,
  kenTangentialitaetA ,
  kenTangentialitaetE ,
  kenTeil ,
  kenTeilAP ,
  kenTeilAUS ,
  kenTeilDARST ,
  kenTeilDX ,
  kenTeilDY ,
  kenTeilEIN ,
  kenTeilFEL ,
  kenTeilG ,
  kenTeilHIERARCHIE ,
  kenTeilINTEGRIERT ,
  kenTeilK ,
  kenTeilLZ ,
  kenTeilNEBEN ,
  kenTeilNTEIL ,
  kenTeilOBEN ,
  kenTeilPARAMETER ,
  kenTeilPF ,
  kenTeilPOL ,
  kenTeilPP ,
  kenTeilPPP ,
  kenTeilPW ,
  kenTeilSML ,
  kenTeilSP ,
  kenTeilUNTEN ,
  kenText ,
  kenTextAP ,
  kenTextDX ,
  kenTextDY ,
  kenTextE ,
  kenTextG ,
  kenTextK ,
  kenTextL ,
  kenTextLZ ,
  kenTextM ,
  kenTextNTEIL ,
  kenTextPF ,
  kenTextPOL ,
  kenTextPP ,
  kenTextPPP ,
  kenTextPW ,
  kenTextR ,
  kenTextfont ,
  kenVariable ,
  kenVariableK ,
  kenVariableT ,
  kenVariableZ ,
  kenVertikalitaetA ,
  kenVertikalitaetE ,
  kenVoreinstellung ,
  kenVoreinstellungBEM ,
  kenVoreinstellungDURCHMASS ,
  kenVoreinstellungFOLIE ,
  kenVoreinstellungGEO ,
  kenVoreinstellungLAENGENMASS ,
  kenVoreinstellungMT ,
  kenVoreinstellungOBERFLAECHE ,
  kenVoreinstellungPOSNUMMER ,
  kenVoreinstellungRADIUSMASS ,
  kenVoreinstellungTEXT ,
  kenVoreinstellungTT ,
  kenVoreinstellungWINKELMASS ,
  kenWinkelmass ,
  kenWinkelmassPR ,
  kenWinkelmassSR ,
  kenWinkelmassZG ,
  kenWinkelmassZP ,
  kenZeichnungselement ,
  kenZeichnungselementAUS ,
  kenZeichnungselementDX ,
  kenZeichnungselementDY ,
  kenZeichnungselementEIN ,
  kenZeichnungselementPOL ,
  kenZeichnungselementPP ,
  kenZeichnungselementPPP ,
  kenZeichnungselementPW ,
  kenZeichnungselementSFD ,
  kenZeichnungselementZRA ,
  kenEnde
} Kennungen;


#define _PAR_NULL	0
#define _PAR_AB		1001	/* KEY_Abstand */
#define _PAR_AB1	1002	/* KEY_Abstand1 */
#define _PAR_AB2	1003	/* KEY_Abstand2 */
#define _PAR_AD		1179	/* KEY_AbgebrocheneDarstellung */
#define _PAR_AI		1107	/* KEY_Aenderungsindex */
#define _PAR_AIid	1108	/* KEY_Aenderungsindex */
#define _PAR_AIna	1109	/* KEY_Aenderungsindex */
#define _PAR_ALLE	1076	/* KEY_Alle */
#define _PAR_ART	1270	/* KEY_ArtOZeichen */
#define _PAR_ARW	1271	/* KEY_AndereRauheit */
#define _PAR_ARWid	1272	/* KEY_AndereRauheit */
#define _PAR_ARWna	1273	/* KEY_AndereRauheit */
#define _PAR_ATE	1274	/* KEY_AlleTeile */
#define _PAR_AUSB	1417	/* KEY_AusBlendFolien */
#define _PAR_AUSBid	1418	/* KEY_AusBlendFolien */
#define _PAR_AUSBna	1419	/* KEY_AusBlendFolien */
#define _PAR_AUSE	1221	/* KEY_AusgeschlosseneElemente */
#define _PAR_AUSEid	1222	/* KEY_AusgeschlosseneElemente */
#define _PAR_AUSEna	1223	/* KEY_AusgeschlosseneElemente */
#define _PAR_AUSL	1204	/* KEY_AusgenommeneLinien */
#define _PAR_AUSLid	1205	/* KEY_AusgenommeneLinien */
#define _PAR_AUSLna	1206	/* KEY_AusgenommeneLinien */
#define _PAR_AUSSEN	1224	/* KEY_LageBzglSuchgebiet */
#define _PAR_AWI	1004	/* KEY_Anfangswinkel */
#define _PAR_B		1207	/* KEY_Breite */
#define _PAR_BAZU	1275	/* KEY_Bearbeitungszugabe */
#define _PAR_BAZUid	1276	/* KEY_Bearbeitungszugabe */
#define _PAR_BAZUna	1277	/* KEY_Bearbeitungszugabe */
#define _PAR_BE		1278	/* KEY_Bezugselement */
#define _PAR_BEid	1279	/* KEY_Bezugselement */
#define _PAR_BEna	1280	/* KEY_Bezugselement */
#define _PAR_BExy	1281	/* KEY_Bezugselement */
#define _PAR_BE1	1110	/* KEY_Bezugselement1 */
#define _PAR_BE1id	1111	/* KEY_Bezugselement1 */
#define _PAR_BE1na	1112	/* KEY_Bezugselement1 */
#define _PAR_BE1xy	1113	/* KEY_Bezugselement1 */
#define _PAR_BE2	1114	/* KEY_Bezugselement2 */
#define _PAR_BE2id	1115	/* KEY_Bezugselement2 */
#define _PAR_BE2na	1116	/* KEY_Bezugselement2 */
#define _PAR_BE2xy	1117	/* KEY_Bezugselement2 */
#define _PAR_BEi	1200	/* KEY_Bezugselemente */
#define _PAR_BEiid	1201	/* KEY_Bezugselemente */
#define _PAR_BEina	1202	/* KEY_Bezugselemente */
#define _PAR_BEixy	1203	/* KEY_Bezugselemente */
#define _PAR_BEAR	1282	/* KEY_BearbeitungFolie */
#define _PAR_BEARid	1283	/* KEY_BearbeitungFolie */
#define _PAR_BEARna	1284	/* KEY_BearbeitungFolie */
#define _PAR_BELza	1285	/* KEY_VtabMusterbelegung */
#define _PAR_BELxy	1286	/* KEY_VtabMusterbelegung */
#define _PAR_BELstr	1287	/* KEY_VtabMusterbelegung */
#define _PAR_BES	1288	/* KEY_Beschreibung */
#define _PAR_BESid	1289	/* KEY_Beschreibung */
#define _PAR_BESna	1290	/* KEY_Beschreibung */
#define _PAR_BG		1180	/* KEY_ZuBemassendeGerade */
#define _PAR_BGid	1181	/* KEY_ZuBemassendeGerade */
#define _PAR_BGna	1182	/* KEY_ZuBemassendeGerade */
#define _PAR_BG1	1183	/* KEY_ZuBemassendeGerade1 */
#define _PAR_BG1id	1184	/* KEY_ZuBemassendeGerade1 */
#define _PAR_BG1na	1185	/* KEY_ZuBemassendeGerade1 */
#define _PAR_BG2	1186	/* KEY_ZuBemassendeGerade2 */
#define _PAR_BG2id	1187	/* KEY_ZuBemassendeGerade2 */
#define _PAR_BG2na	1188	/* KEY_ZuBemassendeGerade2 */
#define _PAR_BGR	1291	/* KEY_PosNrArtBegrenzer */
#define _PAR_BGRH	1292	/* KEY_PosNrBegrHoehe */
#define _PAR_BGRL	1293	/* KEY_PosNrBegrLaenge */
#define _PAR_BL		1005	/* KEY_Bogenlaenge */
#define _PAR_BMP	1225	/* KEY_BMP */
#define _PAR_BMPid	1226	/* KEY_BMP */
#define _PAR_BMPna	1227	/* KEY_BMP */
#define _PAR_BMPxy	1228	/* KEY_BMP */
#define _PAR_BP1	1167	/* KEY_Bezugspunkt1 */
#define _PAR_BP1id	1168	/* KEY_Bezugspunkt1 */
#define _PAR_BP1na	1169	/* KEY_Bezugspunkt1 */
#define _PAR_BP1xy	1170	/* KEY_Bezugspunkt1 */
#define _PAR_BP2	1171	/* KEY_Bezugspunkt2 */
#define _PAR_BP2id	1172	/* KEY_Bezugspunkt2 */
#define _PAR_BP2na	1173	/* KEY_Bezugspunkt2 */
#define _PAR_BP2xy	1174	/* KEY_Bezugspunkt2 */
#define _PAR_BPi	1084	/* KEY_Bezugspunkte */
#define _PAR_BPiid	1085	/* KEY_Bezugspunkte */
#define _PAR_BPina	1086	/* KEY_Bezugspunkte */
#define _PAR_BPixy	1087	/* KEY_Bezugspunkte */
#define _PAR_BPM	1189	/* KEY_ZuBemassenderMittelpunkt */
#define _PAR_BPMid	1190	/* KEY_ZuBemassenderMittelpunkt */
#define _PAR_BPMna	1191	/* KEY_ZuBemassenderMittelpunkt */
#define _PAR_BPMxy	1192	/* KEY_ZuBemassenderMittelpunkt */
#define _PAR_BTU	1294	/* KEY_BTU */
#define _PAR_BUS	1229	/* KEY_BUS */
#define _PAR_BWI	1118	/* KEY_Bezugswinkel */
#define _PAR_BZP	1088	/* KEY_Bezugspunkt */
#define _PAR_BZPid	1089	/* KEY_Bezugspunkt */
#define _PAR_BZPna	1090	/* KEY_Bezugspunkt */
#define _PAR_BZPxy	1091	/* KEY_Bezugspunkt */
#define _PAR_BZST	1295	/* KEY_Bezugsstrecke */
#define _PAR_BZSTid	1296	/* KEY_Bezugsstrecke */
#define _PAR_BZSTna	1297	/* KEY_Bezugsstrecke */
#define _PAR_D		1006	/* KEY_Durchmesser */
#define _PAR_DAT	1298	/* KEY_DATEI */
#define _PAR_DATid	1299	/* KEY_DATEI */
#define _PAR_DATna	1300	/* KEY_DATEI */
#define _PAR_DB		1420	/* KEY_Datenbank */
#define _PAR_DELTA	1301	/* KEY_PosNrDeltaZahl */
#define _PAR_DX		1007	/* KEY_DeltaX */
#define _PAR_DXFMAS	1421	/* KEY_DxfMass */
#define _PAR_DXFPKT	1479	/* KEY_DxfPunkte */
#define _PAR_DXFTXT	1422	/* KEY_DxfText */
#define _PAR_DY		1008	/* KEY_DeltaY */
#define _PAR_EINB	1423	/* KEY_EinBlendFolien */
#define _PAR_EINBid	1424	/* KEY_EinBlendFolien */
#define _PAR_EINBna	1425	/* KEY_EinBlendFolien */
#define _PAR_EINH	1388	/* KEY_Einheit */
#define _PAR_EINHid	1389	/* KEY_Einheit */
#define _PAR_EINHna	1390	/* KEY_Einheit */
#define _PAR_ELE	1009	/* KEY_Element */
#define _PAR_ELEid	1010	/* KEY_Element */
#define _PAR_ELEna	1011	/* KEY_Element */
#define _PAR_ELEi	1408	/* KEY_Elemente */
#define _PAR_ELEiid	1409	/* KEY_Elemente */
#define _PAR_ELEina	1410	/* KEY_Elemente */
#define _PAR_ELEp	1405	/* KEY_Element */
#define _PAR_ELEpid	1406	/* KEY_Element */
#define _PAR_ELEpna	1407	/* KEY_Element */
#define _PAR_ELE1	1012	/* KEY_Element1 */
#define _PAR_ELE1id	1013	/* KEY_Element1 */
#define _PAR_ELE1na	1014	/* KEY_Element1 */
#define _PAR_ELE2	1015	/* KEY_Element2 */
#define _PAR_ELE2id	1016	/* KEY_Element2 */
#define _PAR_ELE2na	1017	/* KEY_Element2 */
#define _PAR_ELE3	1018	/* KEY_Element3 */
#define _PAR_ELE3id	1019	/* KEY_Element3 */
#define _PAR_ELE3na	1020	/* KEY_Element3 */
#define _PAR_EP		1021	/* KEY_Endpunkt */
#define _PAR_EPid	1022	/* KEY_Endpunkt */
#define _PAR_EPna	1023	/* KEY_Endpunkt */
#define _PAR_EPxy	1024	/* KEY_Endpunkt */
#define _PAR_EZRAHM	1302	/* KEY_EZHRahmen */
#define _PAR_FA		1025	/* KEY_Farbe */
#define _PAR_FEL	1391	/* KEY_ObjektFormelement */
#define _PAR_FELid	1392	/* KEY_ObjektFormelement */
#define _PAR_FELna	1393	/* KEY_ObjektFormelement */
#define _PAR_FENNR	1230	/* KEY_Fensternr */
#define _PAR_FL		1426	/* KEY_Formelementliste */
#define _PAR_FO		1427	/* KEY_FixesObjekt */
#define _PAR_FOid	1428	/* KEY_FixesObjekt */
#define _PAR_FOna	1429	/* KEY_FixesObjekt */
#define _PAR_FOL	1398	/* KEY_Folie */
#define _PAR_FOLid	1399	/* KEY_Folie */
#define _PAR_FOLna	1400	/* KEY_Folie */
#define _PAR_FOLI	1430	/* KEY_Folien */
#define _PAR_FOLIid	1431	/* KEY_Folien */
#define _PAR_FOLIna	1432	/* KEY_Folien */
#define _PAR_FVF	1303	/* KEY_Fertigungsverfahren */
#define _PAR_FVFid	1304	/* KEY_Fertigungsverfahren */
#define _PAR_FVFna	1305	/* KEY_Fertigungsverfahren */
#define _PAR_G		1026	/* KEY_Gerade */
#define _PAR_Gid	1027	/* KEY_Gerade */
#define _PAR_Gna	1028	/* KEY_Gerade */
#define _PAR_Gi		1411	/* KEY_Geraden */
#define _PAR_Giid	1412	/* KEY_Geraden */
#define _PAR_Gina	1413	/* KEY_Geraden */
#define _PAR_G1		1029	/* KEY_Gerade1 */
#define _PAR_G1id	1030	/* KEY_Gerade1 */
#define _PAR_G1na	1031	/* KEY_Gerade1 */
#define _PAR_G2		1032	/* KEY_Gerade2 */
#define _PAR_G2id	1033	/* KEY_Gerade2 */
#define _PAR_G2na	1034	/* KEY_Gerade2 */
#define _PAR_GA		1231	/* KEY_GA */
#define _PAR_GAB	1306	/* KEY_VergabeModus */
#define _PAR_GEOi	1232	/* KEY_Geo */
#define _PAR_GEOiid	1233	/* KEY_Geo */
#define _PAR_GEOina	1234	/* KEY_Geo */
#define _PAR_GEOM	1307	/* KEY_GeoFolie */
#define _PAR_GEOMid	1308	/* KEY_GeoFolie */
#define _PAR_GEOMna	1309	/* KEY_GeoFolie */
#define _PAR_GESAMT	1433	/* KEY_Gesamthistorie */
#define _PAR_GEVERB	1216	/* KEY_Geradenverbindung */
#define _PAR_GEWL	1208	/* KEY_GewuenschteLinien */
#define _PAR_GEWLid	1209	/* KEY_GewuenschteLinien */
#define _PAR_GEWLna	1210	/* KEY_GewuenschteLinien */
#define _PAR_GK		1035	/* KEY_Geradenkennung */
#define _PAR_GN		1470	/* KEY_GeradeNachtraeglich */
#define _PAR_GNid	1471	/* KEY_GeradeNachtraeglich */
#define _PAR_GNna	1472	/* KEY_GeradeNachtraeglich */
#define _PAR_GRPi	1235	/* KEY_Gruppe */
#define _PAR_GRPiid	1236	/* KEY_Gruppe */
#define _PAR_GRPina	1237	/* KEY_Gruppe */
#define _PAR_H		1310	/* KEY_Hoehe */
#define _PAR_HWL	1119	/* KEY_Hinweislinie */
#define _PAR_HWLid	1120	/* KEY_Hinweislinie */
#define _PAR_HWLna	1121	/* KEY_Hinweislinie */
#define _PAR_HWLxy	1165	/* KEY_Hinweislinie */
#define _PAR_HWL1	1434	/* KEY_Hinweislinie1 */
#define _PAR_HWL1id	1435	/* KEY_Hinweislinie1 */
#define _PAR_HWL1na	1436	/* KEY_Hinweislinie1 */
#define _PAR_HWL1xy	1437	/* KEY_Hinweislinie1 */
#define _PAR_HWL2	1438	/* KEY_Hinweislinie2 */
#define _PAR_HWL2id	1439	/* KEY_Hinweislinie2 */
#define _PAR_HWL2na	1440	/* KEY_Hinweislinie2 */
#define _PAR_HWL2xy	1441	/* KEY_Hinweislinie2 */
#define _PAR_HWL3	1442	/* KEY_Hinweislinie3 */
#define _PAR_HWL3id	1443	/* KEY_Hinweislinie3 */
#define _PAR_HWL3na	1444	/* KEY_Hinweislinie3 */
#define _PAR_HWL3xy	1445	/* KEY_Hinweislinie3 */
#define _PAR_ID		1000	/* Identifizierung */
#define _PAR_IE		1211	/* KEY_Inselerkennung */
#define _PAR_K		1092	/* KEY_Kreis */
#define _PAR_Kid	1093	/* KEY_Kreis */
#define _PAR_Kna	1094	/* KEY_Kreis */
#define _PAR_K1		1193	/* KEY_Kreis1 */
#define _PAR_K1id	1194	/* KEY_Kreis1 */
#define _PAR_K1na	1195	/* KEY_Kreis1 */
#define _PAR_K2		1196	/* KEY_Kreis2 */
#define _PAR_K2id	1197	/* KEY_Kreis2 */
#define _PAR_K2na	1198	/* KEY_Kreis2 */
#define _PAR_KB		1036	/* KEY_Kreisbogen */
#define _PAR_KBid	1037	/* KEY_Kreisbogen */
#define _PAR_KBna	1038	/* KEY_Kreisbogen */
#define _PAR_KENN	1394	/* KEY_Merkmal */
#define _PAR_KENNid	1395	/* KEY_Merkmal */
#define _PAR_KENNna	1396	/* KEY_Merkmal */
#define _PAR_KK		1039	/* KEY_KreisKennung */
#define _PAR_KoK	1122	/* KEY_Koerperkante */
#define _PAR_KoKid	1123	/* KEY_Koerperkante */
#define _PAR_KoKna	1124	/* KEY_Koerperkante */
#define _PAR_KL		1040	/* KEY_KurzLang */
#define _PAR_KlAu	1311	/* KEY_KlammerAuf */
#define _PAR_KlAuid	1312	/* KEY_KlammerAuf */
#define _PAR_KlAuna	1313	/* KEY_KlammerAuf */
#define _PAR_KlZu	1314	/* KEY_KlammerZu */
#define _PAR_KlZuid	1315	/* KEY_KlammerZu */
#define _PAR_KlZuna	1316	/* KEY_KlammerZu */
#define _PAR_KMH	1125	/* KEY_KurzeMassHilfsLinie */
#define _PAR_KN		1473	/* KEY_KreisNachtraeglich */
#define _PAR_KNid	1474	/* KEY_KreisNachtraeglich */
#define _PAR_KNna	1475	/* KEY_KreisNachtraeglich */
#define _PAR_KONBEZ	1041	/* KEY_KonBezSchalter */
#define _PAR_KOO	1317	/* KEY_Koordinate */
#define _PAR_KOOid	1318	/* KEY_Koordinate */
#define _PAR_KOOna	1319	/* KEY_Koordinate */
#define _PAR_KOOxy	1320	/* KEY_Koordinate */
#define _PAR_KOOstr	1321	/* KEY_Koordinate */
#define _PAR_KOPIE	1238	/* KEY_Kopie */
#define _PAR_L		1042	/* KEY_Laenge */
#define _PAR_Li		1239	/* KEY_Linien */
#define _PAR_Liid	1240	/* KEY_Linien */
#define _PAR_Lina	1241	/* KEY_Linien */
#define _PAR_LA		1043	/* KEY_Linienart */
#define _PAR_LART	1212	/* KEY_LART */
#define _PAR_LB		1044	/* KEY_Linienbreite */
#define _PAR_LBP	1045	/* KEY_Lotbezugspunkt */
#define _PAR_LINKS	1446	/* KEY_Links */
#define _PAR_LSP	1242	/* KEY_LageStartpunkt */
#define _PAR_LT		1046	/* KEY_Linientyp */
#define _PAR_MA		1126	/* KEY_Massart */
#define _PAR_MAB	1127	/* KEY_Masslinienabstand */
#define _PAR_MB		1128	/* KEY_ArtMassBegr */
#define _PAR_MBH	1322	/* KEY_MassBegrHoehe */
#define _PAR_MBL	1323	/* KEY_MassBegrLaenge */
#define _PAR_MITBEM	1095	/* KEY_MitBemassung */
#define _PAR_MITEZH	1447	/* KEY_MitEinzelheiten */
#define _PAR_MITKON	1096	/* KEY_MitKonBez */
#define _PAR_MITOBF	1097	/* KEY_MitObfZeichen */
#define _PAR_MITPOS	1098	/* KEY_MitPosNummern */
#define _PAR_MITTIG	1448	/* KEY_Mittig */
#define _PAR_MK		1129	/* KEY_Masskennzeichnung */
#define _PAR_ML		1047	/* KEY_Mittellinie */
#define _PAR_MLM	1199	/* KEY_Masslinienmitte */
#define _PAR_MRW	1324	/* KEY_MittenRauhwert */
#define _PAR_MRWid	1325	/* KEY_MittenRauhwert */
#define _PAR_MRWna	1326	/* KEY_MittenRauhwert */
#define _PAR_MST	1243	/* KEY_Masstab */
#define _PAR_MTEIL	1449	/* KEY_MitTeilen */
#define _PAR_MTH	1130	/* KEY_MassTextHoehe */
#define _PAR_MTL	1131	/* KEY_MasstextLage */
#define _PAR_MTWA	1132	/* KEY_MasstextwinkelArt */
#define _PAR_MTWI	1133	/* KEY_Masstextwinkel */
#define _PAR_N		1048	/* KEY_Anzahl */
#define _PAR_NA		1049	/* KEY_Name */
#define _PAR_NBE	1450	/* KEY_NeuesBezugselement */
#define _PAR_NBEid	1451	/* KEY_NeuesBezugselement */
#define _PAR_NBEna	1452	/* KEY_NeuesBezugselement */
#define _PAR_NBExy	1453	/* KEY_NeuesBezugselement */
#define _PAR_NEUIDX	1454	/* KEY_NeuerIndex */
#define _PAR_Ni		1050	/* KEY_NumerischesVerhaeltnis*/
#define _PAR_NN		1134	/* KEY_Nennmass */
#define _PAR_NNid	1135	/* KEY_Nennmass */
#define _PAR_NNna	1136	/* KEY_Nennmass */
#define _PAR_NND	1137	/* KEY_NennmassDarstellung */
#define _PAR_NNF	1138	/* KEY_NennmassFaktor */
#define _PAR_NNPF	1139	/* KEY_NNPostfix */
#define _PAR_NNPFid	1140	/* KEY_NNPostfix */
#define _PAR_NNPFna	1141	/* KEY_NNPostfix */
#define _PAR_NORM	1244	/* KEY_VAR */
#define _PAR_NPM	1142	/* KEY_NeuePositionMasstext */
#define _PAR_NPMid	1143	/* KEY_NeuePositionMasstext */
#define _PAR_NPMna	1144	/* KEY_NeuePositionMasstext */
#define _PAR_NPMxy	1166	/* KEY_NeuePositionMasstext */
#define _PAR_NR		1401	/* KEY_Nummer */
#define _PAR_NURKON	1397	/* KEY_NurKonstruktion */
#define _PAR_OARW	1327	/* KEY_ObereAndereRauheit */
#define _PAR_OARWid	1328	/* KEY_ObereAndereRauheit */
#define _PAR_OARWna	1329	/* KEY_ObereAndereRauheit */
#define _PAR_OFF	1455	/* KEY_Offset */
#define _PAR_OFFX	1456	/* KEY_OffsetX */
#define _PAR_OFFY	1457	/* KEY_OffsetY */
#define _PAR_OFZ	1330	/* KEY_ObfName */
#define _PAR_OFZid	1331	/* KEY_ObfName */
#define _PAR_OFZna	1332	/* KEY_ObfName */
#define _PAR_OH		1333	/* KEY_OberflHoehe */
#define _PAR_OP		1077	/* KEY_Operand */
#define _PAR_OPid	1078	/* KEY_Operand */
#define _PAR_OPna	1079	/* KEY_Operand */
#define _PAR_OPi	1213	/* KEY_Operanden */
#define _PAR_OPiid	1214	/* KEY_Operanden */
#define _PAR_OPina	1215	/* KEY_Operanden */
#define _PAR_ORW	1334	/* KEY_ObererRauhwert */
#define _PAR_ORWid	1335	/* KEY_ObererRauhwert */
#define _PAR_ORWna	1336	/* KEY_ObererRauhwert */
#define _PAR_P		1069	/* KEY_Punkt */
#define _PAR_Pid	1070	/* KEY_Punkt */
#define _PAR_Pna	1071	/* KEY_Punkt */
#define _PAR_Pxy	1072	/* KEY_Punkt */
#define _PAR_Pi		1245	/* KEY_Punkte */
#define _PAR_Piid	1246	/* KEY_Punkte */
#define _PAR_Pina	1247	/* KEY_Punkte */
#define _PAR_Pixy	1248	/* KEY_Punkte */
#define _PAR_P1		1051	/* KEY_Punkt1 */
#define _PAR_P1id	1052	/* KEY_Punkt1 */
#define _PAR_P1na	1053	/* KEY_Punkt1 */
#define _PAR_P1xy	1054	/* KEY_Punkt1 */
#define _PAR_P2		1055	/* KEY_Punkt2 */
#define _PAR_P2id	1056	/* KEY_Punkt2 */
#define _PAR_P2na	1057	/* KEY_Punkt2 */
#define _PAR_P2xy	1058	/* KEY_Punkt2 */
#define _PAR_PA		1059	/* KEY_Auswahlpunkt */
#define _PAR_PAid	1060	/* KEY_Auswahlpunkt */
#define _PAR_PAna	1061	/* KEY_Auswahlpunkt */
#define _PAR_PAxy	1062	/* KEY_Auswahlpunkt */
#define _PAR_PARA	1099	/* KEY_Parametrik */
#define _PAR_PARM	1402	/* KEY_Parameter */
#define _PAR_PARMid	1403	/* KEY_Parameter */
#define _PAR_PARMna	1404	/* KEY_Parameter */
#define _PAR_PBEM	1337	/* KEY_ParametrikBemFolie */
#define _PAR_PBEMid	1338	/* KEY_ParametrikBemFolie */
#define _PAR_PBEMna	1339	/* KEY_ParametrikBemFolie */
#define _PAR_PD		1080	/* KEY_Drehpunkt */
#define _PAR_PDid	1081	/* KEY_Drehpunkt */
#define _PAR_PDna	1082	/* KEY_Drehpunkt */
#define _PAR_PDxy	1083	/* KEY_Drehpunkt */
#define _PAR_PDA	1063	/* KEY_PunktDarstellung */
#define _PAR_PFNN	1145	/* KEY_NNPrefix */
#define _PAR_PFNNid	1146	/* KEY_NNPrefix */
#define _PAR_PFNNna	1147	/* KEY_NNPrefix */
#define _PAR_PINDEX	1340	/* KEY_ParameterIndex */
#define _PAR_PL		1064	/* KEY_Punktlage */
#define _PAR_PM		1065	/* KEY_Mittelpunkt */
#define _PAR_PMid	1066	/* KEY_Mittelpunkt */
#define _PAR_PMna	1067	/* KEY_Mittelpunkt */
#define _PAR_PMxy	1068	/* KEY_Mittelpunkt */
#define _PAR_PML	1148	/* KEY_PositionMasslinie */
#define _PAR_PMLid	1149	/* KEY_PositionMasslinie */
#define _PAR_PMLna	1150	/* KEY_PositionMasslinie */
#define _PAR_PMLxy	1151	/* KEY_PositionMasslinie */
#define _PAR_PN		1476	/* KEY_PunktNachtraeglich */
#define _PAR_PNid	1477	/* KEY_PunktNachtraeglich */
#define _PAR_PNna	1478	/* KEY_PunktNachtraeglich */
#define _PAR_PNUM	1341	/* KEY_PosNummernFolie */
#define _PAR_PNUMid	1342	/* KEY_PosNummernFolie */
#define _PAR_PNUMna	1343	/* KEY_PosNummernFolie */
#define _PAR_PRJ	1152	/* KEY_Projektion */
#define _PAR_PRJid	1153	/* KEY_Projektion */
#define _PAR_PRJna	1154	/* KEY_Projektion */
#define _PAR_PUEBER	1249	/* KEY_PunktUebernahme */
#define _PAR_PZP	1175	/* KEY_Plazierpunkt */
#define _PAR_PZPid	1176	/* KEY_Plazierpunkt */
#define _PAR_PZPna	1177	/* KEY_Plazierpunkt */
#define _PAR_PZPxy	1178	/* KEY_Plazierpunkt */
#define _PAR_R		1073	/* KEY_Radius */
#define _PAR_RBEM	1345	/* KEY_ReferenzBemFolie */
#define _PAR_RBEMid	1346	/* KEY_ReferenzBemFolie */
#define _PAR_RBEMna	1347	/* KEY_ReferenzBemFolie */
#define _PAR_RECHTS	1458	/* KEY_Rechts */
#define _PAR_REFER	1459	/* KEY_Referenz */
#define _PAR_REFLOE	1460	/* KEY_RefLoesen */
#define _PAR_RILR	1348	/* KEY_Rillenrichtung */
#define _PAR_RSB	1217	/* KEY_Randschraffurbreite */
#define _PAR_SCH	1351	/* KEY_SchraffurFolie */
#define _PAR_SCHid	1352	/* KEY_SchraffurFolie */
#define _PAR_SCHna	1353	/* KEY_SchraffurFolie */
#define _PAR_SG		1414	/* KEY_SymmetrieGerade */
#define _PAR_SGid	1415	/* KEY_SymmetrieGerade */
#define _PAR_SGna	1416	/* KEY_SymmetrieGerade */
#define _PAR_SKFAKT	1354	/* KEY_Skalierungsfaktor */
#define _PAR_STZ	1355	/* KEY_PosNrStartZahl */
#define _PAR_SNR	1250	/* KEY_MusterIndex */
#define _PAR_SNRid	1251	/* KEY_MusterIndex */
#define _PAR_SNRna	1252	/* KEY_MusterIndex */
#define _PAR_SCHLIE	1253	/* KEY_LinienzugSchliessen */
#define _PAR_SCFD	1100	/* KEY_Schriftfeld */
#define _PAR_SCFDid	1101	/* KEY_Schriftfeld */
#define _PAR_SCFDna	1102	/* KEY_Schriftfeld */
#define _PAR_SFD	1461	/* KEY_MitSchriftfeld */
#define _PAR_SMU	1218	/* KEY_Schraffurmuster */
#define _PAR_SMUid	1219	/* KEY_Schraffurmuster */
#define _PAR_SMUna	1220	/* KEY_Schraffurmuster */
#define _PAR_STDUEB	1103	/* KEY_Stammdatenuebername */
#define _PAR_STL	1254	/* KEY_StuecklistenStruktur */
#define _PAR_TBP	1074	/* KEY_Tangentenbezugspunkt */
#define _PAR_TEIL	1104	/* KEY_Struktur */
#define _PAR_TEILid	1105	/* KEY_Struktur */
#define _PAR_TEILna	1106	/* KEY_Struktur */
#define _PAR_TEXT	1356	/* KEY_TextFolie */
#define _PAR_TEXTid	1357	/* KEY_TextFolie */
#define _PAR_TEXTna	1358	/* KEY_TextFolie */
#define _PAR_TFO	1255	/* KEY_TFO */
#define _PAR_TFOid	1256	/* KEY_TFO */
#define _PAR_TFOna	1257	/* KEY_TFO */
#define _PAR_TH		1258	/* KEY_TH */
#define _PAR_THP	1359	/* KEY_PosNrTextHoehe */
#define _PAR_TK		1360	/* KEY_PosNrPrefix */
#define _PAR_TKid	1361	/* KEY_PosNrPrefix */
#define _PAR_TKna	1362	/* KEY_PosNrPrefix */
#define _PAR_TLA	1462	/* KEY_TextLinienabstand */
#define _PAR_TLO	1155	/* KEY_ToleranzOben */
#define _PAR_TLOstr	1156	/* KEY_ToleranzOben */
#define _PAR_TLU	1157	/* KEY_ToleranzUnten */
#define _PAR_TLUstr	1158	/* KEY_ToleranzUnten */
#define _PAR_TN		1259	/* KEY_TN */
#define _PAR_TNN	1159	/* KEY_TextNachNennmass */
#define _PAR_TNNid	1160	/* KEY_TextNachNennmass */
#define _PAR_TNNna	1161	/* KEY_TextNachNennmass */
#define _PAR_TSP1	1363	/* KEY_Textstartpunkt1 */
#define _PAR_TSP1id	1364	/* KEY_Textstartpunkt1 */
#define _PAR_TSP1na	1365	/* KEY_Textstartpunkt1 */
#define _PAR_TSP1xy	1366	/* KEY_Textstartpunkt1 */
#define _PAR_TSP2	1367	/* KEY_Textstartpunkt2 */
#define _PAR_TSP2id	1368	/* KEY_Textstartpunkt2 */
#define _PAR_TSP2na	1369	/* KEY_Textstartpunkt2 */
#define _PAR_TSP2xy	1370	/* KEY_Textstartpunkt2 */
#define _PAR_TUL	1371	/* KEY_TextUnterStrichen */
#define _PAR_TVN	1162	/* KEY_TextVorNennmass */
#define _PAR_TVNid	1163	/* KEY_TextVorNennmass */
#define _PAR_TVNna	1164	/* KEY_TextVorNennmass */
#define _PAR_TWI	1260	/* KEY_TWI */
#define _PAR_TXK	1372	/* KEY_UmrandungPosNr */
#define _PAR_TXT	1261	/* KEY_TXT */
#define _PAR_TXTid	1262	/* KEY_TXT */
#define _PAR_TXTna	1263	/* KEY_TXT */
#define _PAR_TXTi	1264	/* KEY_Texte */
#define _PAR_TXTiid	1265	/* KEY_Texte */
#define _PAR_TXTina	1266	/* KEY_Texte */
#define _PAR_UARW	1373	/* KEY_UntereAndereRauheit */
#define _PAR_UARWid	1374	/* KEY_UntereAndereRauheit */
#define _PAR_UARWna	1375	/* KEY_UntereAndereRauheit */
#define _PAR_UEB	1376	/* KEY_Ueberschrift */
#define _PAR_UEBid	1377	/* KEY_Ueberschrift */
#define _PAR_UEBna	1378	/* KEY_Ueberschrift */
#define _PAR_URW	1379	/* KEY_UntererRauhwert */
#define _PAR_URWid	1380	/* KEY_UntererRauhwert */
#define _PAR_URWna	1381	/* KEY_UntererRauhwert */
#define _PAR_VERGAB	1463	/* KEY_VergabeModus */
#define _PAR_VINDEX	1382	/* KEY_MusterIndex */
#define _PAR_VOR	1383	/* KEY_Voreinstellung */
#define _PAR_VORid	1384	/* KEY_Voreinstellung */
#define _PAR_VORna	1385	/* KEY_Voreinstellung */
#define _PAR_WA		1267	/* KEY_WA */
#define _PAR_WERT	1464	/* KEY_WertNennmass */
#define _PAR_WI		1075	/* KEY_Winkel */
#define _PAR_WM		1465	/* KEY_Winkelmass */
#define _PAR_WMid	1466	/* KEY_Winkelmass */
#define _PAR_WMna	1467	/* KEY_Winkelmass */
#define _PAR_X		1468	/* KEY_X */
#define _PAR_Y		1469	/* KEY_Y */
#define _PAR_ZA		1268	/* KEY_ZA */
#define _PAR_ZAH	1386	/* KEY_Zahl */
#define _PAR_ZAHstr	1387	/* KEY_Zahl */
#define _PAR_ZB		1269	/* KEY_ZB */

#define MAX_PAR_NUMMER	1479	/*** A N P A S S E N ! ! ! ***/

#define ABSCHLUSS	0


#define AB(a)			_PAR_AB     , (double)(a)
#define AB1(a)			_PAR_AB1    , (double)(a)
#define AB2(a)			_PAR_AB2    , (double)(a)
#define AD(a)			_PAR_AD     , (int)(a)
#define AI(a)			_PAR_AI     , (char *)(a)
#define AIid(a)			_PAR_AIid   , (CadObjektIdentifizierung *)(a)
#define AIna(a)			_PAR_AIna   , (char *)(a)
#define ALLE(a)			_PAR_ALLE   , (int)(a)
#define ART(a)			_PAR_ART    , (int)(a)
#define ARW(a)			_PAR_ARW    , (char *)(a)
#define ARWid(a)		_PAR_ARWid  , (CadObjektIdentifizierung *)(a)
#define ARWna(a)		_PAR_ARWna  , (char *)(a)
#define ATE(a)			_PAR_ATE    , (int)(a)
#define AUSBLENDFOLIEN(a)	_PAR_AUSB   , (Element *)(a)
#define AUSBLENDFOLIENid(a)	_PAR_AUSBid , (CadObjektIdentifizierung *)(a)
#define AUSBLENDFOLIENna(a)	_PAR_AUSBna , (char *)(a)
#define AUSGEi(a)		_PAR_AUSE   , (Element *)(a)
#define AUSGEiid(a)		_PAR_AUSEid , (CadObjektIdentifizierung *)(a)
#define AUSGEina(a)		_PAR_AUSEna , (char *)(a)
#define AUSGL(a)		_PAR_AUSL   , (Element *)(a)
#define AUSGLid(a)		_PAR_AUSLid , (CadObjektIdentifizierung *)(a)
#define AUSGLna(a)		_PAR_AUSLna , (char *)(a)
#define AUSSEN(a)		_PAR_AUSSEN , (int)(a)
#define AWI(a)			_PAR_AWI    , (double)(a)
#define B(a)			_PAR_B      , (double)(a)
#define BAZU(a)			_PAR_BAZU   , (char *)(a)
#define BAZUid(a)		_PAR_BAZUid , (CadObjektIdentifizierung *)(a)
#define BEZUna(a)		_PAR_BAZUna , (char *)(a)
#define BE(a)			_PAR_BE     , (Element *)(a)
#define BEid(a)			_PAR_BEid   , (CadObjektIdentifizierung *)(a)
#define BEna(a)			_PAR_BEna   , (char *)(a)
#define BExy(a)			_PAR_BExy   , (Koordinaten3D *)(a)
#define BE1(a)			_PAR_BE1    , (Element *)(a)
#define BE1id(a)		_PAR_BE1id  , (CadObjektIdentifizierung *)(a)
#define BE1na(a)		_PAR_BE1na  , (char *)(a)
#define BE1xy(a)		_PAR_BE1xy  , (Koordinaten3D *)(a)
#define BE2(a)			_PAR_BE2    , (Element *)(a)
#define BE2id(a)		_PAR_BE2id  , (CadObjektIdentifizierung *)(a)
#define BE2na(a)		_PAR_BE2na  , (char *)(a)
#define BE2xy(a)		_PAR_BE2xy  , (Koordinaten3D *)(a)
#define BEi(a)			_PAR_BEi    , (Element *)(a)
#define BEiid(a)		_PAR_BEiid  , (CadObjektIdentifizierung *)(a)
#define BEina(a)		_PAR_BEina  , (char *)(a)
#define BEixy(a)		_PAR_BEixy  , (Koordinaten3D *)(a)
#define BEARBEITUNG(a)		_PAR_BEAR   , (Element *)(a)
#define BEARBEITUNGid(a)	_PAR_BEARid , (CadObjektIdentifizierung *)(a)
#define BEARBEITUNGna(a)	_PAR_BEARna , (char *)(a)
#define BELEGUNG(a)		_PAR_BELza  , (double)(a)
#define BELEGUNGxy(a)		_PAR_BELxy  , (Koordinaten3D *)(a)
#define BELEGUNGstr(a)		_PAR_BELstr , (char *)(a)
#define BESCHREIBUNG(a)		_PAR_BES    , (char *)(a)
#define BESCHREIBUNGid(a)	_PAR_BESid  , (CadObjektIdentifizierung *)(a)
#define BESCHREIBUNGna(a)	_PAR_BESna  , (char *)(a)
#define BG(a)			_PAR_BG     , (Element *)(a)
#define BGid(a)			_PAR_BGid   , (CadObjektIdentifizierung *)(a)
#define BGna(a)			_PAR_BGna   , (char *)(a)
#define BG1(a)			_PAR_BG1    , (Element *)(a)
#define BG1id(a)		_PAR_BG1id  , (CadObjektIdentifizierung *)(a)
#define BG1na(a)		_PAR_BG1na  , (char *)(a)
#define BG2(a)			_PAR_BG2    , (Element *)(a)
#define BG2id(a)		_PAR_BG2id  , (CadObjektIdentifizierung *)(a)
#define BG2na(a)		_PAR_BG2na  , (char *)(a)
#define BGR(a)			_PAR_BGR    , (int)(a)
#define BGRH(a)			_PAR_BGRH   , (double)(a)
#define BGRL(a)			_PAR_BGRL   , (double)(a)
#define BL(a)			_PAR_BL     , (double)(a)
#define BMP(a)			_PAR_BMP    , (Element *)(a)
#define BMPid(a)		_PAR_BMPid  , (CadObjektIdentifizierung *)(a)
#define BMPna(a)		_PAR_BMPna  , (char *)(a)
#define BMPxy(a)		_PAR_BMPxy  , (Koordinaten3D *)(a)
#define BP1(a)			_PAR_BP1    , (Element *)(a)
#define BP1id(a)		_PAR_BP1id  , (CadObjektIdentifizierung *)(a)
#define BP1na(a)		_PAR_BP1na  , (char *)(a)
#define BP1xy(a)		_PAR_BP1xy  , (Koordinaten3D *)(a)
#define BP2(a)			_PAR_BP2    , (Element *)(a)
#define BP2id(a)		_PAR_BP2id  , (CadObjektIdentifizierung *)(a)
#define BP2na(a)		_PAR_BP2na  , (char *)(a)
#define BP2xy(a)		_PAR_BP2xy  , (Koordinaten3D *)(a)
#define BPi(a)			_PAR_BPi    , (Element *)(a)
#define BPiid(a)		_PAR_BPiid  , (CadObjektIdentifizierung *)(a)
#define BPina(a)		_PAR_BPina  , (char *)(a)
#define BPixy(a)		_PAR_BPixy  , (Koordinaten3D *)(a)
#define BPM(a)			_PAR_BPM    , (Element *)(a)
#define BPMid(a)		_PAR_BPMid  , (CadObjektIdentifizierung *)(a)
#define BPMna(a)		_PAR_BPMna  , (char *)(a)
#define BPMxy(a)		_PAR_BPMxy  , (Koordinaten3D *)(a)
#define BTU(a)			_PAR_BTU    , (int)(a)
#define BUS(a)			_PAR_BUS    , (int)(a)
#define BWI(a)			_PAR_BWI    , (double)(a)
#define BZP(a)			_PAR_BZP    , (Element *)(a)
#define BZPid(a)		_PAR_BZPid  , (CadObjektIdentifizierung *)(a)
#define BZPna(a)		_PAR_BZPna  , (char *)(a)
#define BZPxy(a)		_PAR_BZPxy  , (Koordinaten3D *)(a)
#define BZST(a)			_PAR_BZST   , (char *)(a)
#define BZSTid(a)		_PAR_BZSTid , (CadObjektIdentifizierung *)(a)
#define BZSTna(a)		_PAR_BZSTna , (char *)(a)
#define D(a)			_PAR_D      , (double)(a)
#define DATEI(a)		_PAR_DAT    , (char *)(a)
#define DATEIid(a)		_PAR_DATid  , (CadObjektIdentifizierung *)(a)
#define DATEIna(a)		_PAR_DATna  , (char *)(a)
#define DATENBANK(a)		_PAR_DB     , (int)(a)
#define DELTA(a)		_PAR_DELTA  , (long)(a)
#define DX(a)			_PAR_DX     , (double)(a)
#define DXFMASS(a)		_PAR_DXFMAS , (int)(a)
#define DXFPUNKTE(a)		_PAR_DXFPKT , (int)(a)
#define DXFTEXT(a)		_PAR_DXFTXT , (int)(a)
#define DY(a)			_PAR_DY     , (double)(a)
#define EINBLENDFOLIEN(a)	_PAR_EINB   , (Element *)(a)
#define EINBLENDFOLIENid(a)	_PAR_EINBid , (CadObjektIdentifizierung *)(a)
#define EINBLENDFOLIENna(a)	_PAR_EINBna , (char *)(a)
#define EINHEIT(a)		_PAR_EINH   , (char *)(a)
#define EINHEITid(a)		_PAR_EINHid , (CadObjektIdentifizierung *)(a)
#define EINHEITna(a)		_PAR_EINHna , (char *)(a)
#define ELE(a)			_PAR_ELE    , (Element *)(a)
#define ELEid(a)		_PAR_ELEid  , (CadObjektIdentifizierung *)(a)
#define ELEna(a)		_PAR_ELEna  , (char *)(a)
#define ELEi(a)			_PAR_ELEi   , (Element *)(a)
#define ELEiid(a)		_PAR_ELEiid , (CadObjektIdentifizierung *)(a)
#define ELEina(a)		_PAR_ELEina , (char *)(a)
#define _ELEp(a)		_PAR_ELEp   , (Element *)(a)
#define _ELEpid(a)		_PAR_ELEpid , (CadObjektIdentifizierung *)(a)
#define _ELEpna(a)		_PAR_ELEpna , (char *)(a)
#define ELEp(a,b)		_ELEp(a)    , (Koordinaten3D *)(b)
#define ELEpid(a,b)		_ELEpid(a)  , (Koordinaten3D *)(b)
#define ELEpna(a,b)		_ELEpna(a)  , (Koordinaten3D *)(b)
#define ELE1(a)			_PAR_ELE1   , (Element *)(a)
#define ELE1id(a)		_PAR_ELE1id , (CadObjektIdentifizierung *)(a)
#define ELE1na(a)		_PAR_ELE1na , (char *)(a)
#define ELE2(a)			_PAR_ELE2   , (Element *)(a)
#define ELE2id(a)		_PAR_ELE2id , (CadObjektIdentifizierung *)(a)
#define ELE2na(a)		_PAR_ELE2na , (char *)(a)
#define ELE3(a)			_PAR_ELE3   , (Element *)(a)
#define ELE3id(a)		_PAR_ELE3id , (CadObjektIdentifizierung *)(a)
#define ELE3na(a)		_PAR_ELE3na , (char *)(a)
#define EP(a)			_PAR_EP     , (Element *)(a)
#define EPid(a)			_PAR_EPid   , (CadObjektIdentifizierung *)(a)
#define EPna(a)			_PAR_EPna   , (char *)(a)
#define EPxy(a)			_PAR_EPxy   , (Koordinaten3D *)(a)
#define EZHRAHMEN(a)		_PAR_EZRAHM , (int)(a)
#define FA(a)			_PAR_FA     , (int)(a)
#define FEL(a)			_PAR_FEL    , (Element *)(a)
#define FELid(a)		_PAR_FELid  , (CadObjektIdentifizierung *)(a)
#define FELna(a)		_PAR_FELna  , (char *)(a)
#define FENSTERNR(a)		_PAR_FENNR  , (int)(a)
#define FL(a)			_PAR_FL     , (int)(a)
#define FO(a)			_PAR_FO     , (Element *)(a)
#define FOid(a)			_PAR_FOid   , (CadObjektIdentifizierung *)(a)
#define FOna(a)			_PAR_FOna   , (char *)(a)
#define FOLIE(a)		_PAR_FOL    , (Element *)(a)
#define FOLIEid(a)		_PAR_FOLid  , (CadObjektIdentifizierung *)(a)
#define FOLIEna(a)		_PAR_FOLna  , (char *)(a)
#define FOLIEN(a)		_PAR_FOLI   , (Element *)(a)
#define FOLIENid(a)		_PAR_FOLIid , (CadObjektIdentifizierung *)(a)
#define FOLIENna(a)		_PAR_FOLIna , (char *)(a)
#define FVF(a)			_PAR_FVF    , (char *)(a)
#define FVFid(a)		_PAR_FVFid  , (CadObjektIdentifizierung *)(a)
#define FVFna(a)		_PAR_FVFna  , (char *)(a)
#define G(a)			_PAR_G      , (Element *)(a)
#define Gid(a)			_PAR_Gid    , (CadObjektIdentifizierung *)(a)
#define Gna(a)			_PAR_Gna    , (char *)(a)
#define Gi(a)			_PAR_Gi     , (Element *)(a)
#define Giid(a)			_PAR_Giid   , (CadObjektIdentifizierung *)(a)
#define Gina(a)			_PAR_Gina   , (char *)(a)
#define G1(a)			_PAR_G1     , (Element *)(a)
#define G1id(a)			_PAR_G1id   , (CadObjektIdentifizierung *)(a)
#define G1na(a)			_PAR_G1na   , (char *)(a)
#define G2(a)			_PAR_G2     , (Element *)(a)
#define G2id(a)			_PAR_G2id   , (CadObjektIdentifizierung *)(a)
#define G2na(a)			_PAR_G2na   , (char *)(a)
#define GA(a)			_PAR_GA     , (double)(a)
#define GAB(a)			_PAR_GAB    , (double)(a)
#define GEOi(a)			_PAR_GEOi   , (Element *)(a)
#define GEOiid(a)		_PAR_GEOiid , (CadObjektIdentifizierung *)(a)
#define GEOina(a)		_PAR_GEOina , (char *)(a)
#define GEOMETRIE(a)		_PAR_GEOM   , (Element *)(a)
#define GEOMETRIEid(a)		_PAR_GEOMid , (CadObjektIdentifizierung *)(a)
#define GEOMETRIEna(a)		_PAR_GEOMna , (char *)(a)
#define GESAMT(a)		_PAR_GESAMT , (int)(a)
#define GEVERB(a)		_PAR_GEVERB , (int)(a)
#define GEWL(a)			_PAR_GEWL   , (Element *)(a)
#define GEWLid(a)		_PAR_GEWLid , (CadObjektIdentifizierung *)(a)
#define GEWLna(a)		_PAR_GEWLna , (char *)(a)
#define GK(a)			_PAR_GK     , (int)(a)
#define GN(a)			_PAR_GN     , (Element *)(a)
#define GNid(a)			_PAR_GNid   , (CadObjektIdentifizierung *)(a)
#define GNna(a)			_PAR_GNna   , (char *)(a)
#define GRPi(a)			_PAR_GRPi   , (Element *)(a)
#define GRPiid(a)		_PAR_GRPiid , (CadObjektIdentifizierung *)(a)
#define GRPina(a)		_PAR_GRPina , (char *)(a)
#define H(a)			_PAR_H      , (double)(a)
#define HWL(a)			_PAR_HWL    , (Element *)(a)
#define HWLid(a)		_PAR_HWLid  , (CadObjektIdentifizierung *)(a)
#define HWLna(a)		_PAR_HWLna  , (char *)(a)
#define HWLxy(a)		_PAR_HWLxy  , (Koordinaten3D *)(a)
#define HWL1(a)			_PAR_HWL1   , (Element *)(a)
#define HWL1id(a)		_PAR_HWL1id , (CadObjektIdentifizierung *)(a)
#define HWL1na(a)		_PAR_HWL1na , (char *)(a)
#define HWL1xy(a)		_PAR_HWL1xy , (Koordinaten3D *)(a)
#define HWL2(a)			_PAR_HWL2   , (Element *)(a)
#define HWL2id(a)		_PAR_HWL2id , (CadObjektIdentifizierung *)(a)
#define HWL2na(a)		_PAR_HWL2na , (char *)(a)
#define HWL2xy(a)		_PAR_HWL2xy , (Koordinaten3D *)(a)
#define HWL3(a)			_PAR_HWL3   , (Element *)(a)
#define HWL3id(a)		_PAR_HWL3id , (CadObjektIdentifizierung *)(a)
#define HWL3na(a)		_PAR_HWL3na , (char *)(a)
#define HWL3xy(a)		_PAR_HWL3xy , (Koordinaten3D *)(a)
#define ID(a)			_PAR_ID     , (CadObjektIdentifizierung *)(a)
#define IE(a)			_PAR_IE     , (int)(a)
#define K(a)			_PAR_K      , (Element *)(a)
#define Kid(a)			_PAR_Kid    , (CadObjektIdentifizierung *)(a)
#define Kna(a)			_PAR_Kna    , (char *)(a)
#define K1(a)			_PAR_K1     , (Element *)(a)
#define K1id(a)			_PAR_K1id   , (CadObjektIdentifizierung *)(a)
#define K1na(a)			_PAR_K1na   , (char *)(a)
#define K2(a)			_PAR_K2     , (Element *)(a)
#define K2id(a)			_PAR_K2id   , (CadObjektIdentifizierung *)(a)
#define K2na(a)			_PAR_K2na   , (char *)(a)
#define KB(a)			_PAR_KB     , (Element *)(a)
#define KBid(a)			_PAR_KBid   , (CadObjektIdentifizierung *)(a)
#define KBna(a)			_PAR_KBna   , (char *)(a)
#define KENNBUCHST(a)		_PAR_KENN   , (char *)(a)
#define KENNBUCHSTid(a)		_PAR_KENNid , (CadObjektIdentifizierung *)(a)
#define KENNBUCHSTna(a)		_PAR_KENNna , (char *)(a)
#define KK(a)			_PAR_KK     , (int)(a)
#define KoK(a)			_PAR_KoK    , (Element *)(a)
#define KoKid(a)		_PAR_KoKid  , (CadObjektIdentifizierung *)(a)
#define KoKna(a)		_PAR_KoKna  , (char *)(a)
#define KL(a)			_PAR_KL     , (int)(a)
#define KlAuf(a)		_PAR_KlAu   , (char *)(a)
#define KlAufid(a)		_PAR_KlAuid , (CadObjektIdentifizierung *)(a)
#define KlAufna(a)		_PAR_KlAuna , (char *)(a)
#define KlZu(a)			_PAR_KlZu   , (char *)(a)
#define KlZuid(a)		_PAR_KlZuid , (CadObjektIdentifizierung *)(a)
#define KlZuna(a)		_PAR_KlZuna , (char *)(a)
#define KMH(a)			_PAR_KMH    , (char *)(a)
#define KN(a)			_PAR_KN     , (Element *)(a)
#define KNid(a)			_PAR_KNid   , (CadObjektIdentifizierung *)(a)
#define KNna(a)			_PAR_KNna   , (char *)(a)
#define KONBEZ(a)		_PAR_KONBEZ , (int)(a)
#define KOORD(a)		_PAR_KOO    , (Element *)(a)
#define KOORDid(a)		_PAR_KOOid  , (CadObjektIdentifizierung *)(a)
#define KOORDna(a)		_PAR_KOOna  , (char *)(a)
#define KOORDxy(a)		_PAR_KOOxy  , (Koordinaten3D *)(b)
#define KOORDstr(a)		_PAR_KOOstr , (char *)(a)
#define KOPIE(a)		_PAR_KOPIE  , (int)(a)
#define L(a)			_PAR_L      , (double)(a)
#define _Li(a)			_PAR_Li     , (Element *)(a)
#define _Liid(a)		_PAR_Liid   , (CadObjektIdentifizierung *)(a)
#define _Lina(a)		_PAR_Lina   , (char *)(a)
#define Li(a,b)			_Li(a)      , (Koordinaten3D *)(b)
#define Liid(a,b)		_Liid(a)    , (Koordinaten3D *)(b)
#define Lina(a,b)		_Lina(a)    , (Koordinaten3D *)(b)
#define LA(a)			_PAR_LA     , (int)(a)
#define LART(a)			_PAR_LART   , (int)(a)
#define LB(a)			_PAR_LB     , (int)(a)
#define LBP(a)			_PAR_LBP    , (int)(a)
#define LINKS(a)		_PAR_LINKS  , (int)(a)
#define LSP(a)			_PAR_LSP    , (int)(a)
#define LT(a)			_PAR_LT     , (int)(a)
#define MA(a)			_PAR_MA     , (int)(a)
#define MAB(a)			_PAR_MAB    , (double)(a)
#define MASSTAB(a)		_PAR_MST    , (double)(a)
#define MB(a)			_PAR_MB     , (int)(a)
#define MBH(a)			_PAR_MBH    , (double)(a)
#define MBL(a)			_PAR_MBL    , (double)(a)
#define MITBEMASSUNG(a)		_PAR_MITBEM , (int)(a)
#define MITEINZELHEITEN(a)	_PAR_MITEZH , (int)(a)
#define MITKONBEZ(a)		_PAR_MITKON , (int)(a)
#define MITOBERFLAECHE(a)	_PAR_MITOBF , (int)(a)
#define MITPOSNUMMERN(a)	_PAR_MITPOS , (int)(a)
#define MK(a)			_PAR_MK     , (int)(a)
#define MITTELLINIE(a)		_PAR_ML     , (int)(a)
#define MITTIG(a)		_PAR_MITTIG , (int)(a)
#define MLM(a)			_PAR_MLM    , (int)(a)
#define MRW(a)			_PAR_MRW    , (char *)(a)
#define MRWid(a)		_PAR_MRWid  , (CadObjektIdentifizierung *)(a)
#define MRWna(a)		_PAR_MRWna  , (char *)(a)
#define MTEIL(a)		_PAR_MTEIL  , (int)(a)
#define MTH(a)			_PAR_MTH    , (double)(a)
#define MTL(a)			_PAR_MTL    , (int)(a)
#define MTWA(a)			_PAR_MTWA   , (int)(a)
#define MTWI(a)			_PAR_MTWI   , (double)(a)
#define N(a)			_PAR_N      , (double)(a)
#define NA(a)			_PAR_NA     , (char *)(a)
#define NBE(a)			_PAR_NBE    , (Element *)(a)
#define NBEid(a)		_PAR_NBEid  , (CadObjektIdentifizierung *)(a)
#define NBEna(a)		_PAR_NBEna  , (char *)(a)
#define NBExy(a)		_PAR_NBExy  , (Koordinaten3D *)(a)
#define NEUINDEX(a)		_PAR_NEUIDX , (double)(a)
#define Ni(a)			_PAR_Ni     , (double)(a)
#define NN(a)			_PAR_NN     , (char *)(a)
#define NNid(a)			_PAR_NNid   , (CadObjektIdentifizierung *)(a)
#define NNna(a)			_PAR_NNna   , (char *)(a)
#define NND(a)			_PAR_NND    , (char *)(a)
#define NNF(a)			_PAR_NNF    , (double)(a)
#define NNPF(a)			_PAR_NNPF   , (char *)(a)
#define NNPFid(a)		_PAR_NNPFid , (CadObjektIdentifizierung *)(a)
#define NNPFna(a)		_PAR_NNPFna , (char *)(a)
#define NORM(a)			_PAR_NORM   , (int)(a)
#define NPM(a)			_PAR_NPM    , (Element *)(a)
#define NPMid(a)		_PAR_NPMid  , (CadObjektIdentifizierung *)(a)
#define NPMna(a)		_PAR_NPMna  , (char *)(a)
#define NPMxy(a)		_PAR_NPMxy  , (Koordinaten3D *)(a)
#define NR(a)			_PAR_NR     , (int)(a)
#define NURKONSTRUKTION(a)	_PAR_NURKON , (int)(a)
#define OARW(a)			_PAR_OARW   , (char *)(a)
#define OARWid(a)		_PAR_OARWid , (CadObjektIdentifizierung *)(a)
#define OARWna(a)		_PAR_OARWna , (char *)(a)
#define OFFSET(a)		_PAR_OFF    , (double)(a)
#define OFFSETX(a)		_PAR_OFFX   , (double)(a)
#define OFFSETY(a)		_PAR_OFFY   , (double)(a)
#define OFZ(a)			_PAR_OFZ    , (char *)(a)
#define OFZid(a)		_PAR_OFZid  , (CadObjektIdentifizierung *)(a)
#define OFZna(a)		_PAR_OFZna  , (char *)(a)
#define OH(a)			_PAR_OH     , (double)(a)
#define OP(a)			_PAR_OP     , (Element *)(a)
#define OPid(a)			_PAR_OPid   , (CadObjektIdentifizierung *)(a)
#define OPna(a)			_PAR_OPna   , (char *)(a)
#define OPi(a)			_PAR_OPi    , (Element *)(a)
#define OPiid(a)		_PAR_OPiid  , (CadObjektIdentifizierung *)(a)
#define OPina(a)		_PAR_OPina  , (char *)(a)
#define ORW(a)			_PAR_ORW    , (char *)(a)
#define ORWid(a)		_PAR_ORWid  , (CadObjektIdentifizierung *)(a)
#define ORWna(a)		_PAR_ORWna  , (char *)(a)
#define P(a)			_PAR_P      , (Element *)(a)
#define Pid(a)			_PAR_Pid    , (CadObjektIdentifizierung *)(a)
#define Pna(a)			_PAR_Pna    , (char *)(a)
#define Pxy(a)			_PAR_Pxy    , (Koordinaten3D *)(a)
#define Pi(a)			_PAR_Pi     , (Element *)(a)
#define Piid(a)			_PAR_Piid   , (CadObjektIdentifizierung *)(a)
#define Pina(a)			_PAR_Pina   , (char *)(a)
#define Pixy(a)			_PAR_Pixy   , (Koordinaten3D *)(a)
#define P1(a)			_PAR_P1     , (Element *)(a)
#define P1id(a)			_PAR_P1id   , (CadObjektIdentifizierung *)(a)
#define P1na(a)			_PAR_P1na   , (char *)(a)
#define P1xy(a)			_PAR_P1xy   , (Koordinaten3D *)(a)
#define P2(a)			_PAR_P2     , (Element *)(a)
#define P2id(a)			_PAR_P2id   , (CadObjektIdentifizierung *)(a)
#define P2na(a)			_PAR_P2na   , (char *)(a)
#define P2xy(a)			_PAR_P2xy   , (Koordinaten3D *)(a)
#define PA(a)			_PAR_PA     , (Element *)(a)
#define PAid(a)			_PAR_PAid   , (CadObjektIdentifizierung *)(a)
#define PAna(a)			_PAR_PAna   , (char *)(a)
#define PAxy(a)			_PAR_PAxy   , (Koordinaten3D *)(a)
#define PARAMETER(a)		_PAR_PARM   , (char *)(a)
#define PARAMETERid(a)		_PAR_PARMid , (CadObjektIdentifizierung *)(a)
#define PARAMETERna(a)		_PAR_PARMna , (char *)(a)
#define PARAMETRIK(a)		_PAR_PARA   , (int)(a)
#define PARAMETRIKBEM(a)	_PAR_PBEM   , (Element *)(a)
#define PARAMETRIKBEMid(a)	_PAR_PBEMid , (CadObjektIdentifizierung *)(a)
#define PARAMETRIKBEMna(a)	_PAR_PBEMna , (char *)(a)
#define PD(a)			_PAR_PD     , (Element *)(a)
#define PDid(a)			_PAR_PDid   , (CadObjektIdentifizierung *)(a)
#define PDna(a)			_PAR_PDna   , (char *)(a)
#define PDxy(a)			_PAR_PDxy   , (Koordinaten3D *)(a)
#define PDA(a)			_PAR_PDA    , (int)(a)
#define PFNN(a)			_PAR_PFNN   , (char *)(a)
#define PFNNid(a)		_PAR_PFNNid , (CadObjektIdentifizierung *)(a)
#define PFNNna(a)		_PAR_PFNNna , (char *)(a)
#define PARINDEX(a)		_PAR_PINDEX , (double)(a)
#define PL(a)			_PAR_PL     , (double)(a)
#define PM(a)			_PAR_PM     , (Element *)(a)
#define PMid(a)			_PAR_PMid   , (CadObjektIdentifizierung *)(a)
#define PMna(a)			_PAR_PMna   , (char *)(a)
#define PMxy(a)			_PAR_PMxy   , (Koordinaten3D *)(a)
#define PML(a)			_PAR_PML    , (Element *)(a)
#define PMLid(a)		_PAR_PMLid  , (CadObjektIdentifizierung *)(a)
#define PMLna(a)		_PAR_PMLna  , (char *)(a)
#define PMLxy(a)		_PAR_PMLxy  , (Koordinaten3D *)(a)
#define PN(a)			_PAR_PN     , (Element *)(a)
#define PNid(a)			_PAR_PNid   , (CadObjektIdentifizierung *)(a)
#define PNna(a)			_PAR_PNna   , (char *)(a)
#define POSNUMMERN(a)		_PAR_PNUM   , (Element *)(a)
#define POSNUMMERNid(a)		_PAR_PNUMid , (CadObjektIdentifizierung *)(a)
#define POSNUMMERNna(a)		_PAR_PNUMna , (char *)(a)
#define PRJ(a)			_PAR_PRJ    , (Element *)(a)
#define PRJid(a)		_PAR_PRJid  , (CadObjektIdentifizierung *)(a)
#define PRJna(a)		_PAR_PRJna  , (char *)(a)
#define PUEBERNAHME(a)		_PAR_PUEBER , (int)(a)
#define PZP(a)			_PAR_PZP    , (Element *)(a)
#define PZPid(a)		_PAR_PZPid  , (CadObjektIdentifizierung *)(a)
#define PZPna(a)		_PAR_PZPna  , (char *)(a)
#define PZPxy(a)		_PAR_PZPxy  , (Koordinaten3D *)(a)
#define R(a)			_PAR_R      , (double)(a)
#define RECHTS(a)		_PAR_RECHTS , (int)(a)
#define REFERENZ(a)		_PAR_REFER  , (int)(a)
#define REFERENZBEM(a)		_PAR_RBEM   , (Element *)(a)
#define REFERENZBEMid(a)	_PAR_RBEMid , (CadObjektIdentifizierung *)(a)
#define REFERENZBEMna(a)	_PAR_RBEMna , (char *)(a)
#define REFLOESEN(a)		_PAR_REFLOE , (int)(a)
#define RILR(a)			_PAR_RILR   , (int)(a)
#define RSB(a)			_PAR_RSB    , (double)(a)
#define SACHNUMMER(a)		_PAR_SNR    , (char *)(a)
#define SACHNUMMERid(a)		_PAR_SNRid  , (CadObjektIdentifizierung *)(a)
#define SACHNUMMERna(a)		_PAR_SNRna  , (char *)(a)
#define SCHLIESSEN(a)		_PAR_SCHLIE , (int)(a)
#define SCHRAFFUR(a)		_PAR_SCH    , (Element *)(a)
#define SCHRAFFURid(a)		_PAR_SCHid  , (CadObjektIdentifizierung *)(a)
#define SCHRAFFURna(a)		_PAR_SCHna  , (char *)(a)
#define SCHRIFTFELD(a)		_PAR_SCFD   , (Element *)(a)
#define SCHRIFTFELDid(a)	_PAR_SCFDid , (CadObjektIdentifizierung *)(a)
#define SCHRIFTFELDna(a)	_PAR_SCFDna , (char *)(a)
#define SFD(a)			_PAR_SFD    , (int)(a)
#define SG(a)			_PAR_SG     , (Element *)(a)
#define SGid(a)			_PAR_SGid   , (CadObjektIdentifizierung *)(a)
#define SGna(a)			_PAR_SGna   , (char *)(a)
#define SKFAKTOR(a)		_PAR_SKFAKT , (double)(a)
#define SMU(a)			_PAR_SMU    , (char *)(a)
#define SMUid(a)		_PAR_SMUid  , (CadObjektIdentifizierung *)(a)
#define SMUna(a)		_PAR_SMUna  , (char *)(a)
#define STDUEBERNAHME(a)	_PAR_STDUEB , (int)(a)
#define STL(a)			_PAR_STL    , (int)(a)
#define STZ(a)			_PAR_STZ    , (double)(a)
#define TBP(a)			_PAR_TBP    , (int)(a)
#define TEIL(a)			_PAR_TEIL   , (Element *)(a)
#define TEILid(a)		_PAR_TEILid , (CadObjektIdentifizierung *)(a)
#define TEILna(a)		_PAR_TEILna , (char *)(a)
#define TEXT(a)			_PAR_TEXT   , (Element *)(a)
#define TEXTid(a)		_PAR_TEXTid , (CadObjektIdentifizierung *)(a)
#define TEXTna(a)		_PAR_TEXTna , (char *)(a)
#define TFO(a)			_PAR_TFO    , (char *)(a)
#define TFOid(a)		_PAR_TFOid  , (CadObjektIdentifizierung *)(a)
#define TFOna(a)		_PAR_TFOna  , (char *)(a)
#define TH(a)			_PAR_TH     , (double)(a)
#define THP(a)			_PAR_THP    , (double)(a)
#define TK(a)			_PAR_TK     , (char *)(a)
#define TKid(a)			_PAR_TKid   , (CadObjektIdentifizierung *)(a)
#define TKna(a)			_PAR_TKna   , (char *)(a)
#define TLA(a)			_PAR_TLA    , (double)(a)
#define TLO(a)			_PAR_TLO    , (double)(a)
#define TLOstr(a)		_PAR_TLOstr , (char *)(a)
#define TLU(a)			_PAR_TLU    , (double)(a)
#define TLUstr(a)		_PAR_TLUstr , (char *)(a)
#define TN(a)			_PAR_TN     , (double)(a)
#define TNN(a)			_PAR_TNN    , (char *)(a)
#define TNNid(a)		_PAR_TNNid  , (CadObjektIdentifizierung *)(a)
#define TNNna(a)		_PAR_TNNna  , (char *)(a)
#define TSP1(a)			_PAR_TSP1   , (Element *)(a)
#define TSP1id(a)		_PAR_TSP1id , (CadObjektIdentifizierung *)(a)
#define TSP1na(a)		_PAR_TSP1na , (char *)(a)
#define TSP1xy(a)		_PAR_TSP1xy , (Koordinaten3D *)(a)
#define TSP2(a)			_PAR_TSP2   , (Element *)(a)
#define TSP2id(a)		_PAR_TSP2id , (CadObjektIdentifizierung *)(a)
#define TSP2na(a)		_PAR_TSP2na , (char *)(a)
#define TSP2xy(a)		_PAR_TSP2xy , (Koordinaten3D *)(a)
#define TUL(a)			_PAR_TUL    , (int)(a)
#define TVN(a)			_PAR_TVN    , (char *)(a)
#define TVNid(a)		_PAR_TVNid  , (CadObjektIdentifizierung *)(a)
#define TVNna(a)		_PAR_TVNna  , (char *)(a)
#define TWI(a)			_PAR_TWI    , (double)(a)
#define TXK(a)			_PAR_TXK    , (int)(a)
#define TXT(a)			_PAR_TXT    , (char *)(a)
#define TXTid(a)		_PAR_TXTid  , (CadObjektIdentifizierung *)(a)
#define TXTna(a)		_PAR_TXTna  , (char *)(a)
#define TXTi(a)			_PAR_TXTi   , (Element *)(a)
#define TXTiid(a)		_PAR_TXTiid , (CadObjektIdentifizierung *)(a)
#define TXTina(a)		_PAR_TXTina , (char *)(a)
#define UARW(a)			_PAR_UARW   , (char *)(a)
#define UARWid(a)		_PAR_UARWid , (CadObjektIdentifizierung *)(a)
#define UARWna(a)		_PAR_UARWna , (char *)(a)
#define UEBERSCHRIFT(a)		_PAR_UEB    , (char *)(a)
#define UEBERSCHRIFTid(a)	_PAR_UEBid  , (CadObjektIdentifizierung *)(a)
#define UEBERSCHRIFTna(a)	_PAR_UEBna  , (char *)(a)
#define URW(a)			_PAR_URW    , (char *)(a)
#define URWid(a)		_PAR_URWid  , (CadObjektIdentifizierung *)(a)
#define URWna(a)		_PAR_URWna  , (char *)(a)
#define VARIANTENINDEX(a)	_PAR_VINDEX , (double)(a)
#define VERGABEMODUS(a)		_PAR_VERGAB , (double)(a)
#define VOREINST(a)		_PAR_VOR    , (Element *)(a)
#define VOREINSTid(a)		_PAR_VORid  , (CadObjektIdentifizierung *)(a)
#define VOREINSTna(a)		_PAR_VORna  , (char *)(a)
#define WA(a)			_PAR_WA     , (double)(a)
#define WERT(a)			_PAR_WERT   , (double)(a)
#define WI(a)			_PAR_WI     , (double)(a)
#define WM(a)			_PAR_WM     , (Element *)(a)
#define WMid(a)			_PAR_WMid   , (CadObjektIdentifizierung *)(a)
#define WMna(a)			_PAR_WMna   , (char *)(a)
#define X(a)			_PAR_X      , (double)(a)
#define Y(a)			_PAR_Y      , (double)(a)
#define ZA(a)			_PAR_ZA     , (double)(a)
#define ZAHL(a)			_PAR_ZAH    , (double)(a)
#define ZAHLstr(a)		_PAR_ZAHstr , (char *)(a)
#define ZB(a)			_PAR_ZB     , (double)(a)


typedef enum {
  IdPunkt ,
  IdExistPunkt ,
  IdGerade ,
  IdKreis ,
  IdLinienzug ,
  IdFlaeche ,
  IdText ,
  IdFormelement ,
  IdTeil ,
  IdGruppe ,
  IdEinzelheit ,
  IdZeichnungselement ,
  IdSilhouette ,
  IdSchraffur ,
  IdLaengenmass ,
  IdWinkelmass ,
  IdDurchmass ,
  IdRadiusmass ,
  IdKettenmass ,
  IdKettenmassEle ,
  IdSteigendesMass ,
  IdSteigendesMassEle
} IdentCode;

typedef enum {
  typUnbekannt ,
  typIdentifizierung ,
  typKoordinaten3D ,
  typInteger ,
  typDouble ,
  typString ,
  typListe
} ListenElementTyp;

typedef enum {
  AntwortJa ,
  AntwortNein ,
  AntwortUser
} TypFuerAntwort;

typedef struct _ListenElement *ElementZeiger;

typedef struct {
  ElementZeiger First;
  ElementZeiger Last;
  int           Laenge;
} UnivListe;

typedef struct _ListenElement {
  struct _ListenElement *Prev;
  struct _ListenElement *Next;
  ListenElementTyp      Typ;
  union {
    CadObjektIdentifizierung ident;
    Koordinaten3D            koord;
    int                      wert;
    double                   zahl;
    char                     *string;
    UnivListe                liste;
  } Element;
} ListenElement;

typedef struct {
  int typ;
  int allokiert;
  union {
    Koordinaten3D            *koord;
    CadObjektIdentifizierung *ident;
    char                     *string;
    double                   zahl;
    int                      wert;
    UnivListe                *liste;
  } u;
} Element;

typedef struct {
  CadObjektIdentifizierung Id;
  CadObjektIdentifizierung Anfangspunkt;
  CadObjektIdentifizierung Endpunkt;
  Farbe                    Fa;
  Linienart                La;
  Linienbreite             Lb;
} EndlicheGerade;

typedef struct {
  CadObjektIdentifizierung Id;
  CadObjektIdentifizierung Stuetzpunkt;
  CadObjektIdentifizierung Richtungsvektor;
  Farbe                    Fa;
  Linienart                La;
  Linienbreite             Lb;
} UnendlicheGerade;

typedef struct {
  CadObjektIdentifizierung Id;
  CadObjektIdentifizierung Anfangspunkt;
  CadObjektIdentifizierung Richtungsvektor;
  Farbe                    Fa;
  Linienart                La;
  Linienbreite             Lb;
} EinsUnendlicheGerade;

typedef struct {
  CadObjektTyp typ;
  union {
    EndlicheGerade       EG;
    EinsUnendlicheGerade SG;
    UnendlicheGerade     UG;
  } u;
} Gerade;

typedef struct {
  CadObjektIdentifizierung Id;
  Koordinaten3D            Koordinaten;
} KartesischerVektor;

typedef struct {
  CadObjektIdentifizierung Id;
  Koordinaten3D            Koordinaten;
  Farbe                    Fa;
  ArtGrafDarstellungPunkt  Pda;
} KartesischerPunkt;

typedef struct {
  CadObjektIdentifizierung Id;
  CadObjektIdentifizierung Mittelpunkt;
  double                   Radius;
  Farbe                    Fa;
  Linienart                La;
  Linienbreite             Lb;
} Vollkreis;

typedef struct {
  CadObjektIdentifizierung Id;
  CadObjektIdentifizierung Mittelpunkt;
  CadObjektIdentifizierung Anfangspunkt;
  CadObjektIdentifizierung Endpunkt;
  double                   Radius;
  Farbe                    Fa;
  Linienart                La;
  Linienbreite             Lb;
} Kreisbogen;

typedef struct {
  CadObjektTyp typ;
  union {
    Vollkreis  KR;
    Kreisbogen KB;
  } u;
} Kreis;

typedef struct {
  CadObjektIdentifizierung Id;
  UnivListe                Elemente;
} Gruppe;

typedef struct {
  Beziehungsart            Art;
  CadObjektIdentifizierung Owner;
  UnivListe                Member;
} CadBeziehung;

typedef struct {
  CadObjektIdentifizierung Id;
  char                     *Name;
} Name;

typedef struct {
  CadObjektIdentifizierung Id;
  UnivListe                Elemente;
} Flaeche;

#if BRAUCHE_PROTOTYPEN
typedef enum { 
  ErsteVariablenart ,
  vZahl ,
  vText ,
  vFormel ,
  vKoordinaten3D ,
  LetzteVariablenart
} Variablenart;

typedef enum { 
  ErsteFormelart ,
  fZahl ,
  fText ,
  fKoordinaten3D ,
  LetzteFormelart
} Formelart;
#endif

typedef struct {
  CadObjektIdentifizierung Id;
  Formelart                Art;
  UnivListe                TeilUndPara;
  UnivListe                ParaTypen;
} Funktion;

#if BRAUCHE_PROTOTYPEN
typedef struct {
  char      *dummy;
  Formelart Art;
  union {
    double        ErgZahl;
    Koordinaten3D ErgKoord3D;
    char          *ErgText;
  } u;
} TypFormel;

typedef struct {
  Variablenart Art;
  union {
    double        wZahl;
    char          *wText;
    TypFormel     wFormel;
    Koordinaten3D wKoord3D;
  } u;
} Variablenwert;
#endif

typedef struct {
  CadObjektIdentifizierung Id;
  char                     *dummy;
  Variablenwert            Wert;
} Variable;

typedef struct {
  CadObjektIdentifizierung Id;
  UnivListe                Elemente;
  UnivListe                Orientierung;
} Linienzug;

typedef struct {
  CadObjektIdentifizierung Id;
  UnivListe                Elemente;
  double                   ZEbene;
} Silhouette;

typedef struct _TextZeile {
  char              *Text;
  Koordinaten3D     Bezugspunkt;
  double            Winkel;
  Koordinaten3D     BiegeMittelpunkt;
  Boolean           BiegeUmlaufsinn;
  struct _TextZeile *Naechste;
} TextZeile;

typedef struct {
  CadObjektIdentifizierung Id;
  CadObjektIdentifizierung TextBiegeMittelpunkt;
  CadObjektIdentifizierung Bezugspunkt;
  double                   TextWinkel;
  Farbe                    Fa;
  Linienbreite             Lb;
  char                     *Fontname;
  char                     *Dateiname;
  int                      TextFormat;
  double                   TextHoehe;
  double                   TextNeigung;
  double                   Zeichenbreite;
  double                   Zeichenabstand;
  double                   Wortabstand;
  double                   Zeilenabstand;
  double                   ZeilenabstandUnterOberLaenge;
  int                      Zeilenanzahl;
  TextZeile                TextZeilen;
} Text;

typedef struct {
  CadObjektIdentifizierung Id;
  CadObjektIdentifizierung Flaeche;
  CadObjektIdentifizierung Koerperkante;
  Koordinaten3D            Startpunkt;
  char                     *Muster;
  double                   Winkel;
  double                   Abstand;
  Farbe                    Fa;
} Schraffur;

typedef struct {
  CadObjektIdentifizierung Id;
  UnivListe                Geometrie;
  char                     *Sachnummer;
} Formelement;

typedef struct {
  int dummy;
} Laengenmass;

typedef struct {
  int dummy;
} Radiusmass;

typedef struct {
  int dummy;
} Durchmass;

typedef struct {
  int dummy;
} Winkelmass;

typedef struct {
  int dummy;
} Kettenmass;

typedef struct {
  int dummy;
} SteigendesMass;

typedef struct {
  int dummy;
} KettenmassEle;

typedef struct {
  int dummy;
} SteigendesMassEle;



int ListeErzeugen (
  UnivListe *p
);

int ListeLoeschen (
  UnivListe *p
);

UnivListe ListeKopieren (
  UnivListe *p
);

int ListeErweitern (
  UnivListe        *p ,
  ListenElementTyp typ ,
  void             *ele
);

int ListenElementEinfuegen (
  UnivListe        *p ,
  ListenElementTyp typ ,
  void             *ele ,
  int              pos
);

int ListenElementErsetzen (
  UnivListe        *p ,
  ListenElementTyp typ ,
  void             *ele ,
  int              pos
);

int ListenElementLoeschen (
  UnivListe *p ,
  int       pos
);

int ListenElementLesen (
  UnivListe        *p ,
  int              pos ,
  ListenElementTyp typ ,
  void             *ele
);

int ListenElemente (
  UnivListe *p
);

int ErzeugteElemente (
  void
);

void HoleErzeugtesElement (
  int                      nr ,
  CadObjektIdentifizierung *id
);

void HoleAlleErzeugtenElemente (
  UnivListe *elemente
);

Element *ErzeugeTempElement (
  ListenElementTyp typ ,
  void             *p
);

Element *ErzeugeTempXYElement (
  double x ,
  double y ,
  double z
);

int ErzeugePunktKar (
  Koordinaten3D            *ko ,
  int                      fa ,
  int                      pda ,
  CadObjektIdentifizierung *p
);

int ErzeugeGeradeEndlich (
  Element                  *ap ,
  Element                  *ep ,
  int                      fa ,
  int                      la ,
  int                      lb ,
  CadObjektIdentifizierung *ge
);

int ErzeugeGeradeUnendlich (
  Element                  *sp ,
  CadObjektIdentifizierung *vek ,
  int                      fa ,
  int                      la ,
  int                      lb ,
  CadObjektIdentifizierung *ge
);

int ErzeugeGeradeEinsUnendlich (
  Element                  *ap ,
  CadObjektIdentifizierung *vek ,
  int                      fa ,
  int                      la ,
  int                      lb , 
  CadObjektIdentifizierung *ge
);

int ErzeugeVektor (
  Element                  *p ,
  CadObjektIdentifizierung *vek
);

int ErzeugeKreisVoll (
  Element                  *mp ,
  double                   rad ,
  int                      fa ,
  int                      la ,
  int                      lb ,
  CadObjektIdentifizierung *kr
);

int ErzeugeKreisBogen (
  Element                  *mp ,
  Element                  *ap ,
  Element                  *ep ,
  double                   rad ,
  int                      fa ,
  int                      la ,
  int                      lb ,
  CadObjektIdentifizierung *kr
);

int PunktFuerKreisbogen (
  Koordinaten3D *mp ,
  double        wi ,
  double        rad ,
  Koordinaten3D *p
);

int ErzeugeVariableZahl (
  double                   wert ,
  CadObjektIdentifizierung *var
);

int ErzeugeVariableText (
  char                     *str ,
  CadObjektIdentifizierung *var
);

int ErzeugeVariableKoord (
  Koordinaten3D            *ko ,
  CadObjektIdentifizierung *var
);

int ErzeugeVariableFormel (
  Formelart                formart ,
  char                     *str ,
  CadObjektIdentifizierung *var
);

int LoescheCadObjekt (
  CadObjektIdentifizierung *id
);

int ErzeugeGruppeAus (
  UnivListe                *p ,
  CadObjektIdentifizierung *gr
);

int VergebeNamen (
  CadObjektIdentifizierung *id ,
  CadObjektIdentifizierung *na
);

int ErzeugeName (
  char                     *name ,
  CadObjektIdentifizierung *na
);

int ErzeugeUndVergebeNamen (
  char                     *name ,
  CadObjektIdentifizierung *obj
);

int SchalteKnwSicherungEin (
  void
);

int SchalteKnwSicherungAus (
  void
);

int SchalteFehlermeldungenEin (
  void
);

int SchalteFehlermeldungenAus (
  void
);

int CompilerSperren (
  void
);

int CompilerFreigeben (
  void
);

int CadObjektIdReserviertDarstellen (
  CadObjektIdentifizierung *id
);

int CadObjektIdOriginalDarstellen (
  CadObjektIdentifizierung *id
);

int LeseBeziehung (
  Beziehungsart            art ,
  CadObjektIdentifizierung *owner ,
  CadBeziehung             *bez
);

int LeseCadObjekt (
  Element *ele ,
  void    *obj
);

int StartSeqLesen (
  int typ
);

int LeseSeq (
  int  typ ,
  int  *ende ,
  void *p
);


#if BRAUCHE_PROTOTYPEN

#define StarteProschni(a,b) if ( 0 != InitProschni ( a , b , 0 ) ) exit ( 1 );

#if defined(_XtIntrinsic_h)
#  define XtAppMainLoop(a) StarteXApplikation(); XtAppMainLoop(a)
#  define XtMainLoop()     StarteXApplikation(); XtMainLoop()
#endif


CadObjektTyp TypCadObjektId (
  CadObjektIdentifizierung *id
);

void ErsetzeTypCadObjektId (
  CadObjektIdentifizierung *id ,
  CadObjektTyp             typ
);

TypDatenbasisNummer DBCadObjektId (
  CadObjektIdentifizierung *id
);

void ErsetzeDBCadObjektId (
  CadObjektIdentifizierung *id ,
  TypDatenbasisNummer      db
);

int FehlerText (
  int  fehlernr ,
  char **text
);

int BefehlFehlerText (
  char **text ,
  int  *position
);

int InitProschni (
  int    *argc ,
  char   **argv ,
  double dummy
);

void ExitProschni (
  void
);

int ErzeugeGerade (
  int kennung ,
  ...
);

int ErzeugePunkt (
  int kennung ,
  ...
);

int ErzeugeKreis (
  int kennung ,
  ...
);

int ErzeugeFlaeche (
  int kennung ,
  ...
);

int ErzeugeSchraffur (
  int kennung ,
  ...
);

int ErzeugeAequidistante (
  int kennung ,
  ...
);

int ErzeugeRundung (
  int kennung ,
  ...
);

int ErzeugeFase (
  int kennung ,
  ...
);

int ErzeugeLinienzug (
  int kennung ,
  ...
);

int ErzeugeText (
  int kennung ,
  ...
);

int ErzeugeTeil (
  int kennung ,
  ...
);

int ErzeugeGruppe (
  int kennung ,
  ...
);

int ErzeugeLaengenmass (
  int kennung ,
  ...
);

int ErzeugeRadiusmass (
  int kennung ,
  ...
);

int ErzeugeDurchmass (
  int kennung ,
  ...
);

int ErzeugeWinkelmass (
  int kennung ,
  ...
);

int ErzeugeKettenmass (
  int kennung ,
  ...
);

int ErzeugeSteigendesmass (
  int kennung ,
  ...
);

int ErzeugeFolie (
  int kennung ,
  ...
);

int ErzeugeOberflaechenzeichen (
  int kennung ,
  ...
);

int ErzeugePositionsnummer (
  int kennung ,
  ...
);

int ErzeugeEinzelheit (
  int kennung ,
  ...
);

int ErzeugeZeichnungselement (
  int kennung ,
  ...
);

int ErzeugeStueckliste (
  int kennung ,
  ...
);

int ErzeugeVariable (
  int kennung ,
  ...
);

int ErzeugeFunktion (
  int kennung ,
  ...
);

int ErzeugeSachmerkmalleiste (
  int kennung ,
  ...
);

int ErzeugeSMLvariante (
  int kennung ,
  ...
);

int ErzeugeVoreinstellung (
  int kennung ,
  ...
);

int ErzeugeMetafile (
  int kennung ,
  ...
);

int DreheObjekt (
  int kennung ,
  ...
);

int SchiebeObjekt (
  int kennung ,
  ...
);

int KopiereObjekt (
  int kennung ,
  ...
);

int AktiviereObjekt (
  int kennung ,
  ...
);

int BlendeObjekt (
  int kennung ,
  ...
);

int ErweitereObjekt (
  int kennung ,
  ...
);

int LoescheObjekt (
  int kennung ,
  ...
);

int DefiniereTeil (
  int kennung ,
  ...
);

int TrimmeObjekt (
  int kennung ,
  ...
);

int ZeigePunkt (
  int kennung ,
  ...
);

int Interpretiere (
  char *datei ,
  ...
);

int LoeseObjekt (
  int kennung ,
  ...
);

int SortiereSMLvariante (
  int kennung ,
  ...
);

int Schalte (
  int kennung ,
  ...
);

int Merke (
  int kennung ,
  ...
);

int Vergesse (
  int kennung ,
  ...
);

int AendereObjekt (
  int kennung ,
  ...
);

int Lade (
  int kennung ,
  ...
);

int Plaziere (
  int kennung ,
  ...
);

int Speichere (
  int kennung ,
  ...
);

int PickeObjekt (
  int                      was ,
  int                      *taste ,
  Koordinaten3D            *ko ,
  CadObjektIdentifizierung *id
);

int PickenAbbruch (
  void
);

int SiscadpBefehl (
  char *befehl
);

int BeantworteSiscadpFrage (
  TypFuerAntwort antwort
);

int BildNeuAufbau (
  void
);

int ZoomGanz (
  int fenster
);

int SetzeFenster (
  int    fenster ,
  double xlu ,
  double ylu ,
  double xro ,
  double yro
);

int RechnerZahl (
  char   *formel ,
  double *ergebnis
);

int RechnerText (
  char *formel ,
  char **ergebnis
);

int RechnerKoord (
  char          *formel ,
  Koordinaten3D *ergebnis
);

int CadObjektExistiert (
  CadObjektIdentifizierung *id
);

void InitCadObjektId (
  CadObjektIdentifizierung *id
);

int LoescheZeichnung (
  void
);

int LeseZeichnungsname (
  char **name
);

int LeseAktivesTeil (
  CadObjektIdentifizierung *teil
);

int LeseOberstesTeil (
  CadObjektIdentifizierung *teil
);

void InitCadObjekt (
  CadObjektTyp typ ,
  void         *p
);

void ReInitCadObjekt (
  CadObjektTyp typ ,
  void         *p
);


#  if defined(_XtIntrinsic_h)

void XApplikationAnmelden (
  Widget       toplevel ,
  XtAppContext appl
);

void StarteXApplikation (
  void
);

#define XtAppAddWorkProc(a,b,c) { ProschniAddWorkProc(b);\
                                  XtAppAddWorkProc(a,b,c); }

#define ReturnFromWorkProc(a,b) { ProschniRemWorkProc(a,b);\
                                  return(a); }

void ProschniAddWorkProc (
  Boolean (*funk)()
);

void ProschniRemWorkProc (
  Boolean ret ,
  Boolean (*funk)()
);

#  endif

#if _p_tks_h_ && defined(SpracheTypenKonstantenSpez)
void InitProschniTyp (
  ProschniTyp *p
);
#endif

#endif

#endif
