#!/bin/sh
#  master_validate.sh from ObjectProDSP 0.1
#  Copyright (C) 1994, Mountain Math Software. All rights reserved.
#  
#  This file is part of ObjectProDSP, a tool for Digital Signal
#  Processing design, development and implementation. It is free
#  software provided you use and distribute it under the terms of
#  version 2 of the GNU General Public License as published
#  by the Free Software Foundation. You may NOT distribute it or
#  works derived from it or code that it generates under ANY
#  OTHER terms.  In particular NONE of the ObjectProDSP system is
#  licensed for use under the GNU General Public LIBRARY License.
#  Mountain Math Software plans to offer a commercial version of
#  ObjectProDSP for a fee. That version will allow redistribution
#  of generated code under standard commercial terms.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of version 2 of the GNU General
#  Public License along with this program. See file COPYING. If not
#  or if you wish information on commercial versions and licensing
#  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
#  USA, or send us e-mail at: support@mtnmath.com.
#  
#  You may also obtain the GNU General Public License by writing the
#  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
#  USA.  However if you received a copy of this program without the
#  file COPYING or without a copyright notice attached to all text
#  files, libraries and executables please inform Mountain Math Software.
#  
#  ObjectProDSP is a trademark of Mountain Math Software.
#  
#  Master validation script

#Ordinarily it is best to use the same base line data for target
# and interactive tests. This saves space and is a better test.
#To make the test independent set the following to a nun null string.
OPD_CREATE_SEPARATE_TARGET_BASE_LINE=
export OPD_CREATE_SEPARATE_TARGET_BASE_LINE

function abort() {
	echo "Validation aborted, error code $1."
	echo "Validation aborted, error code $1." >> $OPD_TESTS
	exit
}

function report_error() {
	# Find all error files in the directory tree starting at $1.
	# Put these in a list file and report how many were found.
	OPD_ERR=$OPDV/list_of_error_files
	find $1 -name 'err_for_*' -newer $OPD_START_TEST_FILE > $OPD_ERR 
	if [ -s $OPD_ERR ] ;then 
		OPD_ERR_COUNT=`awk 'END{print NR}' < $OPD_ERR`
		echo "Error files are:" >> $OPD_TESTS
		awk '{ print NR ". " $0 }' < $OPD_ERR >> $OPD_TESTS
		echo "Found $OPD_ERR_COUNT error files." >> $OPD_TESTS
		echo "See \`$OPD_TESTS' for the list." >> $OPD_TESTS
	else 
		echo "\`$OPD_TESTS' is the test log." >> $OPD_TESTS
		echo "No errors found." >> $OPD_TESTS
	fi
	rm $OPD_ERR
}

function force_to_null () {
	if [ -e  $1  ] ;then OPD_FORCE_TO_NULL_RET=$*
	else OPD_FORCE_TO_NULL_RET= ;fi
}

function generate_test_code() {
	cd $OPDT
	OPD_AR_TYP=$2
	force_to_null $OPDV/make_*_validate.rec
	OPD_GENERATE=$OPD_FORCE_TO_NULL_RET
	force_to_null $OPDV/make_*_validate_$OPD_AR_TYP.rec 
	OPD_GENERATE="$OPD_GENERATE $OPD_FORCE_TO_NULL_RET"
	for i in $OPD_GENERATE ; do
		echo "Creating tests from \`$i' with flags \`$1'"
		echo "Creating tests from \`$i' with flags \`$1'" >> $OPD_TESTS
		if ! $OPD_ROOT/bin/opd -c -a $i $1 ;then abort 4_$i ;fi
		echo "Created tests from \`$i' with flags \`$1'"
		echo "Created tests from \`$i' with flags \`$1'" >> $OPD_TESTS
		rm *.dat
	done
}

function do_all_tests () {
	TEST_TYPE=$1
	if [ -n "$OPD_MASTER_CREATE" ] ;then 
		echo "Creating base line $TEST_TYPE test data."
		echo "Creating base line $TEST_TYPE test data." >> $OPD_TESTS
		if ! $OPDT/interactive_node_master_ValCreate_$TEST_TYPE.sh ;then abort 6 ;fi
		echo "Created interactive $TEST_TYPE node base line data for $OPD_DOING tests." >> $OPD_TESTS
		echo "Created interactive $TEST_TYPE node base line data for $OPD_DOING tests." 
		if [ -n "$OPD_CREATE_SEPARATE_TARGET_BASE_LINE" ] ;then
			if ! $OPDT/target_master_create_$TEST_TYPE.sh ;then abort 5 ;fi
			echo "Created target $TEST_TYPE base line data for $OPD_DOING tests." >> $OPD_TESTS
			echo "Created target $TEST_TYPE base line data for $OPD_DOING tests." 
		fi
	fi

	OPD_TAR_VAL_PARAM="-l $OPD_TESTS"
	export OPD_TAR_VAL_PARAM 

	echo "Starting interactive $TEST_TYPE node compare test."
	echo "Starting interactive $TEST_TYPE node compare test." >> $OPD_TESTS
	if ! $OPDT/interactive_node_master_ValCompare_$TEST_TYPE.sh $OPD_TESTS ;then abort 8 ;fi

	echo "Starting target $TEST_TYPE compare test."
	echo "Starting target $TEST_TYPE compare test." >> $OPD_TESTS
	if ! $OPDT/target_master_compare_$TEST_TYPE.sh $OPD_TESTS ;then abort 7 ;fi

}

OPD_VALIDATE=VALIDATE
OPD_VAL_DATA=VAL_DATA
OPD_RE_VAL=REVALIDATE
OPD_MASTER_CREATE=
export OPD_MASTER_CREATE
OPD_DO_GEN_CODE=yes
case $1 in
$OPD_VALIDATE) ;;
$OPD_VAL_DATA) OPD_MASTER_CREATE=yes ;;
$OPD_RE_VAL) OPD_DO_GEN_CODE= ;;
*)
	echo "Must specify \`$OPD_VALIDATE' to run validation tests"
	echo "\`$OPD_VAL_DATA' to create test data and run tests"
	echo "or \`$OPD_RE_VAL' to rerun tests without creating code."
	echo "The default is to only run floating point test."
	echo "To run both float and 16 bit integer tests"
	echo "set and export \`INCLUDE_INT16=yes'."
	exit ;;
esac

OPDV=$OPD_ROOT/validate
OPD_TESTS=$OPDV/validation_log
OPDT=$OPDV/test_nodes

if [ ! -d $OPDT ] ; then if !  mkdir $OPDT ;then abort a1 ;fi ;fi
if [ ! -d $OPDT/float ] ; then if !  mkdir $OPDT/float ;then abort a1 ;fi ;fi
if [ ! -d $OPDT/int16 ] ; then if !  mkdir $OPDT/int16 ;then abort a1 ;fi ;fi

echo "Tests started at `date`." > $OPD_TESTS
echo "Tests started at `date`." 
OPD_START_TEST_FILE=$OPD_ROOT/validate/touched_at_start
export OPD_START_TEST_FILE
touch $OPD_START_TEST_FILE
OPD_NEWER_TESTS="-newer $OPD_START_TEST_FILE"

# if not generating code use old shell scripte
if [ -z "$OPD_DO_GEN_CODE" ] ;then OPD_NEWER_TESTS= ;fi
export OPD_NEWER_TESTS

OPD_DATA=$OPDV/test_data

OPD_HAVE_FLOAT=
if [ -x $OPD_FLOAT ] ;then OPD_HAVE_FLOAT=yes ;fi

OPD_INT16=$OPD_ROOT/bin/opd_dsp16_exe
OPD_HAVE_INT16=
if [ -n "$INCLUDE_INT16" ] ;then
	if [ -x $OPD_INT16 ] ;then OPD_HAVE_INT16=yes ;fi
fi

if [ -z "$OPD_HAVE_FLOAT" ] ;then
	if [ -z "$OPD_HAVE_INT16" ] ;then
		echo "There is no floating point ($OPD_FLOAT) simulator"
		echo "and either no 16 bit integer ($OPD_INT16) simulator"
		echo "or INCLUDE_INT16 was not set."
		echo "Cannot run any validation tests."
		exit
	fi
fi

OPD_BASE_LOG=
OPD_DOING=
if [ -n "$OPD_HAVE_FLOAT" ] ;then 
	OPD_DOING="floating point" 
	if [ -n "$OPD_HAVE_INT16" ] ;then
		OPD_DOING="$OPD_DOING and"
		OPD_BASE_LOG=$OPDV/base_log
	else OPD_BASE_LOG=$OPDV/base_float_log ;fi
else OPD_BASE_LOG=$OPDV/base_int16_log ;fi
if [ ! -z "$OPD_HAVE_INT16" ] ;then OPD_DOING="$OPD_DOING 16 bit integer" ;fi


# Check to see if test data exists. exit
if [ -z "$OPD_MASTER_CREATE" ] ;then
	OPD_BASE_DATA_FILE=$OPDT/val_Basic_float/BasicPlt.dat
	if [ ! -e $OPD_BASE_DATA_FILE ] ;then 
		echo "There is no base line test data:"
		echo "\`$OPD_BASE_DATA_FILE'."
		echo "Use the \`VAL_DATA' option to create all base line data for the"
		echo "$OPD_DOING tests. You can then"
		echo "run tests against this created data."
		echo "If you want to verify your installation against known data"
		echo "you need to install the \`test_data' distribution.\n" 
		exit
	fi
fi

echo "Performing $OPD_DOING tests." >> $OPD_TESTS
echo "Performing $OPD_DOING tests." 

OPD_FLOAT=$OPD_ROOT/bin/opd_dsp_exe
echo "Creating ascii input files." >> $OPD_TESTS
echo "Creating ascii input files."
if ! $OPD_ROOT/bin/gen_data ;then abort a2 ;fi

echo "Creating DSP++ code." >> $OPD_TESTS
echo "Creating DSP++ code."
if ! $OPD_ROOT/bin/gen_dpp_code -f $OPD_DATA/io > \
	$OPD_DATA/io_genf.dpp ;then abort aa1 ;fi
if ! $OPD_ROOT/bin/gen_dpp_code -i -f $OPD_DATA/io > \
	$OPD_DATA/io_readf.dpp ;then abort aa2 ;fi

if [ -n "$INCLUDE_INT16" ] ;then
	if ! $OPD_ROOT/bin/gen_dpp_code -f $OPD_DATA/ioi > \
		$OPD_DATA/io_geni.dpp ;then abort ab1 ;fi
	if ! $OPD_ROOT/bin/gen_dpp_code -i -f $OPD_DATA/ioi > \
		$OPD_DATA/io_readi.dpp ;then abort ab2 ;fi
fi

OPD_GEN_CODE=$OPD_DO_GEN_CODE
# Check to see if test files exist already, if not create them
OPD_FLOAT_TAR_SRC=$OPDT/val_Basic_float/compare/nodehds.C
if [ -n "$OPD_HAVE_FLOAT" ] ;then 
	if [ ! -e $OPD_FLOAT_TAR_SRC ] ;then OPD_GEN_CODE=yes 
	elif [ $OPD_FLOAT -nt $OPD_FLOAT_TAR_SRC ] ;then OPD_GEN_CODE=yes ;fi
fi


if [ -n "$OPD_GEN_CODE" ] ;then
	OPD_TEST_TYPE=float
    export OPD_TEST_TYPE
	echo "Removing old float code and executables."
	echo "Removing old float code and executables."  >> $OPD_TESTS
	find $OPDT -name 'val_*_float' -exec \
		$OPD_ROOT/scripts/clear_old_test.sh {} tarflt \;
	echo "Creating \`.dpp' files and target code for floating point tests." 
	echo "Creating \`.dpp' files and target code for floating point tests." >> \
		$OPD_TESTS
	OPD_TEST_TYPE=float
	export OPD_TEST_TYPE
	if ! generate_test_code "" float  ;then abort 2 ;fi
	echo "Created \`.dpp' files and target code for floating point tests." 
	echo "Created \`.dpp' files and target code for floating point tests." >> \
		$OPD_TESTS
fi

OPD_GEN_CODE=
OPD_INT16_TAR_SRC=$OPDT/val_Basic_int16/compare/nodehds.C
if [ -n "$INCLUDE_INT16" ] ;then
	OPD_GEN_CODE=$OPD_DO_GEN_CODE
	if [  -n "$OPD_HAVE_INT16" ] ;then
		if [ ! -e $OPD_INT16_TAR_SRC ] ;then OPD_GEN_CODE=yes
		elif [ $OPD_INT16 -nt $OPD_INT16_TAR_SRC ] ;then OPD_GEN_CODE=yes ;fi
	fi
fi

if [ -n "$OPD_GEN_CODE" ] ;then
	OPD_TEST_TYPE=int16
    export OPD_TEST_TYPE
	echo "Removing old 16 bit integer code and executables."
	echo "Removing old 16 bit integer code and executables."  >> $OPD_TESTS
	find $OPDT -name 'val_*_int16' -exec \
		$OPD_ROOT/scripts/clear_old_test.sh {} tarint \;
	echo "Creating \`.dpp' files and target code for 16 bit integer tests." 
	echo "Creating \`.dpp' files and target code for 16 bit integer tests." >> \
		$OPD_TESTS
	OPD_TEST_TYPE=int16
	export OPD_TEST_TYPE
	if ! generate_test_code "-i" int16 ;then abort 3 ;fi
	echo "Created \`.dpp' files and target code for 16 bit integer tests." 
	echo "Created \`.dpp' files and target code for 16 bit integer tests." >> \
		$OPD_TESTS
fi

OPD_TEST_TYPE=.
export OPD_TEST_TYPE

if [ -n "$OPD_HAVE_FLOAT" ] ;then
	cd $OPDT
	echo "Building master float scripts in \`$OPDT'." >> $OPD_TESTS
	echo "Building master float scripts in \`$OPDT'."
	if ! $OPD_ROOT/scripts/gen_test.sh $OPD_TESTS float ;then abort 4 ;fi
fi

if [ -n "$OPD_HAVE_INT16" ] ;then
	cd $OPDT
	echo "Building master int16 scripts in \`$OPDT'." >> $OPD_TESTS
	echo "Building master int16 scripts in \`$OPDT'."
	if ! $OPD_ROOT/scripts/gen_test.sh $OPD_TESTS int16 ;then abort 4 ;fi
fi

if [ -n "$OPD_HAVE_FLOAT" ] ;then do_all_tests float ;fi

if [ -n "$OPD_HAVE_INT16" ] ;then do_all_tests int16 ;fi

echo "Doing \`compare_byte_of_selected_files' in \`$OPD_ROOT/scripts/master_validate.sh'."
echo "Doing \`compare_byte_of_selected_files' in \`$OPD_ROOT/scripts/master_validate.sh'." \
	>> $OPD_TESTS

find $OPD_ROOT/validate/test_nodes -name '*.cmp' \
	-newer $OPD_START_TEST_FILE \
	-exec $OPD_ROOT/scripts/do_cmp_test.sh {} $OPD_TESTS $OPD_MASTER_CREATE \;

echo "Did \`compare_byte_of_selected_files' in \`$OPD_ROOT/scripts/master_validate.sh'."
echo "Did \`compare_byte_of_selected_files'."  >> $OPD_TESTS

echo "Tests completed at `date`." >> $OPD_TESTS
echo "Tests completed at `date`." 
if ! $OPD_ROOT/bin/report_test -l $OPD_TESTS \
	$OPD_ROOT/validate/make_*_validate*.rec ;then abort report ;fi
echo  >> $OPD_TESTS
report_error $OPDT
if [ -e $OPD_BASE_LOG ] ;then 
	if ! $OPD_ROOT/bin/cmp_val_log $OPD_TESTS $OPD_BASE_LOG ;then
		echo "WARNING: problem executing $OPD_ROOT/bin/cmp_val_log"
		echo "to compare test log with base test log."
		echo "Cannot verify that a complete set of tests were run."
	fi
else echo "WARNING: There is no base log file \`$OPD_BASE_LOG'."
	echo "Cannot verify that a complete set of tests were run."
fi
cat $OPD_TESTS

