/*
 *  dspsig.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include "sysintfc.h"
#include "shared.h"
#include "cgidbg.h"
#include "syssig.h"
#include "ques.h"
#include "dsp.h"
#include "dspsig.h"
#include "yacintfc.h"


static void SigTerminate(int)
{
	ExitCleanUp();
	exit(1);
}

static int Sleeping = 0 ;

const TheSleepOfTheDead = 60000 ;

static int ResumeSleep ;

static void DumpState()
{
/*
 *	LogOut << "Sleeping = " << Sleeping << ", ResumeSleep = " <<
 *		ResumeSleep << "\n" ;
 *	LogOut << "IsBusy = " << DspExecState->IsBusy() << "\n" ;
 */
}
// NO IO IN SIGNAL PROCESSING

static void SigQuiet(int)
{
	SetDspSignals();
	// LogOut << "SigQuiet signal\n" ;
	// DumpState();
	if (Sleeping) {
		Sleeping = 0 ;
		return ;
	}
	ResumeSleep = 1 ;
	while (ResumeSleep) {
		ResumeSleep = 0 ;
		Sleeping = 1 ;
		sleep (TheSleepOfTheDead);
	}
}


static void SigAbortExecution(int)
{
	SetDspSignals();
	// LogOut << "SigAbort signal\n" ;
	// DumpState();
	if (DspExecState->IsBusy()) State.Error("user termination");
	if (Sleeping) ResumeSleep= 1;
}

extern void linux_core_dump();

static void SigHandle(int Signal)
{
	if (Signal ==2) {
		TheLog << "Signal 2 caught. Exiting.\n" ;
		ExitOneWayOrAnother();
	}
	TheLog << "Signal " << Signal << " caught, forcing core dump.\n" ;
#ifdef __linux__
    linux_core_dump();
#else
	kill(getpid(),3);
#endif
	ExitOneWayOrAnother();
}


void SetDspSignals()
{
	SetCatchSignals(SigHandle,SigTerminate,SigAbortExecution,SigQuiet);
}

