/*
 *  rlfir.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <complex.h>
#include <math.h>
#include "ObjProDSP/portable.h"
#include "ObjProGen/newaloc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSPcom/dspconst.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProArithGen/arthfnc.h"
#include "ObjProDSPcom/firc.h"
#include "ObjProDSPcom/rlfirk.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/rlfir.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * RealFirNodeList = 0 ;
static InteractiveEntity * IntEntRealFir ;
void RealFirNodesInit();
RealFir::RealFir (const char * Name, int16 Resample, int16 ZeroPad, int16 Odd, 
		MachWord * Coeff, int32 Coeff_Length):
	ProcessNode(Name, 1, 1, 1, 0, DeltaIn(Resample , ZeroPad), 
	DeltaOut(Resample , ZeroPad), 
	(1 + ((Coeff_Length << 1) - Odd - Resample - 1) / (ZeroPad ? ZeroPad : 1)), 0, 0, 0, TimingTypeLinear, 
	(ArithType::ArithCapabilities)ArithType::ArithTypeUndefined, (ArithType::ArithCapabilities)ArithType::ArithTypeUndefined)
,
	Resample_1(Resample),
	ZeroPad_2(ZeroPad),
	Odd_3(Odd),
	Coeff_4(Coeff),
	Coeff_Length_5(Coeff_Length)
{
	if (!RealFirNodeList) RealFirNodesInit() ;
	RealFirNodeList->Append(MakeDeclaredEntity(this, IntEntRealFir)) ;
	InitArithType(TheArithType);
	NewMenuItem("RealFir",GetName());
#line 104 "../rlfir.usr"
 
	int FilterLength = (GetCoeff_Length() << 1) - Odd ;
	TheFilter = new RealFilter(FilterLength,GetResample(),
		GetZeroPad(),GetCoeff(), this);
#line 57 "../rlfir.C"
} // end constructor

RealFir::~RealFir()
{
	TheMenuServer->DeleteMenuItem("RealFir",GetName());
	RealFirNodeList->Delete(GetName()) ;
#line 115 "../rlfir.usr"
 
	delete TheFilter ;
	TheFilter = 0 ;
#line 68 "../rlfir.C"
} // end destructor

int RealFir::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

RealFir * RealFirDef;

ErrCode RealFir::DoNode(int32 k)
{
#line 136 "../rlfir.usr"
 
	TheFilter->ExecuteKernel(k);
	return OK ;
#line 86 "../rlfir.C"
} // end kernel code

static UserEntity * MakeRealFir(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int RealFir::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntRealFir->CppList(Out,Cmd,this);
}

void RealFir::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeRealFir(Out,EntityReqDescribeFull,*IntEntRealFir,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("Resample");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetResample()));
		Out.NextFillOut(")");
		Out.NextFillOut("specifies the filter resampling factor.");
		Out.NextFillOut("This is the ratio of the input sampling rate to the");
		Out.NextFillOut("output sampling rate.");
		Out.NextQuoteOut("ZeroPad");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetZeroPad()));
		Out.NextFillOut(")");
		Out.NextFillOut("specifies the number of 0's that are");
		Out.NextFillOut("added after each input sample.");
		Out.NextQuoteOut("Odd");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetOdd()));
		Out.NextFillOut(")");
		Out.NextFillOut("determines if the filter is if odd (");
		Out.NextQuoteOut("Odd");
		Out.NextFillOutConcat("=1)");
		Out.NextFillOut("or even (");
		Out.NextQuoteOut("Odd");
		Out.NextFillOutConcat("=0).");
		Out.NextQuoteOut("Coeff");
		Out.NextFillOut("is the list of filter coefficients. The filter is");
		Out.NextFillOut("symmetric and only half (or half plus one");
		Out.NextFillOut("for odd length filters) are specified. The first");
		Out.NextFillOut("in the list is the first coefficient of the filter.");
		Out.NextFillOut("The middle coefficient is at the end of the list.");
		Out.NextFillOut("The default values for the coefficients define a low pass");
		Out.NextFillOut("FIR filter with a pass band of .125 times the total bandwidth");
		Out.NextFillOut("and transition band of .375 times the bandwidth. The");
		Out.NextFillOut("pass band is extremely flat and the stop band is down over");
		Out.NextFillOut("100 db. This is an overdesigned filter for most practical");
		Out.NextFillOut("applications but it provides a good test case. The performance");
		Out.NextFillOut("will be degraded by 16 bit integer arithmetic.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntRealFir->GetOneParameter("Resample")->
			IntP->CurrentValue = Resample_1;
		IntEntRealFir->GetOneParameter("ZeroPad")->
			IntP->CurrentValue = ZeroPad_2;
		IntEntRealFir->GetOneParameter("Odd")->
			IntP->CurrentValue = Odd_3;
		IntEntRealFir->GetOneParameter("Coeff")->
			ArrayP->CurrentValue = 
		(new ArrayData)->SetArrayData(Coeff_Length_5, DecMachWord, Coeff_4);
		break;
	}
} // end  list entity switch

MachWordType TheDataForRealFirCoeffDefaultArray[] = {

		( CastMachWord ) NormToHardLimitMachWord (1.00018552e-04), 
		( CastMachWord ) NormToHardLimitMachWord (3.70747893e-04), 
		( CastMachWord ) NormToHardLimitMachWord (4.46594395e-04), 
		( CastMachWord ) NormToHardLimitMachWord (-5.36969535e-04), 
		( CastMachWord ) NormToHardLimitMachWord (-2.67492760e-03), 
		( CastMachWord ) NormToHardLimitMachWord (-3.52687595e-03), 
		( CastMachWord ) NormToHardLimitMachWord (8.25715193e-04), 
		( CastMachWord ) NormToHardLimitMachWord (1.01494638e-02), 
		( CastMachWord ) NormToHardLimitMachWord (1.50874056e-02), 
		( CastMachWord ) NormToHardLimitMachWord (2.48008436e-03), 
		( CastMachWord ) NormToHardLimitMachWord (-2.76876913e-02), 
		( CastMachWord ) NormToHardLimitMachWord (-4.93498540e-02), 
		( CastMachWord ) NormToHardLimitMachWord (-2.20594765e-02), 
		( CastMachWord ) NormToHardLimitMachWord (7.30790837e-02), 
		( CastMachWord ) NormToHardLimitMachWord (2.04010323e-01), 
		( CastMachWord ) NormToHardLimitMachWord (2.99286359e-01)
	};

	static ArrayData RealFirCoeffDefaultArray = { 16, DecMachWord,
		(void *) TheDataForRealFirCoeffDefaultArray};

void RealFirNodesInit()
{
	if (RealFirNodeList)  return ;

	static StringParam RealFirNameParam =
		{"RealFir", MakeNewEntityName, 0, LegalEntityName};
	static IntParam RealFirResampleParam = {
		 1, 0,  0,  1, 0, 32767};
	static IntParam RealFirZeroPadParam = {
		 0, 0,  0,  0, 0, 32767};
	static IntParam RealFirOddParam = {
		 0, 0,  0,  0,  0,  1};
	static  CastMachWord RealFirCoeffLowerArrayBound =
		{( CastMachWord ) NormToHardLimitMachWord (-1000)} ;

	static  CastMachWord RealFirCoeffUpperArrayBound =
		{( CastMachWord ) NormToHardLimitMachWord (1000)} ;

	static ArrayParam RealFirCoeffParam = {
		DecMachWord, &RealFirCoeffDefaultArray,
		0, 0, (void *) &RealFirCoeffLowerArrayBound, 0,
		(void *) &RealFirCoeffUpperArrayBound, 3, 1024};

	static OneParameter RealFirParArray[] = {
		{"Name", 0, "node name", 0, 0, &RealFirNameParam},
		{"Resample", 0, 
			"filter resampling factor (input rate/output rate)",
			&RealFirResampleParam},
		{"ZeroPad", 0, 
			"zero padding of input",
			&RealFirZeroPadParam, 0, 0, 0, 0, 1},
		{"Odd", 0, 
			"if set the filter length is odd",
			&RealFirOddParam, 0, 0, 0, 0, 1},
		{"Coeff", 0, 
			"list of unique coefficients",
			0, 0, 0, 0,
			&RealFirCoeffParam, 1},

		{0}
	};

	RealFirNodeList = new EntityList;
	IntEntRealFir = new InteractiveEntity("RealFir", RealFirNodeList,
		MakeRealFir, InteractiveNode, "rlfir.h",
		0, "ProcessNode");
	IntEntRealFir->SetParameters(new UserParameters(RealFirParArray));
	TheNodes->Append(IntEntRealFir);
} // end initalization

static UserEntity * MakeRealFir(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("RealFir");
		Out.NextFillOut("implements a symmetric FIR filter.");
		Out.NextFillOut("Input samples can have");
		Out.NextQuoteOut("ZeroPad");
		Out.NextFillOut("0's interpolated");
		Out.NextFillOut("between them. Output sample can be generated for every");
		Out.NextQuoteOut("Resample");
		Out.NextFillOut("input (or zero pad) sample. The");
		Out.NextQuoteOut("Coeff");
		Out.NextFillOut("array contains half of");
		Out.NextFillOut("the symmetric coefficients.");
		Out.NextQuoteOut("Odd");
		Out.NextFillOut("indicates if there are an even(0) or");
		Out.NextFillOut("odd(1) total number of coefficients.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		int16 Resample =
			IntNode.GetIntParameterValue("Resample");
		int16 ZeroPad =
			IntNode.GetIntParameterValue("ZeroPad");
		int16 Odd =
			IntNode.GetIntParameterValue("Odd");
		MachWord * Coeff =
			(MachWord *  ) IntNode.GetArrayParameterValue("Coeff");
		int32 Coeff_Length =
			IntNode.GetLengthArrayParameterValue("Coeff");
		return new RealFir(Name, Resample, ZeroPad, Odd, Coeff, Coeff_Length);

	}
	}
	return 0;
}

static InitObj LocalInit(RealFirNodesInit, "RealFir", "ProcessNode");

