/*
 *  readflt.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <fcntl.h>
#include <libc.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProGen/mkstr.h"
#include "ObjProGen/environ.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/readflt.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * ReadFloatNodeList = 0 ;
static InteractiveEntity * IntEntReadFloat ;
void ReadFloatNodesInit();
ReadFloat::ReadFloat (const char * Name, const char * FileName):
	Signal(Name, 1, 1, 1, 1, TimingTypeLinear, 
	(ArithType::ArithCapabilities)ArithType::ArithTypeUndefined)
,
	FileName_1(FileName)
{
	if (!ReadFloatNodeList) ReadFloatNodesInit() ;
	ReadFloatNodeList->Append(MakeDeclaredEntity(this, IntEntReadFloat)) ;
	InitArithType(TheArithType);
	NewMenuItem("ReadFloat",GetName());
#line 47 "../readflt.usr"
 
	ctor();
#line 48 "../readflt.C"
} // end constructor

ReadFloat::~ReadFloat()
{
	TheMenuServer->DeleteMenuItem("ReadFloat",GetName());
	ReadFloatNodeList->Delete(GetName()) ;
#line 51 "../readflt.usr"
 
	dtor();
#line 58 "../readflt.C"
} // end destructor

int ReadFloat::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

ReadFloat * ReadFloatDef;

ErrCode ReadFloat::DoNode(int32 k)
{
#line 68 "../readflt.usr"
 
	return kernel(k);
#line 75 "../readflt.C"
} // end kernel code

static UserEntity * MakeReadFloat(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int ReadFloat::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntReadFloat->CppList(Out,Cmd,this);
}

void ReadFloat::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeReadFloat(Out,EntityReqDescribeFull,*IntEntReadFloat,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("specifies the disk file");
		Out.NextFillOut("to be read. If no name is specified the node name will be used.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntReadFloat->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		break;
	}
} // end  list entity switch

void ReadFloatNodesInit()
{
	if (ReadFloatNodeList)  return ;

	static StringParam ReadFloatNameParam =
		{"ReadFloat", MakeNewEntityName, 0, LegalEntityName};
	static StringParam ReadFloatFileNameParam = {
		 0, 0, 0};

	static OneParameter ReadFloatParArray[] = {
		{"Name", 0, "node name", 0, 0, &ReadFloatNameParam},
		{"FileName", 0, 
			"ascii file to read",
			0, 0, &ReadFloatFileNameParam},
		{0}
	};

	ReadFloatNodeList = new EntityList;
	IntEntReadFloat = new InteractiveEntity("ReadFloat", ReadFloatNodeList,
		MakeReadFloat, InteractiveNode, "readflt.h",
		0, "Signal");
	IntEntReadFloat->SetParameters(new UserParameters(ReadFloatParArray));
	TheNodes->Append(IntEntReadFloat);
} // end initalization

static UserEntity * MakeReadFloat(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("ReadFloat");
		Out.NextFillOut("reads a file of floating point ascii formatted values");
		Out.NextFillOut("and writes them to a data stream of type `MachWord'.");
		Out.NextFillOut("You can have as many values as you want on each line but there");
		Out.NextFillOut("can only be white space as defined in the");
		Out.NextFillOut("C++ input stream functions between numbers.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		return new ReadFloat(Name, FileName);

	}
	}
	return 0;
}

static InitObj LocalInit(ReadFloatNodesInit, "ReadFloat", "Signal");

