/*
 *  dskchnhd.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include <Integer.h>
#include "tarnod.h"
#include "dskchnhd.h"
#include "timing.h"
#include "strmstr.h"
#include "newaloc.h"
#include "cgidbg.h"

#define SET(Param) Param = C30.Param
#define SET_T(Param) Param = (TimingType) C30.Param

NodeOutChannelHeader::NodeOutChannelHeader(C30NodeOutChannelHeader& C30)
{
		SET(NumeratorSampling);
		SET(DenominatorSampling);
		SET_FLOAT(SampleRate);
		SET_T(TheTimingType);
		SET_FLOAT(FirstSample);
		SET_FLOAT(ErrorTolerance);
		SET_FLOAT(DeltaTimeBase);
		SET(ElementSize);
		SET(BlockSize);
		SET_FLOAT(MinimumX);
		SET_FLOAT(MaximumX);
		SET_FLOAT(SampleRateFactor);
}
#undef SET
#undef SET_T
#undef SET_FLOAT


#ifdef TI_C30
// uint32 SetFloatTemp ;
#endif 

#ifndef NO_USR_MSGS
void NodeOutChannelHeader::CheckTiming(int16 Flags)
{
	if (Flags & 4) {
		// LogOut << "CheckTiming(" << Flags << ")\n" ;
		SampleRateFactor = 1. ;
		NumeratorSampling = DenominatorSampling = 1 ;
		FirstSample = 0.0 ;
	}
	int Warn = 0 ;
	if (SampleRateFactor < 1.e-50) {
		Warn |= 1 ;
		SampleRateFactor = 1 ;
	}
	if (NumeratorSampling < 1.e-50) {
		NumeratorSampling = 1 ;
		Warn |= 2 ;
	}
	if (DenominatorSampling < 1.e-50) {
		DenominatorSampling = 1 ;
		Warn |= 4 ;
	}
	if (SampleRate < 1.e-50) Warn |= 8 ;
	if (Warn > 1) SampleRate = ((double) NumeratorSampling) /
		DenominatorSampling ;
	// if (Warn) LogOut << "Bad timing header, Warn = " << Warn << "\n" ;
}
#endif

#ifdef INTERACTIVE
NodeOutChannelHeader::NodeOutChannelHeader(const TimingDescription& TheTiming,
	const StreamStr& TheStream)
{

#define GET(A) A = TheTiming.A
	GET(NumeratorSampling) ;
	GET(DenominatorSampling) ;
	GET(SampleRate) ;
	GET(TheTimingType) ;
	GET(FirstSample) ;
	GET(ErrorTolerance) ;
	GET(DeltaTimeBase) ;
#undef GET

	ElementSize = TheStream.GetElementSize() ;
	BlockSize = TheStream.GetBlockSize() ;
	MinimumX = TheStream.GetMinimumX() ;
	MaximumX = TheStream.GetMaximumX() ;
	SampleRateFactor = TheStream.GetSampleRateFactor() ;

}
#else
NodeOutChannelHeader::NodeOutChannelHeader(class TargetNode& TheNode,
	int Channel)
{
	ElementSize = TheNode.GetInEltSize(Channel) ;
	BlockSize = TheNode.GetBlockSize(Channel) ;
	NumeratorSampling = 1 ;
	DenominatorSampling = TheNode.GetIncrementIn(Channel);
	SampleRate = 1. / DenominatorSampling ;
	TheTimingType=  TimingTypeLinear;
	FirstSample = 0.0 ;
	ErrorTolerance = 0.0 ;
	DeltaTimeBase = 0.0 ;

	MinimumX = 0 ;
	MaximumX = 0 ;
	SampleRateFactor = 1 ;
}
#endif

NodeOutChannelHeader::NodeOutChannelHeader()
{
	Clear() ;
}

void NodeOutChannelHeader::SetFromImage(const char * Image)
{
	MoveNBytes((char *) this, Image, sizeof(*this));
} 

void NodeOutChannelHeader::Clear()
{
	NumeratorSampling = 0 ;
	DenominatorSampling = 0 ;
	FirstSample = 0 ;
	ElementSize = 0 ;
}

double NodeOutChannelHeader::GetTimeFirst()
{
	return FirstSample;
}

void NodeOutChannelHeader::Display(OutputType Where)
{
#ifdef INTERACTIVE
	*Output + Where <<
		"The relative sample rate from the generating process was " <<
		NumeratorSampling << "/" << DenominatorSampling << ".\n" ;
	// *Output << "This sample rate is ignored in computing the new network"
	// 	<< " sample rates.\n" ;
	*Output << "The absolute sample rate is " << SampleRate << "\n" ;
	*Output << "This "  << (TheTimingType == TimingTypeLinear?
		"is" : "is not") << " a linearly sampled data stream.\n";
	if (BlockSize>ElementSize) {
		*Output <<
			"This is a two dimensional data stream of block size "
			<< BlockSize << "\n" ;
		if (SampleRateFactor > 0.0) {
			*Output << "The axis of the second dimension is hz.\n";
			*Output << "The labeling of this axis is:\n" ;
			*Output << SampleRateFactor * SampleRate <<
				" hz. per frequency axis sample.\n";
		}
		*Output << "The axis ranges from " <<
			MinimumX * SampleRate << " to " <<
			MaximumX * SampleRate << ".\n" ;
		
	} else {
		if (MinimumX) *Output << "MinimumX = " << MinimumX << "\n" ;
		if (MaximumX) *Output << "MaximumX = " << MaximumX << "\n" ;
	}
	*Output << "SampleRateFactor = " << SampleRateFactor << "\n" ;
	if (ElementSize == 2) *Output << "The data is complex, i. e." <<
		" it has two multiplexed elements in each sample.\n" ;
	if (ElementSize > 2) *Output << "Each sample contains " <<
		ElementSize << " multiplexed elements.\n" ;
	*Output << "The first sample time is " << FirstSample << ".\n" ;
/*
 *	if (!NumberWords) *Output<< "There are no words ";
 *	else if (NumberWords == 1)
 *		*Output << "There is 1 word" ;
 *	else *Output << "There are " << NumberWords << " words" ;
 *	if (ElementSize && NumberWords)
 *			*Output << " (" << NumberWords/ElementSize <<
 *		" samples) " ;
 *	*Output << "in this channel.\n" ;
 */
#endif
}

void NodeOutChannelHeader::Dump(ostream& Out)
{
#ifdef INTERACTIVE
	Out << "Sample rate = " << NumeratorSampling << " / " <<
		DenominatorSampling << ".\n" ;
	Out << "( 0x" << NumeratorSampling << " / 0x" << DenominatorSampling 
		<< " )\n" ;
	int32 * DumpDoubleAsHex = (int32 *) &FirstSample ;
	Out << "Time of first sample = " << FirstSample << " ( 0x" <<
		hex(DumpDoubleAsHex[0]) << ", 0x" <<
		hex(DumpDoubleAsHex[1]) << " )\n" ;
	Out << "ElementSize = " << ElementSize << "( 0x" << hex(ElementSize)
		<< ")\n" ;
/*
 *	Out << "NumberWords = " << NumberWords << "( 0x" <<
 *		hex(NumberWords) << ")\n" ;
 */
#endif
}
		
#ifdef INTERACTIVE
TimingDescription TempTiming ;

TimingDescription * NodeOutChannelHeader::GetInitTiming()
{
/*
 *	for (;;) {
 *		if (NumeratorSampling > 0)
 *			if (DenominatorSampling > 0)
 *				if (SampleRate > 1.e-50) break ;
 *		LogOut <<
 *	"NodeOutChannelHeader::GetInitTiming: Channel Header sampling bad.\n" ;
 *		NumeratorSampling = 1 ;
 *		DenominatorSampling = 1 ;
 *		SampleRate = 1. ;
 *		break ;
 *	}
 */
	TempTiming.Clear();
	TempTiming.NumeratorSampling = NumeratorSampling ;
	TempTiming.DenominatorSampling = DenominatorSampling ;
	TempTiming.FirstSample = FirstSample ;
	return &TempTiming ;
}
#endif
double NodeOutChannelHeader::GetTimingRatio()
{
	return ((double) NumeratorSampling) /
		((double) DenominatorSampling) ;
}

