/*
 *  textfrag.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include <string.h>
#include <ctype.h>
#include <iostream.h>
#include "textfrag.h"
#include "textrans.h"
#include "texspec.h"
#include "outtok.h"
#include "debug.h"
#include "cgidbg.h"

static int DoubleDollarLength(const char * text)
{
	int Count = 0 ;
	for (const char * pt = text ; *pt ; pt++)
	    if (*pt=='$') if (pt[1]=='$') if (pt[2]) if (isalpha(pt[2])) {
		pt += 1 ;
		Count++;
	}
	return Count ;
}

const char * ClearDoubleDollar(const char * text)
{
	if (!text) return text ;
	if (!*text) return text ;
	if (!DoubleDollarLength(text)) return text ;
	char * Return = new char[strlen(text)] ;
	int index = 0 ;
	for (const char * pt = text ; *pt; pt++)  {
	   	if (*pt=='$') if (pt[1]=='$') if (pt[2]) if (isalpha(pt[2])) {
			pt += 2 ;
			while(isalnum(*pt)) pt++;
		}
		if (*pt) Return[index++] = *pt ;
		else break ;
	}
	Return[index] = '\0' ;
	if (index) {
		if (index > strlen(text) - 2) DbgError("ClearDoubleDollar","bad index");
	} else {
		Return[0] = ' ' ;
		Return[1] = '\0' ;
	}
	return Return ;
}

const char * DoubleDollarTranslate(const char * text)
{
	const char * Prefix = "{\\tt " ;
	const char * Index = "}\\index{" ;
	const char * Suffix = "}" ;
	int Count = DoubleDollarLength(text);
	if (!Count) return text ;

	int NewSize = (strlen(text) - 2) * 2 +
		strlen(Prefix) + strlen(Index) + strlen(Suffix)  ;
	char * Return = new char[NewSize+1] ;
	strcpy(Return,Prefix);
	strcat(Return,text+2);
	strcat(Return,Index);
	strcat(Return,text+2);
	strcat(Return,Suffix);
	if (strlen(Return) != NewSize) {
		cerr << "strlen = " << strlen(Return) <<
			", new = " << NewSize << "\n" ;
		DbgError("DoubleDollarTranslate","internal error");
	}
	return Return ;
/*
 *	int NewSize = strlen(text) + Count * (strlen(Prefix)+strlen(Suffix)-2);
 *	
 *	int AddSuffix = 0 ;
 *	char * Return = new char[NewSize+1] ;
 *	int index = 0 ;
 *	for (const char * pt = text ; *pt ; pt++) {
 *	    if (*pt == '$') if (pt[1] == '$') if(pt[2]) if (isalpha(pt[2])) {
 *			pt += 1 ;
 *			AddSuffix = 1 ;
 *			strcpy(Return + index, Prefix);
 *			index += strlen(Prefix);
 *			continue ;
 *		}
 *		if(AddSuffix) if (!isalnum(*pt)) {
 *			strcpy(Return + index,Suffix);
 *			index += strlen(Suffix);
 *			AddSuffix = 0 ;
 *		}
 *		Return[index++] = * pt ;
 *	}
 *	if (AddSuffix) {
 *		strcpy(Return+index,Suffix);
 *		index+= strlen(Suffix);
 *	}
 *	Return[index] = '\0' ;
 *	if (index != NewSize)
 *		DbgError("DoubleDollarTranslate","internal error");
 *	// delete (char *) text ;
 *	LogOut << "DoubleDollarTranslate: `" << Return << "'.\n" ;
 *	return Return ;
 */
}

const char * ReplaceQuote(const char * text)
{
	char * Temp = new char[strlen(text)+1] ;
	int index = 0 ;
	int QuoteOut = 0 ;
	for (const char * pt = text ; *pt ; pt ++) {
		if (QuoteOut) if (!isalnum(*pt)) {
			QuoteOut = 0 ;
			Temp[index++] = '\'' ;
		}
	    	if (*pt=='$') if (pt[1]=='$') if (pt[2]) if (isalpha(pt[2])) {
			Temp[index++] = '`' ;
			pt += 1 ;
			QuoteOut = 1 ;
			continue ;
		}
		Temp[index++] = *pt ;
	}
	if (QuoteOut) Temp[index++] = '\'' ;
	if (index != strlen(text)) DbgError("ReplaceQuote", "bad conut");
	Temp[index] = '\0' ;
	// delete (char *) text ;
	return Temp ;
}
		

TextFragment::TextFragment(int line,const char * text):
	Line(line),
	Text(text),
	TeXText(0),
	SpellText(0)
{
	const char * Check = TheTeXWordTranslator.Translate(text);
	Text = text ;
	if (Check) {
		// LogOut << "Found macro in `" << text << "'\n" ;
		TeXText = text ;
		Text = Check ; // translation of TeX macro(s)
	}
	if (DoubleDollarLength(Text)) {
		if (Check) DbgError("TextFragment::ctor","IMPOSSIBLE");
		TeXText = text ;
		Text = ReplaceQuote(text);
		SpellText = ClearDoubleDollar(text);
	} else SpellText = Text ;
}

TextFragment::~TextFragment()
{
	// delete (void *) Text;
	// delete (void *) TeXText;
}

TextFragmentList::~TextFragmentList()
{
	TextFragment * Frag ;
	while (Frag = Get()) delete Frag;
}


TextFragment * TextFragmentList::GetNthEntry(int N)
{
	TextFragmentListIterator Next(*this);
	TextFragment * Return ;
	int count = 0 ;
	while (Return = Next()) {
		if (count == N) return Return ;
		count++;
	}
	return 0;
}

void TextFragmentList::OutTeXEndDot(OutTokens& Out)
{
	const char * Temp = OutTeX(Out);
	Out.NextConcatCond('.');
}

static int LastLine = 0 ;

const char * TextFragmentList::OutTeX(OutTokens& Out)
{
	TextFragmentListIterator Next(*this);
	TextFragment * Frag ;
	const char * Last = 0 ;
	TranslateToTeX.ClearCheckTail();
	LastLine = 0 ;
	while (Frag = Next()) {
		const char * ToWrite = Frag->TeXText ;
		int UsingTeXLine = ToWrite != 0  ;
		if (!UsingTeXLine) ToWrite = Frag->Text ;
		// LogOut << "Outputting TeXfrag: `" << ToWrite << "'.\n" ;
		ToWrite = TranslateToTeX.DoTeXTranslate(ToWrite) ;
		if (UsingTeXLine) {
			// LogOut<<"TeX trans TeXfrag: `" << ToWrite << "'.\n" ;
			ToWrite = DoubleDollarTranslate(ToWrite);
			// LogOut<<"$$ trans TeXfrag: `" << ToWrite << "'.\n" ;
		}
		int CheckLine = Frag->Line ;
		if (CheckLine != LastLine && !strcmp(" ",ToWrite)) continue;
			
		if (CheckLine < 0) {
			CheckLine = -CheckLine ;
			if (LastLine != CheckLine) Out.NextOut("{\\tt");
			else Out.NextFillOutConcat("{\\tt");
			Out.NextOut(ToWrite);
			Out.NextFillOutConcat("}\\index{");
			Out.NextFillOutConcat(ToWrite);
			Out.NextFillOutConcat("}");
		} else {
			if (CheckLine != LastLine) Out.NextFillOut(ToWrite);				else Out.NextFillOutConcat(ToWrite);
		}
 		LastLine = CheckLine ;
		Last = ToWrite ;
	}
	return Last ;
}


