/*
 *  hot_button.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <InterViews/display.h>
#include <InterViews/window.h>
#include <InterViews/telltale.h>
#include <InterViews/event.h>

#include "hot_button.h"
#include "xdrv.h"
#include "cgidbg.h"
#include "dsp_app.h"
#include "menu.h"


DummyPushButtonAction dummy_push_action ;

void DummyPushButtonAction::execute()
{
	DbgError("DummyPushButtonAction::Execute","should not be called");
}

HotButton::HotButton(HotButton * but):
	ivButton(but->body(),but->style(),but->state(),&dummy_push_action),
	menu_line(but->line()),
	index(but->get_index()),
	is_menu_selection(but->menu_selection()),
	the_allocation(0),
	the_blinker(but->blinker()),
	the_glyph_index(but->glyph_index())
{
	Button::enter();
}

HotButton::HotButton(Blinker * bl, ivGlyph* g, ivStyle* s, ivTelltaleState* t,
	MenuViewLine& line, int ix):
	ivButton(g,s,t,&dummy_push_action),
	menu_line(line),
	index(ix),
	is_menu_selection(0),
	the_allocation(0),
	the_glyph_index(0),
	the_blinker(bl)
{
	Button::enter();
}

HotButton::~HotButton()
{
}

void HotButton::unselect()
{
	ivButton::enter();
	the_blinker->stop();
	redraw();
}

void HotButton::select()
{
	ivButton::enter();
	the_blinker->start();
	redraw();
}

void HotButton::allocate(ivCanvas *c, const ivAllocation& alloc, ivExtension&e)
{
	ivInputHandler::allocate(c,alloc,e);
}

const char * HotButton::name()
{
	return menu_line.get_unique_name(index);
}

void HotButton::enter()
{
	menu_line.set_mouse_selection(this);
	// LogOut << "HotButton::enter\n" ;
	// ivButton::enter();
	ivTelltaleState* s = state();
	if (s->test(ivTelltaleState::is_enabled)) {
 	   s->set(ivTelltaleState::is_visible, true);
    }
	menu_line.execute_enter(index);
}

void HotButton::down_state()
{
	// ivButton::enter();
	press();
}

void HotButton::local_leave(int call_base)
{
	// LogOut << "HotButton::local_leave(" << call_base << ")\n" ;
	if (!call_base) {
		ivTelltaleState* s = state();
		if (s->test(ivTelltaleState::is_enabled))
			s->set(ivTelltaleState::is_visible, false);
	}
	menu_line.execute_leave(index);
}

void HotButton::leave()
{
	if (!is_menu_selection) release();
	menu_line.clear_mouse_selection();
	local_leave(1);
}

void HotButton::press(const ivEvent&event)
{
	press();
	// LogOut << "HotButton::press\n" ;
	if (!DspApplication::user_input_allowed()) return ;
	menu_line.press(index, event, this);
}

void HotButton::press()
{
		state()->set(ivTelltaleState::is_active, true);
}

void HotButton::release()
{
	if (is_menu_selection) return ;
	state()->set(ivTelltaleState::is_active, false);
}

void HotButton::release(const ivEvent& event)
{
/*
 *	LogOut << "HotButton::release, L = " << event.left_is_down() <<
 *		", M = " << event.middle_is_down() << ", R = " << event.right_is_down()
 *		<< ", Shift = " << event.shift_is_down() << ", Control = " <<
 *		event.control_is_down() << "\n" ;
 */

/*** BEGIN modified Button::release ***/
	ivTelltaleState* s = state();
	// LogOut << "state = 0x" << hex << s << dec << "\n" ;
	if (s->test(ivTelltaleState::is_enabled)) {
		if (inside(event)) {
			menu_line.release(event);
		}
	}

/*** END modified Button::release ***/
	// LogOut << "state = 0x" << hex << s << dec << "\n" ;
}


void HotButton::peel_off_menu()
{
	menu_line.peel_off_menu(index);
}

void HotButton::raise_windows()
{
	menu_line.raise_windows(index);
}

void HotButton::create_default()
{
	menu_line.create_default(index);
}

void HotButton::create_instance()
{
	menu_line.create_instance(index);
}

void HotButton::do_command()
{
	menu_line.do_command(index);
}

void HotButton::help_paragraph()
{
	menu_line.help_paragraph(index);
}

void HotButton::cond_help_paragraph()
{
	menu_line.cond_help_paragraph(index);
}

void HotButton::help_file()
{
	menu_line.help_file(index);
}



