/*
 *  txtwin.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef TXTWIN_DOT_H
#define TXTWIN_DOT_H
#include <InterViews/monoglyph.h>
#include <InterViews/resource.h>
#include <InterViews/enter-scope.h>
#include <InterViews/patch.h>
#include <InterViews/input.h>
#include <IV-look/field.h>
#include <InterViews/glyph.h>
#include "portable.h"
#include <fstream.h>
#include "usriotyp.h"

class Event ;
class ApplicationWindow ;
class PolyGlyph;
class WidgetKit ;
class Style ;
class Patch ;
class TxtWindow ;
class Session ;
class InputCallback ;
class FocusSelector ;
class Window ;
class FileWindow ;

class ScrollFieldEditor : public FieldEditor {
	TxtWindow& win ;
	FocusSelector * focus_selector ;
	int init ;
public:
	virtual void process_keystroke(const Event&);
	virtual void keystroke(const Event&);
	virtual void press(const Event&);
	virtual void release(const Event&);

	ScrollFieldEditor(const osString& sample, WidgetKit* k, Style* s,
		TxtWindow& w, FocusSelector *sel);
	InputType type() const ;
	void do_init();
	void scroll_patch_redraw() ;
};


class TxtWindow {
	Session * session;
	ApplicationWindow * window ;
	GlyphIndex index_at_bottom ;
	GlyphIndex index_at_top ;
	PolyGlyph* vbox ;
	Patch * scroll_patch ;
	ScrollFieldEditor * editor ;
	GlyphIndex highest_written ;
	Coord text_width ;
	InputCallback& callback ;
	FileWindow * history_window ;
	const char * window_name ;
	const char * history_file_name ;
	ofstream history_file ;
	void do_scroll(const char * str,int new_field);
public:
	TxtWindow(const char * name, Session * session, const char * BaseString,
		int size, InputCallback& call_back, FocusSelector *sel=0);
	~TxtWindow();
	Session * get_session() const {return session;}
	ApplicationWindow * get_window() const {return window;}
	void scroll(const char * str,int new_field=0);
	void edit();
	Glyph * glyph() const {return scroll_patch;}
	Coord width() const {return text_width;}
	ScrollFieldEditor * get_editor() {return editor;}
	void record(const char * str);
	void history();
	void exit_history_window() {history_window = 0 ;}
	InputType type() const ;
	void scroll_patch_redraw() ;
};

#include <InterViews/leave-scope.h>

#endif /* #ifdef TXTWIN_DOT_H */
