/*
 *  texmenu.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef TEXMENU_DOT_H
#define TEXMENU_DOT_H
class MenuDef ;
class MenuItem ;
class MenuDefListIterator ;
class MenuItemListIterator ;
class MenuDefList ;

typedef int (*CompareRoutine)(void * a, void * b) ;

class ObjectDescript {
	const char * Name ;
	const void * Obj ;
	const MenuDef * Parent ; 	// for comand menu contianing command
					// for menu parent menu
	const MenuDef * Child ;		// for command that is a menu child menu

	const char * Ref ;
	
	int OutputFlag: 1 ;
	int PrintDynamic: 1 ;
	int DoNotPrint:1 ;

	void CheckIsChild() const ; 

	void CheckIsMenu() const ; 
	void CheckIsCommand() const ;
public:
	const enum ObjectType {MenuObjectType,CommandObjectType,
		MenuCommandObjectType} Type ;

	ObjectDescript(const char * name, void * obj, const MenuDef * parent,
		ObjectType type, const MenuDef * child=0);
	void SetRef(int Entry) ;
	void SetParent(const ObjectDescript ** Universe) ;
	void SetIsOutput() {OutputFlag=1;}
	void SetPrintDynamic(int toset=1) {PrintDynamic=toset;}

	const char * GetName() const {return Name;}
	const void * GetObject() const {return Obj;}

	MenuDef * GetMenu() 
		{CheckIsMenu(); return (MenuDef *) Obj;}
	const MenuItem * GetCommand() const
		{CheckIsCommand(); return (MenuItem *) Obj;}

	const MenuDef * GetParent() const {return Parent;}
	const MenuDef * GetChild() const {CheckIsChild(); return Child;}
	const char * GetRef() const {return Ref;}
	const char * GetParentRef() const ;
	const char * GetChildRef() const ;

	int IsThis(const char * Name) const ;
	int IsOutput() const {return OutputFlag;}
	int IsPrintDynamic() const {return PrintDynamic;}
	int IsDoNotPrint() const {return DoNotPrint;}
	void SetDoNotPrint() {DoNotPrint=1;}
};

class TeXMenus ;
typedef ObjectDescript * (TeXMenus::*GetNextObject)() ;

struct DynamicMenusToPrint {
	const char * MenuName ;
	const char * UserName ;
	const char * Ref ;
	void BadUserName(const char * found) const ;
	void SetRef(const char * ref) ;
};

struct ForceSectionLevel {
	const char * MenuName ;
	int Level ;
};

class TeXMenus {
	MenuDefList& TheMenus ;
	const ObjectDescript ** AllCommands ;
	const ObjectDescript ** AllMenus ;
	DynamicMenusToPrint * DynamicPrintList ;
	const ForceSectionLevel * FixedSectionLevels ;

	MenuDefListIterator * TempMenuIterator ;
	MenuItemListIterator * TempItemIterator ;
	MenuDef * TempMenu ;
	
	const char * MainMenuName ;
	void ClearMenuIterators() ;

	ObjectDescript * GetNextMenuObject();
	ObjectDescript * GetNextCommandObject() ;
	void CreateObjectList(ObjectDescript**&, GetNextObject Next,
		CompareRoutine Compare);

	void ExtractCommands();
	void ExtractMenus();
	void SetDynamicPrintMenus(ObjectDescript ** menus) ;

	MenuItem * GetNextItem() ;
	MenuItemListIterator * GetItemIterator() ;
	const MenuDef * GetNextMenu() ;
	int IsDynamicPrintMenu(MenuDef * menu)  ;

public:
	TeXMenus(MenuDefList & the_menus,
		DynamicMenusToPrint * DynPrint=0,
		const ForceSectionLevel * fixed_levels=0);

	void TeXPrintClassHierarchy(ostream& Out);
	void TeXPrintMenuFile(ostream& out);
	void TeXPrintCommandRefFile(ostream& out);

	const char * GetTeXMenuRef(const char * Name);
	const char * GetTeXCommandRef(const char * Name);

	const ObjectDescript * GetObject(const char * Name,
		const ObjectDescript ** Lst) const ;
	const ObjectDescript * GetMenuObject(const char * Name) const ;
	const ObjectDescript * GetCommandObject(const char * Name) const ;

	const char * GetMainMenuName() const {return MainMenuName;}
	enum ToGet {InitGet,NextGet} ;
	const char * GetDynamicMenuTreeExamples(ToGet DoWhat=InitGet) const ;
	enum {NoFixedLevel = -1} ;
	int GetFixedLevel(const char * MenuName) const ; // -1 for none
	int HeadPrintDynamicTree(const char * MenuName) const ;
	const ObjectDescript ** GetAllMenus() const {return AllMenus;}
};

extern const char * MainCgiMenu ;

extern TeXMenus * TheTeXMenus ;

#endif /* #ifdef TEXMENU_DOT_H */
