/*
 *  gentex.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
class ostream ;
class OutTokens ;
class MemberFunction ;
class NodeParameterList ;
class Description ;
class TextFragmentList ;

class TeXFile {
	const char * FileName ;
	ostream& Stream ;
	OutTokens* Out ;
public:
	TeXFile(const char * BaseName);
	~TeXFile() ;
	const char * GetFileName() const {return FileName;}
	ostream& GetStream() const {return Stream;}
	OutTokens& GetOut() const {return *Out;}
};

class TeXDocumentation {
	TeXFile Full ;
	TeXFile Short ;
	const char * NodeName;
	const char * MemberName ;
	OutTokens& Out ;
	OutTokens& Ot ;
	int MemberHeaderOut ;
public:
	TeXDocumentation(const char * BaseName, const char * dir_name) ;
	~TeXDocumentation() ;
	void FoundMemberFunction(MemberFunction * TheMember) ;
	void FoundNode(const char * NodeName,
		NodeParameterList * TheNodeParameters, Description * Desc);
	void ShortFoundNode(NodeParameterList * TheNodeParameters,
		Description * Desc);
	void OutNodeName() ;
	void ShortOutParameters(NodeParameterList * List) ;
}; 

const char * StringArrayBound(int Terminal,int Type, int * sym_flag = 0 ) ;
void CantContinue(const char * Routine, const char * Msg) ;
extern TeXDocumentation * TheTeXDocumentation  ;

