/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * to24.c - convert a 8 bits to a 24 bits image.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Thu Jan 16 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

extern int LUGverbose;

to24(inbitmap, outbitmap)
bitmap_hdr *inbitmap;
bitmap_hdr *outbitmap;
{
  int total_size;
  color_map *map;
  byte *r, *g, *b;
  byte *base;
  byte *end;

  if ( inbitmap->magic != LUGUSED )
    error( 19 );

  /* Fill new header */
  outbitmap->magic = LUGUSED;
  outbitmap->xsize = inbitmap->xsize;
  outbitmap->ysize = inbitmap->ysize;
  outbitmap->depth = 24;
  outbitmap->colors = ( 1 << outbitmap->depth );
  total_size  = outbitmap->xsize * outbitmap->ysize;
  r= outbitmap->r = (byte *) Malloc(total_size);
  g= outbitmap->g = (byte *) Malloc(total_size);
  b= outbitmap->b = (byte *) Malloc(total_size);

  /* A pointer to cmap */
  map  = (color_map *) inbitmap->cmap;
  /* A pointer to original 8 bits buffer */
  base = inbitmap->r;
  /* A pointer to the end */
  end = base + total_size;

  VPRINTF(stderr, "Reconverting to 24 planes\n");
  while ( base < end ) {
    *r++ = map[*base][0];
    *g++ = map[*base][1];
    *b++ = map[*base][2];
    base++;
  }
}
