/*
 * bcheck.c
 */

#include <stdio.h>
#include <unistd.h>
#include "asmi.h"

int main(int argc, char *argv)
{
	unsigned int	batt;
	unsigned int	percent;
	unsigned int	status;
	int	retval;
	
	if (iopl (3) < 0) {
		perror ("iopl");
		return 1;
	}

	retval = asmi(APM_CHECK_POWER_STATUS, 1, 0, 0, &batt, &percent);
	if (retval) {
		printf("Couldn't check battery: %s\n", apm_error(retval));
		exit(1);
	}

	status = batt >> 8;
	batt &= 0xff;
	percent &= 0xff;
	
	printf ("battery check: AC status %s, battery status %s, ",
		(status == 0 ? "off-line"
		 : status == 1 ? "on-line"
		 : status == 255 ? "unknown"
		 : "???"),
		(batt == 0 ? "high"
		 : batt == 1 ? "low"
		 : batt == 2 ? "critical"
		 : batt == 3 ? "charging"
		 : batt == 255 ? "unknown"
		 : "???"));
	if (percent <= 100)
		printf ("remaining charge %d%%\n", percent);
	else if (percent == 255)
		printf ("remaining charge unknown\n");
	else
		printf ("remaining charge ???\n");

	return 0;
}

