%{
/*
 * lex_config.l 1.12 1995/04/20 20:46:16 (David Hinds)\n"
 */

#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "cs_types.h"
#include "cs.h"

#include "y.tab.h"

int config_lineno = 1;

int lex_number(char *s);
int lex_string(char *s);

%}

int	[0-9]+
hex	0x[0-9a-fA-F]+
str	\"([^"]|\\.)*\"

%%

\n		config_lineno++;
[ \t]*		/* skip */ ;
[ ]*[#;].*	/* skip */ ;

card		return CARD;
device		return DEVICE;
anonymous	return ANONYMOUS;
tuple		return TUPLE;
version		return VERSION;
function	return FUNCTION;
bind		return BIND;
module		return MODULE;
opts		return OPTS;
start		return START;
stop		return STOP;
include		return INCLUDE;
exclude		return EXCLUDE;
reserve		return RESERVE;
irq		return IRQ_NO;
port		return PORT;
memory		return MEMORY;
region		return REGION;
dtype		return DTYPE;
jedec		return JEDEC;
default		return DEFAULT;
mtd		return MTD;

memory_card	return lex_number("1");
serial_port	return lex_number("2");
parallel_port	return lex_number("3");
fixed_disk	return lex_number("4");
video_adapter	return lex_number("5");
network_adapter	return lex_number("6");
aims_card	return lex_number("7");

{int}		return lex_number(yytext);

{hex}		return lex_number(yytext);

{str}		return lex_string(yytext);

.		return yytext[0];

%%

#ifndef yywrap
int yywrap() { return 1; }
#endif

int lex_number(char *s)
{
    yylval.num = strtol(s, NULL, 0);
    return NUMBER;
}

int lex_string(char *s)
{
    int n = strlen(s);
    yylval.str = malloc(n-1);
    strncpy(yylval.str, s+1, n-2);
    yylval.str[n-2] = '\0';
    return STRING;
}
