#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 2 "yacc_config.y"
/*
 * yacc_config.y 1.17 1995/05/15 05:22:17 (David Hinds)\n"
 */
    
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <sys/types.h>

#include "cs_types.h"
#include "cs.h"
#include "cistpl.h"
#include "ds.h"
    
#include "cardmgr.h"

extern int config_lineno;

#line 30 "yacc_config.y"
typedef union {
    char *str;
    int num;
    struct device_info_t *device;
    struct card_info_t *card;
    struct mtd_ident_t *mtd;
    struct adjust_list_t *adjust;
} YYSTYPE;
#line 36 "y.tab.c"
#define DEVICE 257
#define CARD 258
#define ANONYMOUS 259
#define TUPLE 260
#define VERSION 261
#define FUNCTION 262
#define BIND 263
#define MODULE 264
#define OPTS 265
#define START 266
#define STOP 267
#define REGION 268
#define JEDEC 269
#define DTYPE 270
#define DEFAULT 271
#define MTD 272
#define INCLUDE 273
#define EXCLUDE 274
#define RESERVE 275
#define IRQ_NO 276
#define PORT 277
#define MEMORY 278
#define STRING 279
#define NUMBER 280
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,    0,    0,    0,    0,    1,    1,    1,    1,
    2,    2,    2,    3,    3,    3,    3,    7,    7,    7,
    7,    7,    7,    8,    9,   10,   10,   11,   12,   12,
    4,    4,    4,    5,    6,   13,   13,   13,   13,   13,
   15,   14,   16,   17,
};
short yylen[] = {                                         2,
    0,    2,    2,    2,    2,    2,    2,    2,    2,    3,
    2,    4,    4,    2,    1,    1,    1,    2,    1,    1,
    1,    1,    1,    2,    7,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    2,    1,    1,    1,    1,
    3,    4,    2,    3,
};
short yydefred[] = {                                      1,
    0,    6,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   16,   17,    0,   19,   20,    0,   22,    0,    0,
   38,   37,   39,    0,   14,   18,   36,    0,    0,    0,
    7,    8,    9,    0,    0,    0,    0,    0,    0,   24,
    0,    0,    0,    0,    0,    0,    0,    0,   43,    0,
   11,    0,    0,   10,   31,   34,   35,   33,   32,    0,
   26,   28,   29,   27,   30,    0,   41,   44,    0,    0,
    0,   42,   12,   13,    0,    0,   25,
};
short yydgoto[] = {                                       1,
    9,   31,   10,   11,   12,   13,   14,   15,   16,   17,
   18,   19,   20,   21,   22,   23,   24,
};
short yysindex[] = {                                      0,
 -251,    0, -277, -271, -265, -245, -245, -245,  -29, -248,
  -44,    0,    0, -250,    0,    0,  -24,    0,  -10, -244,
    0,    0,    0,    0,    0,    0,    0, -243, -242, -241,
    0,    0,    0, -245, -239, -238, -237, -236, -235,    0,
 -234, -232, -230, -231, -228, -226, -225, -224,    0, -222,
    0,   -9,    9,    0,    0,    0,    0,    0,    0,   14,
    0,    0,    0,    0,    0, -221,    0,    0, -220, -219,
 -218,    0,    0,    0,   19, -215,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,   52,   72,
   49,    0,    0,   75,    0,    0,    1,    0,   21,    0,
    0,    0,    0,   29,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
    0,   -4,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 350
short yytable[] = {                                      39,
   21,   25,   32,   33,    2,    3,    4,   26,   40,   41,
   42,   43,   44,   27,   34,   35,    5,   36,   37,   45,
   23,    6,    7,    8,   47,   48,   49,   50,    4,   54,
   28,   29,   30,   46,    0,   69,   51,   52,   53,   55,
   56,   57,   58,   59,    0,   60,   61,   63,   15,   62,
   64,    2,   65,   70,   66,   67,   68,   71,   72,   73,
   74,   75,   76,   77,    0,    0,    0,    0,    0,    0,
    0,    3,    0,    0,    5,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   38,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   21,   21,   21,   21,
   21,   21,   21,   21,    0,    0,    0,    0,   21,    0,
    0,    0,    0,   21,   21,   21,   23,   23,   23,   23,
   23,   23,   23,   23,    4,    4,    4,    0,   23,    0,
    0,    0,    0,   23,   23,   23,    4,   40,   40,   40,
   40,    4,    4,    4,   15,   15,   15,    2,    2,    2,
    0,    0,   15,    0,   15,   15,   15,    0,    0,    2,
    0,   15,   15,   15,    2,    2,    2,    3,    3,    3,
    5,    5,    5,    0,    0,    0,    0,    0,    0,    3,
    0,    0,    5,    0,    3,    3,    3,    5,    5,    5,
};
short yycheck[] = {                                      44,
    0,  279,    7,    8,  256,  257,  258,  279,  259,  260,
  261,  262,  263,  279,   44,  264,  268,  266,  267,   44,
    0,  273,  274,  275,  269,  270,  271,  272,    0,   34,
  276,  277,  278,   44,   -1,   45,  280,  280,  280,  279,
  279,  279,  279,  279,   -1,  280,  279,  279,    0,  280,
  279,    0,  279,   45,  280,  280,  279,   44,  280,  280,
  280,  280,   44,  279,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,    0,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  265,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,
  260,  261,  262,  263,   -1,   -1,   -1,   -1,  268,   -1,
   -1,   -1,   -1,  273,  274,  275,  256,  257,  258,  259,
  260,  261,  262,  263,  256,  257,  258,   -1,  268,   -1,
   -1,   -1,   -1,  273,  274,  275,  268,  269,  270,  271,
  272,  273,  274,  275,  256,  257,  258,  256,  257,  258,
   -1,   -1,  264,   -1,  266,  267,  268,   -1,   -1,  268,
   -1,  273,  274,  275,  273,  274,  275,  256,  257,  258,
  256,  257,  258,   -1,   -1,   -1,   -1,   -1,   -1,  268,
   -1,   -1,  268,   -1,  273,  274,  275,  273,  274,  275,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 280
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,"','","'-'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"DEVICE","CARD",
"ANONYMOUS","TUPLE","VERSION","FUNCTION","BIND","MODULE","OPTS","START","STOP",
"REGION","JEDEC","DTYPE","DEFAULT","MTD","INCLUDE","EXCLUDE","RESERVE","IRQ_NO",
"PORT","MEMORY","STRING","NUMBER",
};
char *yyrule[] = {
"$accept : list",
"list :",
"list : list adjust",
"list : list device",
"list : list mtd",
"list : list card",
"list : list error",
"adjust : INCLUDE resource",
"adjust : EXCLUDE resource",
"adjust : RESERVE resource",
"adjust : adjust ',' resource",
"resource : IRQ_NO NUMBER",
"resource : PORT NUMBER '-' NUMBER",
"resource : MEMORY NUMBER '-' NUMBER",
"device : DEVICE STRING",
"device : module",
"device : start",
"device : stop",
"card : CARD STRING",
"card : anonymous",
"card : tuple",
"card : version",
"card : function",
"card : bind",
"anonymous : card ANONYMOUS",
"tuple : card TUPLE NUMBER ',' NUMBER ',' STRING",
"version : card VERSION STRING",
"version : version ',' STRING",
"function : card FUNCTION NUMBER",
"bind : card BIND STRING",
"bind : bind ',' STRING",
"module : device MODULE STRING",
"module : module ',' STRING",
"module : module OPTS STRING",
"start : device START STRING",
"stop : device STOP STRING",
"region : REGION STRING",
"region : dtype",
"region : jedec",
"region : default",
"region : mtd",
"dtype : region DTYPE NUMBER",
"jedec : region JEDEC NUMBER NUMBER",
"default : region DEFAULT",
"mtd : region MTD STRING",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 379 "yacc_config.y"
void yyerror(char *msg, ...)
{
     va_list ap;
     char str[256];

     va_start(ap, msg);
     sprintf(str, "config error, line %d: ", config_lineno);
     vsprintf(str+strlen(str), msg, ap);
#ifdef DEBUG
     fprintf(stderr, "%s\n", str);
#else
     syslog(LOG_INFO, "%s", str);
#endif
     va_end(ap);
}

void parse_configfile(FILE *f)
{
     extern FILE *yyin;
     yyin = f;
     config_lineno = 1;
     yyparse();
     if (root_device == NULL)
	 syslog(LOG_INFO, "no device drivers defined");
     if (root_card == NULL)
	 syslog(LOG_INFO, "no cards defined");
}

#ifdef DEBUG
adjust_list_t *root_adjust = NULL;
device_info_t *root_device = NULL;
card_info_t *root_card = NULL;
void main(void)
{
    parse_configfile(stdin);
}
#endif
#line 318 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 2:
#line 49 "yacc_config.y"
{
		    adjust_list_t **tail = &root_adjust;
		    while (*tail != NULL) tail = &(*tail)->next;
		    *tail = yyvsp[0].adjust;
		}
break;
case 3:
#line 55 "yacc_config.y"
{
		    yyvsp[0].device->next = root_device;
		    root_device = yyvsp[0].device;
		}
break;
case 4:
#line 60 "yacc_config.y"
{
		    if (yyvsp[0].mtd->mtd_type == 0) {
			yyerror("no ID method for this card");
			YYERROR;
		    }
		    if (yyvsp[0].mtd->module == NULL) {
			yyerror("no MTD module specified");
			YYERROR;
		    }
		    yyvsp[0].mtd->next = root_mtd;
		    root_mtd = yyvsp[0].mtd;
		}
break;
case 5:
#line 73 "yacc_config.y"
{
		    if (yyvsp[0].card->ident_type == 0) {
			yyerror("no ID method for this card");
			YYERROR;
		    }
		    if (yyvsp[0].card->functions == 0) {
			yyerror("no function bindings");
			YYERROR;
		    }
		    if (yyvsp[0].card->ident_type == FUNC_IDENT) {
			yyvsp[0].card->next = root_func;
			root_func = yyvsp[0].card;
		    }
		    else {
			yyvsp[0].card->next = root_card;
			root_card = yyvsp[0].card;
		    }
		}
break;
case 7:
#line 95 "yacc_config.y"
{
		    yyvsp[0].adjust->adj.Action = ADD_MANAGED_RESOURCE;
		    yyval.adjust = yyvsp[0].adjust;
		}
break;
case 8:
#line 100 "yacc_config.y"
{
		    yyvsp[0].adjust->adj.Action = REMOVE_MANAGED_RESOURCE;
		    yyval.adjust = yyvsp[0].adjust;
		}
break;
case 9:
#line 105 "yacc_config.y"
{
		    yyvsp[0].adjust->adj.Action = ADD_MANAGED_RESOURCE;
		    yyvsp[0].adjust->adj.Attributes |= RES_RESERVED;
		    yyval.adjust = yyvsp[0].adjust;
		}
break;
case 10:
#line 111 "yacc_config.y"
{
		    yyvsp[0].adjust->adj.Action = yyvsp[-2].adjust->adj.Action;
		    yyvsp[0].adjust->adj.Attributes = yyvsp[-2].adjust->adj.Attributes;
		    yyvsp[0].adjust->next = yyvsp[-2].adjust;
		    yyval.adjust = yyvsp[0].adjust;
		}
break;
case 11:
#line 120 "yacc_config.y"
{
		    yyval.adjust = calloc(sizeof(adjust_list_t), 1);
		    yyval.adjust->adj.Resource = RES_IRQ;
		    yyval.adjust->adj.resource.irq.IRQ = yyvsp[0].num;
		}
break;
case 12:
#line 126 "yacc_config.y"
{
		    if ((yyvsp[0].num < yyvsp[-2].num) || (yyvsp[0].num > 0xffff)) {
			yyerror("invalid port range");
			YYERROR;
		    }
		    yyval.adjust = calloc(sizeof(adjust_list_t), 1);
		    yyval.adjust->adj.Resource = RES_IO_RANGE;
		    yyval.adjust->adj.resource.io.BasePort = yyvsp[-2].num;
		    yyval.adjust->adj.resource.io.NumPorts = yyvsp[0].num - yyvsp[-2].num + 1;
		}
break;
case 13:
#line 137 "yacc_config.y"
{
		    if (yyvsp[0].num < yyvsp[-2].num) {
			yyerror("invalid address range");
			YYERROR;
		    }
		    yyval.adjust = calloc(sizeof(adjust_list_t), 1);
		    yyval.adjust->adj.Resource = RES_MEMORY_RANGE;
		    yyval.adjust->adj.resource.memory.Base = (caddr_t)yyvsp[-2].num;
		    yyval.adjust->adj.resource.memory.Size = yyvsp[0].num - yyvsp[-2].num + 1;
		}
break;
case 14:
#line 150 "yacc_config.y"
{
		    yyval.device = calloc(sizeof(device_info_t), 1);
		    strcpy(yyval.device->dev_info, yyvsp[0].str);
		    free(yyvsp[0].str);
		}
break;
case 18:
#line 161 "yacc_config.y"
{
		    yyval.card = calloc(sizeof(card_info_t), 1);
		    yyval.card->name = yyvsp[0].str;
		}
break;
case 24:
#line 173 "yacc_config.y"
{
		    if (yyvsp[-1].card->ident_type != 0) {
			yyerror("ID method already defined");
			YYERROR;
		    }
		    if (blank_card) {
			yyerror("Anonymous card already defined");
			YYERROR;
		    }
		    yyvsp[-1].card->ident_type = BLANK_IDENT;
		    blank_card = yyvsp[-1].card;
		}
break;
case 25:
#line 188 "yacc_config.y"
{
		    if (yyvsp[-6].card->ident_type != 0) {
			yyerror("ID method already defined");
			YYERROR;
		    }
		    yyvsp[-6].card->ident_type = TUPLE_IDENT;
		    yyvsp[-6].card->tuple.code = yyvsp[-4].num;
		    yyvsp[-6].card->tuple.ofs = yyvsp[-2].num;
		    yyvsp[-6].card->tuple.info = yyvsp[0].str;
		}
break;
case 26:
#line 201 "yacc_config.y"
{
		    if (yyvsp[-2].card->ident_type != 0) {
			yyerror("ID method already defined\n");
			YYERROR;
		    }
		    yyvsp[-2].card->ident_type = VERS_1_IDENT;
		    yyvsp[-2].card->vers.ns = 1;
		    yyvsp[-2].card->vers.pi[0] = yyvsp[0].str;
		}
break;
case 27:
#line 211 "yacc_config.y"
{
		    if (yyvsp[-2].card->vers.ns == 4) {
			yyerror("too many version strings");
			YYERROR;
		    }
		    yyvsp[-2].card->vers.pi[yyvsp[-2].card->vers.ns] = yyvsp[0].str;
		    yyvsp[-2].card->vers.ns++;
		}
break;
case 28:
#line 222 "yacc_config.y"
{
		    if (yyvsp[-2].card->ident_type != 0) {
			yyerror("ID method already defined\n");
			YYERROR;
		    }
		    yyvsp[-2].card->ident_type = FUNC_IDENT;
		    yyvsp[-2].card->func.funcid = yyvsp[0].num;
		}
break;
case 29:
#line 233 "yacc_config.y"
{
		    device_info_t *dev = root_device;
		    if (yyvsp[-2].card->functions == MAX_FUNCTIONS) {
			yyerror("too many bindings\n");
			YYERROR;
		    }
		    for (; dev; dev = dev->next)
			if (strcmp((char *)dev->dev_info, yyvsp[0].str) == 0) break;
		    if (dev == NULL) {
			yyerror("unknown device: %s", yyvsp[0].str);
			YYERROR;
		    }
		    yyvsp[-2].card->device[yyvsp[-2].card->functions] = dev;
		    yyvsp[-2].card->functions++;
		    free(yyvsp[0].str);
		}
break;
case 30:
#line 250 "yacc_config.y"
{
		    device_info_t *dev = root_device;
		    if (yyvsp[-2].card->functions == MAX_FUNCTIONS) {
			yyerror("too many bindings\n");
			YYERROR;
		    }
		    for (; dev; dev = dev->next)
			if (strcmp((char *)dev->dev_info, yyvsp[0].str) == 0) break;
		    if (dev == NULL) {
			yyerror("unknown device: %s", yyvsp[0].str);
			YYERROR;
		    }
		    yyvsp[-2].card->device[yyvsp[-2].card->functions] = dev;
		    yyvsp[-2].card->functions++;
		    free(yyvsp[0].str);
		}
break;
case 31:
#line 269 "yacc_config.y"
{
		    if (yyvsp[-2].device->modules == MAX_MODULES) {
			yyerror("too many modules");
			YYERROR;
		    }
		    yyvsp[-2].device->module[yyvsp[-2].device->modules] = yyvsp[0].str;
		    yyvsp[-2].device->opts[yyvsp[-2].device->modules] = NULL;
		    yyvsp[-2].device->modules++;
		}
break;
case 32:
#line 279 "yacc_config.y"
{
		    if (yyvsp[-2].device->modules == MAX_MODULES) {
			yyerror("too many modules");
			YYERROR;
		    }
		    yyvsp[-2].device->module[yyvsp[-2].device->modules] = yyvsp[0].str;
		    yyvsp[-2].device->opts[yyvsp[-2].device->modules] = NULL;
		    yyvsp[-2].device->modules++;
		}
break;
case 33:
#line 289 "yacc_config.y"
{
		    if (yyvsp[-2].device->opts[yyvsp[-2].device->modules-1] == NULL)
			yyvsp[-2].device->opts[yyvsp[-2].device->modules-1] = yyvsp[0].str;
		    else {
			yyerror("too many options");
			YYERROR;
		    }
		}
break;
case 34:
#line 300 "yacc_config.y"
{
		    if (yyvsp[-2].device->start_cmd != NULL) {
			yyerror("extra start command");
			YYERROR;
		    }
		    yyvsp[-2].device->start_cmd = yyvsp[0].str;
		}
break;
case 35:
#line 310 "yacc_config.y"
{
		    if (yyvsp[-2].device->stop_cmd != NULL) {
			yyerror("extra stop command");
			YYERROR;
		    }
		    yyvsp[-2].device->stop_cmd = yyvsp[0].str;
		}
break;
case 36:
#line 320 "yacc_config.y"
{
		    yyval.mtd = calloc(sizeof(mtd_ident_t), 1);
		    yyval.mtd->name = yyvsp[0].str;
		}
break;
case 41:
#line 331 "yacc_config.y"
{
		    if (yyvsp[-2].mtd->mtd_type != 0) {
			yyerror("ID method already defined");
			YYERROR;
		    }
		    yyvsp[-2].mtd->mtd_type = DTYPE_MTD;
		    yyvsp[-2].mtd->dtype = yyvsp[0].num;
		}
break;
case 42:
#line 342 "yacc_config.y"
{
		    if (yyvsp[-3].mtd->mtd_type != 0) {
			yyerror("ID method already defined");
			YYERROR;
		    }
		    yyvsp[-3].mtd->mtd_type = JEDEC_MTD;
		    yyvsp[-3].mtd->jedec_mfr = yyvsp[-1].num;
		    yyvsp[-3].mtd->jedec_info = yyvsp[0].num;
		}
break;
case 43:
#line 354 "yacc_config.y"
{
		    if (yyvsp[-1].mtd->mtd_type != 0) {
			yyerror("ID method already defined");
			YYERROR;
		    }
		    if (default_mtd) {
			yyerror("Default MTD already defined");
			YYERROR;
		    }
		    yyvsp[-1].mtd->mtd_type = DEFAULT_MTD;
		    default_mtd = yyvsp[-1].mtd;
		}
break;
case 44:
#line 369 "yacc_config.y"
{
		    if (yyvsp[-2].mtd->module != NULL) {
			yyerror("extra MTD entry");
			YYERROR;
		    }
		    yyvsp[-2].mtd->module = yyvsp[0].str;
		}
break;
#line 799 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
