/*
 *	'Stream' user interface view. 
 *
 *	This is work in progress as they say. To maximise compatibility I've
 *	tried to use the standard definitions and values for everything that
 *	is 'user visible' here.
 *
 *		Alan
 */
 
#ifndef __LINUX_STREAM_H
#define __LINUX_STREAM_H
/*
 *	I believe this to be a complete list of every ioctl of relevance and
 *	enough also for the iBCS2 people. 
 */
 
#define I_PUSH		0x89A0
#define I_POP		0x89A1
#define I_LOOK		0x89A2
#define I_FLUSH		0x89A3
#define I_SETSIG	0x89A4
#define I_GETSIG	0x89A5
#define I_FIND		0x89A6
#define I_PEEK		0x89A7
#define I_SRDOPT	0x89A8
#define I_GRDOPT	0x89A9
#define I_NREAD		0x89A0
#define I_FDINSERT	0x89A1
#define I_STR		0x89A2
#define I_SENDFD	0x89A3
#define I_RECVFD	0x89A4
#define I_LINK		0x89A5
#define I_UNLINK	0x89A6

/*
 *	Structures [with reference to the iBCS2 standard]
 */

struct strioctl
{
	int ic_cmd;
	int ic_timout;
#define INFTIM	(-1);
	int ic_len;
	char *ic_dp;	/* Data */
};

struct strbuf
{
	int maxlen;
	int len;
	char *buf;
};

struct strpeekbuf
{
	struct strbuf ctlbuf;
	struct strbuf databuf;
	long flags;
};

#define RNORM	0
#define RMSGD	1
#define RMSGN	2

#define FLUSHR	1
#define FLUSHW	2
#define FLUSHRW (FLUSHR|FLUSHW)

#define S_INPUT 1
#define S_HIPRI 2
#define S_OUTPUT 4
#define S_MSG 8

#define RS_HIPRI	1		/* MSG_OOB to the socket layer */

#define MORECTL		1
#define MOREDATA	2


#ifdef __KERNEL__

/*
 *	Implementation view
 */

#define STR_MAX_LEVELS	8

struct stream
{
	char name[16];
	struct protocol *proto_chain;
	struct device *dev;	/* Net layer device pointer */
	struct inode *clone_open(struct file *fp,struct stream *self);
	int flags;
#define FL_IOCTL_Q 	1	/* Slow ioctl in action */
#define FL_HANGUP 	2	/* Hung up */
#define FL_ALLOC	4	/* Allocated */
	unsigned long ioctl_seq;
	unsigned long wmem;	/* End to end choke flow control */
	unsigned long wlim;
	sk_buff *rcv_queue;		/* Receive queue */
	char rdopt;			/* Read mode */
};

#endif
#endif