
#define DEFAULT_MOD_REVERB 32
#define DEFAULT_MOD_CHORUS_DEPTH 10
/*
 *	gmod.c	- Module player for GUS and Linux.
 *		(C) Hannu Savolainen, 1993
 *
 *	NOTE!	This program doesn't try to be a complete module player.
 *		It's just a too I used while developing the driver. In
 *		addition it can be used as an example on programming
 *		the LInux Sound Driver with GUS.
 *  NOTE NOTE!  This is only a portion of Hannu's code, adapted for
 *	        mp, with mistakes introduced by Greg Lee.
 */

#include <string.h>
#include <unistd.h>
#include "adagio.h"
#include "allphase.h"
#include "midicode.h"

extern int next_wave_prog;
extern int *shm_percsel;

unsigned char *Mf_file_contents;
int Mf_file_size;

#define CMD_ARPEG		0x00
#define CMD_SLIDEUP		0x01
#define CMD_SLIDEDOWN		0x02
#define CMD_SLIDETO		0x03
#define    SLIDE_SIZE		8
#define CMD_VOLSLIDE		0x0a
#define CMD_JUMP		0x0b
#define CMD_VOLUME		0x0c
#define CMD_BREAK		0x0d
#define CMD_SPEED		0x0f
#define CMD_NOP			0xfe
#define CMD_NONOTE		0xff

#define MIN(a, b)		((a) < (b) ? (a) : (b))

#define MAX_TRACK	8
#define MAX_PATTERN	128
#define MAX_POSITION	128

struct note_info
  {
    unsigned char   note;
    unsigned char   vol;
    unsigned char   sample;
    unsigned char   command;
    short           parm1, parm2;
  };

struct voice_info
  {
    int             sample;
    int             note;
    int             volume;
    int             pitchbender;

    /* Pitch sliding */

    int             slide_pitch;
    int             slide_goal;
    int             slide_rate;

    int             volslide;
  };

static int	curr_program[NUM_CHANS] = {
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
static int	curr_expression[NUM_CHANS] = {
 NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,
 NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,
 NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR,NORMAL_EXPR};
static int	curr_note[NUM_CHANS];
static int	curr_bend[NUM_CHANS] = {
8192,8192,8192,8192,8192,8192,8192,8192,8192,8192,8192,8192,8192,8192,8192,8192
};
static int	curr_sample[MAX_TRACK];
static int	curr_arpeggio[MAX_TRACK];
static int	curr_bender_range[MAX_TRACK] = {200,200,200,200,200,200,200,200};
static int	curr_sensitivity[NUM_CHANS] =
{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2};

typedef struct note_info pattern[MAX_TRACK][64];
static int             pattern_len[MAX_POSITION];
static int             pattern_tempo[MAX_POSITION];
static pattern        *pattern_table[MAX_PATTERN];

static struct voice_info voices[MAX_TRACK];

static int             nr_channels, nr_patterns, songlength;
static int             tune[MAX_POSITION];
static double          tick_duration;

static int             period_table[] =
{
  856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453,
  428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226,
  214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113
};

static int             sample_ok[128], sample_vol[128], sample_finetune[128];
static double          this_time, next_time;
static int             ticks_per_division;
static double          clock_rate;	/* HZ */

static void            play_module ();
static int             play_note (int channel, struct note_info *pat);
static void            lets_play_voice (int channel, struct voice_info *v);
static void	       lets_play_arpeggio (int channel, int tick);

static void
init_voices ()
{
  int             i;

  for (i = 0; i < MAX_TRACK; i++)
    {
      voices[i].sample = 0;
      voices[i].note = 0;
      voices[i].volume = 64;

      voices[i].slide_pitch = 0;
      voices[i].slide_goal = 0;
      voices[i].slide_rate = 0;
      voices[i].pitchbender = 0;

      voices[i].volslide = 0;
    }
}

static unsigned short
intelize (unsigned short v)
{
  return ((v & 0xff) << 8) | ((v >> 8) & 0xff);
}

/**
static unsigned long
intelize4 (unsigned long v)
{
  return
  (((v >> 16) & 0xff) << 8) | (((v >> 16) >> 8) & 0xff) |
  (((v & 0xff) << 8) | ((v >> 8) & 0xff) << 16);
}
**/

#define REGULAR_MOD 0
#define MOD_669 1
#define MOD_STM 2
#define EXTRA_LEN 100

static int
mod_load_voices(int mod_file_type, int sample_ptr, int nr_samples)
{
  struct sample_header
    {
      char            name[22];
      unsigned short  length;	/* In words */

      unsigned char   finetune;
      unsigned char   volume;

      unsigned short  repeat_point;	/* In words */
      unsigned short  repeat_length;	/* In words */
    };
  struct mod669_sample_header
    {
      char            name[13];
      unsigned long   length;	/* In bytes */
      unsigned long   loop_start;
      unsigned long   loop_end;
    };
  struct stm_sample_header
    {
      char            name[12];
      unsigned char   instr_disk;
      unsigned short  reserved1;
      unsigned short  length;	/* In bytes */
      unsigned short  loop_start;
      unsigned short  loop_end;
      unsigned char   volume;
      unsigned char   reserved2;
      unsigned short  C2_speed;
      unsigned short  reserved3;

    };



  int             i, total_mem;

  total_mem = 0;

  for (i = 0; i < 64; i++)
    if (gus_dev >= 0) sample_ok[i] = 0;
    else {
      sample_ok[i] = 1;
      sample_vol[i] = 64;
    }

  if (gus_dev >= 0) for (i = 0; i < nr_samples; i++)
    {
      int             len, loop_start, loop_end, base_freq = 0;
      unsigned short  loop_flags = 0;
      char            pname[23];

      struct sample_header *sample = NULL;
      struct mod669_sample_header *mod669_sample = NULL;
      struct stm_sample_header *stm_sample = NULL;

      struct patch_info *patch;

    switch(mod_file_type) {
    case REGULAR_MOD:
      /*sample = (struct sample_header *) &Mf_file_contents[20 + (i * 30)];*/
      sample = (struct sample_header *) (Mf_file_contents + 20 + (i * 30));
      sample_finetune[i] = sample->finetune;
/**
      len = intelize (sample->length) * 2;
      loop_start = intelize (sample->repeat_point) * 2;
      loop_end = loop_start + (intelize (sample->repeat_length) * 2);
**/
      len = intelize (sample->length);
      loop_start = intelize (sample->repeat_point);
      loop_end = intelize (sample->repeat_length);
      if (loop_end + loop_start > len + 1) loop_start /= 2;
      if (loop_end + loop_start > len) len -= loop_start;
      len *= 2;
      loop_start *= 2;
      loop_end *= 2;
      loop_end += loop_start;

      if (loop_start > len)
	loop_start = 0;
      if (loop_end > len)
	loop_end = len;
      if (loop_end <= loop_start)
	loop_end = loop_start + 1;
      strncpy (pname, sample->name, 22);
      pname[22] = '\0';
	break;

    case MOD_669:
      mod669_sample = (struct mod669_sample_header *) &Mf_file_contents[0x1f1 + (i * 0x19)];
      sample_finetune[i] = 0;
      len = *(unsigned long *) &mod669_sample->name[13];
      loop_start = *(unsigned long *) &mod669_sample->name[17];
      loop_end = *(unsigned long *) &mod669_sample->name[21];
      if (loop_end > len)
	loop_end = 1;
      else if (loop_end == len)
	loop_end--;
      if (loop_end < loop_start)
	{
	  loop_start = 0;
	  loop_end = 0;
	}
	  if (loop_end == 0)
	    loop_end = 1;
	  if (loop_end >= len)
	    loop_end = 1;
      strncpy (pname, mod669_sample->name, 13);
      pname[13] = '\0';
	break;

	case MOD_STM:
      sample_finetune[i] = 0;
      stm_sample = (struct stm_sample_header *) &Mf_file_contents[48 + (i * 32)];

      len = stm_sample->length;
      loop_start = stm_sample->loop_start;
      loop_end = stm_sample->loop_end;
      base_freq = stm_sample->C2_speed;
      if (strlen (stm_sample->name) > 21)
	{
	  fprintf (stderr, "\nInvalid name for sample #%d\n", i);
	  return 0;
	}
      strncpy (pname, stm_sample->name, 22);
      pname[22] = '\0';
      if (loop_end > len)
	    loop_end = 1;
      else if (loop_end < loop_start)
	    {
	      loop_start = 0;
	      loop_end = 0;
	    }
	break;

        default:
      fprintf(stderr,"mod load internal error\n");
      return(0);
	break;
      }

      if (loop_end > 2 && loop_end > loop_start + 2)
         loop_flags = WAVE_LOOPING;
if (loop_flags & WAVE_LOOPING)
      loop_flags |= WAVE_SUSTAIN_ON;
      loop_flags |= WAVE_ENVELOPES;
      if (mod_file_type == MOD_669 && len >= 200000) {
	if (verbose) printf("mod: skipping long 669 patch %d\n", i);
	len = 0;
      }

      if (len <= 2) sample_vol[i] = 0;
      else
	{
	  unsigned char *file_patch_data;

	  if (really_verbose) printf("Sample %02d: L%05d, S%05d, E%05d V%02d %s\n",
		   i,
		   len,
		   loop_start,
		   loop_end,
		   (mod_file_type == REGULAR_MOD)? sample->volume : 0,
		   pname);

	  total_mem += len;

	  patch = (struct patch_info *) calloc (sizeof (*patch) + len + EXTRA_LEN, 1);

	  patch->key = GUS_PATCH;
	  patch->device_no = gus_dev;
	  patch->instr_no = next_wave_prog;
	  patch->mode = loop_flags;
	  if (mod_file_type == MOD_669) patch->mode |= WAVE_UNSIGNED;
	  patch->len = len + EXTRA_LEN;
	  patch->loop_start = loop_start;
	  patch->loop_end = loop_end;
	  patch->base_note = 261630;	/* Middle C */
	  if (mod_file_type == MOD_STM) patch->base_freq = base_freq;
	  else patch->base_freq = 8448;

	if (mod_file_type == MOD_669) {
	  patch->low_note = 1000;
	  patch->high_note = 0x7fffffff;
	} else if (mod_file_type == MOD_STM) {
	  patch->low_note = 0;
	  patch->high_note = 0x7fffffff;
	} else {
	  patch->low_note = 0;
	  patch->high_note = 20000000;
	}
	  patch->volume = 120;
	  patch->panning = 0;

	if (loop_flags & WAVE_LOOPING) {

	/* trumpet */
	  patch->env_offset[0] = 246;
	  patch->env_offset[1] = 239;
	  patch->env_offset[2] = 246;
	  patch->env_offset[3] =   8;
	  patch->env_offset[4] =   8;
	  patch->env_offset[5] =   8;
	  patch->env_rate[0] = (0 << 6) | 56;
	  patch->env_rate[1] = (2 << 6) | 50;
	  patch->env_rate[2] = (2 << 6) | 40;
	  patch->env_rate[3] = (1 << 6) |  5;
	  patch->env_rate[4] = (0 << 6) | 63;
	  patch->env_rate[5] = (0 << 6) | 63;
          gus_voice[i].volume = 120;
	} else {
	/* agogo */
	  patch->env_offset[0] = 246;
	  patch->env_offset[1] = 239;
	  patch->env_offset[2] = 209;
	  patch->env_offset[3] = 145;
	  patch->env_offset[4] =   8;
	  patch->env_offset[5] =   8;
	  patch->env_rate[0] = (0 << 6) | 59;
	  patch->env_rate[1] = (3 << 6) |  1;
	  patch->env_rate[2] = (3 << 6) |  5;
	  patch->env_rate[3] = (3 << 6) |  8;
	  patch->env_rate[4] = (1 << 6) |  1;
	  patch->env_rate[5] = (0 << 6) |  3;
          gus_voice[i].volume = 80;
	}

	{
#ifdef DEFAULT_MOD_REVERB
	    int reverb = DEFAULT_MOD_REVERB;
#else
	    int reverb = 0;
#endif
	    int pgm = i;
	    int main_vol = main_volume[i % 16];
	    int n;

	    if (reverb > 0 && setting_reverb) {
	            int r = (reverb * setting_reverb) / 50;
	            if (r > 127) r = 127;
	            if (pgm < 120)
	        	patch->env_rate[3] = (2<<6) | (12 - (r>>4));
	            else if (pgm > 127)
	        	patch->env_rate[1] = (3<<6) | (63 - (r>>1));
	    }

#define VR_NUM 2
#define VR_DEN 3
	    {
	        unsigned voff, poff;
	        for (n = 0; n < 6; n++) {
	            voff = patch->env_offset[n];
	            poff = 2 + main_vol + 63 + gus_voice[pgm].volume / 2;
	            voff = ((poff + VR_NUM*256) * voff + VR_DEN*128) / (VR_DEN*256);
	            patch->env_offset[n] = voff;
	        }
	    }
	}

	  if (sample_ptr + len > Mf_file_size)
	    {
	      perror ("short mod file");
	      free (patch);
	      return 0;
	    }
	  file_patch_data = Mf_file_contents + sample_ptr;
	  sample_ptr += len;

	  memcpy(patch->data, file_patch_data, len);

while (loop_end > 0 && (char)patch->data[loop_end-1] == 0) loop_end--;
patch->loop_end = loop_end;
if ((loop_flags & WAVE_LOOPING) && loop_end <= loop_start) loop_start = patch->loop_start = 0;

if ((loop_flags & WAVE_LOOPING) && !(patch->mode & WAVE_UNSIGNED)) {
	int nls = loop_start;
	int nle = loop_end;
	int ipt = 0, ips = 0;
	char v1, v2;
	while (!ipt) {
		v1 = patch->data[nle-1];  v2 = patch->data[nle];
		if (v2==0) {
			if (v1 < 0) ipt = 1;
			else if (v2 > 0) ipt = 2;
		}
		else {
			if (v1 <= 0 && v2 > 0) ipt = 1;
			else if (v1 >= 0 && v2 < 0) ipt = 2;
		}
		if (!ipt) nle--;
		if (nle <= loop_start) break;
	}
	if (ipt && nls > 0) while (!ips) {
		v1 = patch->data[nls-1];  v2 = patch->data[nls];
		if (v2==0) {
			if (ipt == 1 && v1 < 0) ips = 1;
			else if (ipt == 2 && v2 > 0) ips = 2;
		}
		else {
			if (ipt == 1 && v1 <= 0 && v2 > 0) ips = 1;
			else if (ipt == 2 && v1 >= 0 && v2 < 0) ips = 2;
		}
		if (!ips) nls--;
		if (nls < 1) break;
	}
	if (ipt && ips && ipt == ips && nle <= loop_end) {
		patch->loop_start = nls;
		patch->loop_end = nle;
if (really_verbose) printf("  new start %d, new end %d\n", nls, nle);
	}
else if (really_verbose) printf("  nls %d - ips %d, nle %d - ipt %d\n", nls, ips, nle, ipt);
}

if (patch->len > len) {
	int k;
	char c;
	for (k = len; k < patch->len; k++) {
		c = patch->data[k-1];
		if (c > 1) c -= 2;
		else if (c < -1) c += 2;
		else break;
		patch->data[k] = c;
	} 
}


	  if (write(seq_fd, (char *) patch, sizeof(*patch) + len + EXTRA_LEN) == -1) {
		fprintf(stderr, "mod sample not loaded\n");
	        free (patch);
		continue;
	  }

	  sample_ok[i] = 1;
	  if (mod_file_type == MOD_669) sample_vol[i] = 64;
	  else {
	    if (sample->volume == 0) sample->volume = 64;
	    sample_vol[i] = sample->volume;
	    sample_vol[i] += 32 - sample_vol[i]/2;
	  }

          gus_voice[i].loaded = 1;
          gus_voice[i].vname = strcpy(malloc(strlen(pname)+1), pname);
	  gus_voice[i].modes = patch->mode;
	  gus_voice[i].fix_dur = 0;
	  gus_voice[i].trnsps = 64;
	  gus_voice[i].chorus_spread = 64+8;
	  gus_voice[i].echo_delay = 64+16;
	  gus_voice[i].echo_atten = 64-16;
	  gus_voice[i].fix_key = 0;

	  gus_voice[i].vibrato_sweep = 40;
	  gus_voice[i].vibrato_rate = 0;
	if (loop_flags & WAVE_LOOPING)
	  gus_voice[i].vibrato_depth = 14;
	else
	  gus_voice[i].vibrato_depth = 0;

          gus_voice[i].prog = next_wave_prog++;

	  free (patch);
/**
if (really_verbose) printf("sample %d: finetune %d\n", i, sample_finetune[i]);
**/
	}
    }
    return(1);
}


static int load_module()
{

  int             i;
  int             sample_ptr, pattern_loc = 0;

  int             position;

  unsigned char  *tune_ptr;	/* array 0-127 */

  char            *header;
  char		  mname[22];

  int             nr_samples;	/* 16 or 32 samples */
  int             slen, npat;
  int		  mod_file_type = REGULAR_MOD;

  header = (char *)Mf_file_contents;

  clock_rate = 50.0;
  nr_channels = 4;

  for (i = 0; i < MAX_POSITION; i++)
    pattern_len[i] = 64;

  for (i = 0; i < MAX_POSITION; i++)
    pattern_tempo[i] = 0;

  if (header[28] == 0x1a) {

    mod_file_type = MOD_STM;
    strncpy (mname, header, 20);
    if (verbose) printf( "stm module: %s.\n", mname);

    npat = header[33];
    slen = 0;
    tune_ptr = &header[48 + (31 * 32)];
  
    for (i = 0; i < 64; i++)
      {
        tune[i] = tune_ptr[i];
        if (tune[i] < npat)
  	slen = i;
      }
    nr_samples = 31;
  
    sample_ptr = 48 + (31 * 32) + 64 + (npat * 1024);
  }

  else if (*(unsigned short *) &header[0] == 0x6669) {
    unsigned char *len_ptr, *tempo_ptr;

    mod_file_type = MOD_669;
    clock_rate = 25.0;
    nr_channels = 8;

    if (verbose) {
      printf("669 module: ");
      for (i = 2; i < 108 && header[i]; i++)
        if ((header[i] >= ' ' && header[i] <= 'z') || header[i] == '\n')
          printf ("%c", header[i]);
      printf ("\n");
    }

    npat = header[0x6f];

    tune_ptr = &header[0x71];

    for (slen = 0; slen < 128 && tune_ptr[slen] != 0xff; slen++);
    slen--;

    for (i = 0; i < slen; i++)
      tune[i] = tune_ptr[i];

    len_ptr = &header[0x171];
    for (i = 0; i < slen; i++)
      pattern_len[i] = len_ptr[i] - 1;

    tempo_ptr = &header[0xf1];
    for (i = 0; i < slen; i++)
      pattern_tempo[i] = tempo_ptr[i];

    nr_samples = header[0x6e];
    sample_ptr = 0x1f1 + (nr_samples * 0x19) + (npat * 0x600);

  }

  else if (!strncmp (header, "MMD0", 4)) {
    if (verbose) printf( "not implemented: load_mmd0_module\n");
    return(0);
  }

  else {
    strncpy (mname, header, 22);
    if (verbose) printf( "Module: %s.\n", mname);
  
  
    if (!strncmp (&header[1080], "M.K.", 4))
      {
        nr_samples = 31;
      }
    else if (!strncmp (&header[1080], "FLT4", 4))
      {
        nr_samples = 31;
      }
    else if (!strncmp (&header[1080], "FLT8", 4))
      {
        nr_samples = 31;
	nr_channels = 8;
      }
    else if (!strncmp (&header[1080], "6CHN", 4))
      {
        nr_samples = 31;
	nr_channels = 6;
      }
    else
      {
        nr_samples = 15;
      }
  
    if (nr_samples == 31)
      {
        sample_ptr = pattern_loc = 1084;
        slen = header[950];
        tune_ptr = (unsigned char *) &header[952];
      }
    else
      {
        sample_ptr = pattern_loc = 600;
        slen = header[470];
        tune_ptr = (unsigned char *) &header[472];
      }
  
    npat = 0;
    for (i = 0; i < 128; i++)
      {
        tune[i] = tune_ptr[i];
  
        if (tune_ptr[i] > npat)
  	npat = tune_ptr[i];
        if (npat > 63)
  	{
  	  fprintf(stderr, "bad mod format\n");
  	  return(0);
  	}
  
      }
    npat++;
  
    sample_ptr += (npat * 1024);	/* Location where the first sample is stored */
  }

  if (really_verbose)
    printf("Song length %d, %d patterns, %d max samples.\n", slen, npat, nr_samples);


  if (!mod_load_voices(mod_file_type, sample_ptr, nr_samples)) return(0);

  songlength = slen;

  if (mod_file_type == MOD_669) {
    nr_patterns = slen;
  }
  else if (mod_file_type == MOD_STM) {
    nr_patterns = slen;
  }
  else {
    nr_patterns = npat;
  }

  for (position = 0; position < npat; position++)
    {
      /*unsigned char   patterns[64][4][4];*/
      unsigned char   *patterns;
      int             pat, channel, pp;

      if (mod_file_type == MOD_669)
         pp = 0x1f1 + (nr_samples * 0x19) + (position * 0x600);
      else if (mod_file_type == MOD_STM)
         pp = 1104 + (position * 1024);
      else pp = pattern_loc + (position * 1024);


      if (pp + 1024 > Mf_file_size)
	{
	  fprintf (stderr, "Short file (pattern %d) %d\n", tune[position], pp);
	  return 0;
	}

      patterns = Mf_file_contents + pp;

      if ((pattern_table[position] = (pattern *) malloc (sizeof (struct note_info) * 64 * nr_channels)) == NULL)
	{
	  fprintf (stderr, "Can't allocate memory for a pattern\n");
	  return 0;
	}

      for (pat = 0; pat < 64; pat++)
	{
	  for (channel = 0; channel < nr_channels; channel++)
	    {
	      unsigned short  tmp;
	      unsigned char  *p;

	      unsigned        period, sample, effect, params, note, vol, octave;

             if (mod_file_type == MOD_669) {
	      /*p = &patterns[pat * 24 + channel * 3];*/
	      p = patterns + pat * 24 + channel * 3;

	      if (p[0] >= 0xfe ||
		  (p[0] == 0xff && p[1] == 0xff && p[2] == 0xff) ||
		  (p[0] == 0 && p[1] == 0 && p[2] == 0) ||
		  *(int *) p == -1)
		{
		  period = 0;
		  effect = CMD_NONOTE;
		  sample = 0;
		  vol = 0;
		  params = 0;

		  if (p[0] == 0)
		    {
		      effect = CMD_BREAK;
		      params = -2;
		    }
		}
	      else
		{
		  period = (p[0] >> 2) + 48;
		  effect = (p[2] >> 4);
		  params = p[2] & 0x0f;
		  /*vol = p[1] & 0x0f;*/
		  vol = (p[1] & 0x0f)<<3;

		  if (p[2] == 0xfe)
		    {
		      effect = CMD_VOLUME;
		      params = vol;
		    }
		  else if (p[2] == 0xff)
		    {
		      effect = CMD_NOP;
		    }
		  else
		    switch (effect)
		      {
		      case 0:	/* a - Portamento up */
			effect = CMD_SLIDEUP;
			break;

		      case 1:	/* b - Portamento down */
			effect = CMD_SLIDEDOWN;
			break;

		      case 2:	/* c - Port to note */
			effect = CMD_SLIDETO;
			break;

		      case 3:	/* d - Frequency adjust */
			effect = CMD_NOP;	/* To be implemented */
			break;

		      case 4:	/* e - Frequency vibrato */
			effect = CMD_NOP;	/* To be implemented */
			break;

		      case 5:	/* f - Set tempo */
			effect = CMD_SPEED;
			break;

		      default:
			effect = CMD_NOP;
		      }

		  sample = (((p[0] << 4) & 0x30) | ((p[1] >> 4) & 0x0f)) + 1;
		}
	      note = period;
	     }
	     else if (mod_file_type == MOD_STM) {
	      p = patterns + (pat*nr_channels*4) + (channel*4);

	      if (p[0] < 251)
		{
		  note = p[0] & 15;
		  octave = p[0] / 16;

		  note = 48 + octave * 12 + note;

		  sample = p[1] / 8;
		  vol = (p[1] & 7) + (p[2] / 2);
		  effect = p[2] & 0xF;
		  params = p[3];
		}
	      else
		{
		  note = 0;
		  octave = 0;

		  sample = 0;
		  vol = 0;
		  effect = CMD_NONOTE;
		  params = 0;
		}
	     }
	     else {
	      /*p = &patterns[pat][channel][0];*/
	      p = patterns + (pat*nr_channels*4) + (channel*4);

	      tmp = (p[0] << 8) | p[1];
	      sample = (tmp >> 8) & 0x10;
	      period =
		MIN (tmp & 0xFFF, 1023);
	      tmp = (p[2] << 8) | p[3];
	      sample |= tmp >> 12;
	      effect = (tmp >> 8) & 0xF;
	      params = tmp & 0xFF;

	      note = 0;

	      if (period)
		{
		  /*
		   * Convert period to a Midi note number
		   */

		  for (note = 0; note < 37 && period != period_table[note]; note++);
		  if (note >= 37)
		    note = 0;

		  note += 48;
		}

	      vol = 64;

	      if (sample)
		if (effect == 0xc)
		  {
		    vol = params;
		  }
		else
		  vol = sample_vol[sample - 1];

	      vol *= 2;
	      if (vol>64)vol--;
	     }

	      (*pattern_table[position])[channel][pat].note = note;
	      (*pattern_table[position])[channel][pat].sample = sample;
	      (*pattern_table[position])[channel][pat].command = effect;
	      (*pattern_table[position])[channel][pat].parm1 = params;
	      (*pattern_table[position])[channel][pat].parm2 = 0;
	      (*pattern_table[position])[channel][pat].vol = vol;
/*fprintf(stderr,"%d %d: %d %d %d %d %d\n",
channel,pat,note,sample,effect,params,vol);*/
	    }
	}
    }

  return 1;

}

static void
set_speed (int parm)
{
  if (!parm)
    parm = 1;

  if (parm < 32)
    {
      ticks_per_division = parm;
    }
  else
    {
      tick_duration = (60.0 / parm) * 10.0;
    }

}


static void
sync_time ()
{
  if (next_time > this_time)
    {
      /*SEQ_WAIT_TIME ((long) next_time);*/
      this_time = next_time;
      Mf_realtime = (unsigned long)(0.5 + next_time * 16);
    }
}


void
set_volslide (int channel, struct note_info *pat)
{
  int             n;

  voices[channel].volslide = 0;

  if ((n = (pat->parm1 & 0xf0) >> 4))
    voices[channel].volslide = n;
  else
    voices[channel].volslide = pat->parm1 & 0xf;
}

void
set_slideto (int channel, struct note_info *pat)
{
  int             size, rate, dir, range = 200;

  rate = pat->parm1;
  size = voices[channel].note - pat->note;
  if (!size)
    return;

  if (size < 0)
    {
      size *= -1;
      dir = -1;
    }
  else
    dir = 1;

  if (size > 2)
    {
      range = size * 100;
      rate = rate * size / 200;
    }

  rate = pat->parm1 * dir / 30;
  if (!rate)
    rate = 1;

  voices[channel].slide_pitch = 1;
  voices[channel].slide_goal = (dir * 8192 * 200 * 2 / size) / range;
  voices[channel].pitchbender = 0;
  voices[channel].slide_rate = rate;
  /*SEQ_BENDER_RANGE (gus_dev, channel, range);*/
  curr_bender_range[channel] = range;
}

int
play_note (int channel, struct note_info *pat)
{
  int             jump = -1;
  int             sample, mchan, continue_note = 0;

  if (pat->sample == 0x3f)
    pat->sample = 0;

  if (pat->command == CMD_NONOTE)
    return -1;			/* Undefined */

  sample = pat->sample;

/*  if (really_verbose && (!sample || !pat->note)) continue_note = 1;*/

  if (sample && !pat->note)
    {
      pat->note = voices[channel].note;
    }

  if (sample)
    voices[channel].sample = sample;
  else
    sample = voices[channel].sample;

  sample--;

  sync_time();
/**
if (pat->note) fprintf(stderr,"chan %d, samp %d, note %d, vol %d, at %d = %d\n",
channel, sample, pat->note, pat->vol, (long)next_time, Mf_realtime/16);
**/

/* moved next up --gl */
      if (sample < 0)
	sample = voices[channel].sample - 1;

      if (!sample_ok[sample])
	sample = voices[channel].sample - 1;

      if (sample < 0)
	sample = 0;

      mchan = sample % 16;

  if (pat->note && pat->command != CMD_SLIDETO)	/* Have a note -> play */
    {
      if (sample_ok[sample])
	{
	  sync_time ();

          if (pat->vol > 127) pat->vol=127;

	  if (voices[channel].note && !continue_note) {
	    (*Mf_noteon) (curr_sample[channel] % 16, voices[channel].note, 0);
	    curr_note[curr_sample[channel] % 16] = 0;
	  }
	  if (!continue_note) voices[channel].note = pat->note;

	  /*SEQ_SET_PATCH (gus_dev, channel, sample);*/
	  if (!continue_note && curr_program[mchan] != sample)
	    {
	      /*(*Mf_program) (mchan, (gus_dev >= 0)? sample : ((8*sample)%128));*/
	      (*Mf_program) (mchan, sample);
	        curr_program[mchan] = sample;
/*fprintf(stderr,"chan %d = sample %d\n", channel+1, sample);*/
	    }
	  curr_sample[channel] = sample;

	  /*SEQ_PANNING (gus_dev, channel, panning (channel));*/
	  /*SEQ_PITCHBEND (gus_dev, channel, 0);*/
	if (curr_bend[mchan] != 8192) {
	  (*Mf_pitchbend) (mchan, 8192&0x7f, 8192>>7);
	  curr_bend[mchan] = 8192;
	}
	if (curr_expression[mchan] != NORMAL_EXPR) {
	  (*Mf_parameter) (mchan, EXPRESSION, NORMAL_EXPR);
	  curr_expression[mchan] = NORMAL_EXPR;
	}
	  /*SEQ_START_NOTE (gus_dev, channel, pat->note, pat->vol);*/

	  if (pat->vol && pat->note && !continue_note) {
	    (*Mf_noteon) (mchan, pat->note, pat->vol);
	    curr_note[mchan] = pat->note;
	  }
/*
else
fprintf(stderr,"note %d, vol %d, s %d\n", pat->note, pat->vol, sample);
*/
	  voices[channel].volume = pat->vol;
	  voices[channel].note = pat->note;
	  voices[channel].slide_pitch = 0;
	}
      else
	/*SEQ_STOP_NOTE (gus_dev, channel, pat->note, pat->vol);*/
	(*Mf_noteon) (mchan, pat->note, 0);
    }

 {
  int argx = (pat->parm1 >> 4) & 0x0f;
  int argy = (pat->parm1) & 0x0f;
  switch (pat->command)
    {

    case CMD_NOP:;
      break;

    case CMD_JUMP:
      /*jump = pat->parm1;*/
      jump = argx*10 + argy;
      break;

    case CMD_BREAK:
      jump = -2;
      break;

    case CMD_SPEED:
      set_speed (pat->parm1);
      break;

    case CMD_SLIDEUP:
      voices[channel].slide_pitch = 1;
      voices[channel].slide_goal = 8191;
      voices[channel].pitchbender = 0;
      voices[channel].slide_rate = pat->parm1 * SLIDE_SIZE;
      /*SEQ_BENDER_RANGE (gus_dev, channel, 200);*/
      curr_bender_range[channel] = 200;
      break;

    case CMD_SLIDEDOWN:
      voices[channel].slide_pitch = 1;
      voices[channel].slide_goal = -8192;
      voices[channel].pitchbender = 0;
      voices[channel].slide_rate = -pat->parm1 * SLIDE_SIZE;
      /*SEQ_BENDER_RANGE (gus_dev, channel, 200);*/
      curr_bender_range[channel] = 200;
      break;

    case CMD_SLIDETO:
      set_slideto (channel, pat);
      break;

    case CMD_VOLUME:
      {
        int vol = pat->parm1*2;
        if (vol>127) vol=127;
      if (pat->note && pat->command != 3)
	break;
      /*SEQ_START_NOTE (gus_dev, channel, 255, vol);*/
	if (curr_expression[mchan] != vol) {
	  (*Mf_parameter) (mchan, EXPRESSION, vol/2);
	  curr_expression[mchan] = vol/2;
	}
      }
      break;

    case CMD_ARPEG:
if ((pat->parm1) && really_verbose)
	printf("arpeggio %d %d\n", argx, argy);
      curr_arpeggio[channel] = pat->parm1;
      break;

    case 4: {
	static int oargx = 0, oargy = 0;
	  if (!argx) argx = oargx; if (!argy) argy = oargy;
/*if (really_verbose) printf("vibrato %d %d\n", pat->parm1, pat->parm2);*/
	  (*Mf_parameter) (mchan, MODWHEEL, argy);
	  oargx = argx; oargy = argy;
        }
      break;

    case 5:
if (really_verbose) printf("cont. slide %d %d\n", argx, argy);
      break;

    case 6:
if (really_verbose) printf("cont. vibrato %d %d\n", argx, argy);
      break;

    case 7:
if (really_verbose) printf("tremulo %d %d\n", argx, argy);
      break;

    case 9:
if (really_verbose) printf("set samp. offset %d\n", 2*(argx*4096+argy*256));
      break;

    case 14:
      switch (argx) {
        case 0: if (really_verbose)
	   printf ("filter %s\n", argy? "off":"on");
	break;
        case 4: if (really_verbose) {
	   char *wvname[4] = {"sine","ramp down","square","random"};
	   printf ("vibrato wave %s\n", wvname[argy%4]);
	   }
	break;
        case 5: if (really_verbose)
	   printf ("finetune %d\n", (argy<8)? argy:(argy-16));
	break;
        case 12: if (really_verbose)
	   printf ("Xmd %d\n", argy);
	break;
        case 13: if (really_verbose)
	   printf ("delay sample %d\n", argy);
	break;
        case 14: if (really_verbose)
	   printf ("delay pattern %d\n", argy);
	break;
        case 15: if (really_verbose && argy)
	   printf ("invert sample at speed %d\n", argy);
	break;
        default: if (really_verbose)
	   printf ("Xmd %d\n", argy);
	break;
        }
      break;

    case CMD_VOLSLIDE:
      set_slideto (channel, pat);
      break;

    default:
      if (really_verbose) printf ("Command %x %02x\n", pat->command, pat->parm1);
      break;
    }
  }

  return jump;
}

static void
lets_play_arpeggio (int channel, int tick)
{
	int a_notes = curr_arpeggio[channel];
	int o_note = voices[channel].note;
	int vol = voices[channel].volume;
	int note1, note2, mchan, div1 = 0, div2 = 0;

	if (!a_notes || !o_note || !vol) return;

	note1 = (a_notes >> 4) & 0x0f;
	note2 = a_notes & 0x0f;
	mchan = curr_sample[channel] % 16;

	if (note1 && !note2) div1 = ticks_per_division/2;
	else if (!note1 && note2) {
		div2 = ticks_per_division/2;
	}
	else {
		div1 = ticks_per_division/3;
		div2 = 2 * div1;
	}

	if (tick == div1 && note1) {
	    sync_time();
	    /*(*Mf_noteon) (mchan, o_note, 0);*/
	    (*Mf_noteon) (mchan, o_note + note1, vol);
	}
	else if (tick == div2 && note2) {
	    sync_time();
	    if (note1) (*Mf_noteon) (mchan, o_note + note1, 0);
	    else (*Mf_noteon) (mchan, o_note, 0);
	    (*Mf_noteon) (mchan, o_note + note2, vol);
	}
	else if (tick == ticks_per_division - 1) {
	    sync_time();
	    if (note1 && !note2) (*Mf_noteon) (mchan, o_note + note1, 0);
	    if (note2) (*Mf_noteon) (mchan, o_note + note2, 0);
	    /*(*Mf_noteon) (mchan, o_note, vol);*/
	    curr_arpeggio[channel] = 0;
	}
}

void
lets_play_voice (int channel, struct voice_info *v)
{
  if (v->slide_pitch)
    {
      v->pitchbender += v->slide_rate;
      if (v->slide_goal < 0)
	{
	  if (v->pitchbender <= v->slide_goal)
	    {
	      v->pitchbender = v->slide_goal;
	      v->slide_pitch = 0;	/* Stop */
	    }
	}
      else
	{
	  if (v->pitchbender >= v->slide_goal)
	    {
	      v->pitchbender = v->slide_goal;
	      v->slide_pitch = 0;	/* Stop */
	    }
	}

      sync_time ();
      /*SEQ_PITCHBEND (gus_dev, channel, v->pitchbender);*/
       {
	  int new_bend, range, mchan = curr_sample[channel]%16;
	  if (curr_bender_range[channel] > 200) {
	    if (curr_sensitivity[mchan] != 12) {
	      (*Mf_parameter) (mchan, RPN_M, 0);
	      (*Mf_parameter) (mchan, RPN_L, 0);
	      (*Mf_parameter) (mchan, DATA_ENTRY, 12);
	      curr_sensitivity[mchan] = 12;
	    }
	    range = 1200;
	  }
	  else {
	    if (curr_sensitivity[mchan] != 2) {
	      (*Mf_parameter) (mchan, RPN_M, 0);
	      (*Mf_parameter) (mchan, RPN_L, 0);
	      (*Mf_parameter) (mchan, DATA_ENTRY, 2);
	      curr_sensitivity[mchan] = 2;
	    }
	    range = 200;
	  }
	  new_bend = (curr_bender_range[channel] * v->pitchbender) / range;
	  new_bend += 8192;
	  if (new_bend > 8191) new_bend = 8191;
	  else if (new_bend < 0) new_bend = 0;
	  if (curr_bend[mchan] != new_bend)
	  (*Mf_pitchbend) (mchan,
	     new_bend&0x7f, 0x7f&(new_bend>>7));
	  curr_bend[mchan] = new_bend;
	}
    }

  if (v->volslide)
    {
      v->volume += v->volslide;
      sync_time ();

      if (v->volume > 127) v->volume = 127;
      /*SEQ_START_NOTE (gus_dev, channel, 255, v->volume);*/
	if (voices[channel].sample) {
	  (*Mf_parameter) (curr_sample[channel] % 16, EXPRESSION, v->volume/2);
	  curr_expression[curr_sample[channel] % 16] = v->volume/2;
	}
    }
}

void
play_module ()
{
  int             i, position, jump_to_pos;

  init_voices ();

  percsel = 0;
  *shm_percsel = 0;

#if 0
  for (i=0;i<32;i++)
  {
  	/*SEQ_EXPRESSION(gus_dev, i, 127);*/
  	/*SEQ_MAIN_VOLUME(gus_dev, i, 100);*/
  }
#endif
  next_time = 0.0;

  Mf_currtime = Mf_realtime = 0;

  (*Mf_trackstart) ();

#ifdef DEFAULT_MOD_REVERB
  for (i = 0; i < NUM_CHANS; i++)
    (*Mf_parameter) (i, REVERBERATION, DEFAULT_MOD_REVERB);
#endif
#ifdef DEFAULT_MOD_CHORUS_DEPTH
  for (i = 0; i < NUM_CHANS; i++)
    (*Mf_parameter) (i, CHORUS_DEPTH, DEFAULT_MOD_CHORUS_DEPTH);
#endif

  set_speed (6);

  for (position = 0; position < songlength; position++)
    {
      int             tick, pattern, channel, pos, go_to;

      pos = tune[position];
      if (pattern_tempo[position])
	set_speed (pattern_tempo[position]);

      jump_to_pos = -1;
      for (pattern = 0; pattern < pattern_len[position] && jump_to_pos == -1; pattern++)
	{
	  this_time = 0.0;

	  for (channel = 0; channel < nr_channels; channel++)
	    {
	      if ((go_to = play_note (channel, &(*pattern_table[pos])[channel][pattern])) != -1)
		  jump_to_pos = go_to;
	    }

	  next_time += tick_duration;

	  for (tick = 1; tick < ticks_per_division; tick++)
	    {
	      for (channel = 0; channel < nr_channels; channel++) {
		lets_play_voice (channel, &voices[channel]);
		lets_play_arpeggio (channel, tick);
	      }
	      next_time += tick_duration;
	    }

	}

      if (really_verbose && jump_to_pos >= 0 && Mf_realtime >= 500000)
	printf("can't jump to %d at %d\n", jump_to_pos, Mf_realtime);

      if (jump_to_pos >= 0 && Mf_realtime < 500000)
	position = jump_to_pos;
    }

  /*SEQ_WAIT_TIME ((int) next_time + 200);*/	/* Wait extra 2 secs */

#if 0
  for (i = 0; i < nr_channels; i++)
    SEQ_STOP_NOTE (gus_dev, i, 0, 127);
  SEQ_DUMPBUF ();
#endif
  next_time += 50;
  sync_time();
  for (i = 0; i < nr_channels; i++)
    if (voices[i].note) {
      (*Mf_noteon) (curr_sample[i] % 16, voices[i].note, 0);
      curr_note[ curr_sample[i] % 16 ] = 0;
    }

  for (i = 0; i < NUM_CHANS; i++)
	  if (curr_note[i]) {
	    (*Mf_noteon) (curr_program[i] % 16, curr_note[i], 0);
		fprintf(stderr, "yet another note off\n");
	    curr_note[i] = 0;
	  }

  for (i = 0; i < nr_patterns; i++)
    free (pattern_table[i]);
}



static void do_module()
{
  int j;

  /* play only on gus, if available */
  if (gus_dev >= 0) sb_dev = ext_dev = ext_index = -1;

  for (j = 0; j < MAX_PATTERN; j++)
    pattern_table[j] = NULL;

  if (load_module ())
    {
	tick_duration = 100.0 / clock_rate;
	play_module ();
    }
  else mferror("unknown file format");
}
