/*
 * ---------------------------------------------------------------------------
 * sfxserver/types.h
 *
 * Copyright by Terry Evans 1994
 * tevans@cs.utah.edu, tevans@slc.unisys.com
 * ---------------------------------------------------------------------------
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ---------------------------------------------------------------------------
 */

#ifndef _TYPES_H
#define _TYPES_H


typedef struct
{
  unsigned char *data;	/* unsigned 8-bit raw samples */
  int length;           /* length of sample in bytes  */
} sample_t;


typedef struct
{
  int position;         /* Current position into the file */
  float vol_left;       /* Left volume */
  float vol_right;      /* Right volume */
  int in_use;           /* Is the current channel in use? */
  sample_t *sample;     /* Current sample playing on this channel */
} channel_t;


typedef struct
{
  unsigned char *clipped;  /* Sound data to play */
  unsigned char *silence;  /* Just plain silence */
  int unclipped_l;         /* Unclipped raw data (left) */
  int unclipped_r;         /* Unclipped raw data (right) */
  int size;                /* Size of mixxed buffer */
} mix_t;


#endif /* _TYPES_H */
