/*
 * OS specific settings for ISC
 */
#ifndef _OS_H_
#define _OS_H_

#include <sys/types.h>
#include <sys/errno.h>
#include <sys/signal.h>
#include <sys/fcntl.h>
#include <sys/tty.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/inode.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/fs/s5dir.h>
#include <sys/file.h>
#include <sys/immu.h>
#include <sys/region.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/sysmacros.h>
#include <sys/dma.h>
#include <sys/wait.h>

#include "local.h"

#if NSND > 0
#define KERNEL_SOUNDCARD
#else
#undef KERNEL_SOUNDCARD
#endif

#ifdef CONFIGURE_SOUNDCARD

#undef ALLOW_SELECT
#define SHORT_BANNERS

#include "soundcard.h"

/* typedef struct uio snd_rw_buf; */
typedef char snd_rw_buf;

extern time_t lbolt;

#if 0
#define COPY_FROM_USER(target, source, offs, count) copyin(&((source)[offs]), (target), (count))
#define COPY_TO_USER(target, offs, source, count) copyout((source), &((target)[offs]), count)
#else
#define COPY_FROM_USER(target, source, offs, count) \
	if (copyin(&((source)[offs]), (target), (count))) { \
		printf ("snd: Bad copyin()!\n"); \
		return RET_ERROR(EIO); \
	}
#define COPY_TO_USER(target, offs, source, count) \
	if (copyout((source), &((target)[offs]), count)) { \
		printf ("snd: Bad copyout()!\n"); \
		return RET_ERROR(EIO); \
	}
#endif


#define IOCTL_FROM_USER(target, source, offs, count) copyin(&(((char *)source)[offs]), (target), (count))
#define IOCTL_TO_USER(target, offs, source, count) copyout((source), &(((char *)target)[offs]), (count))

#define GET_BYTE_FROM_USER(target, addr, offs)	target = fubyte(&((addr)[offs]))
#define GET_SHORT_FROM_USER(target, addr, offs)	copyin(&((addr)[offs]), (char*)&(target), 2)
#define GET_WORD_FROM_USER(target, addr, offs)	target = fuword(&((addr)[offs]))
#define PUT_WORD_TO_USER(addr, offs, data)	suword(data, &((addr)[offs]))

/*****
#define IOCTL_IN(arg)			(*(int*)arg)
******/
#define IOCTL_OUT(arg, ret)		*(int*)arg = ret
#define IOCTL_IN(arg)			fuword((int*)(arg))
/*****
#define IOCTL_OUT(arg, ret)		suword(ret, (int*)(arg))
******/

#define printk 		printf

extern int isc_sound_timeout(caddr_t arg);

#define REQUEST_TIMEOUT(ticks, wqueue)	\
 	      timeout(isc_sound_timeout, &(wqueue), lbolt + (ticks));
#define PROCESS_ABORTING ((u.u_procp)->p_sig)	/* Returns 1, if process has received
						   a signal which terminates it */
/* #define INTERRUPTIBLE_SLEEP_ON(on_what) 	sleep(&(on_what), PZERO+3) */
#define INTERRUPTIBLE_SLEEP_ON(A, F) { \
	int x; \
	x = spl6(); \
	A = F = 1; \
	sleep(&(A), PZERO + 8); \
	A = F = 0; \
	splx(x); \
	}
#define WAKE_UP(q)	{ q = 0; wakeup(&(q)); }

/*******
#define ALLOC_DMA_CHN(chn) dma_alloc(chn, DMA_BLOCK)
#define RELEASE_DMA_CHN(chn) dma_relse(chn)
********/
#define ALLOC_DMA_CHN(chn) (0)
#define RELEASE_DMA_CHN(chn) (0)

#define GET_TIME()	(lbolt)	/* Returns current time (1/HZ secs since boot) */

#define RELEASE_IRQ(irq_no)
#define DEFINE_WAIT_QUEUE(name, flag) static int *name = NULL; static int flag = 0
#define DEFINE_WAIT_QUEUES(name, flag) static int *name = {NULL}; static int flag = {0}

#define DMA_MODE_READ		0
#define DMA_MODE_WRITE		1

#ifndef HZ
extern int hz;
#define HZ	hz
#endif

#define DISABLE_INTR(flags)	flags = spl6()
#define RESTORE_INTR(flags)	splx(flags)

#define RET_ERROR(err)		-(err)

#define INB			inb
#define OUTB(addr, data)	outb(data, addr)
#define memcpy(d, s, c)		bcopy(s, d, c)

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

#define NO_INLINE_ASM

#endif
#endif
