/*
  Last updated : Thu Aug 18 18:00:11 1994
  Modified by JSP from code by Charles Hawkins <ceh@eng.cam.ac.uk>,

    J.S.Peatfield@amtp.cam.ac.uk

  Copyright (c) University of Cambridge, 1993,1994
*/

/* Standard headers */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <linux/if.h>
#include <linux/sockios.h>
#include <net/if_arp.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <getopt.h>
#include <stdlib.h>
#include <errno.h>

/* local headers */
#include "bootp.h"

/* These don't seem to be defined in the bootp.h header I have  20/06/94 JSP */
#define TAG_MERIT_DUMP    14
#define TAG_DOMAINNAME    15
#define TAG_SWAP_SERVER   16
#define TAG_ROOTPATH      17
#define TAG_EXTENSIONS    18

/* Back in NET2 (and before?) the ifreq.ifr_hwaddr was a char array,
   but in NET3 it is now a "sockaddr", and we need the data part.

   This detects the difference between the net2 and net3 structures,
   but note that code compiled on net3 will fail on net2, and that the
   net2 code will only work in net3 due to backwards compatability
   code which may disappear at some point.  Recompile bootpc when you
   switch to a kernel newer than 1.1.14 or so.

*/
#ifdef OLD_SIOCGIFHWADDR
#define NET3_HWADDR
#define use_hwaddr ifr_hwaddr.sa_data
#else
#define use_hwaddr ifr_hwaddr
#endif


/* Needed for getopt stuff */
extern char *optarg;
extern int optind, opterr, optopt;

/* My forward declarations */
void FatalError();

void ParseCookie(unsigned char *cookie,
		 unsigned char *match,
		 struct in_addr my_addr) ;

void PrintList(char *name,
	       unsigned char *cookie,
	       int pos,
	       int len) ;

void PrintString(char *name,
	       unsigned char *cookie,
	       int pos,
	       int len) ;

int in2host(char *address) ;

/* My global variables */
static int verbose = 0 ;   /* verbose mode or not 10/02/94 JSP */
static int debug   = 0 ;   /* debug mode or not 14/02/94 JSP */
static int subnet  = 0 ;   /* if we have seen a subnet TAG yet (sigh) */


int main(int argc,
	 char *argv[])
{
  int sockfd;
  struct sockaddr_in cli_addr, serv_addr;
  struct bootp bppdu;
  struct ifreq ifr;
  fd_set rfds, wfds, xfds;
  struct timeval timeout ;
  long rancopy ;
  struct in_addr temp_addr ;
  int retry_wait, waited;
  int one=1, i, givenhwaddr ;
  struct timeval tp;
  char *device, *bootfile, *server ;
/* See RFC1497, RFC1542  09/02/94   JSP  */
  unsigned char mincookie[] = {99,130,83,99,255} ;

/* defaults unless overridden by command line options 10/02/94  JSP */
  device = "eth0" ;             /* first ethernet card */
  bootfile = "" ;               /* No bootfile by default */
  server = "255.255.255.255" ;  /* i.e broadcast to everyone */
  givenhwaddr = 0 ;             /* i.e. use our real HW address */

/* Setting the default bootfile to "linux" seemed to cause problems for
   the CMU-2.1 bootpd, though I can't tell why, I don't run it here...
   Perhaps it really should default to "vmlinuz" ... 17/06/94  JSP
*/

  while (1) {
    int option_index = 0, option ;
    static struct option long_options[] = {
      {"bootfile", 1, 0, 1},
      {"dev", 1, 0, 2},
      {"verbose", 0, 0, 3},
      {"debug", 0, 0, 4},
      {"server", 1, 0, 5},
      {"hwaddr", 1, 0, 6},
      {"in2host", 1, 0, 10},
      {"help", 0, 0, 100},
      {0, 0, 0, 0},
    } ;

    option = getopt_long (argc, argv, "", long_options, &option_index);

    if (option == -1)
      break ;

    switch (option) {
    case 1:  /* New bootfile */
      bootfile = optarg ;
      if (strlen(bootfile) > 127) { /* buffer space for 128 only */
	if (verbose)
	  fprintf(stderr, "Bootfile %s too long, truncating\n", bootfile) ;
	bootfile[127] = 0;
      }
      break ;
    case 2:  /* New device */
      device = optarg ;
      if (strlen(device) > IFNAMSIZ-1) {  /* only IFNAMSIZ space in struct */
	if (verbose)
	  fprintf(stderr, "device name %s too long, truncating\n", device) ;
	device[IFNAMSIZ -1] = 0;
      }
      break ;
    case 3:
      verbose = 1 ;
      break ;
    case 4:
      debug = 1 ;
      break ;
    case 5:
      server = optarg ;
      break ;
    case 6:
      /* This MAY be useful for some types of debugging, however all
	 the bootpd programs I have reply to the hardware address
	 given here, thus we never see the replies.  Other bootpds may
	 not so it may be possible to use this to test a bootpd will
	 respond for another HW address.  17/08/94  JSP */
      { int error, count ;
	unsigned int value ;
	char cc ;

	for (i=0; i < IFHWADDRLEN; ++i) {  /* get the MAC address */
	  error = sscanf(optarg, "%2x%n%[ :.]%n", &value,&count,&cc,&count) ;
	  ifr.use_hwaddr[i] = value ;
	  if (error <= 0) {   /* Not enough given */
	    if (debug)
	      fprintf(stderr, "Ran out of numbers in hwaddr, ignoring\n") ;
	    break ;
	  }
	  optarg += count ;
	}
	givenhwaddr = 1 ;
      }
      break ;
    case 10:
      return in2host(optarg) ;
      break ;
    case 100:
      fprintf (stderr, "%s is used to find the IP number and other setup\n"
	      "information for a machine\n"
	      "\n", argv[0]) ;
    default:
      fprintf (stderr,
	       "Usage: %s\t[--dev device] [--bootfile file] [--verbose] [--server address] [--hwaddr mac-address]\n"
	       "\t\t[--in2host address]\n"
	       "\t\t[--help]\n", argv[0]) ;
      exit (1) ;
    }
  }

  if (verbose) {
    fprintf (stderr, "BOOTPclient v0.31\n") ;
    fprintf (stderr, "  device=%s  bootfile=%s\n\n",
	     device, bootfile ) ;
  }

/* zero structure before use */
  memset((char *) &serv_addr, 0, sizeof(serv_addr));

  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = inet_addr(server) ;
  serv_addr.sin_port = htons(IPPORT_BOOTPS);

  if((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    perror("bootpc: socket failed");
    FatalError();
  }
  
  if (setsockopt(sockfd,SOL_SOCKET,SO_BROADCAST,&one,sizeof(one))==-1) {
    perror("bootpc: setsockopt failed");
    FatalError();
  }
  
  memset((char *) &cli_addr, 0, sizeof(cli_addr));
  cli_addr.sin_family = AF_INET;
  cli_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  cli_addr.sin_port = htons(IPPORT_BOOTPC);

  if(bind(sockfd, (struct sockaddr *) &cli_addr, sizeof(cli_addr)) < 0) {
    perror("bootpc: bind failed");
    FatalError();
  }

/* Don't do this if we were given the MAC address to use 17/08/94  JSP */
  if (givenhwaddr == 0) {
/* Get the hardware address */
    memcpy(ifr.ifr_name, device, strlen(device)+1);
    if(ioctl(sockfd, SIOCGIFHWADDR, &ifr) < 0) {
      perror("bootpc: ioctl failed");
      FatalError();
    }

#ifdef NET3_HWADDR
/* Check the hardware ARP type if in NET3 or later, currently only Ethernet
   ARPHRD_ETHER is supported by this bootpc program.  20/06/94  JSP
*/

    if (ifr.ifr_hwaddr.sa_family != ARPHRD_ETHER) { /* Not ethernet */
      fprintf(stderr, "Device not ethernet family, got %d family not %d\n",
	      ifr.ifr_hwaddr.sa_family, ARPHRD_ETHER) ;
      FatalError() ;
    }
#endif  /* NET3_HWADDR */
  }

/* If we have the time seed with it xor the hardware address, otherwise
   use the hardware address 12/02/94 JSP */
  if (gettimeofday(&tp, NULL) == -1)
    rancopy = 0 ;
  else
    rancopy = tp.tv_sec + tp.tv_usec ;

/* Do the XOR */
  for (i=0; i < IFHWADDRLEN ; ++i) {
    ((unsigned char *)&rancopy)[ i % sizeof(rancopy) ] ^=
      ((unsigned char *)(ifr.use_hwaddr))[i] ;
  }
/* and set the seed */
  srand(rancopy) ;

  if(debug) {
    fprintf(stderr, "hardware addr is :") ;
    for (i=0; i < IFHWADDRLEN ; ++i)
      fprintf (stderr, "%2.2X ", ((unsigned char *)(ifr.use_hwaddr))[i]) ;
    fprintf(stderr, "\n") ;
  }

/* zero structure before use */
  memset((char *) &bppdu, 0, sizeof(bppdu)) ;

/* Now fill in the packet. */
  bppdu.bp_op = BOOTREQUEST ;
  bppdu.bp_htype = ARPHRD_ETHER ; /* 10Mb/s Ethernet */
  bppdu.bp_hlen = IFHWADDRLEN ;   /* Mac Addresses are alway the same length */
  memcpy(bppdu.bp_chaddr, (ifr.use_hwaddr), IFHWADDRLEN) ;
  bppdu.bp_secs = 0;  /* Must start with zero here, see RFC1542 09/02/94 JSP */

/* Put in the minimal RFC1497 Magic cookie 09/02/94 JSP */
  memcpy(bppdu.bp_vend, mincookie, sizeof(mincookie));
/* Put the user precified bootfile name in place 12/02/94 */
  memcpy(bppdu.bp_file, bootfile, strlen(bootfile)+1);

  retry_wait = 2 ;
  if (verbose)
    fprintf(stderr,"BOOTPclient broadcast...\n");
  while (retry_wait <= 64){
  
/* putf a random value in here, but keep a copy to check later 09/02/94  JSP */
    bppdu.bp_xid = rancopy = rand() ;
    if (verbose) {
      fprintf(stderr,".");
      fflush(stderr);
    }

    if(sendto(sockfd, &bppdu, sizeof(bppdu), 0, 
	      (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
      perror("bootpc: sendto");
      FatalError();
    }
    
    FD_SET(sockfd,&rfds);
    FD_ZERO(&wfds);
    FD_ZERO(&xfds);

/* Randomise the delays a little as suggested in RFC1542  09/02/94  JSP */
    timeout.tv_sec = waited = retry_wait + (1+(rand() & (retry_wait-1))) ;
    timeout.tv_usec = 0;
    
    if(select(sockfd+1, &rfds, &wfds, &xfds, &timeout)<0) {
      perror("bootpc: select");
      FatalError();
    }

    if(!FD_ISSET(sockfd, &rfds)) {
      bppdu.bp_secs += waited ;  /* add time of this timeout  09/02/94  JSP */
      retry_wait = retry_wait*2;
    } else{
      if (recvfrom(sockfd, &bppdu, sizeof(bppdu), 0,
		   (struct sockaddr *)0, (int *)0) < 0){
	perror("bootpc: recvfrom");
	FatalError();
      }
      
/* Check xid is what we asked for  09/02/94  JSP */
      if (bppdu.bp_xid != rancopy) {
	fprintf(stderr, "WARNING bp_xid mismatch\n") ;
	/* Should we quit here, ignore the packet or carry on??? */
      }

      temp_addr.s_addr = bppdu.bp_siaddr.s_addr ;
      printf("SERVER=%s\n", inet_ntoa(temp_addr));

      temp_addr.s_addr = bppdu.bp_yiaddr.s_addr ;
      printf("IPADDR=%s\n", inet_ntoa(temp_addr));

/* Pass the cookie info, the mincookie to look for and our address to
   the cookie parser.  It needs our address to get the network and
   broadcast bits right if the SUBNET is defined in the cookie.
   10/02/94  JSP */

      ParseCookie((unsigned char *)&bppdu.bp_vend,
		  mincookie, temp_addr) ;

/* No SUBNET TAG in the cookie so we fake guess here */
      if (!subnet) {
	struct in_addr network ;
	int type ;
	
	if (verbose)
	  fprintf(stderr, "Guessing network from IP number\n") ;

	type = ntohl(temp_addr.s_addr) ;
	if ((type & 0x80000000) == 0) {
	  /* Class A */
	  network.s_addr = htonl(0xFF000000) ;
	} else if ((type & 0x40000000) == 0) {
	  /* Class B */
	  network.s_addr = htonl(0xFFFF0000) ;
	} else if ((type & 0x20000000) == 0) {
	  /* Class C */
	  network.s_addr = htonl(0xFFFFFF00) ;
	} else { /* GOD KNOWS... other classes are weird */
	  if (verbose)
	    fprintf(stderr, "IP number not Class A,B or C,\n"
		    "setting NETMASK to zero\n") ;
	  network.s_addr = htonl(0x00000000) ;
	}
	temp_addr.s_addr &= network.s_addr ;
	printf("NETWORK=%s\n", inet_ntoa(temp_addr));
	temp_addr.s_addr |= ~network.s_addr ;
	printf("BROADCAST=%s\n", inet_ntoa(temp_addr));
      }

      exit(0);
    }
  }
  fprintf(stderr, "\nNo response from BOOTP server\n");
  FatalError();

  return 0 ;  /* Never reached */
}
    
void FatalError()
{
  if (debug)
    fprintf(stderr, "In FatalError(), errno was %d\n", errno) ;

  fprintf(stderr,
	  " Unable to locate an IP address for this host.\n"
	  "     ***Please report this problem**\n\n"
	  "          [Unable to continue]\n\n");

  if (debug)
    fprintf(stderr, "Will now loop forerver, break out of this to fix\n\n") ;

  while(1) {
    /* your eyes are getting heavy.... */
    sleep(1000) ;
  }
}

/* Parse Magic cookies as specified in RFC1497, well only the bits we
   are actually interested in...  09/02/94 JSP
*/
void ParseCookie(unsigned char *cookie,
		 unsigned char *match,
		 struct in_addr my_addr)
{
  int i=0, len ;
  struct in_addr temp ;

  if (debug) {  /* dump cookie contents in HEX 10/02/94  JSP */
    for (i=0; i<64; i++) {
      if ((i%8) == 0)
	fprintf(stderr, "\n %2.2d :", i) ;
      fprintf(stderr, " 0x%2.2X", cookie[i]) ;
    }
    fprintf(stderr, "\n") ;
  }

/* Must get the same cookie back as we sent  09/02/94  JSP */
  for (i=0; i < 4; ++i) {
    if (cookie[i] != match[i]) {
      if (verbose)
	fprintf(stderr, "RFC1497 Cookie mismatch at offset %d\n", i) ;
      return ;
    }
  }

  if (verbose)
    fprintf(stderr, "found valid RFC1497 cookie, parsing...\n") ;

/* Carry on after the cookie for other data  09/02/94  JSP */
  while (i < 64) {
    if (verbose)
      fprintf(stderr, "cookie position %d is %d\n", i, cookie[i]) ;

    switch (cookie[i]) {  /* The monster switch statement ... */
/* PAD cookie */
    case TAG_PAD :
      i++ ;
      break ;

/* SUBNET we are in */
    case TAG_SUBNET_MASK :
      if (verbose && cookie[i+1] != 4)
	fprintf(stderr, "WARNING len of tag 1 is %d not 4\n", cookie[i+1]) ;
      memcpy((char *)&temp, cookie + i + 2, 4) ;
      printf("NETMASK=%s\n", inet_ntoa(temp)) ;

/* Both values are in network order so this doesn't care about the
   ordering 10/02/94 JSP */
      my_addr.s_addr &=  temp.s_addr ;
      printf("NETWORK=%s\n", inet_ntoa(my_addr)) ;
      my_addr.s_addr |= ~temp.s_addr ;
      printf("BROADCAST=%s\n", inet_ntoa(my_addr)) ;

/* defined so we know later that subnet info has been printed 11/02/94  JSP */
      subnet = 1 ;
      i += 6 ;
      break ;

/* Time of day (ignored) */
    case TAG_TIME_OFFSET :
      i += 5 ;
      break ;

/* IP Gateways (routers) */
    case TAG_GATEWAY :
      len = cookie[i+1] ;
      PrintList("GATEWAYS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* Timeservers (see RFC-868) */
    case TAG_TIME_SERVER :
      len = cookie[i+1] ;
      PrintList("TIMESRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* IEN-116 Nameservers */
    case TAG_NAME_SERVER :
      len = cookie[i+1] ;
      PrintList("IEN116SRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* DNS Nameservers */
    case TAG_DOMAIN_SERVER :
      len = cookie[i+1] ;
      PrintList("DNSSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* LOGGING servers */
    case TAG_LOG_SERVER :
      len = cookie[i+1] ;
      PrintList("LOGSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* Quote of day/Cookie servers */
    case TAG_COOKIE_SERVER :
      len = cookie[i+1] ;
      PrintList("QODSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* LPR servers */
    case TAG_LPR_SERVER :
      len = cookie[i+1] ;
      PrintList("LPRSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* Impress (Imogen) servers */
    case TAG_IMPRESS_SERVER :
      len = cookie[i+1] ;
      PrintList("IMPRESSSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* Remote Location Protocol servers */
    case TAG_RLP_SERVER :
      len = cookie[i+1] ;
      PrintList("RLPSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* HOSTNAME (may be fqdn or leaf) */
    case TAG_HOSTNAME :
      len = cookie[i+1] ;
      PrintString("HOSTNAME", cookie, i+2, len) ;
      i += len + 2 ;
      break ;

/* BOOT File Size (ignored) */
    case TAG_BOOTSIZE :
      i += 3 ;
      break ;

/* Merit DUMP File name (ignored) */
    case TAG_MERIT_DUMP :
      len = cookie[i+1] ;
      i += len + 2 ;
      break ;

/* DOMAIN */
    case TAG_DOMAINNAME :
      len = cookie[i+1] ;
      PrintString("DOMAIN", cookie, i+2, len) ;
      i += len + 2 ;
      break ;

/* SWAPServer address */
    case TAG_SWAP_SERVER :
      memcpy((char *)&temp, cookie + i + 2, 4) ;
      printf("SWAPSRVR=%s\n", inet_ntoa(temp)) ;
      i += 5 ;
      break ;

/* Root pathname to mount as root filesystem (ignored) */
    case TAG_ROOTPATH :
      len = cookie[i+1] ;
      i += len + 2 ;
      break ;

/* Extensions.  Name of further Cookie data (ignored) */
    case TAG_EXTENSIONS :
      len = cookie[i+1] ;
      i += len + 2 ;
      break ;

/* END of cookie (phew) */
    case TAG_END :
      if (verbose)
	fprintf(stderr, "end of cookie parsing, END tag found\n") ;
      return ;

    default:
      if (cookie[i] >= 128 && cookie[i] <= 254) {  /* reserved */
	if (verbose)
	  fprintf(stderr, "reserved TAG %d at %d (len %d) ignored\n",
		  cookie[i], i, cookie[i+1]) ;
	i += 2 + cookie[i+1] ;  /* skip reserved TAG (as per RFC1497)  JSP */
      } else if (verbose) {
	fprintf(stderr, "Not understood TAG %d at %d\n", cookie[i], i) ;
      }
      ++i ;
      break ;
    }
  }
}

/* Print out a list of IP numbers */
void PrintList(char *name,
	       unsigned char *cookie,
	       int pos,
	       int len)
{
  struct in_addr temp ;

  if (verbose)
    fprintf(stderr, "%s found len=%d\n", name, len) ;

  if ((len % 4) != 0) {
    if (verbose)
      fprintf (stderr, "ERROR %s length (%d) not 4 div\n", name, len) ;
    return ;
  }
  if (len == 0) /* Nothing to do  10/02/94  JSP */
    return ;

  printf("%s=\"", name) ;
  for ( ; len; len -= 4, pos += 4) {
    memcpy((char *)&temp, cookie + pos, 4) ;
    printf("%s", inet_ntoa(temp)) ;
    if (len > 4)
      putchar(' ') ;
  }
  printf("\"\n") ;
}

/* Prints the string passed */
void PrintString(char *name,
	       unsigned char *cookie,
	       int pos,
	       int len)
{
  printf("%s=\"", name) ;
  for (; len ; ++pos, --len) {
    putchar(cookie[pos]) ;
  }
  printf ("\"\n") ;
}

/* Takes an address and returns useful bits of the name after lookup,
   this was a seperate program, but it is more compact to have both
   together.  17/02/94  JSP */

int in2host(char *address)
{
  struct in_addr sin_addr;
  struct hostent *hp;
  char *c ;

/* convert to standard network form */
  sin_addr.s_addr = inet_addr(address);

/* perform lookup, must have DNS running or have local hosts file at
   this point */

  hp = gethostbyaddr((char *)&sin_addr, sizeof(sin_addr), AF_INET) ;

  if (hp == NULL) {
    perror ("bootpc: gethostbyaddr") ;
    return -1;
  }

/* Print out a known name to stop repeated calls */
  printf("DONEIN2HOST=1\n") ;

/* Print out full name as returned by the call */
  printf("HOSTFULL=%s\n", hp->h_name) ;

  for(c=(char *)hp->h_name; *c ; ++c)
    if(*c == '.') {
/* Zap first 'dot' to give leaf and domain names */
      printf("HOSTDOMAIN=%s\n", c+1) ;
      *c = 0 ;
      printf("HOSTLEAF=%s\n", hp->h_name) ;
      return 0 ;
    }
  return 0 ;
}
