#include <stdio.h>
#include "file2.h"
#include <malloc.h>
#include "internal.h"
#include <trace.h>

/************************************************************************
 *
 * Function:    _getbuf
 *
 * Description: This routine will allocate a buffer for the indicated file.
 *
 * Input:       stream - a pointer to the file to be allocated
 *
 * Output:      none.
 */

void _getbuf (FILE *stream)
    {
    FUNC_ENTRY ("_getbuf");
/*
 *  Try to allocate a large buffer
 */
    stream->_ptr  =
    stream->_base = (unsigned char *) malloc (BUFSIZ);
    stream->_cnt  = 0;
/*
 *  If there is no buffer available then make the file unbuffered
 */
    if (stream->_base != NULL)
        {
	stream->_flag |= _IOFREEBF;
	set_buf_size(stream, BUFSIZ);
        }
/*
 *  A buffer could not be allocated. Use the single character buffer
 */
    else
        {
	stream->_flag |= _IONBF;
	set_buf_size(stream, 0);
        }

    FUNC_EXIT ("_getbuf");
    }
