/*
 * Program to query an AT&T GIS (formerly NCR) WaveLAN PCMCIA card
 *
 * /usr/src/pc/cardmgr/RCS/waveinfo.c,v 1.1 1996/07/19 05:23:46 root Exp
 *
 ****************************************************************************
 *   Copyright 1995
 *   Anthony D. Joseph
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.         
 ****************************************************************************
 *
 * RCS revisions:
 * waveinfo.c,v
 * Revision 1.1  1996/07/19 05:23:46  root
 * Initial revision
 *
 * Revision 1.0  1995/04/24  05:42:35  adj
 * Alpha release
 *
 * Revision 0.10  1995/04/16  00:26:23  adj
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <linux/fs.h>
#include <sys/types.h>
#include <unistd.h>

static const char *version =
    "waveinfo.c 1.1 1996/07/19 05:23:46 (Anthony Joseph)";

/*======================================================================

  Finds the major device number for the WaveLAN device. If the device
  is found, it is opened and a file handle is returned. Otherwise, -1
  is returned.
    
======================================================================*/

static inline int OpenWaveLAN(void)
{
  FILE *file;
  char line[256], dname[256], *name;
  int dev, fd;
  int found = 0;
    
  /* Open the list of major devices */
  file = fopen("/proc/devices", "r");
  if (file == NULL) {
    fprintf(stderr, "Unable to open /proc/devices\n");
    return(-1);
  }

  /* Scan the file looking for the device name */
  while (!found && (fgets(line, 256, file) != NULL))
    if (sscanf(line, "%d %s", &dev, dname) == 2) /* Look for "# name" lines */
      if (strcmp("wavelan", dname) == 0) found = 1;
  fclose(file);

  if (!found) {
    fprintf(stderr, "No wavelan device found in /proc/devices\n");
    return (-1);
  }
 
  /* Create a temporary character mode special node */
  if ((name = tmpnam(NULL)) == NULL) {
    fprintf(stderr, "Unable to create temporary filename\n");
    return(-1);
  }
  if (mknod(name, (S_IFCHR|S_IREAD|S_IWRITE), MKDEV(dev, 0)) != 0) {
    fprintf(stderr, "Unable to perform mknod\n");
    return(-1);
  }
  fd = open(name, O_RDONLY);	/* Open the temporary node */
  unlink(name);			/* Delete the temporary node */
  return(fd);
} /* OpenWaveLAN */

void main(int argc, char *argv[])
{
  int rc;
  char buf[4096];
  int fd = OpenWaveLAN();

  if (fd < 0) exit(-1);
  if (((rc = read(fd, &buf, 4096)) == -1) && (errno != EAGAIN))
    fprintf(stderr, "Error reading WaveLAN device: %d\n", errno);
  else
    printf("%s\n", buf);
}
