/* config.h, Version 1.0.1, 25/3/1993 by Stewart Forster */

/************************************************************************/
/*   Copyright (C) 1993 Stewart Forster					*/
/*  This program is free software; you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation; either version 2, or (at your option) */
/*  any later version.							*/
/*									*/
/*  This program is distributed in the hope that it will be useful,	*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of	*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	*/
/*  GNU General Public License for more details.			*/
/*									*/
/*  You should have received a copy of the GNU General Public License	*/
/*  along with this program; if not, write to the Free Software		*/
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*/
/************************************************************************/


/************************************************************************/
/*	OS TYPE DEFINITION						*/
/* Define one of the following where appropriate			*/
/************************************************************************/

#define LINUX 
/* #define	SUNOS		 */
/* #define	IRIX	 */
/* #define	ULTRIX		 */

/************************************************************************/
/* SUNOS requires the pstat command to be available.  This is part of 	*/
/* the SunOs distribution but fix this following path if it's wrong.	*/
/************************************************************************/

#ifdef SUNOS
#define	PSTATI	"/usr/etc/pstat -i"
#endif

/************************************************************************/
/* PATHUNTCX is the pathname where the untcx executable resides.  Note	*/
/* that this is the interpreter/unpacker and hence must exist with this	*/
/* path, or else the whole system will fail! This path should also be on*/
/* a filesystem which the local system trusts setuid binaries from,	*/
/* since PATHUNTCX must run setuid to root.				*/
/************************************************************************/

#define	PATHUNTCX	"/usr/local/bin/untcx"

/************************************************************************/
/* PATHTCX is the pathname to the tcx executable.  This does not have to*/
/*  be installed setuid.						*/
/************************************************************************/

#define	PATHTCX		"/usr/local/bin/tcx"

/************************************************************************/
/* PATHPACKER is the pathname to the compression program you wish to use*/
/* with the system. PACKEROPTS is an optional definition of options you	*/
/* wish to pass to the packer program. NB. The compression program must	*/
/* be a `filter', that is, it is capable of reading from stdion and	*/
/* compressing to stdout.						*/
/************************************************************************/

#define	PATHPACKER	"/usr/bin/gzip"
#define	PACKEROPTS	"-7"			/* Optional */

/************************************************************************/
/* PATHUNPACK and the optional UNPACKOPTS serve a similar purpose to	*/
/* PATHPACKER and PACKEROPTS above. */
/************************************************************************/

#define	PATHUNPACK	"/usr/bin/gunzip"
/* #define	UNPACKOPTS	"-d"	*/		/* Optional */

/************************************************************************/
/* ENFSDIR is the pathname to the directory where emergency (out of disk*/
/* space locally) or NFS mounted executables get unpacked to.		*/
/* On SUNOS, if you are using the "tmpfs", you will have to set ENFSDIR	*/
/* to a "real disk". (A "real disk" may also be an NFS mounted partition*/
/* to which the machine has root access to).  There seems to be some	*/
/* problem with fcntl locks on SUNOS tmpfs.				*/
/************************************************************************/

#define	ENFSDIR		"/tmp/exec"

/************************************************************************/
/* SCANRATE is the interval in seconds which the tcx daemon waits before*/
/* rescanning all files it is currently managing, for recompression in	*/
/* the case of local files, or deletion from ENFSDIR in the case of 	*/
/* emergency or NFS mounted executables.  Note that SCANRATE should	*/
/* probably not be larger than ENFSTIMEOUT or LOCALTIMEOUT defined	*/
/* below, otherwise you will undermine the purpose of those variables.	*/
/************************************************************************/

#define	SCANRATE	60		/* 60 seconds between scans */

/************************************************************************/
/* ENFSTIMEOUT is the least number of seconds of disuse of an executable*/
/* residing in ENFSDIR the tcx daemon will wait for, before it attempts	*/
/* to delete the executable. This should be set quite low if there isn't*/
/* much disk space available in ENFSDIR.				*/
/* On SUNOS, this value only sets in after the inode is timed out of the*/
/* inode cache.  This problem will be addressed in a future release.	*/
/************************************************************************/

#define	ENFSTIMEOUT	60		/* 60 seconds of inactivity */

/************************************************************************/
/* LOCALTIMEOUT is the least number of seconds of disuse of an		*/
/* executable residing locally on the system that the tcx will wait	*/
/* before attempting to repack the executable.				*/
/* On SUNOS, this value only sets in after the inode is timed out of the*/
/* inode cache.  This problem will be addressed in a future release.	*/
/************************************************************************/

#define	LOCALTIMEOUT	150		/* 2.5 minutes */

/************************************************************************/
/************************************************************************/
/* You should not need to edit anything after this point		*/
/************************************************************************/
/************************************************************************/

#define	MAXHEADERSIZE	256

/* Define PUSLEEP (portable usleep definition)	*/

#ifdef	IRIX
#define _BSD_SIGNALS
#define	PUSLEEP(x)	(sginap((long)((x)/10000)))
#endif

#ifdef	ULTRIX
#define	PUSLEEP(x)	(usleep(x))	/* usleep code in untcx.c */
#endif

#ifdef	SUNOS
#define	PUSLEEP(x)	(usleep(x))
#endif

#ifdef LINUX
#define	PUSLEEP(x) (usleep(x))
#endif

#include	<stdlib.h>
#include        <unistd.h>
#include        <sys/time.h>
#include        <sys/wait.h>
#include        <sys/types.h>

#ifdef ULTRIX
#include	<sys/param.h>
#include	<sys/mount.h>
#endif

#ifdef LINUX
#include		<sys/vfs.h>
#endif

#ifdef IRIX
#include        <sys/statfs.h>
#endif

#ifdef SUNOS
#include        <sys/vfs.h>
#endif

#include        <sys/stat.h>

#include	<fcntl.h>
#include        <string.h>
#include        <errno.h>
#include        <signal.h>
#include        <stdio.h>

#if defined(SUNOS) || defined(ULTRIX) || defined(LINUX)
#include	<utime.h>
#endif

#ifndef	MAXPATHLEN
#define	MAXPATHLEN	1024
#endif
