#
# unix/Common.mk.in  --
#
# Common macro definitions used by all include files.
#------------------------------------------------------------------------------
# Copyright 1995-1996 Karl Lehenbauer and Mark Diekhans.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  Karl Lehenbauer and
# Mark Diekhans make no representations about the suitability of this
# software for any purpose.  It is provided "as is" without express or
# implied warranty.
#------------------------------------------------------------------------------
# $Id: Common.mk.in,v 5.16 1996/04/25 14:32:40 markd Exp $
#------------------------------------------------------------------------------
#

SHELL = /bin/sh

#------------------------------------------------------------------------------
# TclX version information extracted from tclExtend.h.
#
TCLX_VERSION       = 7.5.0
TCLX_FULL_VERSION  = 7.5.0
TCLX_SHLIB_VERSION = 1.7.5

TKX_VERSION        = 4.1.0
TKX_FULL_VERSION   = 4.1.0
TKX_SHLIB_VERSION  = 1.4.1

#------------------------------------------------------------------------------
# Autoconfig defines that can be overridden in Config.mk.
#
CC           = cc
CFLAGS       = 
RANLIB       = ranlib
srcbasedir   = /usr/src/tclX7.5.0
bldbasedir   = /usr/src/tclX7.5.0
prefix       = /usr
exec_prefix  = /usr
ARCH         = 

#------------------------------------------------------------------------------
# TclX configuration information determined by configure.
#
BUILD_SHARED = YES
TKX_BUILD    = YES
TCLX_DEFS    =  -DNO_SYS_SELECT_H=1 -DSTDC_HEADERS=1 -DRETSIGTYPE=void 
TCLX_LIBS    = 

#------------------------------------------------------------------------------
# Shared library names if BUILD_SHARED is YES.  Base name is the name of
# the library less the version, for dynamic loading.
#
TCLX_SHLIB_BASE_NAME = libtclx.so.1
TCLX_SHLIB_NAME      = libtclx.so.1.7.5
TKX_SHLIB_BASE_NAME  = libtkx.so.1
TKX_SHLIB_NAME       = libtkx.so.1.4.1

#------------------------------------------------------------------------------
# Configuration information from tclConfig.sh and tkConfig.sh. The
# TCL_USE_SHLIBS_CFLAGS is defined to be either the value of TCL_SHLIB_CFLAGS
# of a non-existant macro to be empty.  We don't want to compile with the
# shared library flags if we are not linking shared libraries, as this breaks
# some systems (Linux).
#
TCL_DEFS             =  -DHAVE_UNISTD_H=1 -DHAVE_SYS_TIME_H=1 -DTIME_WITH_SYS_TIME=1 -DHAVE_TZNAME=1 -DHAVE_TIMEZONE_VAR=1 -DSTDC_HEADERS=1 -Dvfork=fork 
TCL_LIBS             = -ldl  -lieee -lm
TCL_SHLIB_CFLAGS     = -fPIC
TCL_USE_SHLIB_CFLAGS = ${TCL_SHLIB_CFLAGS}
TCL_LD_FLAGS         = -rdynamic
TCL_DL_LIBS          = -ldl
TCL_SHLIB_LD         = cc -shared
TCL_BUILD_LIB_SPEC   = -L/usr/src/tcl7.5/unix -ltcl
TCL_LIB_SPEC         = -L/usr/lib -ltcl

TK_DEFS              =  -DHAVE_UNISTD_H=1 -DHAVE_LIMITS_H=1 -DSTDC_HEADERS=1 
TK_LIBS              = -L/usr/X11R6/lib -lX11 -ldl  -lieee -lm
TK_XINCLUDES         = # no special path needed
TK_XLIBSW            = -L/usr/X11R6/lib -lX11
TK_BUILD_LIB_SPEC    = -L/usr/src/tk4.1/unix -ltk
TK_LIB_SPEC          = -L/usr/lib -ltk

#------------------------------------------------------------------------------
# Location of directories.
#
TCL_GENERIC_DIR    = ${TCL_SRC}/generic
TCL_UNIX_DIR       = ${TCL_SRC}/unix
TCL_LIBRARY_DIR    = ${TCL_SRC}/library
TK_GENERIC_DIR     = ${TK_SRC}/generic
TK_UNIX_DIR        = ${TK_SRC}/unix

TCLX_GENERIC_DIR   = ${srcbasedir}/tcl/generic
TCLX_UNIX_SRC_DIR  = ${srcbasedir}/tcl/unix
TCLX_UNIX_BLD_DIR  = ${bldbasedir}/tcl/unix
TKX_GENERIC_DIR    = ${srcbasedir}/tk/generic
TKX_UNIX_SRC_DIR   = ${srcbasedir}/tk/unix
TKX_UNIX_BLD_DIR   = ${bldbasedir}/tk/unix
COMPAT_DIR         = ${srcbasedir}/tcl/compat

#------------------------------------------------------------------------------
# Programs run during the build.
#
TCLX_TMP_RUNTIME   = ${bldbasedir}/tcl/unix
TKX_TMP_RUNTIME    = ${bldbasedir}/tk/unix

RUNTCL             = ${bldbasedir}/unix/runtcl
RUNWISHX           = ${bldbasedir}/unix/runwishx
GENTNDX            = ${RUNTCL} ${srcbasedir}/unix/tools/genindex.tcl
BLDMANHELP         = ${RUNTCL} ${bldbasedir}/unix/tools/bldmanhelp
CONVERTLIB         = ${RUNTCL} ${srcbasedir}/unix/tools/libconvert.tcl
INSTCOPY           = ${RUNTCL} ${bldbasedir}/unix/tools/instcopy
CPMANPAGES         = ${RUNTCL} ${bldbasedir}/unix/tools/cpmanpages

#------------------------------------------------------------------------------
# Install directories for public files.  The value is determined by the
# --with-master configure flag.

TCLX_INST_BIN  = ${TCLX_BIN}
TCLX_INST_LIB  = ${TCLX_LIB}
TCLX_INST_INCL = ${TCLX_INCL}
TCLX_INST_MAN  = ${TCLX_MAN}

TKX_INST_BIN  = ${TCLX_BIN}
TKX_INST_LIB  = ${TCLX_LIB}
TKX_INST_INCL = ${TCLX_INCL}
TKX_INST_MAN  = ${TCLX_MAN}
