/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#ifndef CONFIG_H
#define	CONFIG_H

/*
 * If non-root users shall be restricted to their own directories
 */
/*
 * #define RESTRICTED_DIRS
 */

/*
 * Default Icon Font
 */
#define	DEFAULT_ICON_FONT	"8x13"

/*
 * distances for the icon-placement in windows. Change them if you need a bigger
 * font.
 */
#define	DIR_X_STEP	30
#define	DIR_Y_STEP	20

/*
 * time between mouseclicks to be taken as doubleclicks
 */
#define	MAX_INTERVAL	300

/*
 * How many Directory-windows can be opened. Used for a static field.
 * I think 50 may never be reached, because you will never find anything
 * on a desktop with 50 windows. (Only used in multi-window-mode)
 */
#define	MAX_FOLDERS	50

/*
 * Where to put all the files in case of a secure_remove
 */
#define	DEFAULT_TRASHCAN	NULL

/*
 * Quotas are only supported on hpux at this time. Cause it's system depened,
 * I will only head a way to implement them.
 * Look at main.c. The last function displays the quotas.
 */
#ifdef hpux
#define	HAS_QUOTA
#define	QUOTA_DEV	"/dev+/localroot/dsk/5s8"
#endif
#ifdef linux
#define	HAS_QUOTA
#endif

/*
 * To force the displaying of the usersright and username in directory-windows
 * insert #define SHOWRIGHTS below
 * Note: This can slow down the update-rate of directory windows rapidly.
 */
/* #define	SHOWRIGHTS */

/*
 * Default Iconpath - can be changed by using X11-Resources
 * Be aware that you insert the / at the end of path
 */
#ifdef hpux
#define	ICON_DIR	"/users/kalkan/src/xfilemanager/icons/%N"
#else
#define	ICON_DIR	"~/icons/%N:/usr/X11/include/X11/pixmaps/%N:/usr/X11/include/X11/bitmaps/%N:/var/lib/xfilemanager/icons/%N"
#endif

/*
 * Default Workspace file. e.g. /usr/local/lib/xfilemanager/system.wsrc
 */
#ifdef hpux
#define	DEFAULT_WORKSPACE	"/users/kalkan/src/xfilemanager/system.wsrc"
#else
#define	DEFAULT_WORKSPACE	"/var/lib/xfilemanager/system.wsrc"
#endif

/*
 * Default Filetypes file. e.g. /usr/local/lib/xfilemanager/system.xfmrc
 */
#ifdef hpux
#define	DEFAULT_FILETYPES	"/users/kalkan/src/xfilemanager/system.xfmrc"
#else
#define	DEFAULT_FILETYPES	"/var/lib/xfilemanager/system.xfmrc"
#endif

/*
 * Default Custom-Menu e.g. /usr/local/lib/xfilemanager/system.xfmmenurc"
 */
#ifdef hpux
#define	DEFAULT_CUSTOM		"/users/kalkan/src/xfilemanager/system.xfmmenurc"
#else
#define	DEFAULT_CUSTOM		"/var/lib/xfilemanager/system.xfmmenurc"
#endif

/*
 * The fileaction commands - perhaps systemdependent.
 */
#define	MOVE_CMD	"mv -f"
#define	COPY_CMD	"cp -fR"
#define	RM_CMD		"rm -rf"
#define	MKDIR_CMD	"mkdir -p"
#define	LINK_CMD	"ln -sf"

/*
 * If you are using X11R4 - try this bugfix
 * #define X11R4
 * Insert the define above before the next ifdef
 * Note: This may not fix all problems when compiling with X11R4, but it
 * 	 might be a way to fix them.
 * I compiled and tested the program with X11R4 now and didn't find anything
 * unusual. Some people reported about a widget vertical that has a zero
 * width and/or height. The reasom may lie in the X11R4 package, cause the
 * widget is used by the viewport-widget. Try to fix this bug by inserting
 * *vertical.width: 14
 * *vertical.height:14
 * *horizontal.width: 14
 * *horizontal.height:14
 * into the app-defaults file. (I don't know whether it works or not, but
 * you can try it).
 * Normaly all sizes of viewports are set, before they are realized, so
 * vertical should have a legal size as well.
 */

#ifdef X11R4
#define	XawChainBottom	XtChainBottom
#define	XawChainTop	XtChainTop
#define	XawChainLeft	XtChainLeft
#define	XawChainRight	XtChainRight
#endif

/*
 * File that contains the list of mountable devices
 * DON'T USE IT NOW - IT ONLY SHOWS A LITTLE BOX WITH SOME
 * DEVICENAMES AND SAYS IF IT'S MOUNTED.
 * IT'S STILL UNDER CONSTRUCTION.
 */
#ifdef linux
#define	DEVICE_LIST	"/usr/src/aegis/xfilemanager/system.devrc"
#else
#define	DEVICE_LIST	"/not_existing"	/* A file that absolutly doesn't exist */
#endif

/*
 * Some defines for coherent unix, because this system doesn't know links
 */
#ifdef COHERENT
#define	lstat(a,b)	stat(a,b)
#define	S_ISLNK(a)	0
#endif

#ifdef NODIRENT
#define	dirent	direct
#endif

#ifdef ISC
#include <sys/bsdtypes.h>
#endif

#ifdef linux	/* My old linux libraries (4.4.1) doesn't have the strrstr function */
#define	HAS_NO_STRRSTR
#endif

/*
 * If your includes are missing the mode_t define
 */
/* typedef ushort mode_t; */

#endif
