/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.peer.LabelPeer;

public class Label
extends Component {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    String label;
    int alignment = 0;

    public Label() {
        this("");
    }

    public Label(String string) {
        this.label = string;
    }

    public Label(String string, int n) {
        this.label = string;
        this.setAlignment(n);
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createLabel(this);
        }
        super.addNotify();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = n;
                LabelPeer labelPeer = (LabelPeer)this.peer;
                if (labelPeer != null) {
                    labelPeer.setAlignment(n);
                }
                return;
            }
        }
        throw new IllegalArgumentException("improper alignment: " + n);
    }

    public String getText() {
        return this.label;
    }

    public void setText(String string) {
        if (!(string == this.label || this.label != null && this.label.equals(string))) {
            this.label = string;
            LabelPeer labelPeer = (LabelPeer)this.peer;
            if (labelPeer != null) {
                labelPeer.setText(string);
            }
        }
    }

    protected String paramString() {
        String string = ",align=";
        switch (this.alignment) {
            case 0: {
                string = String.valueOf(string) + "left";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "center";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "right";
            }
        }
        return String.valueOf(super.paramString()) + string + ",label=" + this.label;
    }
}

