/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.peer.ScrollbarPeer;

public class Scrollbar
extends Component {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int value;
    int maximum;
    int minimum;
    int sVisible;
    int orientation;
    int lineIncrement = 1;
    int pageIncrement = 10;

    public Scrollbar() {
        this(1);
    }

    public Scrollbar(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.orientation = n;
                return;
            }
        }
        throw new IllegalArgumentException("illegal scrollbar orientation");
    }

    public Scrollbar(int n, int n2, int n3, int n4, int n5) {
        this(n);
        this.setValues(n2, n3, n4, n5);
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollbar(this);
        }
        super.addNotify();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        if (n < this.minimum) {
            n = this.minimum;
        }
        if (n > this.maximum) {
            n = this.maximum;
        }
        if (n != this.value) {
            this.value = n;
            ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
            if (scrollbarPeer != null) {
                scrollbarPeer.setValue(n);
            }
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getVisible() {
        return this.sVisible;
    }

    public void setLineIncrement(int n) {
        this.lineIncrement = n;
        if (this.peer != null) {
            ((ScrollbarPeer)this.peer).setLineIncrement(n);
        }
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    public void setPageIncrement(int n) {
        this.pageIncrement = n;
        if (this.peer != null) {
            ((ScrollbarPeer)this.peer).setPageIncrement(n);
        }
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public void setValues(int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            n4 = n3;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4) {
            n = n4;
        }
        this.value = n;
        this.sVisible = n2;
        this.minimum = n3;
        this.maximum = n4;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
        if (scrollbarPeer != null) {
            scrollbarPeer.setValues(n, this.sVisible, n3, n4);
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",val=" + this.value + ",vis=" + this.visible + ",min=" + this.minimum + ",max=" + this.maximum + (this.orientation == 1 ? ",vert" : ",horz");
    }
}

