/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.peer.TextAreaPeer;

public class TextArea
extends TextComponent {
    int rows;
    int cols;

    public TextArea() {
        super("");
    }

    public TextArea(int n, int n2) {
        super("");
        this.rows = n;
        this.cols = n2;
    }

    public TextArea(String string) {
        super(string);
    }

    public TextArea(String string, int n, int n2) {
        super(string);
        this.rows = n;
        this.cols = n2;
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createTextArea(this);
        }
        super.addNotify();
    }

    public void insertText(String string, int n) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
        if (textAreaPeer != null) {
            textAreaPeer.insertText(string, n);
            return;
        }
        this.text = String.valueOf(this.text.substring(0, n)) + string + this.text.substring(n);
    }

    public void appendText(String string) {
        if (this.peer != null) {
            this.insertText(string, this.getText().length());
            return;
        }
        this.text = String.valueOf(this.text) + string;
    }

    public void replaceText(String string, int n, int n2) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
        if (textAreaPeer != null) {
            textAreaPeer.replaceText(string, n, n2);
            return;
        }
        this.text = String.valueOf(this.text.substring(0, n)) + string + this.text.substring(n2);
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public Dimension preferredSize(int n, int n2) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
        if (textAreaPeer != null) {
            return textAreaPeer.preferredSize(n, n2);
        }
        return super.preferredSize();
    }

    public Dimension preferredSize() {
        if (this.rows > 0 && this.cols > 0) {
            return this.preferredSize(this.rows, this.cols);
        }
        return super.preferredSize();
    }

    public Dimension minimumSize(int n, int n2) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
        if (textAreaPeer != null) {
            return textAreaPeer.minimumSize(n, n2);
        }
        return super.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.rows > 0 && this.cols > 0) {
            return this.minimumSize(this.rows, this.cols);
        }
        return super.minimumSize();
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",rows=" + this.rows + ",cols=" + this.cols;
    }
}

