/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ParseException;
import java.text.PatternEntry;
import java.util.Vector;

final class MergeCollation {
    Vector patterns = new Vector();
    PatternEntry lastEntry;
    private byte[] statusArray = new byte[8192];
    private int lastIndex = -1;
    private final byte BITARRAYMASK = 1;

    public MergeCollation(String string) throws ParseException {
        int n = 0;
        while (n < this.statusArray.length) {
            this.statusArray[n] = 0;
            ++n;
        }
        this.setPattern(string);
    }

    public String getPattern() {
        return this.getPattern(true);
    }

    public String getPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.patterns.size()) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.elementAt(n);
            if (patternEntry.extension.length() != 0) {
                patternEntry.addToBuffer(stringBuffer, false, bl, this.findLastWithNoExtension(n));
            } else {
                patternEntry.addToBuffer(stringBuffer, false, bl, null);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String emitPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.patterns.size()) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.elementAt(n);
            patternEntry.chars.charAt(0);
            stringBuffer.append(patternEntry.toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setPattern(String string) throws ParseException {
        this.patterns.removeAllElements();
        this.addPattern(string);
    }

    public void addPattern(String string) throws ParseException {
        PatternEntry patternEntry;
        if (string == null) {
            return;
        }
        int n = 0;
        while ((n = (patternEntry = new PatternEntry()).getNextEntry(string, n)) >= 0) {
            this.fixEntry(patternEntry);
        }
    }

    public int getCount() {
        return this.patterns.size();
    }

    public PatternEntry getItemAt(int n) {
        return (PatternEntry)this.patterns.elementAt(n);
    }

    private final PatternEntry findLastWithNoExtension(int n) {
        --n;
        while (n >= 0) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.elementAt(n);
            if (patternEntry.extension.length() == 0) {
                return patternEntry;
            }
            --n;
        }
        return null;
    }

    private final void fixEntry(PatternEntry patternEntry) throws ParseException {
        if (patternEntry.strength != -2) {
            int n = -1;
            boolean bl = false;
            if (patternEntry.chars.length() == 1) {
                bl = true;
                n = patternEntry.chars.charAt(0) / 8;
                if ((this.statusArray[n] & (byte)(1 << patternEntry.chars.charAt(0) % 8)) != 0) {
                    bl = false;
                    this.patterns.removeElement(patternEntry);
                    this.lastIndex = this.patterns.indexOf(this.lastEntry);
                }
            } else {
                n = this.patterns.indexOf(patternEntry);
                if (n != -1) {
                    this.patterns.removeElementAt(n);
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.lastIndex = this.findLastEntry(this.lastEntry, stringBuffer);
            if (stringBuffer.length() != 0) {
                patternEntry.extension = String.valueOf(stringBuffer) + patternEntry.extension;
            }
            this.patterns.insertElementAt(patternEntry, this.lastIndex);
            if (bl) {
                int n2 = n;
                this.statusArray[n2] = (byte)(this.statusArray[n2] | (byte)(1 << patternEntry.chars.charAt(0) % 8));
            }
        } else {
            this.lastIndex = this.patterns.indexOf(patternEntry);
        }
        this.lastEntry = patternEntry;
    }

    private final int findLastEntry(PatternEntry patternEntry, StringBuffer stringBuffer) throws ParseException {
        if (patternEntry == null) {
            return 0;
        }
        if (patternEntry.strength != -2) {
            int n = -1;
            if (patternEntry.chars.length() == 1) {
                int n2 = patternEntry.chars.charAt(0) / 8;
                if ((this.statusArray[n2] & (byte)(1 << patternEntry.chars.charAt(0) % 8)) != 0) {
                    n = this.lastIndex + 1;
                }
            } else {
                n = this.patterns.indexOf(patternEntry) + 1;
            }
            if (n == -1) {
                throw new ParseException("couldn't find last entry: " + patternEntry, n);
            }
            return n;
        }
        int n = this.patterns.size() - 1;
        while (n >= 0) {
            PatternEntry patternEntry2 = (PatternEntry)this.patterns.elementAt(n);
            if (patternEntry2.chars.regionMatches(0, patternEntry.chars, 0, patternEntry2.chars.length())) {
                stringBuffer.append(patternEntry.chars.substring(patternEntry2.chars.length(), patternEntry.chars.length()));
                break;
            }
            --n;
        }
        if (n == -1) {
            throw new ParseException("couldn't find: " + patternEntry, n);
        }
        return n + 1;
    }
}

