/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.peer.TextFieldPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WTextComponentPeer;

class WTextFieldPeer
extends WTextComponentPeer
implements TextFieldPeer {
    native void create(WComponentPeer var1);

    void initialize() {
        TextField textField = (TextField)this.target;
        this.setText(textField.getText());
        if (textField.echoCharIsSet()) {
            this.setEchoCharacter(textField.getEchoChar());
        }
        this.select(textField.getSelectionStart(), textField.getSelectionEnd());
        this.setEditable(textField.isEditable());
        super.initialize();
    }

    public WTextFieldPeer(TextField textField) {
        super(textField);
    }

    public native void setEchoCharacter(char var1);

    public Dimension preferredSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.charWidth('0') * n + 20, fontMetrics.getHeight() + 8);
    }

    public Dimension minimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.stringWidth(((TextField)this.target).getText()) + 20, fontMetrics.getHeight() + 8);
    }

    public void handleAction(long l, int n) {
        this.target.postEvent(new Event(this.target, 1001, ((TextField)this.target).getText()));
    }
}

