/*
 *  errno.h    iBCS compatable header
 */

#define EPERM              1
#define ENOENT             2
#define ESRCH              3
#define EINTR              4
#define EIO                5
#define ENXIO              6
#define E2BIG              7
#define ENOEXEC            8
#define EBADF              9
#define ECHILD            10
#define EAGAIN            11
#define ENOMEM            12
#define EACCES            13
#define EFAULT            14
#define ENOTBLK           15
#define EBUSY             16
#define EEXIST            17
#define EXDEV             18
#define ENODEV            19
#define ENOTDIR           20
#define EISDIR            21
#define EINVAL            22
#define ENFILE            23
#define EMFILE            24
#define ENOTTY            25
#define ETXTBSY           26
#define EFBIG             27
#define ENOSPC            28
#define ESPIPE            29
#define EROFS             30
#define EMLINK            31
#define EPIPE             32
#define EDOM              33
#define ERANGE            34
#define ENOMSG            35
#define EIDRM             36
#define ECHRNG            37
#define EL2NSYNC          38
#define EL3HLT            39
#define EL3RST            40
#define ELNRNG            41
#define EUNATCH           42
#define ENOCSI            43
#define EL2HLT            44
#define EDEADLK           45
#define ENOLCK            46
#define ENOSTR            60
#define ENODATA           61
#define ETIME             62
#define ENOSR             63
#define ENONET            64
#define ENOPKG            65
#define EREMOTE           66
#define ENOLINK           67
#define EADV              68
#define ESRMNT            69
#define ECOMM             70
#define EPROTO            71
#define EMULTIHOP         74
#define ELBIN             75
#define EDOTDOT           76
#define EBADMSG           77
#define ENAMETOOLONG      78
#define EOVERFLOW         79   /* RESERVED */
#define ENOTUNIQ          80
#define EBADFD            81
#define EREMCHG           82
#define EEILSEQ           88   /* RESERVED */
#define ENOSYS            89
#define ELOOP             90
#define EWOULDBLOCK       90   /* Level 2 */
#define ERESTART          91
#define ESTRIPE           92
#define ENOTEMPTY         93
#define EUSERS            94
#define ESTALE           151   /* RESERVED */
#define EIORESID         500   /* RESERVED */

/* Only used by SVr4 (as far as I know now). */
#ifdef ELF_LIBRARY
#define	ELIBACC		83	/* Can not access a needed shared library */
#define	ELIBBAD		84	/* Accessing a corrupted shared library */
#define	ELIBSCN		85	/* .lib section in a.out corrupted */
#define	ELIBMAX		86	/* Attempting to link in too many shared libraries */
#define	ELIBEXEC	87	/* Cannot exec a shared library directly */
#define	EILSEQ		88	/* Illegal byte sequence */
#define	ENOTSOCK	95	/* Socket operation on non-socket */
#define	EDESTADDRREQ	96	/* Destination address required */
#define	EMSGSIZE	97	/* Message too long */
#define	EPROTOTYPE	98	/* Protocol wrong type for socket */
#define	ENOPROTOOPT	99	/* Protocol not available */
#define	EPROTONOSUPPORT	120	/* Protocol not supported */
#define	ESOCKTNOSUPPORT	121	/* Socket type not supported */
#define	EOPNOTSUPP	122	/* Operation not supported on transport endpoint */
#define	EPFNOSUPPORT	123	/* Protocol family not supported */
#define	EAFNOSUPPORT	124      /* Address family not supported by protocol */
#define	EADDRINUSE	125	/* Address already in use */
#define	EADDRNOTAVAIL	126	/* Cannot assign requested address */
#define	ENETDOWN	127	/* Network is down */
#define	ENETUNREACH	128	/* Network is unreachable */
#define	ENETRESET	129	/* Network dropped connection because of reset */
#define	ECONNABORTED	130	/* Software caused connection abort */
#define	ECONNRESET	131	/* Connection reset by peer */
#define	ENOBUFS		132	/* No buffer space available */
#define	EISCONN		133	/* Transport endpoint is already connected */
#define	ENOTCONN	134	/* Transport endpoint is not connected */
#define	ESHUTDOWN	143	/* Cannot send after transport endpoint shutdown */
#define	ETOOMANYREFS	144	/* Too many references: cannot splice */
#define	ETIMEDOUT	145	/* Connection timed out */
#define	ECONNREFUSED	146	/* Connection refused */
#define	EHOSTDOWN	147	/* Host is down */
#define	EHOSTUNREACH	148	/* No route to host */
#define	EALREADY	149	/* Operation already in progress */
#define	EINPROGRESS	150	/* Operation now in progress */
#endif

#ifndef ASSEMBLY_FILE
extern int errno;
#endif
