#include <stdio.h>
#include <netdb.h>
#include <setjmp.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/socket.h>

#include "netresolv.h"

/*	NETRESOLV	- resolve INET addresses and return
			  the INET Hostnames

		Include a timeout of 60 sec. to resolve a name.
		If not resolved, discard the entry...

		Use STDIN to read from the SOCKETPAIR connection
		(i.e. don't care where it comes from...)
		Expect a struct to be sent in a specific format
		Return a struct to STDOUT in another format

*/

/* #define DEBUG 1  */
extern int errno;
sigjmp_buf env;
#define SAVEMASK 1
int processone = 0;
int addedentries = 0;
FILE *dfp;

typedef void (*sigfunc) (int);

/*
   FOR RELIABLE SIGNAL HANDLING --- make sure a restart of
   system calls is performed when signals interrupt
 */
sigfunc
signal (int signo, sigfunc func)
{
  struct sigaction act, oact;

  act.sa_handler = func;
  sigemptyset (&act.sa_mask);
  act.sa_flags = 0;
  if (signo != SIGALRM)
    act.sa_flags |= SA_RESTART;
  if (sigaction (signo, &act, &oact) < 0)
    return (SIG_ERR);
  return (oact.sa_handler);
}

struct nqueue 
{
	struct resolvaddr resentry;
	struct nqueue *link;
};

struct nqueue *last, *first;
struct nqueue dum;  /* Dummy record header */
#define MAXENTRIES 400
struct resolvaddr entries[MAXENTRIES];

char *dbgaddr(unsigned long val)
{
	unsigned char *p;
	static char buf[40];
	
	p = (unsigned char *)&val;
	sprintf(buf,"%u.%u.%u.%u",p[0],p[1],p[2],p[3]);
	return(buf);
}

void addentry( struct resolvaddr *entry )
{
	struct nqueue *place;
#ifdef DEBUG
	fprintf(dfp,"Adding entry...netresolv... \n");
	fflush(dfp);
#endif
	place = (struct nqueue *)malloc(sizeof(*place));
	place->resentry = *entry;
#ifdef DEBUG
	fprintf(dfp,"Added entry...netresolv... %s\n",dbgaddr(entry->inetaddr));
	fflush(dfp);
#endif
	place->link = NULL;
	last->link = place;
	last = place;
	processone++;
}

void delentry()
{
	struct nqueue *current;

#ifdef DEBUG
	fprintf(dfp,"Deleted entry...netresolv\n");
#endif
	current = first->link;
	if (last==first->link)
		last = first;
	if (current)
	{
		first->link = current->link;
		free(current);
	}
	processone--;
}

void sigincatch(int sig)
{
	int status;
	
	signal(SIGUSR1, SIG_IGN);
#ifdef DEBUG
	fprintf(dfp,"SIGNAL CAUGHT\n");
	fflush(dfp);
#endif
	do
	{
	if (addedentries<MAXENTRIES)
	{
	read(0,&entries[addedentries],sizeof(struct resolvaddr));
	status = errno;
	    if (status != EWOULDBLOCK)
	    {
#ifdef DEBUG
		fprintf(dfp,"ADDING ENTRY\n");
		fflush(dfp);
#endif
		addedentries++;
	    }
#ifdef DEBUG
	    else
	    {
		fprintf(dfp,"READ WOULD HAVE BLOCKED\n");
		fflush(dfp);
	    }
#endif
	}
	} while (status != EWOULDBLOCK && addedentries<MAXENTRIES);	
	signal(SIGUSR1, sigincatch);
}

void sigtimecatch(int sig)
{
	struct resolvaddr entry;

	signal(SIGALRM, sigincatch);
#ifdef DEBUG
	fprintf(dfp,"TIMEOUT SIGNAL CAUGHT\n");
	fflush(dfp);
#endif
	siglongjmp(env,1);	
}

void setupsignals()
{
	signal(SIGALRM, sigtimecatch);
	signal(SIGUSR1, sigincatch);
	signal(SIGUSR2, SIG_IGN);
}

int main()
{
	struct nqueue *top;
	struct gotname finalentry;
	struct hostent *res;
	unsigned char *p;
	char addrchar[20];
	int i;

#ifdef DEBUG
	dfp = fopen("dbugfile","w");
	fprintf(dfp,"Starting NETRESOLV\n");
	fflush(dfp);
#endif
	dum.link = NULL;
	last = &dum;
	first = &dum;
	fcntl(0,F_SETFL,FNDELAY);
	setupsignals();
	while (1)
	{
		if (addedentries)
		{
#ifdef DEBUG
			fprintf(dfp,"Loop to ADD %d entries\n",addedentries);
			fflush(dfp);
#endif
			for (i=0;i<addedentries;i++)
				addentry(&entries[i]);
			addedentries = 0;
		}
		if (processone)
		{
#ifdef DEBUG
			fprintf(dfp,"In processone section = %d\n",processone);
			fflush(dfp);
#endif
			top = first->link;
			if (top)
			{
			   if (sigsetjmp( env , SAVEMASK)==0)
			   {
				alarm(60);	
				p = (unsigned char *)&(top->resentry.inetaddr);
#ifdef DEBUG
			fprintf(dfp,"Actual Get host by address call\n");
			fflush(dfp);
#endif
				
				res = gethostbyaddr(p,
					sizeof(unsigned long int),AF_INET);
				alarm(0);
				/* Build return entry... */
				if (res)
				{
					finalentry.where = top->resentry.where;
					strncpy(finalentry.name,res->h_name,79);
#ifdef DEBUG
					fprintf(dfp,"Returning %s\n",finalentry.name);
					fflush(dfp);
#endif
					finalentry.name[79] = 0;
					write(1,&finalentry,sizeof(finalentry));
				/* Send signal to indicate ALL is ready */
					kill(top->resentry.pid,SIGUSR2);
				}
#ifdef DEBUG
				else
				{
					fprintf(dfp,"Failed GETHOSTBYADDR with %d",errno);
					fflush(dfp);
				}
#endif
										
			   }
			   else
			   {
				/*  TIMED OUT */
#ifdef DEBUG
			fprintf(dfp,"Timed out\n");
			fflush(dfp);
#endif
				
				kill(top->resentry.pid,SIGUSR1);
			   }
			   delentry();			
			}
#ifdef DEBUG
			else
			{
			fprintf(dfp,"TOP NULL VALUE!!\n");
			fflush(dfp);
			
			}
#endif
		}
		else			
		   usleep(100);
	}
	return(0);
}
