/*-
 * This file is part of a file of tcsh-6.05 used for the purpose of
 * string handling. It is given ``as it is'' with its copyright.
 *
 * -----------------------------------------------------------------------
 * Copyright (c) 1980, 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#ifndef FREEBSD
#include <malloc.h>
#endif

#ifdef xmalloc
#undef xmalloc
#endif
#define xmalloc    malloc

char   *
strsave(s)
    register const char *s;
{
    char   *n;
    register char *p;

    if (s == NULL)
	s = (const char *) "";
    for (p = (char *) s; *p++ != '\0';)
	continue;
    n = p = (char *) xmalloc((size_t)
			     ((((const char *) p) - s) * sizeof(char)));
    while ((*p++ = *s++) != '\0')
	continue;
    return (n);
}


char *str_in_buff (char *buff, int len, char *string)
{
  if (string)
    if (strlen (string) >= len) /* does not include \0 */
      {
	strncpy (buff, string, len-1);
	buff[len] = '\0';
      }
    else
      strcpy (buff, string);
  else
    strcpy (buff, "");

  return (buff);
}
