/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.server.UID;

public final class VMID
implements Serializable {
    private static byte[] localAddr;
    private static boolean localAddrUnique;
    private byte[] addr = localAddr;
    private UID uid = new UID();
    private static final long serialVersionUID = -538642295484486218L;

    public static boolean isUnique() {
        return localAddrUnique;
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VMID) {
            VMID vMID = (VMID)object;
            if (!this.uid.equals(vMID.uid)) {
                return false;
            }
            if (this.addr == null ^ vMID.addr == null) {
                return false;
            }
            if (this.addr != null) {
                if (this.addr.length != vMID.addr.length) {
                    return false;
                }
                int n = 0;
                while (n < this.addr.length) {
                    if (this.addr[n] != vMID.addr[n]) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.addr != null) {
            int n = 0;
            while (n < this.addr.length) {
                if (n > 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(Integer.toString(this.addr[n] & 0xFF, 10));
                ++n;
            }
        }
        stringBuffer.append(':');
        stringBuffer.append(this.uid.toString());
        return stringBuffer.toString();
    }

    static {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            localAddr = byArray;
            localAddrUnique = byArray != null && (byArray[0] | byArray[1] | byArray[2] | byArray[3]) != 0 && (byArray[0] != 127 || byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 1);
        }
        catch (Exception exception) {
            localAddr = null;
            localAddrUnique = false;
        }
    }
}

