/****************************************************************************
** $Id: qgl.h,v 1.9.2.2 1998/09/28 14:02:45 aavit Exp $
**
** Definition of OpenGL classes for Qt
**
** Created : 970112
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of Qt Free Edition, version 1.41.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/free-license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** Please see http://www.troll.no/pricing.html for information about 
** Qt Professional Edition, which is this same library but with a
** license which allows creation of commercial/proprietary software.
**
*****************************************************************************/

#ifndef QGL_H
#define QGL_H


#define QGL_VERSION	300
#define QGL_VERSION_STR	"3.0b"

const char *qGLVersion();


#ifndef QT_H
#include <qwidget.h>
#endif // QT_H

#if !(defined(Q_WGL) || defined(Q_GLX))
#if defined(_OS_WIN32_)
#define Q_WGL
#else
#define Q_GLX
#endif
#endif
#if defined(Q_WGL)
#include <windows.h>
#endif
#include <GL/gl.h>
#include <GL/glu.h>


class QGLFormat
{
public:
    QGLFormat( bool doubleBuffer=TRUE );
    QGLFormat( const QGLFormat& f );
    virtual ~QGLFormat();

    QGLFormat&		operator=( const QGLFormat& f );

    bool    		doubleBuffer() const;
    void    		setDoubleBuffer( bool enable );
    bool    		depth() const;
    void    		setDepth( bool enable );
    bool    		rgba() const;
    void    		setRgba( bool enable );
    bool    		alpha() const;
    void    		setAlpha( bool enable );
    bool    		accum() const;
    void    		setAccum( bool enable );
    bool    		stencil() const;
    void    		setStencil( bool enable );
    bool    		stereo() const;
    void    		setStereo( bool enable );

    static const	QGLFormat &defaultFormat();
    static void		setDefaultFormat( const QGLFormat& f );

    static bool		hasOpenGL();

private:

    struct FormatFlags : public QShared {
	bool	doubleBuffer;
	bool	depth;
	bool	rgba;
	bool	alpha;
	bool	accum;
	bool	stencil;
	bool	stereo;
    };

    void		detach();
    FormatFlags*	data;
};


class QGLContext
{
public:
    QGLContext( const QGLFormat& format, QPaintDevice* device );
    virtual ~QGLContext();

    virtual bool	create( const QGLContext* shareContext = 0 );
    bool		isValid() const;
    virtual void	reset();

    const QGLFormat&	format() const;
    virtual void	setFormat( const QGLFormat& format );

    virtual void	makeCurrent();
    virtual void	swapBuffers();

    QPaintDevice*	device() const;

protected:
    virtual bool	chooseContext( const QGLContext* shareContext = 0 );
    virtual void	doneCurrent();

#if defined(Q_WGL)
    virtual int		choosePixelFormat( void* pfd );
#elif defined(Q_GLX)
    virtual void*	chooseVisual();
#endif

protected:
#if defined(Q_WGL)
    HANDLE		rc;
    HANDLE		dc;
    HANDLE		win;
#elif defined(Q_GLX)
    void*		vi;
    void*		cx;
#endif

private:
    bool		valid;
    QGLFormat		glFormat;
    QPaintDevice*	paintDevice;

    friend class QGLWidget;

private:	// Disabled copy constructor and operator=
    QGLContext() {}
    QGLContext( const QGLContext& ) {}
    QGLContext&		operator=( const QGLContext& ) { return *this; }
};


class QGLWidget : public QWidget
{
    Q_OBJECT
public:
    QGLWidget( QWidget* parent=0, const char* name=0,
	       const QGLWidget* shareWidget = 0, WFlags f=0 );
    QGLWidget( const QGLFormat& format, QWidget* parent=0, const char* name=0,
	       const QGLWidget* shareWidget = 0, WFlags f=0 );
   ~QGLWidget();

    bool		isValid() const;
    virtual void	makeCurrent();

    bool		doubleBuffer() const;
    virtual void	swapBuffers();

    const QGLFormat&	format() const;
    virtual void	setFormat( const QGLFormat& format );

    const QGLContext*	context() const;
    virtual void	setContext( QGLContext* context, 
				    const QGLContext* shareContext = 0 );

public slots:
    virtual void	updateGL();

protected:
    virtual void	initializeGL();
    virtual void	paintGL();
    virtual void	resizeGL( int w, int h );

    void		paintEvent( QPaintEvent* );
    void		resizeEvent( QResizeEvent* );

    void		gl_init();
    bool		initDone;

private:
    QGLContext*		glcx;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
    QGLWidget( const QGLWidget& );
    QGLWidget&		operator=( const QGLWidget& );
#endif
};


//
// QGLFormat inline functions
//

inline bool QGLFormat::doubleBuffer() const
{
    return data->doubleBuffer;
}

inline bool QGLFormat::depth() const
{
    return data->depth;
}

inline bool QGLFormat::rgba() const
{
    return data->rgba;
}

inline bool QGLFormat::alpha() const
{
    return data->alpha;
}

inline bool QGLFormat::accum() const
{
    return data->accum;
}

inline bool QGLFormat::stencil() const
{
    return data->stencil;
}

inline bool QGLFormat::stereo() const
{
    return data->stereo;
}

//
// QGLContext inline functions
//

inline bool QGLContext::isValid() const
{
    return valid;
}
inline const QGLFormat& QGLContext::format() const
{
    return glFormat;
}

inline QPaintDevice* QGLContext::device() const
{
    return paintDevice;
}

//
// QGLWidget inline functions
//

inline const QGLFormat &QGLWidget::format() const
{
    return glcx->format();
}

inline const QGLContext *QGLWidget::context() const
{
    return glcx;
}

inline bool QGLWidget::doubleBuffer() const
{
    return glcx->format().doubleBuffer();
}


#endif // QGL_H
