#!/bin/sh
#
# whatis -- search the whatis database for keywords.  Like apropos,
#           but match only commands (as whole words).
#
# Copyright (c) 1990, 1991, John W. Eaton.
#
# You may distribute under the terms of the GNU General Public
# License as specified in the README file that comes with the man
# distribution.  
#
# John W. Eaton
# jwe@che.utexas.edu
# Department of Chemical Engineering
# The University of Texas at Austin
# Austin, Texas  78712
#
# whatis-1.4d aeb 950220
#

OLDPATH=$PATH
PATH=/usr/local/bin:/bin:/usr/ucb:/usr/bin

if [ $# = 0 ]
then
    echo "usage: `basename $0` name ..."
    exit 1
fi

manpath=`(PATH=$OLDPATH; %bindir%/man %manpathoption%) | tr : '\040'`

if [ "$manpath" = "" ]
then
    echo "whatis: manpath is null"
    exit 1
fi

if [ "$PAGER" = "" ]
then
    PAGER="%pager%"
fi

# avoid using a pager if only output is "nothing appropriate"
nothing=
found=0
while [ $found = 0 -a -n "$1" ]
do
    for d in $manpath /usr/lib
    do
        if [ -f $d/whatis ]
        then
            if grep -iw%grepsilent% "^$1" $d/whatis > /dev/null
            then
                found=1
            fi
        fi
    done
    if [ $found = 0 ]
    then
	nothing="$nothing $1"
	shift
    fi
done

if [ $found = 0 ]
then
    for i in $nothing
    do
	echo "$i: nothing appropriate"
    done
    exit
fi

while [ $1 ]
do
    for i in $nothing
    do
	echo "$i: nothing appropriate"
    done
    nothing=
    found=0
    for d in $manpath /usr/lib
    do
        if [ -f $d/whatis ]
        then
            if grep -iw "^$1" $d/whatis
            then
                found=1
            fi
        fi
    done

    if [ $found = 0 ]
    then
        echo "$1: nothing appropriate"
    fi

    shift
done | $PAGER

exit
