#
#	Set and adjust the CMOS clock.
#
if [ ! -f /etc/adjtime ]
then
	echo "0.0 0 0.0" > /etc/adjtime
fi
if [ -x /sbin/hwclock ]
then
	[ "$GMT" = "-u" ] && GMT="--utc"
	hwclock --adjust $GMT
	hwclock --hctosys $GMT
else
	[ "$GMT" = "--utc" ] && GMT="-u"
	clock -a $GMT
fi

#
#	Now that /usr/lib/zoneinfo should be available,
#	announce the local time.
#
if [ "$VERBOSE" != no ]
then
	echo
	echo "Local time: `date`"
	echo
fi

