#    Copyright (C) 1995, 1996 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of GNU Ghostscript.
# 
# GNU Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
# anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer to
# the GNU General Public License for full details.
# 
# Everyone is granted permission to copy, modify and redistribute GNU
# Ghostscript, but only under the conditions described in the GNU General
# Public License.  A copy of this license is supposed to have been given to
# you along with GNU Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.
# 
# Aladdin Enterprises is not affiliated with the Free Software Foundation or
# the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
# does not depend on any other GNU software.

# makefile for MS-DOS / Borland C++ (3.1 or later) library testing.

libdefault: gslib.exe

GS_DOCDIR=c:/gs
GS_LIB_DEFAULT=.;c:/gs\;c:/gs/fonts
GS_INIT=gs_init.ps

DEBUG=1
TDEBUG=1
NOPRIVATE=1

GS=gslib
JSRCDIR=jpeg-6a
JVERSION=6
# Allow predefinition of CONFIG
# when using this makefile from inside another one.
!if "$(CONFIG)" == ""
CONFIG=
!endif
CFLAGS=

USE_ASM=1
ASM=tasm

COMP=bcc
COMPAUX=$(COMP)
COMPDIR=c:\bc\bin
BGIDIR=c:\bc\bgi
# BGIDIRSTR must be the same as BGIDIR with / substituted for \.
BGIDIRSTR=c:/bc/bgi
INCDIR=c:\bc\include
LIBDIR=c:\bc\lib

OVERLAY=1

CPU_TYPE=486
FPU_TYPE=0

.swap

PLATFORM=bclib_
MAKEFILE=bclib.mak

AK=ccf.tr
F286=

CO=-Obe -Z
COD=-O
COINT=-Obet
CAOPT=-a
WINCOMP=0

!include "tccommon.mak"
!include "bcflags.mak"

!if $(OVERLAY)
CY=-Y
CYO=-Yo -zAOVLY
LO=/oOVLY
LIBOVL=$(LIBDIR)\overlay
OVLH=overlay.h
!else
CY=
CYO=
LO=
LIBOVL=
OVLH=
!endif

CCFLAGS0=$(GENOPT) $(PLATOPT) $(FPFLAGS) $(CFLAGS) $(XCFLAGS)
CCFLAGS=$(CCFLAGS0) -m$(MM)
CC=$(COMPDIR)\$(COMP) -m$(MM) -zEGS_FAR_DATA @ccf.tr
CCC=$(CC) $(CYO) $(CO) -c
CCD=$(CC) $(CYO) $(COD) -c
CCCF=$(COMPDIR)\$(COMP) -mh @ccf.tr $(CYO) -O -c
CCINT=$(CC) $(CYO) $(COINT) -c
CCLEAF=$(CCC)

.c.obj:
	$(CCC) { $<}

# Allow predefinition of FEATURE_DEVS and DEVICE_DEVS
# when using this makefile from inside another one.
!if "$(FEATURE_DEVS)" == ""
FEATURE_DEVS=patlib.dev path1lib.dev hsblib.dev
!endif
!if "$(DEVICE_DEVS)" == ""
DEVICE_DEVS=vga.dev
!endif
COMPILE_INITS=0

!include "tctail.mak"

ccf.tr: $(MAKEFILE) makefile
!if $(CPU_TYPE) < 286
	echo -a -d -r -G -X -I$(INCDIR) $(CCFLAGS0) >ccf.tr
!else
!  if $(CPU_TYPE) > 286
	echo -3 -a -d -r -G -X -I$(INCDIR) $(CCFLAGS0) >ccf.tr
!  else
	echo -2 -a -d -r -G -X -I$(INCDIR) $(CCFLAGS0) >ccf.tr
!  endif
!endif

ccf1.tr: $(MAKEFILE) makefile
	echo -I$(INCDIR) $(CCFLAGS) >ccf1.tr

bclib__=gp_itbc.$(OBJ) gp_msdos.$(OBJ) gp_nofb.$(OBJ) gp_dosfs.$(OBJ) gp_dosfe.$(OBJ)
bclib_.dev: $(bclib__)
	$(SETMOD) bclib_ $(bclib__)

gp_itbc.$(OBJ): gp_itbc.c $(string__h) $(gx_h) $(gp_h) \
 $(OVLH) $(MAKEFILE) makefile $(AK) ccf1.tr
	$(CC) @ccf1.tr -1- $(CY) -DCPU_TYPE=$(CPU_TYPE) -c gp_itbc.c

BEGINFILES=ccf*.tr
CCBEGIN=$(CCC) *.c

LIBCTR=libc$(MM).tr

$(LIBCTR): $(MAKEFILE) makefile $(ECHOGS_XE)
	echogs -w $(LIBCTR) $(LIBOVL) $(LIBDIR)\$(FPLIB)+
	echogs -a $(LIBCTR) $(LIBDIR)\math$(MM) $(LIBDIR)\c$(MM)

objl.tr: $(ld_tr) gslib.obj gconfig.obj gscdefs.obj $(INTASM)
	echogs -w objl.tr gslib.obj gconfig.obj gscdefs.obj $(INTASM)+
	copy objl.tr+$(ld_tr)

$(GS).exe: $(LIB_ALL) $(LIBCTR) objl.tr lib.tr
	$(COMPDIR)\tlink $(LCT) $(LO) $(LIBDIR)\c0$(MM) @objl.tr ,$(GS),$(GS),@lib.tr @$(LIBCTR)
