#    Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of GNU Ghostscript.
# 
# GNU Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
# anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer to
# the GNU General Public License for full details.
# 
# Everyone is granted permission to copy, modify and redistribute GNU
# Ghostscript, but only under the conditions described in the GNU General
# Public License.  A copy of this license is supposed to have been given to
# you along with GNU Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.
# 
# Aladdin Enterprises is not affiliated with the Free Software Foundation or
# the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
# does not depend on any other GNU software.

# tctail.mak
# Last part of MS-DOS makefile common to Turbo C and Turbo/Borland C++,
# MS-DOS and MS Windows.

# Define the name of this makefile.
TCTAIL_MAK=tctail.mak

# Include the generic makefiles, except for int.mak.
!include "gs.mak"
!include "lib.mak"
!include "jpeg.mak"
!include "libpng.mak"
!include "zlib.mak"
!include "devs.mak"

# -------------------------- Auxiliary programs --------------------------- #

CCAUX=$(COMPDIR)\$(COMPAUX) -m$(MM) -I$(INCDIR) -L$(LIBDIR) -O

$(ECHOGS_XE): echogs.c
	$(CCAUX) echogs.c

# If we are running in a Windows environment with a different compiler
# for the DOS utilities, we have to invoke genarch by hand:
!if $(WINCOMP)
$(GENARCH_XE): genarch.c $(stdpre_h) $(iref_h)
	$(COMPDIR)\$(COMP) -I$(INCDIR) -L$(LIBDIR) -O genarch.c
	echo Run "win genarch arch.h" then continue make
!else
$(GENARCH_XE): genarch.c
	$(CCAUX) genarch.c
!endif

$(GENCONF_XE): genconf.c $(stdpre_h)
	$(CCAUX) genconf.c

$(GENINIT_XE): geninit.c $(stdio__h) $(string__h)
	$(CCAUX) geninit.c

# No special gconfig_.h is needed.
gconfig_.h: $(TCTAIL_MAK) $(ECHOGS_XE)
	echogs -w gconfig_.h /* This file deliberately left blank. */

gconfigv.h: $(TCTAIL_MAK) $(MAKEFILE) $(ECHOGS_XE)
	$(EXP)echogs -w gconfigv.h -x 23 define USE_ASM -x 2028 -q $(USE_ASM)-0 -x 29
	$(EXP)echogs -a gconfigv.h -x 23 define USE_FPU -x 2028 -q $(FPU_TYPE)-0 -x 29
	$(EXP)echogs -a gconfigv.h -x 23 define EXTEND_NAMES 0$(EXTEND_NAMES)
