#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "common.h"
#include "ppm.h"

static void
put_u_long(l, outfp)
     u_long l;
     FILE	*outfp;
{
  int i;
  for(i = 0 ; i < 4 ; i++)
    fputc( 0xff & (l >> (8 * i)), outfp);
}

static void
put_u_short(s, outfp)
     u_short s;
     FILE	*outfp;
{
  fputc( 0xff & s, outfp);  
  fputc( 0xff & (s >> 8), outfp);
}

void
write_bmp(buf, outfp, width, height, rateW, rateH)
     u_char	*buf;
     FILE	*outfp;
     int width;
     int height;
     int rateW;
     int rateH;
{
  long size;
  size = width * height * 3;

  fputc(0x42, outfp);		/* B */
  fputc(0x4d, outfp);		/* M */
  put_u_long(size + 54 , outfp);
  put_u_short(0, outfp);
  put_u_short(0, outfp);
  put_u_long(54, outfp);

  put_u_long(40, outfp);	/* 40  Windows 3.x style */
  put_u_long(width, outfp);
  put_u_long(height, outfp);
  put_u_short(1, outfp);
  put_u_short(24, outfp);
  put_u_long(0, outfp);
  put_u_long(size, outfp);
  put_u_long(2925, outfp);
  put_u_long(2925, outfp);
  put_u_long(0, outfp);
  put_u_long(0, outfp);
  write_ppm(buf, outfp, width, height, rateW, rateH, 0, 1);
}
