.\" $XFree86: xc/programs/Xserver/hw/xfree86/XF86Conf.man,v 3.52.2.7 1998/02/26 13:58:52 dawes Exp $
.TH XF86Config 4/5 "Version 3.3.2"  "XFree86"
.SH NAME
XF86Config - Configuration File for XFree86
.SH DESCRIPTION
.I XFree86
uses a configuration file called \fBXF86Config\fP for its initial
setup.  This configuration file is searched for in the following
places:
.sp
.in 8
.nf
/etc/XF86Config
<XRoot>/lib/X11/XF86Config.\fIhostname\fP
<XRoot>/lib/X11/XF86Config
.fi
.in -8
.LP
where <XRoot> refers to the root of the X11 install tree.
When an X server is started by a `root' user, it will first search for
an \fBXF86Config\fP file in that user's home directory.
.PP
This file is composed of a number of sections.  Each section has
the form:
.sp
.in 8
.nf
Section "\fISectionName\fP"
   \fISectionEntry\fP
   ...
EndSection
.fi
.in -8
.PP
The section names are:
.sp
.in 8
.nf
\fBFiles\fP (File pathnames)
\fBModule\fP (Dynamic module loading)
\fBServerFlags\fP (Server flags)
\fBKeyboard\fP (Keyboard configuration)
\fBPointer\fP (Pointer configuration)
\fBMonitor\fP (Monitor description)
\fBDevice\fP (Graphics device description)
\fBScreen\fP (Screen configuration)
\fBXInput\fP (Extended Input devices configuration)
.fi
.PP
The \fBFiles\fP section is used to specify the default font path
and the path to the RGB database.  These paths can also be set from
the command line (see \fIXserver(1)\fP).  The entries available
for this section are:
.TP 8
.B FontPath \fI"path"\fP
sets the search path for fonts.  This path is a comma separated
list of directories which the X server searches for font databases.
Multiple \fBFontPath\fP entries may be specified, and they will be
concatenated to build up the fontpath used by the server.
.sp
X11R6 allows the X server to request fonts from a font server.  A
font server is specified by placing a "<trans>/<hostname>:<port_number>"
entry into the fontpath.  For example, the fontpath
"/usr/X11R6/lib/X11/fonts/misc/,tcp/zok:7100" tells the X server
to first try to locate the font in the local directory
/usr/X11R6/lib/X11/fonts/misc.  If that fails, then request the
font from the \fIfont server\fP running on machine zok listening
for connections on TCP port number 7100.
.TP 8
.B RGBPath \fI"path"\fP
sets the path name for the RGB color database.
.TP 8
.B ModulePath \fI"path"\fP
sets the search path for dynamic modules.  This path is a comma separated
list fo directories which the X server searches for dynamic module loading
in the order specified.
Multiple \fBModulePath\fP entries may be specified, and they will be
concatenated to build the modulepath used by the server.
.PP
The
.B Module
section is used to specify which dynamic modules should be loaded.
At present dynamic modules are only used for XInput devices, and are
only supported on some systems (currently Linux ELF, FreeBSD 2.x and
NetBSD 1.x).  The entry available for this section is:
.TP 8
.B Load \fI"module"\fP
This instructs the server to load \fI"module"\fP.  If the module
is not specified with a full pathname, the directories specified in
the \fBModulePath\fP are searched.
Modules are currently available to support extended input devices.  The
names of these are:
.sp
.in 20
.nf
.B xf86Elo.so
.B xf86Jstk.so
.B xf86Wacom.so
.B xf86Summa.so
.fi
.in -20
The PEX and XIE extension are also be available as modules on some
systems. The names for these are:
.sp
.in 20
.nf
.B pex5.so
.B xie.so
.fi
.in -20
.RS 8
For an up-to-date listing, check in <XRoot>/lib/modules.
.RE
.PP
The \fBServerFlags\fP section is used to specify some miscellaneous
X server options.  The entries available for this section are:
.TP 8
.B NoTrapSignals
This prevents the X server from trapping a range of unexpected
fatal signals and exiting cleanly.  Instead, the X server will die
and drop core where the fault occurred.  The default behaviour is
for the X server exit cleanly, but still drop a core file.  In
general you never want to use this option unless you are debugging
an X server problem.
.TP 8
.B DontZap
This disallows the use of the \fBCtrl+Alt+Backspace\fP sequence.
This sequence allows you to terminate the X server.
Setting \fBDontZap\fP allows this key sequence to be passed to clients.
.TP 8
.B DontZoom
This disallows the use of the \fBCtrl+Alt+Keypad-Plus\fP and
\fBCtrl+Alt+Keypad-Minus\fP sequences.  These sequences allows you to
switch between video modes.
Setting \fBDontZoom\fP allows these key sequences to be passed to clients.
.TP 8
.B AllowNonLocalXvidtune
This allows the xvidtune client to connect from another host.  By default
non-local connections are not allowed.
.TP 8
.B DisableVidMode
This disables the parts of the VidMode extension used by the xvidtune client
that can be used to change the video modes.
.TP 8
.B AllowNonLocalModInDev
This allows a client to connect from another host and change keyboard
and mouse settings in the running server.  By default
non-local connections are not allowed.
.TP 8
.B DisableModInDev
This disables the parts of the Misc extension that can be used to
modify the input device settings dynamically.
.TP 8
.B AllowMouseOpenFail
This allows the server to start up even if the mouse device can't be
opened/initialised.
.PP
The \fBKeyboard\fP section is used to specify the keyboard input
device, parameters and some default keyboard mapping options.  The
entries available for this section are:
.TP 8
.B Protocol \fI"kbd-protocol"\fP
\fIkbd-protocol\fP may be either \fBStandard\fP or \fBXqueue\fP.
\fBXqueue\fP is specified when using the event queue driver on SVR3
or SVR4.
.TP
.B AutoRepeat \fIdelay rate\fP
changes the behavior of the autorepeat of the keyboard.  This does
not work on all platforms.
.TP 8
.B ServerNumLock
forces the X server to handle the numlock key internally.  The X
server sends a different set of keycodes for the numpad when the
numlock key is active.  This enables applications to make use of
the numpad.
.PP
.nf
.B LeftAlt \fImapping\fP
.B RightAlt \fImapping\fP
.B AltGr \fImapping\fP
.B ScrollLock \fImapping\fP
.B RightCtl \fImapping\fP
.fi
.RS 8
Allows a default mapping to be set for the above keys (note that
\fBAltGr\fP is a synonym for \fBRightAlt\fP).  The values that may
be specified for \fImapping\fP are:
.sp
.in 20
.nf
Meta
Compose
ModeShift
ModeLock
ScrollLock
Control
.fi
.PP
The default mapping when none of these options are specified is:
.sp
.in 20
.nf
LeftAlt     Meta
RightAlt    Meta
ScrollLock  Compose
RightCtl    Control
.fi
.RE
.TP 8
.B XLeds \fIled\fP ...
makes \fIled\fP available for clients instead of using the traditional
function (Scroll Lock, Caps Lock & Num Lock).  \fIled\fP is a list
of numbers in the range 1 to 3.
.TP 8
.B VTSysReq
enables the SYSV-style VT switch sequence for non-SYSV systems
which support VT switching.  This sequence is Alt-SysRq followed
by a function key (Fn).  This prevents the X server trapping the
keys used for the default VT switch sequence.
.TP 8
.B VTInit \fI"command"\fP
Runs \fIcommand\fP after the VT used by the server has been opened.
The command string is passed to "/bin/sh -c", and is run with the
real user's id with stdin and stdout set to the VT.  The purpose
of this option is to allow system dependent VT initialisation
commands to be run.  One example is a command to disable the 2-key
VT switching sequence which is the default on some systems.
.TP 8
.B XkbDisable
Turns the XKEYBOARD extension off, equivalent to using the -kb
command line option.
.PP
.nf
.B XkbRules \fI"rulesfile"\fP
.B XkbModel \fI"model"\fP
.B XkbLayout \fI"layout"\fP
.B XkbVariant \fI"variant"\fP
.B XkbOptions \fI"optionlist"\fP
.fi
.RS 8
These specify the definitions which are used to determine which
XKEYBOARD components to use.  The optionlist, should be a comma
separated list of options.
The default mappings for each these are:
.sp
.in 20
.nf
XkbRules     "xfree86"
XkbModel     "pc101"
XkbLayout    "us"
XkbVariant   ""
XkbOptions   ""
.fi
.RE
.PP
This is the preferred method of specifying the keyboard configuration,
however, you can also specify the components directly with:
.sp
.nf
.B XkbKeymap \fI"keymap"\fP
.B XkbKeycodes \fI"keycodes"\fP
.B XkbTypes \fI"types"\fP
.B XkbCompat \fI"compat"\fP
.B XkbSymbols \fI"symbols"\fP
.B XkbGeometry \fI"geometry"\fP
.fi
.RS 8
If you specify only some of the components, the remaining components
will use these default values:
.sp
.in 20
.nf
XkbKeymap    none
XkbKeycodes  "xfree86"
XkbTypes     "default"
XkbCompat    "default"
XkbSymbols   "us(pc101)"
XkbGeometry  "pc"
.fi
.RE
.PP
The \fBPointer\fP section is used to specify the pointer device
and parameters.  The entries available for this section are:
.TP 8
.B Protocol \fI"protocol-type\fP"
specifies the pointer device protocol type.  The protocol types
available are:
.sp
.in 20
.nf
.B Auto
.B BusMouse
.B GlidePoint
.B GlidePointPS/2
.B IntelliMouse
.B IMPS/2
.B Logitech
.B Microsoft
.B MMHitTab
.B MMSeries
.B Mouseman
.B MouseManPlusPS/2
.B MouseSystems
.B NetMousePS/2
.B NetScrollPS/2
.B OSMouse
.B PS/2
.B SysMouse
.B ThinkingMouse
.B ThinkingMousePS/2
.B Xqueue
.fi
.in -20
.RS 8
.PP
One should specify \fBBusMouse\fP for the Logitech bus mouse and
bus or InPort mice from Microsoft and ATI.
The \fBLogitech\fP protocol is for old serial mouse models from Logitech.
Many newer Logitech serial mice use either the \fBMicrosoft\fP
or \fBMouseMan\fP protocol.  \fBXqueue\fP should be specified here
if it was used in the \fBKeyboard\fP section.  \fBOSMouse\fP refers
to the event-driver mouse interface available on SCO's SVR3, and the
mouse interface provided for OS/2.  This
may optionally be followed by a number specifying the number of
buttons the mouse has.
\fBSysMouse\fP refers to the system mouse device, /dev/sysmouse, in
FreeBSD.
.PP
The \fBPS/2\fP and other \fBXXXXPS/2\fP protocol types are for PS/2 mice.
\fBPS/2\fP should always work with any PS/2 mouse
regardless of the model of the PS/2 mouse.
The other \fBXXXXPS/2\fP protocol types may or may not be supported by
your OS.
.PP
The rest of the protocol types are for serial mice.
If your serial mouse is of a relatively new model, you may specify
\fBAuto\fP, then the X server will try to select an appropriate
protocol type automatically.  The \fBAuto\fP protocol type may
also work for the PS/2 and bus mice on some OSs.
.RE
.TP 8
.B Device \fI"pointer-dev"\fP
specifies the device the server should open for pointer input (eg,
\fB/dev/tty00\fP or \fB/dev/mouse\fP).  A device should not be
specified when using the \fBXqueue\fP or \fBOSMouse\fP protocols.
.TP 8
.B Port \fI"pointer-dev"\fP
is an alternate form of the \fBDevice\fP entry.
.TP 8
.B BaudRate \fIrate\fP
sets the baudrate of the serial mouse to \fIrate\fP. For mice that
allow dynamic speed adjustments (like older Logitechs) the baudrate is
changed in the mouse.  Otherwise the rate is simply set on the
computer's side to allow mice with non-standard rates (the standard
rate is 1200).  For 99% of mice you should not set this to anything
other than the default (1200).
.TP 8
.B Buttons \fIN\fP
This option tells the X server the number of buttons on the mouse.
Currently there is no reliable way to automatically detect the correct 
number. 
This option is the only means for the X server to obtain it.
The default value is three.
Note that if you intend to assign Z axis movement to button events
using the \fBZAxisMapping\fP option below, you need to take account
of those buttons into \fIN\fP too.
.TP 8
.B Emulate3Buttons
enables the emulation of the third mouse button for mice which only
have two physical buttons.  The third button is emulated by pressing
both buttons simultaneously.
.TP 8
.B Emulate3Timeout \fItimeout\fP
sets the time (in milliseconds) that the server waits before deciding if
two buttons were pressed ``simultaneously'' when 3 button emulation is
enabled.  The default timeout is 50ms.
.TP 8
.B ChordMiddle
handles mice which send left+right events when the middle button
is used (like some Logitech Mouseman mice).
.TP 8
.B SampleRate \fIrate\fP
sets the number of motion/button-events the mouse sends per second.
This is currently only supported for some Logitech mice.
.TP 8
.B Resolution \fIcount\fP
sets the resolution of the device in counts per inch.
This is not always supported by all the mice.
.TP 8
.B ClearDTR
This option clears the DTR line on the serial port used by the
mouse.  This option is only valid for a mouse using the \fBMouseSystems\fP
protocol.  Some dual-protocol mice require DTR to be cleared to
operate in MouseSystems mode.  Note, in versions of XFree86 prior
to 2.1, this option also cleared the RTS line.  A separate
\fBClearRTS\fP option has since been added for mice which require
this.
.TP 8
.B ClearRTS
This option clears the RTS line on the serial port used by the
mouse.  This option is only valid for a mouse using the \fBMouseSystems\fP
protocol.  Some dual-protocol mice require both DTR and RTS to be
cleared to operate in MouseSystems mode.  Both the \fBClearDTR\fP
and \fBClearRTS\fP options should be used for such mice.
.TP 8
.B ZAxisMapping X
.TP 8
.B ZAxisMapping Y
.TP 8
.B ZAxisMapping \fIN M\fP
Some mouse devices have a wheel or a roller. Its action is
reported as the Z (third) axis movement in the X server. 
The Z axis movement can be assigned to another axis (\fIX\fP or \fIY\fP)
or a pair of buttons (the button \fIN\fP for negative movement
and \fIM\fP for positive movement) with this option.
.PP
The \fBMonitor\fP sections are used to define the specifications
of a monitor and a list of video modes suitable for use with a
monitor.  More than one \fBMonitor\fP section may be present in an
XF86Config file.  The entries available for this section are:
.TP 8
.B Identifier \fI"ID string"\fP
This specifies a string by which the monitor can be referred to in
a later \fBScreen\fP section.  Each \fBMonitor\fP section should
have a unique ID string.
.TP 8
.B VendorName \fI"vendor"\fP
This optional entry specifies the monitor's manufacturer.
.TP 8
.B ModelName \fI"model"\fP
This optional entry specifies the monitor's model.
.TP 8
.B HorizSync \fIhorizsync-range\fP
gives the range(s) of horizontal sync frequencies supported by the
monitor.  \fIhorizsync-range\fP may be a comma separated list of
either discrete values or ranges of values.  A range of values is
two values separated by a dash.  By default the values are in units
of kHz.  They may be specified in MHz or Hz if \fBMHz\fP or \fBHz\fP
is added to the end of the line.  The data given here is used by the X
server to determine if video modes are within the specifications
of the monitor.  This information should be available in the
monitor's handbook.
.TP 8
.B VertRefresh \fIvertrefresh-range\fP
gives the range(s) of vertical refresh frequencies supported by
the monitor.  \fIvertrefresh-range\fP may be a comma separated list
of either discrete values or ranges of values.  A range of values
is two values separated by a dash.  By default the values are in
units of Hz.  They may be specified in MHz or kHz if \fBMHz\fP or
\fBkHz\fP is added to the end of the line.  The data given here is used
by the X server to determine if video modes are within the
specifications of the monitor.  This information should be available
in the monitor's handbook.
.TP 8
.B Gamma \fIgamma-value(s)\fP
This is an optional entry that can be used to specify the gamma
correction for the monitor.  It may be specified as either a single
value or as three separate RGB values.  Not all X servers are capable
of using this information.
.TP 8
.B Mode \fI"name"\fP
indicates the start of a multi-line video mode description.  The
mode description is terminated with an \fBEndMode\fP line.  The
mode description consists of the following entries:
.sp
.RS 8
.TP 4
.B DotClock \fIclock\fP
is the dot clock rate to be used for the mode.
.TP 4
.B HTimings \fIhdisp hsyncstart hsyncend htotal\fP
specifies the horizontal timings for the mode.
.TP 4
.B VTimings \fIvdisp vsyncstart vsyncend vtotal\fP
specifies the vertical timings for the mode.
.TP 4
.B Flags \fI"flag" ...\fP
specifies an optional set of mode flags.  \fB"Interlace"\fP indicates
that the mode is interlaced.  \fB"DoubleScan"\fP indicates a mode where
each scanline is doubled.  \fB"+HSync"\fP and \fB"-HSync"\fP can
be used to select the polarity of the HSync signal.  \fB"+VSync"\fP
and \fB"-VSync"\fP can be used to select the polarity of the VSync
signal.  \fB"Composite"\fP, can be used to specify composite sync on
hardware where this is supported.  Additionally, on some hardware,
\fB"+CSync"\fP and \fB"-CSync"\fP may be used to select the composite
sync polarity.
.TP
.B HSkew \fIhskew\fP
specifies the number of pixels (towards the right edge of the screen) by which
the display enable signal is to be skewed.  Not all servers use this
information.  This option might become necessary to override the default
value supplied by the server (if any).  "Roving" horizontal lines indicate this
value needs to be increased.  If the last few pixels on a scan line appear on
the left of the screen, this value should be decreased.
.RE
.TP 8
.B Modeline \fI"name" mode-description\fP
is a single line format for specifying video modes.  The
\fImode-description\fP is in four sections, the first three of
which are mandatory.  The first is the pixel clock.  This is a
single number specifying the pixel clock rate for the mode.  The
second section is a list of four numbers specifying the horizontal
timings.  These numbers are the \fIhdisp\fP, \fIhsyncstart\fP,
\fIhsyncend\fP, \fIhtotal\fP.  The third section is a list of four
numbers specifying the vertical timings.  These numbers are
\fIvdisp\fP, \fIvsyncstart\fP, \fIvsyncend\fP, \fIvtotal\fP.  The
final section is a list of flags specifying other characteristics
of the mode.  \fBInterlace\fP indicates that the mode is interlaced.
\fBDoubleScan\fP indicates a mode where each scanline is doubled.  
\fB+HSync\fP and \fB\-HSync\fP can be used to select the polarity
of the HSync signal.  \fB+VSync\fP and \fB\-VSync\fP can be used
to select the polarity of the VSync signal.  \fBComposite\fP can be
used to specify composite sync on hardware where this is supported.
Additionally, on some hardware,
\fB+CSync\fP and \fB-CSync\fP may be used to select the composite
sync polarity.  The \fBHSkew\fP option mentioned above can also be used here.
.PP
The \fBDevice\fP sections are used to define a graphics device
(video board).  More than one \fBDevice\fP section may be present
in an XF86Config file.  The entries available for this section are:
.TP 8
.B Identifier \fI"ID string"\fP
This specifies a string by which the graphics device can be referred
to in a later \fBScreen\fP section.  Each \fBDevice\fP section
should have a unique ID string.
.TP 8
.B VendorName \fI"vendor"\fP
This optional entry specifies the graphics device's manufacturer.
.TP 8
.B BoardName \fI"model"\fP
This optional entry specifies the name of the graphics device.
.TP 8
.B Chipset \fI"chipset-type"\fP
This optional entry specifies the chipset used on the graphics
board.  In most cases this entry is not required because the X
servers will probe the hardware to determine the chipset type.
.TP 8
.B Ramdac \fI"ramdac-type"\fP
This optional entry specifies the type of RAMDAC used on the graphics
board.  This is only used by a few of the X servers, and in most
cases it is not required because the X servers will probe the
hardware to determine the RAMDAC type where possible.
.TP 8
.B DacSpeed \fIspeed\fP
This optional entry specifies the RAMDAC speed rating (which is
usually printed on the RAMDAC chip).  The speed is in MHz.  This
is only used by a few of the X servers, and only needs to be
specified when the speed rating of the RAMDAC is different from
the default built in to the X server.
.TP 8
.B Clocks \fIclock ...\fP
specifies the dotclocks that are on your graphics board.  The clocks
are in MHz, and may be specified as a floating point number.  The
value is stored internally to the nearest kHz.  The ordering of
the clocks is important.  It must match the order in which they
are selected on the graphics board.  Multiple \fBClocks\fP lines
may be specified.  For boards with programmable clock chips, the
\fBClockChip\fP entry should be used instead of this.  A \fBClocks\fP
entry is not mandatory for boards with non-programmable clock chips,
but is highly recommended because it prevents the clock probing
phase during server startup.  This clock probing phase can cause
problems for some monitors.
.TP 8
.B ClockChip \fI"clockchip-type"\fP
This optional entry is used to specify the clock chip type on
graphics boards which have a programmable clock generator.  Only
a few X servers support programmable clock chips.  For details,
see the appropriate X server manual page.
.TP 8
.B ClockProg \fI"command"\fP [\fItextclock\fP]
This optional entry runs \fIcommand\fP to set the clock on the
graphics board instead of using the internal code.  The command
string must consist of the full pathname (and no flags).  When
using this option, and no \fBClocks\fP entry is specified,
it is assumed that the card has a fully programmable clock 
generator; for a card with a set of preset clocks a \fBClocks\fP 
entry is required to specify which clock values are to be made 
available to the server (up to 128 clocks may be specified).  
The optional \fItextclock\fP value is used to tell the server that
\fIcommand\fP must be run to restore the textmode clock at server 
exit (or when VT switching).  \fItextclock\fP must match one of the 
values in the \fBClocks\fP entry.  This parameter is required when 
the clock used for text mode is a programmable clock.

The command is run with the real user's id with stdin and stdout
set to the graphics console device.  Two arguments are passed to
the command.  The first is the clock frequency in MHz as a floating
point number and the second is the index of the clock in the
\fBClocks\fP entry.  The command should return an exit status of
0 when successful, and something in the range 1\-254 otherwise.

The command is run when the initial graphics mode is set and when
changing screen resolution with the hot-key sequences.  If the
program fails at initialisation the server exits.  If it fails
during a mode switch, the mode switch is aborted but the server
keeps running.  It is assumed that if the command fails the clock
has not been changed.
.TP 8
.B Option \fI"optionstring"\fP
This optional entry allows the user to select certain options
provided by the drivers.  Multiple \fBOption\fP entries may be
given.  The supported values for \fIoptionstring\fP  are given in
the appropriate X server manual pages and/or the chipset-specific
README files.
.TP 8
.B VideoRam \fImem\fP
This optional entry specifies the amount of videoram that is
installed on the graphics board. This is measured in kBytes.  In
most cases this is not required because the X server probes the
graphics board to determine this quantity.
.TP 8
.B BIOSBase \fIbaseaddress\fP
This optional entry specifies the base address of the video BIOS
for the VGA board.  This address is normally 0xC0000, which is the
default the X servers will use.  Some systems, particularly those
with on-board VGA hardware, have the BIOS located at an alternate
address, usually 0xE0000.  If your video BIOS is at an address
other than 0xC0000, you must specify the base address in the
XF86Config file.  Note that some X servers don't access the BIOS
at all, and those which do only use the BIOS when searching for
information during the hardware probe phase.
.TP 8
.B MemBase \fIbaseaddress\fP
This optional entry specifies the memory base address of a graphics
board's linear frame buffer.  This entry is only used by a few
X servers, and the interpretation of this base address may be different
for different X servers.  Refer to the appropriate X server manual
page for details.
.TP 8
.B IOBase \fIbaseaddress\fP
This optional entry specifies the IO base address.  This entry is only
used for a few X servers.  Refer to the appropriate X server manual page
for details.
.TP 8
.B DACBase \fIbaseaddress\fP
This optional entry specifies the DAC base address.  This entry is only
used for a few X servers.  Refer to the appropriate X server manual page
for details.
.TP 8
.B POSBase \fIbaseaddress\fP
This optional entry specifies the POS base address.  This entry is only
used for a few X servers.  Refer to the appropriate X server manual page
for details.
.TP 8
.B COPBase \fIbaseaddress\fP
This optional entry specifies the coprocessor base address.  This entry
is only used for a few X servers.  Refer to the appropriate X server
manual page for details.
.TP 8
.B VGABase \fIbaseaddress\fP
This optional entry specifies the VGA memory base address.  This entry
is only used for a few X servers.  Refer to the appropriate X server
manual page for details.
.TP 8
.B Instance \fInumber\fP
This optional entry specifies the instance (which indicates if the
chip is integrated on the motherboard or on an expansion card).
This entry is only used for a few X servers.  Refer to the appropriate
X server manual page for details.
.TP 8
.B Speedup \fI"selection"\fP
This optional entry specifies the selection of speedups to be
enabled.  This entry is only used for a few X servers.  Refer to
the appropriate X server manual page for details.
.TP 8
.B S3MNAdjust \fIM N\fP
This optional entry is specific to the S3 X server.  For details, refer
to the \fIXF86_S3(1)\fP manual page.
.TP 8
.B S3MClk \fIclock\fP
This optional entry is specific to the S3 X server.  For details, refer
to the \fIXF86_S3(1)\fP manual page.
.TP 8
.B S3RefClock \fIclock\fP
This optional entry is specific to the S3 X server.  For details, refer
to the \fIXF86_S3(1)\fP manual page.
.PP
The \fBScreen\fP sections are used to specify which graphics boards
and monitors will be used with a particular X server, and the
configuration in which they are to be used.  The entries available
for this section are:
.TP 8
.B Driver \fI"driver-name"\fP
Each \fBScreen\fP section must begin with a \fBDriver\fP entry,
and the \fIdriver-name\fP given in each \fBScreen\fP section must
be unique.  The driver name determines which X server (or driver
type within an X server when an X server supports more than one
head) reads and uses a particular \fBScreen\fP section.  The driver
names available are:
.sp
.in 20
.nf
.B Accel
.B Mono
.B SVGA
.B VGA2
.B VGA16
.fi
.in -20
.RS 8
.PP
\fBAccel\fP is used by all the accelerated X servers (see
\fIXF86_Accel(1)\fP).  \fBMono\fP is used by the non-VGA mono
drivers in the 2-bit and 4-bit X servers (see \fIXF86_Mono(1)\fP
and \fIXF86_VGA16(1)\fP).  \fBVGA2\fP and \fBVGA16\fP are used by
the VGA drivers in the 2-bit and 4-bit X servers respectively.
\fBSVGA\fP is used by the XF86_SVGA X server.
.RE
.TP 8
.B Device \fI"device-id"\fP
specifies which graphics device description is to be used.
.TP 8
.B Monitor \fI"monitor-id"\fP
specifies which monitor description is to be used.
.TP 8
.B DefaultColorDepth \fIbpp-number\fP
specifies which color depth the server should use, when no -bpp command
line parameter was given.
.TP 8
.B ScreenNo \fIscrnum\fP
This optional entry overrides the default screen numbering in a
multi-headed configuration.  The default numbering is determined by
the ordering of the \fBScreen\fP sections in the \fIXF86Config\fP
file.  To override this, all relevant \fBScreen\fP sections must have
this entry specified.
.TP 8
.B BlankTime \fItime\fP
sets the inactivity timeout for the blanking phase of the screensaver.
\fItime\fP is in minutes, and the default is 10.
This is equivalent to the Xserver's `-s' flag, and the value can be
changed at run-time with \fIxset(1)\fP.
.TP 8
.B StandbyTime \fItime\fP
sets the inactivity timeout for the ``standby'' phase of DPMS mode.
\fItime\fP is in minutes, the default is 20, and it can be changed
at run-time with \fIxset(1)\fP.
This is only suitable for VESA DPMS compatible monitors, and is only
supported currently by some Xservers.  The "power_saver"
Option must be set for this to be enabled.
.TP 8
.B SuspendTime \fItime\fP
sets the inactivity timeout for the ``suspend'' phase of DPMS mode.
\fItime\fP is in minutes, the default is 30, and it can be changed
at run-time with \fIxset(1)\fP.
This is only suitable for VESA DPMS compatible monitors, and is only
supported currently by some Xservers.  The "power_saver"
Option must be set for this to be enabled.
.TP 8
.B OffTime \fItime\fP
sets the inactivity timeout for the ``off'' phase of DPMS mode.
\fItime\fP is in minutes, the default is 40, and it can be changed
at run-time with \fIxset(1)\fP.
This is only suitable for VESA DPMS compatible monitors, and is only
supported currently by some Xservers.  The "power_saver"
Option must be set for this to be enabled.
.TP
.B SubSection \fB"Display"\fP
This entry is a subsection which is used to specify some display
specific parameters.  This subsection is terminated by an
\fBEndSubSection\fP entry.  For some X servers and drivers (those
requiring a list of video modes) this subsection is mandatory.
For X servers which support multiple display depths, more than one
\fBDisplay\fP subsection may be present.  When multiple \fBDisplay\fP
subsections are present, each must have a unique \fBDepth\fP entry.
The entries available for the \fBDisplay\fP subsection are:
.RS 8
.TP 4
.B Depth \fIbpp\fP
This entry is mandatory when more than one \fBDisplay\fP subsection
is present in a \fBScreen\fP section.  When only one \fBDisplay\fP
subsection is present, it specifies the default depth that the X
server will run at.  When more than one \fBDisplay\fP subsection
is present, the depth determines which gets used by the X server.
The subsection used is the one matching the depth at which the X
server is run at.  Not all X servers (or drivers) support more than
one depth.  Permitted values for \fIbpp\fP are 8, 15, 16, 24 and 32.
Not all X servers (or drivers) support all of these values.
\fIbpp\fP values of 24 and 32 are treated equivalently by those X
servers which support them.
.TP 4
.B Weight \fIRGB\fP
This optional entry specifies the relative RGB weighting to be used
for an X server running at 16bpp.  This may also be specified from
the command line (see \fIXFree86(1)\fP).  Values supported by most
16bpp X servers are \fB555\fP and \fB565\fP.  For further details,
refer to the appropriate X server manual page.
.TP 4
.B Virtual \fIxdim ydim\fP
This optional entry specifies the virtual screen resolution to be
used.  \fIxdim\fP must be a multiple of either 8 or 16 for most
colour X servers, and a multiple of 32 for the monochrome X server.
The given value will be rounded down if this is not the case.  For
most X servers, video modes which are too large for the specified
virtual size will be rejected.  If this entry is not present, the
virtual screen resolution will be set to accommodate all the valid
video modes given in the \fBModes\fP entry.  Some X servers do not
support this entry.  Refer to the appropriate X server manual pages
for details.
.TP 4
.B ViewPort \fIx0 y0\fP
This optional entry sets the upper left corner of the initial
display.  This is only relevant when the virtual screen resolution
is different from the resolution of the initial video mode.  If
this entry is not given, then the initial display will be centered
in the virtual display area.
.TP 4
.B Modes \fI"modename" ...\fP
This entry is mandatory for most X servers, and it specifies the
list of video modes to use.  The video mode names must correspond
to those specified in the appropriate \fBMonitor\fP section.  Most
X servers will delete modes from this list which don't satisfy
various requirements.  The first valid mode in this list will be
the default display mode for startup.  The list of valid modes is
converted internally into a circular list.  It is possible to switch
to the next mode with \fBCtrl+Alt+Keypad-Plus\fP and to the previous
mode with \fBCtrl+Alt+Keypad-Minus\fP.
.TP 4
.B InvertVCLK \fI"modename"\fP \fR0|1\fP
This optional entry is specific to the S3 server only.  It may be used
to change the default VCLK invert/non-invert state for individual modes.
If \fI"modename"\fP is "\(**" the setting applies to all modes unless
unless overridden by later entries.
.TP 4
.B EarlySC \fI"modename"\fP \fR0|1\fP
This optional entry is specific to the S3 server only.  It may be used
to change the default EarlySC setting for individual modes.  This
setting can affect screen wrapping.
If \fI"modename"\fP is "\(**" the setting applies to all modes unless 
unless overridden by later entries.
.TP 4
.B BlankDelay \fI"modename" value1 value2\fP
This optional entry is specific to the S3 server only.  It may be used
to change the default blank delay settings for individual modes.  This
can affect screen wrapping.  \fIvalue1\fP and \fIvalue2\fP must be
integers in the range 0\-7.
If \fI"modename"\fP is "\(**" the setting applies to all modes unless
unless overridden by later entries.
.TP 4
.B Visual \fI"visual-name"\fP
This optional entry sets the default root visual type.  This may
also be specified from the command line (see \fIXserver(1)\fP).
The visual types available for 8bpp X servers are (default is
\fBPseudoColor\fP):
.RE
.sp
.in 20
.nf
.B StaticGray
.B GrayScale
.B StaticColor
.B PseudoColor
.B TrueColor
.B DirectColor
.fi
.in -20
.RS 12
.PP
The visual type available for the 16bpp and 32bpp X servers is 
\fBTrueColor\fP.
.PP
The visual type available for the 1bpp X server is \fBStaticGray\fP.
.PP
The visual types available for the 4bpp X server are (default is
\fBStaticColor\fP):
.RE
.sp
.in 20
.nf
.B StaticGray
.B GrayScale
.B StaticColor
.B PseudoColor
.fi
.in -20
.RS 8
.TP 4
.B Option \fI"optionstring"\fP
This optional entry allows the user to select certain options
provided by the drivers.  Multiple \fBOption\fP entries may be
given.  The supported values for \fIoptionstring\fP  are given in
the appropriate X server manual pages and/or the chipset-specific
README files.
.TP 4
.B Black \fIred green blue\fP
This optional entry allows the ``black'' colour to be specified.  This
is only supported with the VGA2 driver in the XF86_Mono server (for
details see \fIXF86_Mono(1)\fP).
.TP 4
.B White \fIred green blue\fP
This optional entry allows the ``white'' colour to be specified.  This
is only supported with the VGA2 driver in the XF86_Mono server (for
details see \fIXF86_Mono(1)\fP).
.RE
.PP
The optional \fBXInput\fP section is used to specify configuration options
for the extended input devices.  For some OSs, the extended device support is
dynamically loaded, and in this case you need to specify which Modules to
load in the \fBModule\fP section (this is documented above).
Each extended device has its own
subsection. To enable an extended device the corresponding subsection
must appear. The subsections names are:
.sp
.in 8
.nf
\fBJoystick\fP (only on supported systems ie. Linux, FreeBSD and NetBSD)
\fBWacomStylus\fP (stylus of a Wacom tablet)
\fBWacomEraser\fP (eraser of a Wacom tablet)
\fBWacomCursor\fP (cursor of a Wacom tablet)
\fBElographics\fP (Elographics touchscreen)
\fBSummaSketch\fP (SummaSketch tablet)
\fBMouse\fP (Mouse)
.fi
.TP
The \fBJoystick\fP subsection supports the following entries:
.RS 8
.TP 4
.B Port \fI"path"\fP
sets the path to the special file which represents the device driver.
.TP 4
.B DeviceName \fI"name"\fP
sets the name of the X device.
.TP 4
.B TimeOut \fItimeout\fP
sets the time (in milliseconds) between two polls of the device driver.
The value given here may be overriden by the Operating System's joystick
driver.
.TP 4
.B MaximumXPosition \fIvalue\fP
sets the maximum X value reported by the device driver.
.TP 4
.B MininimumXPosition \fIvalue\fP
sets the minimum X value reported by the device driver.
.TP 4
.B MaximumYPosition \fIvalue\fP
sets the maximum Y value reported by the device driver.
.TP 4
.B MinimumYPosition \fIvalue\fP
sets the minimum Y value reported by the device driver.
.TP 4
.B CenterX \fIvalue\fP
sets the X center reported by the device driver when the joystick
is idle.  If this value is omitted, it is assumed that the joystick
is centered when it is first enabled.
.TP 4
.B CenterY \fIvalue\fP
sets the Y center reported by the device driver when the joystick
is idle.  If this value is omitted, it is assumed that the joystick
is centered when it is first enabled.
.TP 4
.B Delta \fIvalue\fP
sets the maximum value reported to the X server. i.e. coordinates will
be incremented of \fI(+/\-)value/2\fP at maximum deflection.  This determines
the sensitivity.
.TP 4
.B AlwaysCore
enables the sharing of the core pointer. When this feature is enabled you
cannot put the device in extended mode (i.e. sending extended events). You
can also use the latest integer feedback to control this feature. When the
value of the feedback is zero, the feature is disabled. The feature
is enabled for any other value.
.RE
.TP
Multiple instances of the Wacom devices can  cohabit. It can be useful
to define multiple  devices     with different active     zones.   The
\fBWacomStylus\fP, \fBWacomEraser\fP and \fBWacomCursor\fP subsections
support the following entries:
.RS 8
.TP 4
.B Port \fI"path"\fP
sets the path to the special file which represents serial line where
the tablet is plugged.  You have to specify it for each subsection with
the same value if you want to have multiple devices with the same tablet.
.TP 4
.B DeviceName \fI"name"\fP
sets the name of the X device.
.TP 4
.B Suppress \fInumber\fP
sets the position increment under which not to transmit coordinates.
This entry must be specified only in the first Wacom subsection if you have
multiple devices for one tablet.
.TP 4
.B Mode \fIRelative|Absolute\fP
sets the mode of the device.
.TP 4
.B TiltMode
enables tilt report if your tablet supports it (ROM version 1.4 and above).
If this is enabled, multiple devices at the same time will not be reported.
.TP 4
.B HistorySize \fInumber\fP
sets the motion history size. By default the value is zero.
.TP 4
.B AlwaysCore
enables the sharing of the core pointer. When this feature is enabled you
cannot put the device in extended mode (i.e. sending extended events). You
can also use the latest integer feedback to control this feature. When the
value of the feedback is zero, the feature is disabled. The feature
is enabled for any other value.
.TP 4
.B TopX \fInumber\fP
X coordinate of the top corner of the active zone.
.TP 4
.B TopY \fInumber\fP
Y coordinate of the top corner of the active zone.
.TP 4
.B BottomX \fInumber\fP
X coordinate of the bottom corner of the active zone.
.TP 4
.B BottomY \fInumber\fP
Y coordinate of the bottom corner of the active zone.
.TP 4
.B KeepShape
When this option is enabled, the active zone  begins according to TopX
and TopY.  The  bottom corner is calculated  to  keep shapes  ie.  the
ratio width/heigth of  the active zone  is calculated to have the same
ratio as the one of the screen.
.RE
.TP
The \fBElographics\fP subsection support the following entries:
.RS 8
.TP 4
.B Port \fI"path"\fP
sets the path to the special file which represents the device driver.
.TP 4
.B DeviceName \fI"name"\fP
sets the name of the X device.
.TP 4
.B MaximumXPosition \fIposition\fP
sets the maximum X position reported by the touchscreen.
.TP 4
.B MinimumXPosition \fIposition\fP
sets the minimum X position reported by the touchscreen.
.TP 4
.B MaximumYPosition \fIposition\fP
sets the maximum Y position reported by the touchscreen.
.TP 4
.B MinimumYPosition \fIposition\fP
sets the minimum Y position reported by the touchscreen.
.TP 4
.B ScreenNo \fInumber\fP
sets the screen number where the touchscreen is connected.
.TP 4
.B UntouchDelay \fIvalue\fP
sets the delay (in tens of milliseconds) after which the device
considers that an untouch occurs.
.TP 4
.B ReportDelay \fIvalue\fP
sets the delay (in ten of milliseconds) between two reports
of positions.
.TP 4
.B AlwaysCore
enables the sharing of the core pointer. When this feature is enabled you
cannot put the device in extended mode (i.e. sending extended events). You
can also use the latest integer feedback to control this feature. When the
value of the feedback is zero, the feature is disabled. The feature
is enabled for any other value.
.RE
.TP
The \fBSummaSketch\fP subsection support the following entries:
.RS 8
.TP 4
.B Port \fI"path"\fP
sets the path to the special file which represents the device driver.
.TP 4
.B DeviceName \fI"name"\fP
sets the name of the X device.
.TP 4
.B Mode \fIRelative|Absolute\fP
sets the mode of the device.
.TP 4
.B Cursor \fIStylus|Puck\fP
sets the cursor type, stylus or 4 button puck.
.TP 4
.B Increment \fIvalue\fP
sets the maximum change in coordinates before new report.
.TP 4
.B HistorySize \fInumber\fP
sets the motion history size. By default the value is zero.
.TP 4
.B AlwaysCore
enables the sharing of the core pointer. When this feature is enabled you
cannot put the device in extended mode (i.e. sending extended events). You
can also use the latest integer feedback to control this feature. When the
value of the feedback is zero, the feature is disabled. The feature
is enabled for any other value.
.RE
.TP
The \fBMouse\fP subsection support the same entries as the
standard \fBPointer\fP section, plus the following:
.RS 8
.TP 4
.B DeviceName \fI"name"\fP
sets the name of the X device.
.TP 4
.B AlwaysCore
enables the sharing of the core pointer. When this feature is enabled you
cannot put the device in extended mode (i.e. sending extended events). You
can also use the latest integer feedback to control this feature. When the
value of the feedback is zero, the feature is disabled. The feature
is enabled for any other value.
.RE
.PP
For an example of an XF86Config file, see the file installed as
<XRoot>/lib/X11/XF86Config.eg.
.SH FILES
.PP
.nf
/etc/XF86Config
<XRoot>/lib/X11/XF86Config.\fIhostname\fP
<XRoot>/lib/X11/XF86Config
.sp 1
Note: <XRoot> refers to the root of the X11 install tree.
.fi
.SH "SEE ALSO"
X(1), Xserver(1), XFree86(1), XF86_SVGA(1), XF86_VGA16(1),
XF86_Mono(1), XF86_S3(1), XF86_8514(1), XF86_Mach8(1), XF86_Mach32(1),
XF86_P9000(1), XF86_AGX(1), XF86_W32(1).
.SH AUTHORS
.PP
Refer to the
.I XFree86(1)
manual page.
.\" $XConsortium: XF86Conf.man /main/27 1996/12/09 17:33:00 kaleb $
