/***********************************************************
Copyright 1993 by Ove Kalkan

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
 * Icon.c - Icon widget
 *
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>
#include <X11/extensions/shape.h>
#include "IconP.h"

#include <stdio.h>


/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

#define offset(field) XtOffsetOf(IconRec, field)
static XtResource resources[] = {
     {XtNimage,  XtCPixmap, XtRPixmap, sizeof(Pixmap),
	offset(icon.image), XtRImmediate, (XtPointer) None},
     {XtNshape,  XtCPixmap, XtRPixmap, sizeof(Pixmap),
	offset(icon.shape), XtRImmediate, (XtPointer) None},
    {XtNimageWidth, XtCWidth, XtRDimension,  sizeof(Dimension),
	offset(icon.width), XtRImmediate, (XtPointer)0},
    {XtNimageHeight, XtCHeight, XtRDimension, sizeof(Dimension),
	offset(icon.height), XtRImmediate, (XtPointer)0},
};
#undef offset

static void Initialize();
static void Redisplay();
static Boolean SetValues();
static void ClassInitialize();
static void Destroy();
static void Resize();

IconClassRec iconClassRec = {
  {
/* core_class fields */	
#define superclass		(&simpleClassRec)
    /* superclass	  	*/	(WidgetClass) superclass,
    /* class_name	  	*/	"Icon",
    /* widget_size	  	*/	sizeof(IconRec),
    /* class_initialize   	*/	ClassInitialize,
    /* class_part_initialize	*/	NULL,
    /* class_inited       	*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize		  	*/	XtInheritRealize,
    /* actions		  	*/	NULL,
    /* num_actions	  	*/	0,
    /* resources	  	*/	resources,
    /* num_resources	  	*/	XtNumber(resources),
    /* xrm_class	  	*/	NULLQUARK,
    /* compress_motion	  	*/	TRUE,
    /* compress_exposure  	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest	  	*/	FALSE,
    /* destroy		  	*/	Destroy,
    /* resize		  	*/	Resize,
    /* expose		  	*/	Redisplay,
    /* set_values	  	*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus	 	*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private   	*/	NULL,
    /* tm_table		   	*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	NULL,/*XtInheritDisplayAccelerator,*/
    /* extension		*/	NULL
  },
/* Simple class fields initialization */
  {
    /* change_sensitive		*/	XtInheritChangeSensitive
  }
};

WidgetClass iconWidgetClass = (WidgetClass)&iconClassRec;
/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static void ClassInitialize()
{
    XawInitializeWidgetSet();
}



static void GetnormalGC(lw)
    IconWidget lw;
{
    XGCValues	values;

    values.foreground	= lw->core.border_pixel;
    values.background	= lw->core.background_pixel;
    values.graphics_exposures = False;

    lw->icon.normal_GC = XtGetGC(
	(Widget)lw,
	(unsigned) GCForeground | GCBackground | GCGraphicsExposures,
	&values);
}

static void GetgrayGC(lw)
    IconWidget lw;
{
    XGCValues	values;

    values.foreground = lw->core.border_pixel;
    values.background = lw->core.background_pixel;
    values.fill_style = FillTiled;
    values.tile       = XmuCreateStippledPixmap(XtScreen((Widget)lw),
						lw->core.border_pixel, 
						lw->core.background_pixel,
						lw->core.depth);
    values.graphics_exposures = False;

    lw->icon.stipple = values.tile;
    lw->icon.gray_GC = XtGetGC((Widget)lw, 
				(unsigned) GCForeground | GCBackground |
					   GCTile | GCFillStyle |
					   GCGraphicsExposures,
				&values);
}


/* ARGSUSED */
static void Initialize(request, new)
 Widget request, new;
{
    IconWidget lw = (IconWidget) new;

    GetnormalGC(lw);
    GetgrayGC(lw);

    if (lw->core.height == 0)
        lw->core.height = lw->icon.height;

    if (lw->core.width == 0)		/* need icon.lbm_width */
        lw->core.width = lw->icon.width;

    (*XtClass(new)->core_class.resize) ((Widget)lw);
} /* Initialize */

/*
 * Repaint the widget window
 */

/* ARGSUSED */
static void Redisplay(w, event, region)
    Widget w;
    XEvent *event;
    Region region;
{
   IconWidget lw = (IconWidget) w;
   GC gc;

   gc = XtIsSensitive((Widget)lw) ? lw->icon.normal_GC : lw->icon.gray_GC;

   if (lw->icon.image != None && lw->icon.width != 0 && lw->icon.height != 0) {
        int x, y;
        Display *dpy = XtDisplay((Widget) lw);
        Window win = XtWindow((Widget) lw);

        x = (lw->core.width - lw->icon.width)/2;
        y = (lw->core.height - lw->icon.height)/2;

        XFillRectangle(dpy,win,gc,0,0,lw->core.width,lw->core.height);
        if (lw->icon.shape != None) {
             XShapeCombineMask(dpy,win,ShapeBounding,x,y,lw->icon.shape,ShapeSet);
        }
        XCopyArea (dpy,lw->icon.image,win,gc,0,0,lw->icon.width,lw->icon.height,x,y);
   }
   else {
        Display *dpy = XtDisplay((Widget) lw);
        Window win = XtWindow((Widget) lw);

        XFillRectangle(dpy,win,lw->icon.gray_GC,0,0,lw->core.width,lw->core.height);
   }
}

/*
 * Set specified arguments into widget
 */

static Boolean SetValues(current, request, new, args, num_args)
    Widget current, request, new;
    ArgList args;
    Cardinal *num_args;
{
    IconWidget curlw = (IconWidget) current;
    IconWidget reqlw = (IconWidget) request;
    IconWidget newlw = (IconWidget) new;
    Boolean redisplay;

    if (curlw->icon.image != newlw->icon.image) {
	redisplay = True;
    }
    if (curlw->icon.shape != newlw->icon.shape) {
	redisplay = True;
    }
    if (curlw->icon.width != newlw->icon.width) {
	redisplay = True;
    }
    if (curlw->icon.height != newlw->icon.height) {
	redisplay = True;
    }

    if (curlw->core.border_pixel != newlw->core.border_pixel
	|| curlw->core.background_pixel != newlw->core.background_pixel) {

	XtReleaseGC(new, curlw->icon.normal_GC);
	XtReleaseGC(new, curlw->icon.gray_GC);
	XmuReleaseStippledPixmap( XtScreen(current), curlw->icon.stipple );
	GetnormalGC(newlw);
	GetgrayGC(newlw);
	redisplay = True;
    }

    return (redisplay || XtIsSensitive(current) != XtIsSensitive(new));
}

static void Destroy(w)
    Widget w;
{
    IconWidget lw = (IconWidget)w;

    XtReleaseGC( w, lw->icon.normal_GC );
    XtReleaseGC( w, lw->icon.gray_GC);
    XmuReleaseStippledPixmap( XtScreen(w), lw->icon.stipple );
}

static void Resize(w)
    Widget w;
{
}


