/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public final class System {
    public static final InputStream in = System.nullInputStream();
    public static final PrintStream out = System.nullPrintStream();
    public static final PrintStream err = System.nullPrintStream();
    private static SecurityManager security = new NullSecurityManager();
    private static Properties props;

    private System() {
    }

    public static void setIn(InputStream inputStream) {
        System.checkIO();
        System.setIn0(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        System.checkIO();
        System.setOut0(printStream);
    }

    public static void setErr(PrintStream printStream) {
        System.checkIO();
        System.setErr0(printStream);
    }

    private static void checkIO() {
        System.getSecurityManager().checkExec("setio");
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(SecurityManager securityManager) {
        if (security != null && !(security instanceof NullSecurityManager)) {
            throw new SecurityException("SecurityManager already set");
        }
        if (securityManager == null) {
            throw new NullPointerException();
        }
        security = securityManager;
        SecurityManager.setSecurityManager();
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native long currentTimeMillis();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static Properties getProperties() {
        System.getSecurityManager().checkPropertiesAccess();
        return props;
    }

    public static void setProperties(Properties properties) {
        System.getSecurityManager().checkPropertiesAccess();
        props = properties;
    }

    public static String getProperty(String string) {
        if (!System.isPropertyAllowed(string)) {
            System.getSecurityManager().checkPropertyAccess(string);
        }
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        if (!System.isPropertyAllowed(string)) {
            System.getSecurityManager().checkPropertyAccess(string);
        }
        return props.getProperty(string, string2);
    }

    private static boolean isPropertyAllowed(String string) {
        return "true".equalsIgnoreCase(props.getProperty(String.valueOf(string) + ".applet"));
    }

    public static String getenv(String string) {
        throw new Error("getenv no longer supported, use properties and -D instead: " + string);
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void load(String string) {
        System.getSecurityManager().checkLink(string);
        Runtime.getRuntime().load(string);
    }

    public static void loadLibrary(String string) {
        System.getSecurityManager().checkLink(string);
        Runtime.getRuntime().loadLibrary(string);
    }

    private static InputStream nullInputStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static PrintStream nullPrintStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static void initializeSystemClass() {
        props = System.initProperties(new Properties());
        FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
        FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fileOutputStream2 = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fileInputStream));
        System.setOut0(new PrintStream(new BufferedOutputStream(fileOutputStream, 128), true));
        System.setErr0(new PrintStream(new BufferedOutputStream(fileOutputStream2, 128), true));
    }
}

