
#include "E.h"

TextClass          *
CreateTclass()
{
  TextClass          *t;

  EDBUG(5, "CreateTclass");
  t = Emalloc(sizeof(TextClass));
  if (!t)
    EDBUG_RETURN(NULL);
  t->name = NULL;
  t->norm.normal = t->norm.hilited = t->norm.clicked = t->norm.disabled = NULL;
  t->active.normal = t->active.hilited = t->active.clicked = t->active.disabled = NULL;
  t->sticky.normal = t->sticky.hilited = t->sticky.clicked = t->sticky.disabled = NULL;
  t->sticky_active.normal = t->sticky_active.hilited = t->sticky_active.clicked = t->sticky_active.disabled = NULL;
  t->justification = 512;
  EDBUG_RETURN(t);
}

TextState          *
CreateTextState()
{
  TextState          *ts;

  EDBUG(6, "CreateTextState");
  ts = Emalloc(sizeof(TextState));
  if (!ts)
    EDBUG_RETURN(NULL);
  ts->fontname = NULL;
  ts->style.mode = MODE_WRAP_CHAR;
  ts->style.orientation = FONT_TO_RIGHT;
  ts->style.justification = 0;
  ts->style.spacing = 0;
  ts->font = NULL;
  ts->efont = NULL;
  ts->xfont = NULL;
  ts->xfontset = 0;
  EDBUG_RETURN(ts);
}

void
TclassPopulate(TextClass * tclass)
{
  EDBUG(6, "TclassPopulate");
  if (!tclass)
    EDBUG_RETURN_;

  if (!tclass->norm.normal)
    EDBUG_RETURN_;
  if (!tclass->norm.hilited)
    tclass->norm.hilited = tclass->norm.normal;
  if (!tclass->norm.clicked)
    tclass->norm.clicked = tclass->norm.normal;
  if (!tclass->norm.disabled)
    tclass->norm.disabled = tclass->norm.normal;

  if (!tclass->active.normal)
    tclass->active.normal = tclass->norm.normal;
  if (!tclass->active.hilited)
    tclass->active.hilited = tclass->active.normal;
  if (!tclass->active.clicked)
    tclass->active.clicked = tclass->active.normal;
  if (!tclass->active.disabled)
    tclass->active.disabled = tclass->active.normal;

  if (!tclass->sticky.normal)
    tclass->sticky.normal = tclass->norm.normal;
  if (!tclass->sticky.hilited)
    tclass->sticky.hilited = tclass->sticky.normal;
  if (!tclass->sticky.clicked)
    tclass->sticky.clicked = tclass->sticky.normal;
  if (!tclass->sticky.disabled)
    tclass->sticky.disabled = tclass->sticky.normal;

  if (!tclass->sticky_active.normal)
    tclass->sticky_active.normal = tclass->norm.normal;
  if (!tclass->sticky_active.hilited)
    tclass->sticky_active.hilited = tclass->sticky_active.normal;
  if (!tclass->sticky_active.clicked)
    tclass->sticky_active.clicked = tclass->sticky_active.normal;
  if (!tclass->sticky_active.disabled)
    tclass->sticky_active.disabled = tclass->sticky_active.normal;
  EDBUG_RETURN_;
}

void
TclassApply(ImageClass * iclass, Window win, int w, int h, int active, int sticky, int state, char expose, TextClass * tclass, char *text)
{

  EDBUG(4, "TclassApply");
  if ((!iclass) || (!tclass) || (!win) || (w < 1) || (h < 1))
    EDBUG_RETURN_;

  if (queue_up)
    {
      DrawQueue          *dq;

      dq = Emalloc(sizeof(DrawQueue));
      dq->win = win;
      dq->iclass = iclass;
      dq->w = w;
      dq->h = h;
      dq->active = active;
      dq->sticky = sticky;
      dq->state = state;
      dq->expose = expose;
      dq->tclass = tclass;
      dq->text = duplicate(text);
      dq->w = w;
      dq->shape_propagate = 0;
      dq->pager = NULL;
      dq->redraw_pager = NULL;
      AddItem(dq, "DRAW", dq->win, LIST_TYPE_DRAW);
      EDBUG_RETURN_;
    }
  XClearWindow(disp, win);
  TextDraw(tclass, win, active, sticky, state, text,
	   iclass->padding.left, iclass->padding.top,
	   w - (iclass->padding.left + iclass->padding.right),
	   h - (iclass->padding.top + iclass->padding.bottom),
	   h - (iclass->padding.top + iclass->padding.bottom),
	   tclass->justification);
  EDBUG_RETURN_;
}
