#include "E.h"

Window
ECreateWindow(Window parent, int x, int y, int w, int h, int saveunder)
{
  Window              win;
  XSetWindowAttributes attr;

  EDBUG(6, "ECreateWindow");
  attr.backing_store = NotUseful;
  attr.override_redirect = False;
  attr.colormap = root.cmap;
  attr.border_pixel = 0;
  attr.background_pixel = 0;
  attr.background_pixmap = None;
  if ((saveunder == 1) && (mode.save_under))
    attr.save_under = True;
  else if (saveunder == 2)
    attr.save_under = True;
  else
    attr.save_under = False;
  win = XCreateWindow(disp, parent, x, y, w, h, 0, root.depth,
		      InputOutput, root.vis, CWOverrideRedirect | CWSaveUnder |
		    CWBackingStore | CWColormap | CWBackPixmap | CWBackPixel |
		      CWBorderPixel,
		      &attr);
  EDBUG_RETURN(win);
}

Window
ECreateEventWindow(Window parent, int x, int y, int w, int h)
{
  Window              win;
  XSetWindowAttributes attr;

  EDBUG(6, "ECreateEventWindow");
  attr.override_redirect = False;
  win = XCreateWindow(disp, parent, x, y, w, h, 0, 0, InputOnly, root.vis,
		      CWOverrideRedirect, &attr);
  EDBUG_RETURN(win);
}

/*
 * create a window which will accept the keyboard focus when no other 
 * windows have it
 */
Window
ECreateFocusWindow(Window parent, int x, int y, int w, int h)
{
  Window              win;
  XSetWindowAttributes attr;

  EDBUG(6, "ECreateFocusWindow");

  attr.backing_store = NotUseful;
  attr.override_redirect = True;
  attr.colormap = root.cmap;
  attr.border_pixel = 0;
  attr.background_pixel = 0;
  attr.save_under = False;
  attr.event_mask = KeyPressMask | FocusChangeMask;

  win = XCreateWindow(disp, parent, x, y, w, h, 0, 0, InputOnly,
		      CopyFromParent, CWOverrideRedirect | CWSaveUnder |
		      CWBackingStore | CWColormap | CWBackPixel |
		      CWBorderPixel | CWEventMask, &attr);

  XSetWindowBackground(disp, win, 0);
  XMapWindow(disp, win);
  XSetInputFocus(disp, win, RevertToParent, CurrentTime);

  EDBUG_RETURN(win);
}

void
GrabX()
{
  EDBUG(6, "GrabX");
  if (mode.server_grabbed <= 0)
    XGrabServer(disp);
  mode.server_grabbed++;
  EDBUG_RETURN_;
}

void
UngrabX()
{
  EDBUG(6, "UngrabX");
  if (mode.server_grabbed == 1)
    {
      XUngrabServer(disp);
      XFlush(disp);
    }
  mode.server_grabbed--;
  if (mode.server_grabbed < 0)
    mode.server_grabbed = 0;
  EDBUG_RETURN_;
}

void
SetBG(Window win, Pixmap pmap, int color)
{
  static Atom         a = 0, aa = 0, aaa = 0;
  static Window       alive_win = 0;

  EDBUG(6, "SetBG");
  if (!a)
    {
      a = XInternAtom(disp, "_XROOTPMAP_ID", False);
      aa = XInternAtom(disp, "_XROOTCOLOR_PIXEL", False);
      aaa = XInternAtom(disp, "_XROOTWINDOW", False);
    }
  if (!alive_win)
    {
      alive_win = ECreateWindow(root.win, -100, -100, 1, 1, 0);
      XChangeProperty(disp, alive_win, aaa, XA_WINDOW, 32, PropModeReplace,
		      (unsigned char *)&alive_win, 1);
      XChangeProperty(disp, root.win, aaa, XA_WINDOW, 32, PropModeReplace,
		      (unsigned char *)&alive_win, 1);
    }
  XChangeProperty(disp, win, a, XA_PIXMAP, 32, PropModeReplace,
		  (unsigned char *)&pmap, 1);
  XChangeProperty(disp, win, aa, XA_CARDINAL, 32, PropModeReplace,
		  (unsigned char *)&color, 1);
  if (pmap)
    XSetWindowBackgroundPixmap(disp, win, pmap);
  else
    XSetWindowBackground(disp, win, color);
  XClearWindow(disp, win);
  EDBUG_RETURN_;
}

void
GetWinXY(Window win, int *x, int *y)
{
  Window              w1;
  unsigned int        w, h, b, d;

  EDBUG(7, "GetWinXY");
  XGetGeometry(disp, win, &w1, x, y, &w, &h, &b, &d);
  EDBUG_RETURN_;
}

void
GetWinWH(Window win, unsigned int *w, unsigned int *h)
{
  Window              w1;
  int                 x, y;
  unsigned int        b, d;

  EDBUG(7, "GetWinWH");
  XGetGeometry(disp, win, &w1, &x, &y, w, h, &b, &d);
  EDBUG_RETURN_;
}

int
GetWinDepth(Window win)
{
  Window              w1;
  unsigned int        w, h, b, d;
  int                 x, y;

  EDBUG(7, "GetWinDepth");
  XGetGeometry(disp, win, &w1, &x, &y, &w, &h, &b, &d);
  EDBUG_RETURN(d);
}

int
WinExists(Window win)
{
  Window              w1;
  int                 x, y;
  unsigned int        w, h;
  unsigned int        b, d;

  EDBUG(7, "WinExists");
  if (XGetGeometry(disp, win, &w1, &x, &y, &w, &h, &b, &d))
    EDBUG_RETURN(1);
  EDBUG_RETURN(0);
}

Window
WindowAtXY_0(Window base, int bx, int by, int x, int y)
{
  Window             *list = NULL;
  XWindowAttributes   att;
  Window              child = 0, parent_win = 0, root_win = 0;
  int                 i;
  unsigned int        ww, wh, num;
  int                 wx, wy;

  EDBUG(7, "WindowAtXY_0");
  if (!XGetWindowAttributes(disp, base, &att))
    EDBUG_RETURN(0);
  if (att.class == InputOnly)
    EDBUG_RETURN(0);
  wx = att.x;
  wy = att.y;
  ww = att.width;
  wh = att.height;

  wx += bx;
  wy += by;

  if (!((x >= wx) &&
	(y >= wy) &&
	(x < (int)(wx + ww)) &&
	(y < (int)(wy + wh))))
    EDBUG_RETURN(0);

  if (!XQueryTree(disp, base, &root_win, &parent_win, &list, &num))
    EDBUG_RETURN(base);
  if (list)
    {
      for (i = num - 1;; i--)
	{
	  if ((child = WindowAtXY_0(list[i], wx, wy, x, y)) != 0)
	    {
	      XFree(list);
	      EDBUG_RETURN(child);
	    }
	  if (!i)
	    break;
	}
      XFree(list);
    }
  EDBUG_RETURN(base);
}

Window
WindowAtXY(int x, int y)
{
  Window             *list = NULL;
  Window              child = 0, parent_win = 0, root_win = 0;
  unsigned int        num;
  int                 i;

  EDBUG(7, "WindowAtXY");
  GrabX();
  if (!XQueryTree(disp, root.win, &root_win, &parent_win, &list, &num))
    {
      UngrabX();
      EDBUG_RETURN(root.win);
    }
  if (list)
    {
      i = num - 1;
      do
	{
	  XWindowAttributes   xwa;

	  XGetWindowAttributes(disp, list[i], &xwa);
	  if (xwa.map_state != IsViewable)
	    continue;

	  if ((child = WindowAtXY_0(list[i], 0, 0, x, y)) == 0)
	    continue;

	  XFree(list);
	  UngrabX();
	  EDBUG_RETURN(child);
	}
      while (--i > 0);
      XFree(list);
    }
  UngrabX();
  EDBUG_RETURN(root.win);
}

void
PointerAt(int *x, int *y)
{
  Window              dw;
  int                 dd;
  unsigned int        mm;

  XQueryPointer(disp, root.win, &dw, &dw, &dd, &dd, x, y, &mm);
}
