/* vi:set ts=8 sts=0 sw=8:
 * $Id: project.h,v 1.5 1999/01/18 20:06:56 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PROJECT_H__
#define __PROJECT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>
#include "main.h"

#ifdef WANT_PROJECT

typedef struct {
	unsigned	_rev;		/* file format version (internal use) */
	char *		name;		/* name of project */
	unsigned	numfiles;	/* number of files in project */
	unsigned	version;	/* project version number */
	char *		path;		/* path to project */
} prj_t;


extern void prj_close_cb(GtkWidget *wgt, gpointer cbdata);
extern void prj_open_cb(GtkWidget *wgt, gpointer cbdata);
extern void prj_open(GtkWidget *wgt, gpointer cbdata);

#endif	/* WANT_PROJECT */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __PROJECT_H__ */
