/* C (Copyright) 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#define _SYSCALL_ .byte 0x9a, 0, 0, 0, 0, 7, 0

#if defined(__i486__) || defined(i486)
#define ALIGN 4
#else
#define ALIGN 2
#endif

#ifdef NO_UNDERSCORE
#define SYMBOL_NAME(X) X
#define SYMBOL_NAME_LABEL(X) X##:
#else
#define SYMBOL_NAME(X) _##X
#define SYMBOL_NAME_LABEL(X) _##X##:
#endif

#define ERRNO SYMBOL_NAME(errno)

#define	ENTRY(name)							      \
  .globl SYMBOL_NAME(name);						      \
  .globl ERRNO;							      \
  .align ALIGN;								      \
  SYMBOL_NAME_LABEL(name)

/* Use this for the different syntaxes for assembler labels */
#ifdef ELF_LIBRARY
#define L(X) .L##X
#define LF(X) .L##X
#define LL(X) .L##X##:
#else
#define L(X) X
#define LF(X) X##f
#define LL(X) X##:
#endif

#ifdef __PIC__
#define STORE_NUMBER(VALUE,ADDR) 		\
	pushl %ebx;				\
	call L2;				\
L2:						\
	popl %ebx;				\
	addl $_GLOBAL_OFFSET_TABLE_+[.-L2],%ebx; \
	movl	ADDR##@GOT(%ebx),%ebx;	        \
	movl	VALUE, (%ebx);	       	\
	popl    %ebx
#else
#define STORE_NUMBER(VALUE,ADDR) movl VALUE,ADDR
#endif


#ifdef __PIC__
#define	PSEUDO(name, syscall_name, args)				      \
  .text;								      \
  ENTRY (name)								      \
    movl $__IBCS_##syscall_name, %eax;					      \
    _SYSCALL_ ;								      \
    jnc	Lexit;								      \
    pushl %ebx;								      \
    call .L2;								      \
.L2:									      \
    popl %ebx;								      \
    addl $_GLOBAL_OFFSET_TABLE_+[.-.L2],%ebx;				      \
    movl ERRNO@GOT(%ebx),%ebx;						      \
    movl %eax,(%ebx);							      \
    popl %ebx;								      \
    movl $-1,%eax;							      \
   Lexit:
#else
#define	PSEUDO(name, syscall_name, args)				      \
  .text;								      \
  ENTRY (name)								      \
    movl $__IBCS_##syscall_name, %eax;					      \
    _SYSCALL_ ;								      \
    jnc	Lexit;								      \
    movl %eax,ERRNO;							      \
    movl $-1,%eax;							      \
   Lexit:
#endif

#define	r0	%eax
#define	r1	%edx
#define MOVE(x,y)	movl x , y


